/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources;

import org.chromium.ui.resources.Resource;

public abstract class ResourceLoader {
    private final int mResourceType;
    private final ResourceLoaderCallback mCallback;

    public ResourceLoader(int resourceType, ResourceLoaderCallback callback) {
        this.mResourceType = resourceType;
        this.mCallback = callback;
    }

    public int getResourceType() {
        return this.mResourceType;
    }

    public abstract void loadResource(int var1);

    public abstract void preloadResource(int var1);

    protected void notifyLoadFinished(int resId, Resource resource) {
        if (this.mCallback != null) {
            this.mCallback.onResourceLoaded(this.getResourceType(), resId, resource);
        }
    }

    public static interface ResourceLoaderCallback {
        public void onResourceLoaded(int var1, int var2, Resource var3);
    }
}

