/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.dynamics;

import android.util.SparseArray;
import org.chromium.ui.resources.ResourceLoader;
import org.chromium.ui.resources.dynamics.DynamicResource;

public class DynamicResourceLoader
extends ResourceLoader {
    private final SparseArray<DynamicResource> mDynamicResources = new SparseArray();

    public DynamicResourceLoader(int resourceType, ResourceLoader.ResourceLoaderCallback callback) {
        super(resourceType, callback);
    }

    public void registerResource(int resId, DynamicResource resource) {
        assert (this.mDynamicResources.get(resId) == null);
        this.mDynamicResources.put(resId, (Object)resource);
    }

    public void unregisterResource(int resId) {
        this.mDynamicResources.remove(resId);
    }

    @Override
    public void loadResource(int resId) {
        DynamicResource resource = (DynamicResource)this.mDynamicResources.get(resId);
        if (resource == null) {
            return;
        }
        if (resource.isDirty()) {
            this.notifyLoadFinished(resId, resource);
        }
    }

    @Override
    public void preloadResource(int resId) {
        assert (false) : "Preloading dynamic resources isn't supported.";
    }
}

