/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.widget;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.widget.Button;
import org.chromium.ui.R;

@TargetApi(value=21)
public class ButtonCompat
extends Button {
    private static final float PRE_L_PRESSED_BRIGHTNESS = 0.85f;
    private static final int DISABLED_COLOR = 0x424F4F4F;
    private int mColor;

    public static Button createBorderlessButton(Context context) {
        return new Button((Context)new ContextThemeWrapper(context, R.style.ButtonCompatBorderlessOverlay));
    }

    public ButtonCompat(Context context, int buttonColor, boolean buttonRaised) {
        this(context, buttonColor, buttonRaised, null);
    }

    public ButtonCompat(Context context, AttributeSet attrs) {
        this(context, ButtonCompat.getColorFromAttributeSet(context, attrs), ButtonCompat.getRaisedStatusFromAttributeSet(context, attrs), attrs);
    }

    private ButtonCompat(Context context, int buttonColor, boolean buttonRaised, AttributeSet attrs) {
        super((Context)new ContextThemeWrapper(context, R.style.ButtonCompatOverlay), attrs);
        this.getBackground().mutate();
        this.setButtonColor(buttonColor);
        this.setRaised(buttonRaised);
    }

    public void setButtonColor(int color2) {
        if (color2 == this.mColor) {
            return;
        }
        this.mColor = color2;
        if (Build.VERSION.SDK_INT >= 21) {
            this.updateButtonBackgroundL();
        } else {
            this.updateButtonBackgroundPreL();
        }
    }

    private void setRaised(boolean raised) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (raised) {
            TypedArray a = this.getContext().obtainStyledAttributes(null, new int[]{16843848}, 0, 16974424);
            int stateListAnimatorId = a.getResourceId(0, 0);
            a.recycle();
            StateListAnimator stateListAnimator = null;
            if (stateListAnimatorId != 0) {
                stateListAnimator = AnimatorInflater.loadStateListAnimator((Context)this.getContext(), (int)stateListAnimatorId);
            }
            this.setStateListAnimator(stateListAnimator);
        } else {
            this.setElevation(0.0f);
            this.setStateListAnimator(null);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (Build.VERSION.SDK_INT < 21) {
            this.updateButtonBackgroundPreL();
        }
    }

    @TargetApi(value=21)
    private void updateButtonBackgroundL() {
        ColorStateList csl = new ColorStateList((int[][])new int[][]{{-16842910}, new int[0]}, new int[]{0x424F4F4F, this.mColor});
        GradientDrawable shape = (GradientDrawable)((RippleDrawable)this.getBackground()).getDrawable(0);
        shape.mutate();
        shape.setColor(csl);
    }

    private void updateButtonBackgroundPreL() {
        GradientDrawable background = (GradientDrawable)this.getBackground();
        background.setColor(this.getBackgroundColorPreL());
    }

    private int getBackgroundColorPreL() {
        for (int state : this.getDrawableState()) {
            if (state != 16842919 && state != 16842908 && state != 0x10100A1) continue;
            return Color.rgb((int)Math.round((float)Color.red((int)this.mColor) * 0.85f), (int)Math.round((float)Color.green((int)this.mColor) * 0.85f), (int)Math.round((float)Color.blue((int)this.mColor) * 0.85f));
        }
        for (int state : this.getDrawableState()) {
            if (state != 16842910) continue;
            return this.mColor;
        }
        return 0x424F4F4F;
    }

    private static int getColorFromAttributeSet(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ButtonCompat, 0, 0);
        int color2 = a.getColor(R.styleable.ButtonCompat_buttonColor, -1);
        a.recycle();
        return color2;
    }

    private static boolean getRaisedStatusFromAttributeSet(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ButtonCompat, 0, 0);
        boolean raised = a.getBoolean(R.styleable.ButtonCompat_buttonRaised, true);
        a.recycle();
        return raised;
    }
}

