/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.RejectedExecutionException;

class ReflectConstructor {
    private Class<?> mClass;
    private Class<?>[] mParameterTypes;
    private Constructor<?> mConstructor;

    public ReflectConstructor() {
    }

    public ReflectConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        this.init(clazz, parameterTypes);
    }

    public boolean init(Class<?> clazz, Class<?> ... parameterTypes) {
        this.mClass = clazz;
        this.mParameterTypes = parameterTypes;
        this.mConstructor = null;
        if (this.mClass == null) {
            return false;
        }
        try {
            this.mConstructor = this.mClass.getConstructor(this.mParameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                this.mConstructor = this.mClass.getDeclaredConstructor(this.mParameterTypes);
                this.mConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this.mConstructor != null;
    }

    public Object newInstance(Object ... args) {
        if (this.mConstructor == null) {
            throw new UnsupportedOperationException(this.toString());
        }
        try {
            return this.mConstructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RejectedExecutionException(e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public boolean isNull() {
        return this.mConstructor == null;
    }

    public String toString() {
        if (this.mConstructor != null) {
            return this.mConstructor.toString();
        }
        String ret = "";
        if (this.mClass != null) {
            ret = ret + this.mClass.toString();
        }
        return ret;
    }
}

