/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import java.lang.reflect.Field;
import java.util.concurrent.RejectedExecutionException;

class ReflectField {
    private Object mInstance;
    private Class<?> mClass;
    private String mName;
    private Field mField;

    public ReflectField() {
    }

    public ReflectField(Object instance, String name) {
        this.init(instance, null, name);
    }

    public ReflectField(Class<?> clazz, String name) {
        this.init(null, clazz, name);
    }

    public boolean init(Object instance, Class<?> clazz, String name) {
        this.mInstance = instance;
        this.mClass = clazz != null ? clazz : (instance != null ? instance.getClass() : null);
        this.mName = name;
        this.mField = null;
        if (this.mClass == null) {
            return false;
        }
        try {
            this.mField = this.mClass.getField(this.mName);
        }
        catch (NoSuchFieldException e) {
            for (Class<?> parent = this.mClass; parent != null; parent = parent.getSuperclass()) {
                try {
                    this.mField = parent.getDeclaredField(this.mName);
                    this.mField.setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
        }
        return this.mField != null;
    }

    public Object get() {
        if (this.mField == null) {
            throw new UnsupportedOperationException(this.toString());
        }
        try {
            return this.mField.get(this.mInstance);
        }
        catch (IllegalAccessException | NullPointerException e) {
            throw new RejectedExecutionException(e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ExceptionInInitializerError e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isNull() {
        return this.mField == null;
    }

    public String toString() {
        if (this.mField != null) {
            return this.mField.toString();
        }
        String ret = "";
        if (this.mClass != null) {
            ret = ret + this.mClass.toString() + ".";
        }
        if (this.mName != null) {
            ret = ret + this.mName;
        }
        return ret;
    }

    public String getName() {
        return this.mName;
    }

    public Object getInstance() {
        return this.mInstance;
    }
}

