/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Button;
import java.util.ArrayList;
import org.xwalk.core.R;
import org.xwalk.core.XWalkEnvironment;

public class XWalkDialogManager {
    public static final int DIALOG_NOT_FOUND = 1;
    public static final int DIALOG_OLDER_VERSION = 2;
    public static final int DIALOG_NEWER_VERSION = 3;
    public static final int DIALOG_ARCHITECTURE_MISMATCH = 4;
    public static final int DIALOG_SIGNATURE_CHECK_ERROR = 5;
    public static final int DIALOG_DOWNLOAD_ERROR = 6;
    public static final int DIALOG_SELECT_STORE = 7;
    public static final int DIALOG_UNSUPPORTED_STORE = 8;
    public static final int DIALOG_DECOMPRESSING = 11;
    public static final int DIALOG_DOWNLOADING = 12;
    private static final String TAG = "XWalkLib";
    private Context mContext;
    private Dialog mActiveDialog;
    private AlertDialog mNotFoundDialog;
    private AlertDialog mOlderVersionDialog;
    private AlertDialog mNewerVersionDialog;
    private AlertDialog mArchitectureMismatchDialog;
    private AlertDialog mSignatureCheckErrorDialog;
    private AlertDialog mDownloadErrorDialog;
    private AlertDialog mSelectStoreDialog;
    private AlertDialog mUnsupportedStoreDialog;
    private ProgressDialog mDecompressingDialog;
    private ProgressDialog mDownloadingDialog;

    public XWalkDialogManager(Context context) {
        this.mContext = context;
    }

    public void setAlertDialog(int id2, AlertDialog dialog) {
        if (dialog instanceof ProgressDialog || dialog instanceof DatePickerDialog || dialog instanceof TimePickerDialog) {
            throw new IllegalArgumentException("The type of dialog must be AlertDialog");
        }
        if (id2 == 1) {
            this.mNotFoundDialog = dialog;
        } else if (id2 == 2) {
            this.mOlderVersionDialog = dialog;
        } else if (id2 == 3) {
            this.mNewerVersionDialog = dialog;
        } else if (id2 == 4) {
            this.mArchitectureMismatchDialog = dialog;
        } else if (id2 == 5) {
            this.mSignatureCheckErrorDialog = dialog;
        } else if (id2 == 6) {
            this.mDownloadErrorDialog = dialog;
        } else if (id2 == 7) {
            this.mSelectStoreDialog = dialog;
        } else if (id2 == 8) {
            this.mUnsupportedStoreDialog = dialog;
        } else {
            throw new IllegalArgumentException("Invalid dialog id " + id2);
        }
    }

    public void setProgressDialog(int id2, ProgressDialog dialog) {
        if (id2 == 11) {
            this.mDecompressingDialog = dialog;
        } else if (id2 == 12) {
            this.mDownloadingDialog = dialog;
        } else {
            throw new IllegalArgumentException("Invalid dialog id " + id2);
        }
    }

    public AlertDialog getAlertDialog(int id2) {
        if (id2 == 1) {
            if (this.mNotFoundDialog == null) {
                this.mNotFoundDialog = this.buildAlertDialog();
                this.setTitle(this.mNotFoundDialog, R.string.startup_not_found_title);
                this.setMessage(this.mNotFoundDialog, R.string.startup_not_found_message);
                this.setPositiveButton(this.mNotFoundDialog, R.string.xwalk_get_crosswalk);
                this.setNegativeButton(this.mNotFoundDialog, R.string.xwalk_close);
            }
            return this.mNotFoundDialog;
        }
        if (id2 == 2) {
            if (this.mOlderVersionDialog == null) {
                this.mOlderVersionDialog = this.buildAlertDialog();
                this.setTitle(this.mOlderVersionDialog, R.string.startup_older_version_title);
                this.setMessage(this.mOlderVersionDialog, R.string.startup_older_version_message);
                this.setPositiveButton(this.mOlderVersionDialog, R.string.xwalk_get_crosswalk);
                this.setNegativeButton(this.mOlderVersionDialog, R.string.xwalk_close);
            }
            return this.mOlderVersionDialog;
        }
        if (id2 == 3) {
            if (this.mNewerVersionDialog == null) {
                this.mNewerVersionDialog = this.buildAlertDialog();
                this.setTitle(this.mNewerVersionDialog, R.string.startup_newer_version_title);
                this.setMessage(this.mNewerVersionDialog, R.string.startup_newer_version_message);
                this.setNegativeButton(this.mNewerVersionDialog, R.string.xwalk_close);
            }
            return this.mNewerVersionDialog;
        }
        if (id2 == 4) {
            if (this.mArchitectureMismatchDialog == null) {
                this.mArchitectureMismatchDialog = this.buildAlertDialog();
                this.setTitle(this.mArchitectureMismatchDialog, R.string.startup_architecture_mismatch_title);
                this.setMessage(this.mArchitectureMismatchDialog, R.string.startup_architecture_mismatch_message);
                this.setPositiveButton(this.mArchitectureMismatchDialog, R.string.xwalk_get_crosswalk);
                this.setNegativeButton(this.mArchitectureMismatchDialog, R.string.xwalk_close);
            }
            return this.mArchitectureMismatchDialog;
        }
        if (id2 == 5) {
            if (this.mSignatureCheckErrorDialog == null) {
                this.mSignatureCheckErrorDialog = this.buildAlertDialog();
                this.setTitle(this.mSignatureCheckErrorDialog, R.string.startup_signature_check_error_title);
                this.setMessage(this.mSignatureCheckErrorDialog, R.string.startup_signature_check_error_message);
                this.setNegativeButton(this.mSignatureCheckErrorDialog, R.string.xwalk_close);
            }
            return this.mSignatureCheckErrorDialog;
        }
        if (id2 == 6) {
            if (this.mDownloadErrorDialog == null) {
                this.mDownloadErrorDialog = this.buildAlertDialog();
                this.setTitle(this.mDownloadErrorDialog, R.string.crosswalk_install_title);
                this.setMessage(this.mDownloadErrorDialog, R.string.download_failed_message);
                this.setPositiveButton(this.mDownloadErrorDialog, R.string.xwalk_retry);
                this.setNegativeButton(this.mDownloadErrorDialog, R.string.xwalk_cancel);
            }
            return this.mDownloadErrorDialog;
        }
        if (id2 == 7) {
            if (this.mSelectStoreDialog == null) {
                this.mSelectStoreDialog = this.buildAlertDialog();
                this.setTitle(this.mSelectStoreDialog, R.string.crosswalk_install_title);
                this.setPositiveButton(this.mSelectStoreDialog, R.string.xwalk_continue);
            }
            return this.mSelectStoreDialog;
        }
        if (id2 == 8) {
            if (this.mUnsupportedStoreDialog == null) {
                this.mUnsupportedStoreDialog = this.buildAlertDialog();
                this.setTitle(this.mUnsupportedStoreDialog, R.string.crosswalk_install_title);
                this.setMessage(this.mUnsupportedStoreDialog, R.string.unsupported_store_message);
                this.setNegativeButton(this.mUnsupportedStoreDialog, R.string.xwalk_close);
            }
            return this.mUnsupportedStoreDialog;
        }
        throw new IllegalArgumentException("Invalid dialog id " + id2);
    }

    public ProgressDialog getProgressDialog(int id2) {
        if (id2 == 11) {
            if (this.mDecompressingDialog == null) {
                this.mDecompressingDialog = this.buildProgressDialog();
                this.setTitle((AlertDialog)this.mDecompressingDialog, R.string.crosswalk_install_title);
                this.setMessage((AlertDialog)this.mDecompressingDialog, R.string.decompression_progress_message);
                this.setNegativeButton((AlertDialog)this.mDecompressingDialog, R.string.xwalk_cancel);
                this.mDecompressingDialog.setProgressStyle(0);
            }
            return this.mDecompressingDialog;
        }
        if (id2 == 12) {
            if (this.mDownloadingDialog == null) {
                this.mDownloadingDialog = this.buildProgressDialog();
                this.setTitle((AlertDialog)this.mDownloadingDialog, R.string.crosswalk_install_title);
                this.setMessage((AlertDialog)this.mDownloadingDialog, R.string.download_progress_message);
                this.setNegativeButton((AlertDialog)this.mDownloadingDialog, R.string.xwalk_cancel);
                this.mDownloadingDialog.setProgressStyle(1);
            }
            return this.mDownloadingDialog;
        }
        throw new IllegalArgumentException("Invalid dialog id " + id2);
    }

    void showInitializationError(int status, Runnable cancelCommand, Runnable downloadCommand) {
        AlertDialog dialog = null;
        ArrayList<ButtonAction> actions = new ArrayList<ButtonAction>();
        if (status == 2) {
            dialog = this.getAlertDialog(1);
            actions.add(new ButtonAction(-1, downloadCommand, true));
            actions.add(new ButtonAction(-2, cancelCommand, false));
        } else if (status == 3) {
            dialog = this.getAlertDialog(2);
            actions.add(new ButtonAction(-1, downloadCommand, true));
            actions.add(new ButtonAction(-2, cancelCommand, false));
        } else if (status == 4) {
            dialog = this.getAlertDialog(3);
            actions.add(new ButtonAction(-2, cancelCommand, true));
        } else if (status == 6) {
            dialog = this.getAlertDialog(4);
            actions.add(new ButtonAction(-1, downloadCommand, true));
            actions.add(new ButtonAction(-2, cancelCommand, false));
        } else if (status == 7) {
            dialog = this.getAlertDialog(5);
            actions.add(new ButtonAction(-2, cancelCommand, true));
        } else {
            throw new IllegalArgumentException("Invalid status " + status);
        }
        this.showDialog(dialog, actions);
    }

    void showDownloadError(Runnable cancelCommand, Runnable downloadCommand) {
        AlertDialog dialog = this.getAlertDialog(6);
        ArrayList<ButtonAction> actions = new ArrayList<ButtonAction>();
        actions.add(new ButtonAction(-1, downloadCommand, true));
        actions.add(new ButtonAction(-2, cancelCommand, false));
        this.showDialog(dialog, actions);
    }

    void showSelectStore(Runnable downloadCommand, String storeName) {
        AlertDialog dialog = this.getAlertDialog(7);
        String message = this.mContext.getString(R.string.select_store_message);
        this.setMessage(dialog, message.replace("STORE_NAME", storeName));
        ArrayList<ButtonAction> actions = new ArrayList<ButtonAction>();
        actions.add(new ButtonAction(-1, downloadCommand, true));
        this.showDialog(dialog, actions);
    }

    void showUnsupportedStore(Runnable cancelCommand) {
        AlertDialog dialog = this.getAlertDialog(8);
        ArrayList<ButtonAction> actions = new ArrayList<ButtonAction>();
        actions.add(new ButtonAction(-2, cancelCommand, true));
        this.showDialog(dialog, actions);
    }

    void showDecompressProgress(Runnable cancelCommand) {
        ProgressDialog dialog = this.getProgressDialog(11);
        ArrayList<ButtonAction> actions = new ArrayList<ButtonAction>();
        actions.add(new ButtonAction(-2, cancelCommand, false));
        this.showDialog((AlertDialog)dialog, actions);
    }

    void showDownloadProgress(Runnable cancelCommand) {
        ProgressDialog dialog = this.getProgressDialog(12);
        ArrayList<ButtonAction> actions = new ArrayList<ButtonAction>();
        actions.add(new ButtonAction(-2, cancelCommand, false));
        this.showDialog((AlertDialog)dialog, actions);
    }

    void dismissDialog() {
        this.mActiveDialog.dismiss();
        this.mActiveDialog = null;
    }

    void setProgress(int progress, int max) {
        ProgressDialog dialog = (ProgressDialog)this.mActiveDialog;
        dialog.setIndeterminate(false);
        dialog.setMax(max);
        dialog.setProgress(progress);
    }

    boolean isShowingDialog() {
        return this.mActiveDialog != null && this.mActiveDialog.isShowing();
    }

    private AlertDialog buildAlertDialog() {
        AlertDialog dialog = new AlertDialog.Builder(this.mContext).create();
        dialog.setIcon(17301543);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    private ProgressDialog buildProgressDialog() {
        ProgressDialog dialog = new ProgressDialog(this.mContext);
        dialog.setIndeterminate(true);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    private void setTitle(AlertDialog dialog, int resourceId) {
        dialog.setTitle((CharSequence)this.mContext.getString(resourceId));
    }

    private void setMessage(AlertDialog dialog, int resourceId) {
        this.setMessage(dialog, this.mContext.getString(resourceId));
    }

    private void setMessage(AlertDialog dialog, String text) {
        if ((text = text.replaceAll("APP_NAME", XWalkEnvironment.getApplicationName())).startsWith("this")) {
            text = text.replaceFirst("this", "This");
        }
        dialog.setMessage((CharSequence)text);
    }

    private void setPositiveButton(AlertDialog dialog, int resourceId) {
        dialog.setButton(-1, (CharSequence)this.mContext.getString(resourceId), (DialogInterface.OnClickListener)null);
    }

    private void setNegativeButton(AlertDialog dialog, int resourceId) {
        dialog.setButton(-2, (CharSequence)this.mContext.getString(resourceId), (DialogInterface.OnClickListener)null);
    }

    private void showDialog(final AlertDialog dialog, final ArrayList<ButtonAction> actions) {
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface d) {
                for (ButtonAction action : actions) {
                    Button button = dialog.getButton(action.mWhich);
                    if (button == null) {
                        if (!action.mMandatory) continue;
                        throw new RuntimeException("Button " + action.mWhich + " is mandatory");
                    }
                    if (action.mClickAction == null) continue;
                    final Runnable command = action.mClickAction;
                    button.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            XWalkDialogManager.this.dismissDialog();
                            command.run();
                        }
                    });
                }
            }
        });
        this.mActiveDialog = dialog;
        this.mActiveDialog.show();
    }

    private static class ButtonAction {
        int mWhich;
        Runnable mClickAction;
        boolean mMandatory;

        ButtonAction(int which, Runnable command, boolean mandatory) {
            this.mWhich = which;
            this.mClickAction = command;
            this.mMandatory = mandatory;
        }
    }
}

