/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import java.util.ArrayList;
import org.xwalk.core.ReflectConstructor;
import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkCoreWrapper;

public abstract class XWalkExtension {
    private ArrayList<Object> constructorTypes;
    private ArrayList<Object> constructorParams;
    private ReflectMethod postWrapperMethod;
    private XWalkCoreWrapper coreWrapper;
    private Object bridge;
    private ReflectMethod postMessageintStringMethod = new ReflectMethod(null, "postMessage", new Class[0]);
    private ReflectMethod postBinaryMessageintbyteArrayMethod = new ReflectMethod(null, "postBinaryMessage", new Class[0]);
    private ReflectMethod broadcastMessageStringMethod = new ReflectMethod(null, "broadcastMessage", new Class[0]);
    private ReflectMethod onInstanceCreatedintMethod = new ReflectMethod(null, "onInstanceCreated", new Class[0]);
    private ReflectMethod onInstanceDestroyedintMethod = new ReflectMethod(null, "onInstanceDestroyed", new Class[0]);
    private ReflectMethod onBinaryMessageintbyteArrayMethod = new ReflectMethod(null, "onBinaryMessage", new Class[0]);

    protected Object getBridge() {
        return this.bridge;
    }

    public XWalkExtension(String name, String jsApi) {
        this.constructorTypes = new ArrayList();
        this.constructorTypes.add(String.class);
        this.constructorTypes.add(String.class);
        this.constructorParams = new ArrayList();
        this.constructorParams.add(name);
        this.constructorParams.add(jsApi);
        this.reflectionInit();
    }

    public XWalkExtension(String name, String jsApi, String[] entryPoints) {
        this.constructorTypes = new ArrayList();
        this.constructorTypes.add(String.class);
        this.constructorTypes.add(String.class);
        this.constructorTypes.add(String[].class);
        this.constructorParams = new ArrayList();
        this.constructorParams.add(name);
        this.constructorParams.add(jsApi);
        this.constructorParams.add(entryPoints);
        this.reflectionInit();
    }

    public void postMessage(int instanceID, String message) {
        try {
            this.postMessageintStringMethod.invoke(instanceID, message);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public void postBinaryMessage(int instanceID, byte[] message) {
        try {
            this.postBinaryMessageintbyteArrayMethod.invoke(instanceID, message);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public void broadcastMessage(String message) {
        try {
            this.broadcastMessageStringMethod.invoke(message);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public void onInstanceCreated(int instanceID) {
        try {
            this.onInstanceCreatedintMethod.invoke(instanceID);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public void onInstanceDestroyed(int instanceID) {
        try {
            this.onInstanceDestroyedintMethod.invoke(instanceID);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public void onBinaryMessage(int instanceID, byte[] message) {
        try {
            this.onBinaryMessageintbyteArrayMethod.invoke(instanceID, message);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public abstract void onMessage(int var1, String var2);

    public abstract String onSyncMessage(int var1, String var2);

    void reflectionInit() {
        XWalkCoreWrapper.initEmbeddedMode();
        this.coreWrapper = XWalkCoreWrapper.getInstance();
        if (this.coreWrapper == null) {
            XWalkCoreWrapper.reserveReflectObject(this);
            return;
        }
        int length = this.constructorTypes.size();
        Class[] paramTypes = new Class[length + 1];
        for (int i = 0; i < length; ++i) {
            Object type2 = this.constructorTypes.get(i);
            if (type2 instanceof String) {
                paramTypes[i] = this.coreWrapper.getBridgeClass((String)type2);
                this.constructorParams.set(i, this.coreWrapper.getBridgeObject(this.constructorParams.get(i)));
                continue;
            }
            if (type2 instanceof Class) {
                paramTypes[i] = (Class)type2;
                continue;
            }
            assert (false);
        }
        paramTypes[length] = Object.class;
        this.constructorParams.add(this);
        ReflectConstructor constructor = new ReflectConstructor(this.coreWrapper.getBridgeClass("XWalkExtensionBridge"), paramTypes);
        try {
            this.bridge = constructor.newInstance(this.constructorParams.toArray());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.postWrapperMethod != null) {
            this.postWrapperMethod.invoke(new Object[0]);
        }
        this.postMessageintStringMethod.init(this.bridge, null, "postMessageSuper", Integer.TYPE, String.class);
        this.postBinaryMessageintbyteArrayMethod.init(this.bridge, null, "postBinaryMessageSuper", Integer.TYPE, byte[].class);
        this.broadcastMessageStringMethod.init(this.bridge, null, "broadcastMessageSuper", String.class);
        this.onInstanceCreatedintMethod.init(this.bridge, null, "onInstanceCreatedSuper", Integer.TYPE);
        this.onInstanceDestroyedintMethod.init(this.bridge, null, "onInstanceDestroyedSuper", Integer.TYPE);
        this.onBinaryMessageintbyteArrayMethod.init(this.bridge, null, "onBinaryMessageSuper", Integer.TYPE, byte[].class);
    }
}

