/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.content.Context;
import android.util.Log;
import org.xwalk.core.XWalkEnvironment;
import org.xwalk.core.XWalkLibraryLoader;

public class XWalkInitializer {
    private static final String TAG = "XWalkLib";
    private XWalkInitListener mInitListener;
    private Context mContext;
    private boolean mIsXWalkReady;

    public XWalkInitializer(XWalkInitListener listener, Context context) {
        this.mInitListener = listener;
        this.mContext = context;
        XWalkLibraryLoader.prepareToInit(this.mContext);
    }

    public boolean initAsync() {
        if (this.mIsXWalkReady) {
            return false;
        }
        if (XWalkLibraryLoader.isInitializing() || XWalkLibraryLoader.isDownloading()) {
            Log.d((String)TAG, (String)"Other initialization or download is proceeding");
            return false;
        }
        Log.d((String)TAG, (String)"Initialized by XWalkInitializer");
        XWalkLibraryLoader.startDecompress(new XWalkLibraryListener());
        this.mInitListener.onXWalkInitStarted();
        return true;
    }

    public boolean cancelInit() {
        Log.d((String)TAG, (String)"Cancel by XWalkInitializer");
        return XWalkLibraryLoader.cancelDecompress();
    }

    public boolean isXWalkReady() {
        return this.mIsXWalkReady;
    }

    public boolean isSharedMode() {
        return this.mIsXWalkReady && XWalkLibraryLoader.isSharedLibrary();
    }

    public boolean isDownloadMode() {
        return this.mIsXWalkReady && XWalkEnvironment.isDownloadMode();
    }

    private class XWalkLibraryListener
    implements XWalkLibraryLoader.DecompressListener,
    XWalkLibraryLoader.ActivateListener {
        private XWalkLibraryListener() {
        }

        @Override
        public void onDecompressStarted() {
        }

        @Override
        public void onDecompressCancelled() {
            XWalkInitializer.this.mInitListener.onXWalkInitCancelled();
        }

        @Override
        public void onDecompressCompleted() {
            XWalkLibraryLoader.startActivate(this);
        }

        @Override
        public void onActivateStarted() {
        }

        @Override
        public void onActivateFailed() {
            XWalkInitializer.this.mInitListener.onXWalkInitFailed();
        }

        @Override
        public void onActivateCompleted() {
            XWalkInitializer.this.mIsXWalkReady = true;
            XWalkLibraryLoader.finishInit(XWalkInitializer.this.mContext);
            XWalkInitializer.this.mInitListener.onXWalkInitCompleted();
        }
    }

    public static interface XWalkInitListener {
        public void onXWalkInitStarted();

        public void onXWalkInitCancelled();

        public void onXWalkInitFailed();

        public void onXWalkInitCompleted();
    }
}

