/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.DownloadManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.xwalk.core.XWalkCoreWrapper;
import org.xwalk.core.XWalkDecompressor;
import org.xwalk.core.XWalkEnvironment;

class XWalkLibraryLoader {
    private static final String DEFAULT_DOWNLOAD_FILE_NAME = "xwalk_download.tmp";
    private static final String DOWNLOAD_WITHOUT_NOTIFICATION = "android.permission.DOWNLOAD_WITHOUT_NOTIFICATION";
    private static final String TAG = "XWalkLib";
    private static AsyncTask<Void, Integer, Integer> sActiveTask;

    XWalkLibraryLoader() {
    }

    public static boolean isInitializing() {
        return sActiveTask != null && (sActiveTask instanceof DecompressTask || sActiveTask instanceof ActivateTask);
    }

    public static boolean isDownloading() {
        return sActiveTask != null && (sActiveTask instanceof DownloadManagerTask || sActiveTask instanceof HttpDownloadTask);
    }

    public static boolean isSharedLibrary() {
        return XWalkCoreWrapper.getInstance().isSharedMode();
    }

    public static boolean isLibraryReady() {
        return XWalkCoreWrapper.getInstance() != null;
    }

    public static int getLibraryStatus() {
        return XWalkCoreWrapper.getCoreStatus();
    }

    public static void prepareToInit(Context context) {
        XWalkEnvironment.init(context);
        XWalkCoreWrapper.handlePreInit(context.getClass().getName());
    }

    public static void finishInit(Context context) {
        XWalkCoreWrapper.handlePostInit(context.getClass().getName());
    }

    public static void startDecompress(DecompressListener listener) {
        new DecompressTask(listener).execute(new Void[0]);
    }

    public static boolean cancelDecompress() {
        return sActiveTask != null && sActiveTask instanceof DecompressTask && sActiveTask.cancel(true);
    }

    public static void startActivate(ActivateListener listener) {
        new ActivateTask(listener).execute(new Void[0]);
    }

    public static void startDownloadManager(DownloadListener listener, Context context, String url) {
        new DownloadManagerTask(listener, context, url).execute(new Void[0]);
    }

    public static boolean cancelDownloadManager() {
        return sActiveTask != null && sActiveTask instanceof DownloadManagerTask && sActiveTask.cancel(true);
    }

    public static void startHttpDownload(DownloadListener listener, Context context, String url) {
        new HttpDownloadTask(listener, context, url).execute(new Void[0]);
    }

    public static boolean cancelHttpDownload() {
        return sActiveTask != null && sActiveTask instanceof HttpDownloadTask && sActiveTask.cancel(true);
    }

    private static class HttpDownloadTask
    extends AsyncTask<Void, Integer, Integer> {
        private static final String XWALK_DOWNLOAD_DIR = "xwalk_download";
        private static final int UPDATE_INTERVAL_MS = 500;
        private static final int DOWNLOAD_SUCCESS = 0;
        private static final int DOWNLOAD_FAILED = -1;
        private DownloadListener mListener;
        private Context mContext;
        private String mDownloadUrl;
        private File mDownloadedFile;
        private long mProgressUpdateTime;

        HttpDownloadTask(DownloadListener listener, Context context, String url) {
            this.mListener = listener;
            this.mContext = context;
            this.mDownloadUrl = url;
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("HttpDownloadTask started, " + this.mDownloadUrl));
            sActiveTask = this;
            String savedFile = XWalkLibraryLoader.DEFAULT_DOWNLOAD_FILE_NAME;
            try {
                String name = new File(new URL(this.mDownloadUrl).getPath()).getName();
                if (!name.isEmpty()) {
                    savedFile = name;
                }
            }
            catch (NullPointerException | MalformedURLException e) {
                Log.e((String)XWalkLibraryLoader.TAG, (String)("Invalid download URL " + this.mDownloadUrl));
                this.mDownloadUrl = null;
                return;
            }
            this.mDownloadedFile = new File(this.mContext.getDir(XWALK_DOWNLOAD_DIR, 0), savedFile);
            this.mListener.onDownloadStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(Void ... params) {
            if (this.mDownloadUrl == null) {
                return -1;
            }
            if (this.mDownloadedFile.exists()) {
                this.mDownloadedFile.delete();
            }
            InputStream input = null;
            OutputStream output = null;
            HttpURLConnection connection = null;
            try {
                int count;
                URL url = new URL(this.mDownloadUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    Log.e((String)XWalkLibraryLoader.TAG, (String)("Server returned HTTP " + connection.getResponseCode() + " " + connection.getResponseMessage()));
                    Integer n = -1;
                    return n;
                }
                int fileLength = connection.getContentLength();
                input = connection.getInputStream();
                output = new FileOutputStream(this.mDownloadedFile);
                byte[] data = new byte[4096];
                long total = 0L;
                while ((count = input.read(data)) != -1) {
                    if (this.isCancelled()) {
                        Integer n = -1;
                        return n;
                    }
                    total += (long)count;
                    output.write(data, 0, count);
                    long time = SystemClock.uptimeMillis();
                    if (time - this.mProgressUpdateTime <= 500L) continue;
                    this.mProgressUpdateTime = time;
                    this.publishProgress(new Integer[]{(int)total, fileLength});
                }
                output.flush();
            }
            catch (Exception e) {
                Integer n = -1;
                return n;
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return 0;
        }

        protected void onProgressUpdate(Integer ... progress) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("HttpDownloadTask updated: " + progress[0] + "/" + progress[1]));
            int percentage = 0;
            if (progress[1] > 0) {
                percentage = (int)((double)progress[0].intValue() * 100.0 / (double)progress[1].intValue());
            }
            this.mListener.onDownloadUpdated(percentage);
        }

        protected void onCancelled(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"HttpDownloadTask cancelled");
            sActiveTask = null;
            this.mListener.onDownloadCancelled();
        }

        protected void onPostExecute(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("HttpDownloadTask finished, " + result));
            sActiveTask = null;
            if (result == 0) {
                this.mListener.onDownloadCompleted(Uri.fromFile((File)this.mDownloadedFile));
            } else {
                this.mListener.onDownloadFailed(-1, 0);
            }
        }
    }

    private static class DownloadManagerTask
    extends AsyncTask<Void, Integer, Integer> {
        private static final int QUERY_INTERVAL_MS = 100;
        private static final int MAX_PAUSED_COUNT = 6000;
        private DownloadListener mListener;
        private Context mContext;
        private String mDownloadUrl;
        private DownloadManager mDownloadManager;
        private long mDownloadId;

        DownloadManagerTask(DownloadListener listener, Context context, String url) {
            this.mListener = listener;
            this.mContext = context;
            this.mDownloadUrl = url;
            this.mDownloadManager = (DownloadManager)context.getSystemService("download");
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DownloadManagerTask started, " + this.mDownloadUrl));
            sActiveTask = this;
            String savedFile = XWalkLibraryLoader.DEFAULT_DOWNLOAD_FILE_NAME;
            try {
                String name = new File(new URL(this.mDownloadUrl).getPath()).getName();
                if (!name.isEmpty()) {
                    savedFile = name;
                }
            }
            catch (NullPointerException | MalformedURLException e) {
                Log.e((String)XWalkLibraryLoader.TAG, (String)("Invalid download URL " + this.mDownloadUrl));
                this.mDownloadUrl = null;
                return;
            }
            File downloadDir = this.mContext.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
            File downloadFile = new File(downloadDir, savedFile);
            if (downloadFile.isFile()) {
                downloadFile.delete();
            }
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.mDownloadUrl));
            request.setDestinationInExternalFilesDir(this.mContext, Environment.DIRECTORY_DOWNLOADS, savedFile);
            if (this.isSilentDownload()) {
                request.setNotificationVisibility(2);
            }
            this.mDownloadId = this.mDownloadManager.enqueue(request);
            this.mListener.onDownloadStarted();
        }

        protected Integer doInBackground(Void ... params) {
            if (this.mDownloadUrl == null) {
                return 16;
            }
            DownloadManager.Query query = new DownloadManager.Query().setFilterById(new long[]{this.mDownloadId});
            int pausedCount = 0;
            while (!this.isCancelled()) {
                int statusIdx;
                int status;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                Cursor cursor = this.mDownloadManager.query(query);
                if (cursor == null || !cursor.moveToFirst()) continue;
                int totalIdx = cursor.getColumnIndex("total_size");
                int downloadIdx = cursor.getColumnIndex("bytes_so_far");
                int totalSize = cursor.getInt(totalIdx);
                int downloadSize = cursor.getInt(downloadIdx);
                if (totalSize > 0) {
                    this.publishProgress(new Integer[]{downloadSize, totalSize});
                }
                if ((status = cursor.getInt(statusIdx = cursor.getColumnIndex("status"))) == 16 || status == 8) {
                    return status;
                }
                if (status != 4 || ++pausedCount != 6000) continue;
                return status;
            }
            return 2;
        }

        protected void onProgressUpdate(Integer ... progress) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DownloadManagerTask updated: " + progress[0] + "/" + progress[1]));
            int percentage = 0;
            if (progress[1] > 0) {
                percentage = (int)((double)progress[0].intValue() * 100.0 / (double)progress[1].intValue());
            }
            this.mListener.onDownloadUpdated(percentage);
        }

        protected void onCancelled(Integer result) {
            this.mDownloadManager.remove(new long[]{this.mDownloadId});
            Log.d((String)XWalkLibraryLoader.TAG, (String)"DownloadManagerTask cancelled");
            sActiveTask = null;
            this.mListener.onDownloadCancelled();
        }

        protected void onPostExecute(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DownloadManagerTask finished, " + result));
            sActiveTask = null;
            if (result == 8) {
                DownloadManager.Query query;
                Cursor cursor;
                Uri uri = this.mDownloadManager.getUriForDownloadedFile(this.mDownloadId);
                Log.d((String)XWalkLibraryLoader.TAG, (String)("Uri for downloaded file:" + uri.toString()));
                if (uri.getScheme().equals("content") && (cursor = this.mDownloadManager.query(query = new DownloadManager.Query().setFilterById(new long[]{this.mDownloadId}))) != null && cursor.moveToFirst()) {
                    int index = cursor.getColumnIndex("local_filename");
                    uri = Uri.parse((String)("file://" + cursor.getString(index)));
                }
                this.mListener.onDownloadCompleted(uri);
            } else {
                DownloadManager.Query query;
                Cursor cursor;
                int error = 1000;
                if (result == 16 && (cursor = this.mDownloadManager.query(query = new DownloadManager.Query().setFilterById(new long[]{this.mDownloadId}))) != null && cursor.moveToFirst()) {
                    int reasonIdx = cursor.getColumnIndex("reason");
                    error = cursor.getInt(reasonIdx);
                }
                this.mListener.onDownloadFailed(result, error);
            }
        }

        private boolean isSilentDownload() {
            try {
                PackageManager packageManager = this.mContext.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 4096);
                return Arrays.asList(packageInfo.requestedPermissions).contains(XWalkLibraryLoader.DOWNLOAD_WITHOUT_NOTIFICATION);
            }
            catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
                return false;
            }
        }
    }

    private static class ActivateTask
    extends AsyncTask<Void, Integer, Integer> {
        ActivateListener mListener;

        ActivateTask(ActivateListener listener) {
            this.mListener = listener;
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"ActivateTask started");
            sActiveTask = this;
            this.mListener.onActivateStarted();
        }

        protected Integer doInBackground(Void ... params) {
            if (XWalkCoreWrapper.getInstance() != null) {
                return -1;
            }
            return XWalkCoreWrapper.attachXWalkCore();
        }

        protected void onPostExecute(Integer result) {
            if (result == 1) {
                XWalkCoreWrapper.dockXWalkCore();
            }
            Log.d((String)XWalkLibraryLoader.TAG, (String)("ActivateTask finished, " + result));
            sActiveTask = null;
            if (result > 1) {
                this.mListener.onActivateFailed();
            } else {
                this.mListener.onActivateCompleted();
            }
        }
    }

    private static class DecompressTask
    extends AsyncTask<Void, Integer, Integer> {
        DecompressListener mListener;
        boolean mIsCompressed;
        boolean mIsDecompressed;

        DecompressTask(DecompressListener listener) {
            this.mListener = listener;
        }

        protected void onPreExecute() {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"DecompressTask started");
            sActiveTask = this;
            this.mIsCompressed = XWalkDecompressor.isLibraryCompressed();
            if (this.mIsCompressed) {
                SharedPreferences sp = XWalkEnvironment.getSharedPreferences();
                int version = sp.getInt("version", 0);
                boolean bl = this.mIsDecompressed = version > 0 && version == 8;
            }
            if (this.mIsCompressed && !this.mIsDecompressed) {
                this.mListener.onDecompressStarted();
            }
        }

        protected Integer doInBackground(Void ... params) {
            if (!this.mIsCompressed || this.mIsDecompressed) {
                return 0;
            }
            if (!XWalkDecompressor.decompressLibrary()) {
                return 1;
            }
            SharedPreferences sp = XWalkEnvironment.getSharedPreferences();
            sp.edit().putInt("version", 8).apply();
            return 0;
        }

        protected void onCancelled(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)"DecompressTask cancelled");
            sActiveTask = null;
            this.mListener.onDecompressCancelled();
        }

        protected void onPostExecute(Integer result) {
            Log.d((String)XWalkLibraryLoader.TAG, (String)("DecompressTask finished, " + result));
            if (result != 0) {
                throw new RuntimeException("Decompression Failed");
            }
            sActiveTask = null;
            this.mListener.onDecompressCompleted();
        }
    }

    public static interface DownloadListener {
        public void onDownloadStarted();

        public void onDownloadUpdated(int var1);

        public void onDownloadCancelled();

        public void onDownloadCompleted(Uri var1);

        public void onDownloadFailed(int var1, int var2);
    }

    public static interface ActivateListener {
        public void onActivateStarted();

        public void onActivateFailed();

        public void onActivateCompleted();
    }

    public static interface DecompressListener {
        public void onDecompressStarted();

        public void onDecompressCancelled();

        public void onDecompressCompleted();
    }
}

