/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.os.Build;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.extension.ExtensionInstanceHelper;
import org.xwalk.core.extension.XWalkExternalExtension;

public class MessageInfo {
    private String TAG = "MessageInfo";
    private XWalkExternalExtension mExtension;
    private int mInstanceId;
    private String mJsName;
    private String mCallbackId;
    private String mObjectId;
    private String mCmd;
    private JSONArray mArgs;
    private ByteBuffer mBinaryArgs;

    private int AlignedWith4Bytes(int length) {
        return length + (4 - length % 4);
    }

    public MessageInfo(MessageInfo info) {
        this.mExtension = info.mExtension;
        this.mInstanceId = info.mInstanceId;
        this.mJsName = info.mJsName;
        this.mCallbackId = info.mCallbackId;
        this.mObjectId = info.mObjectId;
        this.mArgs = info.mArgs;
        this.mCmd = info.mCmd;
    }

    public MessageInfo(XWalkExternalExtension extension, int instanceId, String message) {
        this.mExtension = extension;
        this.mInstanceId = instanceId;
        if (message.trim().charAt(0) == '[') {
            try {
                this.mArgs = new JSONArray(message);
                this.mCmd = "invokeNative";
                this.mJsName = this.mArgs.getString(0);
                this.mCallbackId = this.mArgs.getString(1);
                this.mObjectId = this.mArgs.getString(2);
                if (Build.VERSION.SDK_INT >= 19) {
                    this.mArgs.remove(0);
                    this.mArgs.remove(0);
                    this.mArgs.remove(0);
                }
            }
            catch (JSONException e) {
                Log.e((String)this.TAG, (String)e.toString());
            }
        } else {
            try {
                JSONObject m = new JSONObject(message);
                String cmd = m.getString("cmd");
                int objectId = m.getInt("objectId");
                this.mCmd = cmd;
                this.mObjectId = Integer.toString(objectId);
                this.mCallbackId = Integer.toString(0);
                String msgType = m.getString("type");
                this.mArgs = new JSONArray();
                if (msgType.equals("postMessageToExtension")) {
                    this.mArgs = m.getJSONArray("args");
                    this.mJsName = m.getString("name");
                    if (this.mCmd.equals("newInstance")) {
                        this.mObjectId = this.mArgs.getString(0);
                        this.mArgs = this.mArgs.getJSONArray(1);
                    }
                } else {
                    this.mJsName = msgType;
                    this.mArgs.put(0, (Object)m.getString("name"));
                    this.mArgs.put(1, (Object)m.getJSONArray("args"));
                }
            }
            catch (JSONException e) {
                Log.e((String)this.TAG, (String)e.toString());
            }
        }
    }

    public MessageInfo(XWalkExternalExtension extension, int instanceId, byte[] message) {
        this.mExtension = extension;
        this.mInstanceId = instanceId;
        this.mCmd = "invokeNative";
        try {
            this.mArgs = null;
            ByteBuffer buf = ByteBuffer.wrap(message);
            if (buf.order() != ByteOrder.LITTLE_ENDIAN) {
                buf.order(ByteOrder.LITTLE_ENDIAN);
            }
            int byteOffset = buf.position();
            int byteCountOfInt = 4;
            int funcNameLen = buf.getInt(byteOffset);
            int alignedFuncNameLen = this.AlignedWith4Bytes(funcNameLen);
            this.mJsName = new String(message, byteOffset += byteCountOfInt, funcNameLen);
            this.mCallbackId = Integer.toString(buf.getInt(byteOffset += alignedFuncNameLen));
            int objectIdLen = buf.getInt(byteOffset += byteCountOfInt);
            int alignedObjectIdLen = this.AlignedWith4Bytes(objectIdLen);
            this.mObjectId = new String(message, byteOffset += byteCountOfInt, objectIdLen);
            int len = message.length - (byteOffset += alignedObjectIdLen);
            this.mBinaryArgs = ByteBuffer.wrap(message, byteOffset, len);
        }
        catch (IndexOutOfBoundsException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
        catch (NullPointerException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    public String getJsName() {
        return this.mJsName;
    }

    public void setJsName(String JsName) {
        this.mJsName = JsName;
    }

    public JSONArray getArgs() {
        return this.mArgs;
    }

    public void setArgs(JSONArray args) {
        this.mArgs = args;
    }

    public ByteBuffer getBinaryArgs() {
        return this.mBinaryArgs;
    }

    public void setBinaryArgs(ByteBuffer args) {
        this.mBinaryArgs = args;
    }

    public String getObjectId() {
        return this.mObjectId;
    }

    public void setObjectId(String objectId) {
        this.mObjectId = objectId;
    }

    public String getCallbackId() {
        return this.mCallbackId;
    }

    public void setCallbackId(String callbackId) {
        this.mCallbackId = callbackId;
    }

    public String getCmd() {
        return this.mCmd;
    }

    public void postResult(JSONArray args) {
        try {
            JSONArray result = new JSONArray();
            result.put(0, (Object)this.mCallbackId);
            for (int i = 0; i < args.length(); ++i) {
                result.put(i + 1, args.get(i));
            }
            Log.w((String)this.TAG, (String)("postResult: " + result.toString()));
            this.mExtension.postMessage(this.mInstanceId, result.toString());
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    public XWalkExternalExtension getExtension() {
        return this.mExtension;
    }

    public int getInstanceId() {
        return this.mInstanceId;
    }

    public ExtensionInstanceHelper getInstanceHelper() {
        return this.mExtension.getInstanceHelper(this.mInstanceId);
    }

    public void postResult(byte[] buffer) {
        this.mExtension.postBinaryMessage(this.mInstanceId, buffer);
    }
}

