/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.util.Log;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xwalk.core.extension.BindingObject;
import org.xwalk.core.extension.JsApi;
import org.xwalk.core.extension.JsConstructor;
import org.xwalk.core.extension.JsContextInfo;
import org.xwalk.core.extension.MessageHandler;
import org.xwalk.core.extension.MessageInfo;
import org.xwalk.core.extension.XWalkExternalExtension;

class ReflectionHelper {
    private static final String TAG = "JsStubReflectHelper";
    private Class<?> myClass;
    private Map<String, MemberInfo> members = new HashMap<String, MemberInfo>();
    private Map<String, String> bindingClasses = new HashMap<String, String>();
    private Map<String, ReflectionHelper> constructorReflections = new HashMap<String, ReflectionHelper>();
    private String[] eventList = null;
    private MemberInfo entryPoint = null;
    static Set<Class<?>> primitives = new HashSet();

    public ReflectionHelper(Class<?> clazz) {
        this.myClass = clazz;
        this.init();
    }

    void getMemberInfo(AccessibleObject[] accessers, MemberType type2) {
        for (AccessibleObject a : accessers) {
            String name;
            if (!a.isAnnotationPresent(JsApi.class) && !a.isAnnotationPresent(JsConstructor.class)) continue;
            MemberInfo mInfo = new MemberInfo();
            mInfo.javaName = name = ((Member)((Object)a)).getName();
            mInfo.accesser = a;
            mInfo.isStatic = Modifier.isStatic(((Member)((Object)a)).getModifiers());
            if (a.isAnnotationPresent(JsApi.class)) {
                JsApi mAnno = a.getAnnotation(JsApi.class);
                if (type2 == MemberType.JS_PROPERTY && mAnno.isEventList()) {
                    if (!((Field)a).getType().equals(String[].class)) {
                        Log.w((String)TAG, (String)("Invalid type for Supported JS event list" + name));
                        continue;
                    }
                    try {
                        this.eventList = (String[])((Field)a).get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                mInfo.type = type2;
                mInfo.isWritable = mAnno.isWritable();
                mInfo.isEntryPoint = mAnno.isEntryPoint();
                mInfo.withPromise = mAnno.withPromise();
                mInfo.jsName = name;
                mInfo.wrapArgs = mAnno.wrapArgs();
                mInfo.wrapReturns = mAnno.wrapReturns();
            } else if (a.isAnnotationPresent(JsConstructor.class)) {
                if (type2 != MemberType.JS_METHOD) {
                    Log.w((String)TAG, (String)("Invalid @JsConstructor on non-function member:" + name));
                    continue;
                }
                JsConstructor cAnno = a.getAnnotation(JsConstructor.class);
                mInfo.type = MemberType.JS_CONSTRUCTOR;
                mInfo.isEntryPoint = cAnno.isEntryPoint();
                mInfo.mainClass = cAnno.mainClass();
                mInfo.withPromise = false;
                if (mInfo.mainClass == null) continue;
                mInfo.jsName = mInfo.mainClass.getSimpleName();
                this.bindingClasses.put(mInfo.mainClass.getName(), mInfo.jsName);
                this.constructorReflections.put(mInfo.jsName, new ReflectionHelper(mInfo.mainClass));
            }
            if (mInfo.isEntryPoint) {
                if (this.entryPoint != null) {
                    Log.w((String)TAG, (String)("Entry point already exist, try to set another:" + mInfo.jsName));
                    continue;
                }
                if (type2 == MemberType.JS_PROPERTY && !this.isBindingClass(((Field)mInfo.accesser).getType())) {
                    Log.w((String)TAG, (String)("Invalid entry point setting on property:" + name));
                    continue;
                }
                this.entryPoint = mInfo;
            }
            if (this.members.containsKey(mInfo.jsName)) {
                Log.w((String)TAG, (String)("Conflict namespace - " + mInfo.jsName));
                continue;
            }
            this.members.put(mInfo.jsName, mInfo);
        }
    }

    boolean isBindingClass(Class<?> clz) {
        return BindingObject.class.isAssignableFrom(clz);
    }

    void init() {
        primitives.add(Byte.class);
        primitives.add(Integer.class);
        primitives.add(Long.class);
        primitives.add(Double.class);
        primitives.add(Character.class);
        primitives.add(Float.class);
        primitives.add(Boolean.class);
        primitives.add(Short.class);
        this.getMemberInfo(this.myClass.getDeclaredMethods(), MemberType.JS_METHOD);
        this.getMemberInfo(this.myClass.getDeclaredFields(), MemberType.JS_PROPERTY);
    }

    public static void registerHandlers(ReflectionHelper reflection, MessageHandler handler, Object object) {
        if (reflection == null || handler == null) {
            return;
        }
        for (String key : reflection.getMembers().keySet()) {
            MemberInfo m = reflection.getMembers().get(key);
            handler.register(m.jsName, m.javaName, m.type, object, reflection);
        }
    }

    Map<String, MemberInfo> getMembers() {
        return this.members;
    }

    ReflectionHelper getConstructorReflection(String jsName) {
        if (!this.constructorReflections.containsKey(jsName)) {
            return null;
        }
        return this.constructorReflections.get(jsName);
    }

    ReflectionHelper getReflectionByBindingClass(String className) {
        if (!this.bindingClasses.containsKey(className)) {
            return null;
        }
        return this.getConstructorReflection(this.bindingClasses.get(className));
    }

    Boolean hasMethod(String name) {
        if (!this.members.containsKey(name)) {
            return false;
        }
        MemberInfo m = this.members.get(name);
        return m.type == MemberType.JS_METHOD || m.type == MemberType.JS_CONSTRUCTOR;
    }

    Boolean hasProperty(String name) {
        if (!this.members.containsKey(name)) {
            return false;
        }
        return this.members.get((Object)name).type == MemberType.JS_PROPERTY;
    }

    MemberInfo getMemberInfo(String name) {
        return this.members.get(name);
    }

    Object[] getArgsFromJson(XWalkExternalExtension ext, int instanceID, Method m, JSONArray args) {
        Class<?>[] pTypes = m.getParameterTypes();
        Object[] oArgs = new Object[pTypes.length];
        boolean isStatic = Modifier.isStatic(m.getModifiers());
        for (int i = 0; i < pTypes.length; ++i) {
            try {
                Class<?> p = pTypes[i];
                if (isStatic && p.equals(JsContextInfo.class)) {
                    oArgs[i++] = new JsContextInfo(instanceID, ext, m.getClass(), Integer.toString(0));
                    continue;
                }
                oArgs[i] = args.get(i);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return oArgs;
    }

    public static boolean isSerializable(Object obj) {
        Class<?> clz = obj.getClass();
        return clz.isPrimitive() || primitives.contains(clz) || obj instanceof String || obj instanceof Map || obj instanceof JSONArray || obj instanceof JSONObject;
    }

    public static Object toSerializableObject(Object obj) {
        if (obj.getClass().isArray()) {
            JSONArray result = new JSONArray();
            Object[] arr = (Object[])obj;
            for (int i = 0; i < arr.length; ++i) {
                try {
                    result.put(i, ReflectionHelper.toSerializableObject(arr[i]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
        if (ReflectionHelper.isSerializable(obj)) {
            return obj;
        }
        try {
            Method m = obj.getClass().getMethod("toJSONString", new Class[0]);
            String jsonStr = (String)m.invoke(obj, new Object[0]);
            if (jsonStr.trim().charAt(0) == '[') {
                return new JSONArray(jsonStr);
            }
            return new JSONObject(jsonStr);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"No serialization method: \"toJSONString\", or errors happened.");
            try {
                Field[] fields;
                Class<?> c = obj.getClass();
                JSONObject json = new JSONObject();
                for (Field f : fields = c.getFields()) {
                    json.put(f.getName(), f.get(obj));
                }
                return json;
            }
            catch (Exception e2) {
                Log.e((String)TAG, (String)"Field to serialize object to JSON.");
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static String objToJSON(Object obj) {
        if (obj == null) {
            return "null";
        }
        Object sObj = ReflectionHelper.toSerializableObject(obj);
        return sObj instanceof String ? JSONObject.quote((String)sObj.toString()) : sObj.toString();
    }

    Object invokeMethod(XWalkExternalExtension ext, int instanceID, Object obj, String mName, JSONArray args) throws Exception {
        if (!this.hasMethod(mName).booleanValue()) {
            throw new NoSuchMethodException("No such method:" + mName);
        }
        if (!this.getMemberInfo((String)mName).isStatic && !this.myClass.isInstance(obj)) {
            throw new InvocationTargetException(new Exception("Invalid target to set property:" + mName));
        }
        Method m = (Method)this.members.get((Object)mName).accesser;
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        Object[] oArgs = this.getArgsFromJson(ext, instanceID, m, args);
        return m.invoke(obj, oArgs);
    }

    Object getProperty(Object obj, String pName) throws Exception {
        if (!this.hasProperty(pName).booleanValue()) {
            throw new NoSuchFieldException("No such property:" + pName);
        }
        if (!this.getMemberInfo((String)pName).isStatic && !this.myClass.isInstance(obj)) {
            throw new InvocationTargetException(new Exception("Invalid target to set property:" + pName));
        }
        Field f = (Field)this.members.get((Object)pName).accesser;
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        return f.get(obj);
    }

    void setProperty(Object obj, String pName, Object value) throws Exception {
        if (!this.hasProperty(pName).booleanValue()) {
            throw new NoSuchFieldException("No such property:" + pName);
        }
        if (!this.getMemberInfo((String)pName).isStatic && !this.myClass.isInstance(obj)) {
            throw new InvocationTargetException(new Exception("Invalid target to set property:" + pName));
        }
        Field f = (Field)this.members.get((Object)pName).accesser;
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        f.set(obj, value);
    }

    String[] getEventList() {
        return this.eventList;
    }

    MemberInfo getEntryPoint() {
        return this.entryPoint;
    }

    boolean isEventSupported(String event) {
        if (this.eventList == null) {
            return false;
        }
        for (int i = 0; i < this.eventList.length; ++i) {
            if (!this.eventList[i].equals(event)) continue;
            return true;
        }
        return false;
    }

    boolean isInstance(Object obj) {
        return this.myClass.isInstance(obj);
    }

    public Object handleMessage(MessageInfo info, Object targetObj) throws Exception {
        Object result = null;
        try {
            JSONArray args;
            String cmd = info.getCmd();
            if (info.getBinaryArgs() != null) {
                JSONArray newArgs = new JSONArray();
                newArgs.put((Object)info.getBinaryArgs());
                newArgs.put((Object)info.getCallbackId());
                args = newArgs;
            } else {
                args = info.getArgs();
            }
            String memberName = info.getJsName();
            XWalkExternalExtension ext = info.getExtension();
            int instanceId = info.getInstanceId();
            switch (cmd) {
                case "invokeNative": {
                    result = this.invokeMethod(ext, instanceId, targetObj, memberName, args);
                    break;
                }
                case "newInstance": {
                    BindingObject newObj = (BindingObject)this.invokeMethod(ext, instanceId, targetObj, memberName, args);
                    result = info.getInstanceHelper().addBindingObject(info.getObjectId(), newObj);
                    break;
                }
                case "getProperty": {
                    result = this.getProperty(targetObj, memberName);
                    break;
                }
                case "setProperty": {
                    this.setProperty(targetObj, memberName, args.get(0));
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("Unsupported cmd: " + cmd));
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Invalid message, error msg:\n" + e.toString()));
            e.printStackTrace();
        }
        return result;
    }

    public class MemberInfo {
        MemberType type;
        boolean isWritable;
        AccessibleObject accesser;
        boolean isEntryPoint;
        String jsName;
        String javaName;
        Class<?> mainClass;
        boolean isStatic;
        boolean withPromise;
        String wrapArgs = "";
        String wrapReturns = "";
    }

    public static enum MemberType {
        JS_METHOD,
        JS_PROPERTY,
        JS_CONSTRUCTOR;

    }
}

