/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.xwalk.core.extension.ExtensionInstanceHelper;
import org.xwalk.core.extension.JsStubGenerator;
import org.xwalk.core.extension.MessageHandler;
import org.xwalk.core.extension.ReflectionHelper;
import org.xwalk.core.extension.XWalkExtensionContextClient;

public class XWalkExternalExtension {
    protected String mName;
    protected String mJsApi;
    protected String[] mEntryPoints;
    private Map<Integer, ExtensionInstanceHelper> instanceHelpers;
    protected XWalkExtensionContextClient mExtensionContext;
    protected ReflectionHelper mReflection;
    protected boolean useJsStubGeneration;
    protected MessageHandler mHandler;

    public XWalkExternalExtension(String name, String jsApi, XWalkExtensionContextClient context) {
        this(name, jsApi, null, context);
    }

    public XWalkExternalExtension(String name, String jsApi, String[] entryPoints, XWalkExtensionContextClient context) {
        assert (context != null);
        this.mName = name;
        this.mJsApi = jsApi;
        this.mEntryPoints = entryPoints;
        this.mExtensionContext = context;
        this.instanceHelpers = new HashMap<Integer, ExtensionInstanceHelper>();
        this.mHandler = new MessageHandler();
        if (this.mJsApi == null || this.mJsApi.length() == 0) {
            this.useJsStubGeneration = true;
            this.mReflection = new ReflectionHelper(this.getClass());
            this.mJsApi = new JsStubGenerator(this.mReflection).generate();
            if (this.mJsApi == null || this.mJsApi.length() == 0) {
                Log.e((String)("Extension-" + this.mName), (String)"Can't generate JavaScript stub for this extension.");
                return;
            }
        } else {
            this.mReflection = null;
            this.useJsStubGeneration = false;
        }
        this.mExtensionContext.registerExtension(this);
    }

    public final String getExtensionName() {
        return this.mName;
    }

    public final String getJsApi() {
        return this.mJsApi;
    }

    public final String[] getEntryPoints() {
        return this.mEntryPoints;
    }

    public void onStart() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }

    public void onNewIntent(Intent intent) {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void onInstanceCreated(int instanceID) {
        this.instanceHelpers.put(instanceID, new ExtensionInstanceHelper(this, instanceID));
    }

    public void onInstanceDestroyed(int instanceID) {
        this.instanceHelpers.remove(instanceID);
    }

    public boolean isAutoJS() {
        return this.useJsStubGeneration;
    }

    public void onMessage(int extensionInstanceID, String message) {
        if (this.useJsStubGeneration) {
            this.getInstanceHelper(extensionInstanceID).handleMessage(message);
        }
    }

    public void onBinaryMessage(int extensionInstanceID, byte[] message) {
        if (this.useJsStubGeneration) {
            this.getInstanceHelper(extensionInstanceID).handleMessage(message);
        }
    }

    public String onSyncMessage(int extensionInstanceID, String message) {
        Object result = null;
        if (this.useJsStubGeneration) {
            result = this.getInstanceHelper(extensionInstanceID).handleMessage(message);
        }
        return result != null ? ReflectionHelper.objToJSON(result) : "";
    }

    public ReflectionHelper getReflection() {
        return this.mReflection;
    }

    public MessageHandler getMessageHandler() {
        return this.mHandler;
    }

    public ReflectionHelper getTargetReflect(String cName) {
        ReflectionHelper targetReflect = this.mReflection.getConstructorReflection(cName);
        return targetReflect != null ? targetReflect : this.mReflection;
    }

    protected ExtensionInstanceHelper getInstanceHelper(int instanceId) {
        return this.instanceHelpers.get(instanceId);
    }

    public void sendEvent(String type2, Object event) {
        try {
            JSONObject msgOut = new JSONObject();
            msgOut.put("cmd", (Object)"onEvent");
            msgOut.put("type", (Object)type2);
            msgOut.put("event", (Object)ReflectionHelper.objToJSON(event));
            this.broadcastMessage(msgOut.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void postMessage(int instanceID, String message) {
        this.mExtensionContext.postMessage(this, instanceID, message);
    }

    public final void postBinaryMessage(int instanceID, byte[] message) {
        this.mExtensionContext.postBinaryMessage(this, instanceID, message);
    }

    public final void broadcastMessage(String message) {
        this.mExtensionContext.broadcastMessage(this, message);
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        throw new ActivityNotFoundException("This method is no longer supported");
    }
}

