/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import android.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.chromium.base.CollectionUtil;

public class UrlUtilities {
    private static final String TAG = "UrlUtilities";
    private static final HashSet<String> ACCEPTED_SCHEMES = CollectionUtil.newHashSet("about", "app", "content", "data", "file", "http", "https", "javascript");
    private static final HashSet<String> FALLBACK_VALID_SCHEMES = CollectionUtil.newHashSet("http", "https");

    public static boolean isValidForIntentFallbackNavigation(String uri) {
        try {
            return UrlUtilities.isValidForIntentFallbackNavigation(new URI(uri));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValidForIntentFallbackNavigation(URI uri) {
        return FALLBACK_VALID_SCHEMES.contains(uri.getScheme());
    }

    public static boolean isAcceptedScheme(URI uri) {
        return ACCEPTED_SCHEMES.contains(uri.getScheme());
    }

    public static boolean isAcceptedScheme(String uri) {
        try {
            return UrlUtilities.isAcceptedScheme(new URI(uri));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static String safeGetStringExtra(Intent intent, String name) {
        try {
            return intent.getStringExtra(name);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)("getStringExtra failed on intent: " + intent));
            return null;
        }
    }

    public static List<ComponentName> getIntentHandlers(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        ArrayList<ComponentName> nameList = new ArrayList<ComponentName>();
        for (ResolveInfo r : list) {
            nameList.add(new ComponentName(r.activityInfo.packageName, r.activityInfo.name));
        }
        return nameList;
    }

    public static boolean isSpecializedHandlerAvailable(Context context, Intent intent) {
        return UrlUtilities.isPackageSpecializedHandler(context, null, intent);
    }

    public static boolean isPackageSpecializedHandler(Context context, String packageName, Intent intent) {
        try {
            List handlers = context.getPackageManager().queryIntentActivities(intent, 64);
            if (handlers == null || handlers.size() == 0) {
                return false;
            }
            for (ResolveInfo resolveInfo : handlers) {
                IntentFilter filter = resolveInfo.filter;
                if (filter == null || filter.countDataAuthorities() == 0 || filter.countDataPaths() == 0) continue;
                if (TextUtils.isEmpty((CharSequence)packageName)) {
                    return true;
                }
                ActivityInfo activityInfo = resolveInfo.activityInfo;
                if (activityInfo == null || !activityInfo.packageName.equals(packageName)) continue;
                return true;
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("isPackageSpecializedHandler e=" + e));
        }
        return false;
    }
}

