/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.ui.autofill.AutofillDelegate;
import org.chromium.ui.autofill.AutofillPopup;
import org.chromium.ui.autofill.AutofillSuggestion;

@JNINamespace(value="xwalk")
public class XWalkAutofillClientAndroid {
    private final long mNativeXWalkAutofillClientAndroid;
    private AutofillPopup mAutofillPopup;
    private ContentViewCore mContentViewCore;

    @CalledByNative
    public static XWalkAutofillClientAndroid create(long nativeClient) {
        return new XWalkAutofillClientAndroid(nativeClient);
    }

    private XWalkAutofillClientAndroid(long nativeXWalkAutofillClient) {
        this.mNativeXWalkAutofillClientAndroid = nativeXWalkAutofillClient;
    }

    public void init(ContentViewCore contentViewCore) {
        this.mContentViewCore = contentViewCore;
    }

    @CalledByNative
    private void showAutofillPopup(float x, float y, float width, float height, boolean isRtl, AutofillSuggestion[] suggestions) {
        if (this.mContentViewCore == null) {
            return;
        }
        if (this.mAutofillPopup == null) {
            this.mAutofillPopup = new AutofillPopup(this.mContentViewCore.getContext(), this.mContentViewCore.getViewAndroidDelegate(), new AutofillDelegate(){

                @Override
                public void dismissed() {
                }

                @Override
                public void suggestionSelected(int listIndex) {
                    XWalkAutofillClientAndroid.this.nativeSuggestionSelected(XWalkAutofillClientAndroid.this.mNativeXWalkAutofillClientAndroid, listIndex);
                }

                @Override
                public void deleteSuggestion(int listIndex) {
                }
            });
        }
        this.mAutofillPopup.setAnchorRect(x, y, width, height);
        this.mAutofillPopup.filterAndShow(suggestions, isRtl);
    }

    @CalledByNative
    public void hideAutofillPopup() {
        if (this.mAutofillPopup == null) {
            return;
        }
        this.mAutofillPopup.dismiss();
        this.mAutofillPopup = null;
    }

    @CalledByNative
    private static AutofillSuggestion[] createAutofillSuggestionArray(int size) {
        return new AutofillSuggestion[size];
    }

    @CalledByNative
    private static void addToAutofillSuggestionArray(AutofillSuggestion[] array, int index, String name, String label, int uniqueId) {
        array[index] = new AutofillSuggestion(name, label, 0, uniqueId, false, false);
    }

    private native void nativeSuggestionSelected(long var1, int var3);
}

