/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="xwalk")
public class XWalkContentLifecycleNotifier {
    private static final ObserverList<Observer> sLifecycleObservers = new ObserverList();
    private static int sNumXWalkViews = 0;

    private XWalkContentLifecycleNotifier() {
    }

    public static void addObserver(Observer observer) {
        sLifecycleObservers.addObserver(observer);
    }

    public static void removeObserver(Observer observer) {
        sLifecycleObservers.removeObserver(observer);
    }

    public static boolean hasXWalkViewInstances() {
        return sNumXWalkViews > 0;
    }

    @CalledByNative
    private static void onXWalkViewCreated() {
        ThreadUtils.assertOnUiThread();
        assert (sNumXWalkViews >= 0);
        if (++sNumXWalkViews == 1) {
            for (Observer observer : sLifecycleObservers) {
                observer.onFirstXWalkViewCreated();
            }
        }
    }

    @CalledByNative
    private static void onXWalkViewDestroyed() {
        ThreadUtils.assertOnUiThread();
        assert (sNumXWalkViews > 0);
        if (--sNumXWalkViews == 0) {
            for (Observer observer : sLifecycleObservers) {
                observer.onLastXWalkViewDestroyed();
            }
        }
    }

    public static interface Observer {
        public void onFirstXWalkViewCreated();

        public void onLastXWalkViewDestroyed();
    }
}

