/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Picture;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import android.widget.Toast;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.components.navigation_interception.InterceptNavigationDelegate;
import org.chromium.components.navigation_interception.NavigationParams;
import org.chromium.content.browser.ContentVideoViewEmbedder;
import org.xwalk.core.internal.ClientCertLookupTable;
import org.xwalk.core.internal.ClientCertRequestHandlerInternal;
import org.xwalk.core.internal.ClientCertRequestInternal;
import org.xwalk.core.internal.CustomViewCallbackInternal;
import org.xwalk.core.internal.PageLoadListener;
import org.xwalk.core.internal.R;
import org.xwalk.core.internal.SslUtil;
import org.xwalk.core.internal.XWalkClient;
import org.xwalk.core.internal.XWalkContentVideoViewClient;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkDownloadListenerInternal;
import org.xwalk.core.internal.XWalkFindListenerInternal;
import org.xwalk.core.internal.XWalkGeolocationPermissions;
import org.xwalk.core.internal.XWalkHttpAuthHandlerInternal;
import org.xwalk.core.internal.XWalkJavascriptResultHandlerInternal;
import org.xwalk.core.internal.XWalkNavigationHandler;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkResourceClientInternal;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewInternal;
import org.xwalk.core.internal.XWalkWebChromeClient;
import org.xwalk.core.internal.XWalkWebResourceRequestHandlerInternal;
import org.xwalk.core.internal.XWalkWebResourceResponseInternal;

@JNINamespace(value="xwalk")
class XWalkContentsClientBridge
extends XWalkContentsClient {
    private static final String TAG = XWalkContentsClientBridge.class.getName();
    private static final int NEW_XWALKVIEW_CREATED = 100;
    private static final int NEW_ICON_DOWNLOAD = 101;
    private XWalkViewInternal mXWalkView;
    private XWalkUIClientInternal mXWalkUIClient;
    private XWalkResourceClientInternal mXWalkResourceClient;
    private XWalkClient mXWalkClient;
    private XWalkWebChromeClient mXWalkWebChromeClient;
    private Bitmap mFavicon;
    private XWalkDownloadListenerInternal mDownloadListener;
    private XWalkFindListenerInternal mFindListener;
    private InterceptNavigationDelegate mInterceptNavigationDelegate;
    private PageLoadListener mPageLoadListener;
    private XWalkNavigationHandler mNavigationHandler;
    private XWalkNotificationService mNotificationService;
    private Handler mUiThreadHandler;
    private boolean mIsFullscreen = false;
    private XWalkUIClientInternal.LoadStatusInternal mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.FINISHED;
    private String mLoadingUrl = null;
    protected long mNativeContentsClientBridge;
    private float mPageScaleFactor;
    protected ClientCertLookupTable mLookupTable;

    public XWalkContentsClientBridge(XWalkViewInternal xwView) {
        this.mXWalkView = xwView;
        this.mLookupTable = new ClientCertLookupTable();
        this.mInterceptNavigationDelegate = new InterceptNavigationDelegateImpl(this);
        this.mUiThreadHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        XWalkViewInternal newXWalkView = (XWalkViewInternal)((Object)msg.obj);
                        if (newXWalkView == XWalkContentsClientBridge.this.mXWalkView) {
                            throw new IllegalArgumentException("Parent XWalkView cannot host it's own popup window");
                        }
                        if (newXWalkView != null && newXWalkView.getNavigationHistory().size() != 0) {
                            throw new IllegalArgumentException("New WebView for popup window must not have been previously navigated.");
                        }
                        XWalkContentsClientBridge.this.mXWalkView.completeWindowCreation(newXWalkView);
                        break;
                    }
                    case 101: {
                        String url = (String)msg.obj;
                        XWalkContentsClientBridge.this.nativeDownloadIcon(XWalkContentsClientBridge.this.mNativeContentsClientBridge, url);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        };
    }

    public void setUIClient(XWalkUIClientInternal client) {
        this.mXWalkUIClient = client == null ? new XWalkUIClientInternal(this.mXWalkView) : client;
        this.mXWalkUIClient.setContentsClient(this);
    }

    public void setResourceClient(XWalkResourceClientInternal client) {
        if (client != null) {
            this.mXWalkResourceClient = client;
            return;
        }
        this.mXWalkResourceClient = new XWalkResourceClientInternal(this.mXWalkView);
    }

    public void setXWalkWebChromeClient(XWalkWebChromeClient client) {
        if (client == null) {
            return;
        }
        this.mXWalkWebChromeClient = client;
    }

    public XWalkWebChromeClient getXWalkWebChromeClient() {
        return this.mXWalkWebChromeClient;
    }

    public void setXWalkClient(XWalkClient client) {
        this.mXWalkClient = client;
    }

    public void setNavigationHandler(XWalkNavigationHandler handler) {
        this.mNavigationHandler = handler;
    }

    void registerPageLoadListener(PageLoadListener listener) {
        this.mPageLoadListener = listener;
    }

    public void setNotificationService(XWalkNotificationService service) {
        if (this.mNotificationService != null) {
            this.mNotificationService.shutdown();
        }
        this.mNotificationService = service;
        if (this.mNotificationService != null) {
            this.mNotificationService.setBridge(this);
        }
    }

    public boolean onNewIntent(Intent intent) {
        return this.mNotificationService.maybeHandleIntent(intent);
    }

    public InterceptNavigationDelegate getInterceptNavigationDelegate() {
        return this.mInterceptNavigationDelegate;
    }

    @Override
    public boolean shouldOverrideUrlLoading(String url) {
        if (this.mXWalkResourceClient != null && this.mXWalkView != null) {
            return this.mXWalkResourceClient.shouldOverrideUrlLoading(this.mXWalkView, url);
        }
        return false;
    }

    @Override
    public boolean shouldOverrideKeyEvent(KeyEvent event) {
        boolean overridden = false;
        if (this.mXWalkUIClient != null && this.mXWalkView != null) {
            overridden = this.mXWalkUIClient.shouldOverrideKeyEvent(this.mXWalkView, event);
        }
        if (!overridden) {
            return super.shouldOverrideKeyEvent(event);
        }
        return overridden;
    }

    @Override
    public void onUnhandledKeyEvent(KeyEvent event) {
        if (this.mXWalkUIClient != null && this.mXWalkView != null) {
            this.mXWalkUIClient.onUnhandledKeyEvent(this.mXWalkView, event);
        }
    }

    @Override
    public void getVisitedHistory(ValueCallback<String[]> callback) {
    }

    @Override
    public void doUpdateVisitedHistory(String url, boolean isReload) {
        this.mXWalkResourceClient.doUpdateVisitedHistory(this.mXWalkView, url, isReload);
    }

    @Override
    public void onProgressChanged(int progress) {
        this.mXWalkResourceClient.onProgressChanged(this.mXWalkView, progress);
    }

    @Override
    public void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        this.mXWalkView.onOverScrolledDelegate(scrollX, scrollY, clampedX, clampedY);
    }

    @Override
    public XWalkWebResourceResponseInternal shouldInterceptRequest(XWalkContentsClient.WebResourceRequestInner request) {
        WebResourceResponse response = this.mXWalkResourceClient.shouldInterceptLoadRequest(this.mXWalkView, request.url);
        if (response == null) {
            XWalkWebResourceResponseInternal xwalkResponse = this.mXWalkResourceClient.shouldInterceptLoadRequest(this.mXWalkView, new XWalkWebResourceRequestHandlerInternal(request));
            if (xwalkResponse == null) {
                return null;
            }
            Map<String, String> responseHeaders = xwalkResponse.getResponseHeaders();
            if (responseHeaders == null) {
                responseHeaders = new HashMap<String, String>();
            }
            return new XWalkWebResourceResponseInternal(xwalkResponse.getMimeType(), xwalkResponse.getEncoding(), xwalkResponse.getData(), xwalkResponse.getStatusCode(), xwalkResponse.getReasonPhrase(), responseHeaders);
        }
        return new XWalkWebResourceResponseInternal(response.getMimeType(), response.getEncoding(), response.getData());
    }

    @Override
    public void onDidChangeThemeColor(int color2) {
        this.mXWalkUIClient.onDidChangeThemeColor(this.mXWalkView, color2);
    }

    @Override
    public void onDocumentLoadedInFrame(long frameId) {
        this.mXWalkResourceClient.onDocumentLoadedInFrame(this.mXWalkView, frameId);
    }

    @Override
    public void onResourceLoadStarted(String url) {
        this.mXWalkResourceClient.onLoadStarted(this.mXWalkView, url);
    }

    @Override
    public void onResourceLoadFinished(String url) {
        this.mXWalkResourceClient.onLoadFinished(this.mXWalkView, url);
    }

    @Override
    public void onLoadResource(String url) {
        if (this.mXWalkClient != null) {
            this.mXWalkClient.onLoadResource(this.mXWalkView, url);
        }
    }

    @Override
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (this.mXWalkClient == null || this.mXWalkView == null) {
            return false;
        }
        XWalkUIClientInternal.ConsoleMessageType consoleMessageType = XWalkUIClientInternal.ConsoleMessageType.DEBUG;
        ConsoleMessage.MessageLevel messageLevel = consoleMessage.messageLevel();
        switch (messageLevel) {
            case TIP: {
                consoleMessageType = XWalkUIClientInternal.ConsoleMessageType.INFO;
                break;
            }
            case LOG: {
                consoleMessageType = XWalkUIClientInternal.ConsoleMessageType.LOG;
                break;
            }
            case WARNING: {
                consoleMessageType = XWalkUIClientInternal.ConsoleMessageType.WARNING;
                break;
            }
            case ERROR: {
                consoleMessageType = XWalkUIClientInternal.ConsoleMessageType.ERROR;
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown message level, defaulting to DEBUG");
            }
        }
        return this.mXWalkUIClient.onConsoleMessage(this.mXWalkView, consoleMessage.message(), consoleMessage.lineNumber(), consoleMessage.sourceId(), consoleMessageType);
    }

    @Override
    @CalledByNative
    public void onReceivedHttpAuthRequest(XWalkHttpAuthHandlerInternal handler, String host, String realm) {
        if (this.mXWalkResourceClient != null) {
            this.mXWalkResourceClient.onReceivedHttpAuthRequest(this.mXWalkView, handler, host, realm);
        }
    }

    @Override
    public void onReceivedSslError(ValueCallback<Boolean> callback, SslError error) {
        if (this.mXWalkResourceClient != null) {
            this.mXWalkResourceClient.onReceivedSslError(this.mXWalkView, callback, error);
        }
    }

    @Override
    public void onReceivedLoginRequest(String realm, String account, String args) {
    }

    @Override
    public void onReceivedClientCertRequest(ClientCertRequestInternal handler) {
        if (this.mXWalkResourceClient != null) {
            this.mXWalkResourceClient.onReceivedClientCertRequest(this.mXWalkView, handler);
        }
    }

    @Override
    public void onReceivedResponseHeaders(XWalkContentsClient.WebResourceRequestInner request, XWalkWebResourceResponseInternal response) {
        if (this.mXWalkResourceClient != null) {
            this.mXWalkResourceClient.onReceivedResponseHeaders(this.mXWalkView, new XWalkWebResourceRequestHandlerInternal(request), response);
        }
    }

    @Override
    public void onGeolocationPermissionsShowPrompt(String origin, XWalkGeolocationPermissions.Callback callback) {
        if (this.mXWalkWebChromeClient != null) {
            this.mXWalkWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
        }
    }

    @Override
    public void onGeolocationPermissionsHidePrompt() {
        if (this.mXWalkWebChromeClient != null) {
            this.mXWalkWebChromeClient.onGeolocationPermissionsHidePrompt();
        }
    }

    @Override
    public void onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
        if (this.mFindListener == null) {
            return;
        }
        this.mFindListener.onFindResultReceived(activeMatchOrdinal, numberOfMatches, isDoneCounting);
    }

    @Override
    public void onNewPicture(Picture picture) {
    }

    @Override
    public void onPageStarted(String url) {
        if (this.mXWalkUIClient != null) {
            this.mLoadingUrl = url;
            this.mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.FINISHED;
            this.mXWalkUIClient.onPageLoadStarted(this.mXWalkView, url);
        }
    }

    @Override
    public void onPageFinished(String url) {
        if (this.mPageLoadListener != null) {
            this.mPageLoadListener.onPageFinished(url);
        }
        if (this.mXWalkUIClient != null) {
            if (this.mLoadStatus == XWalkUIClientInternal.LoadStatusInternal.CANCELLED && this.mLoadingUrl != null) {
                this.mXWalkUIClient.onPageLoadStopped(this.mXWalkView, this.mLoadingUrl, this.mLoadStatus);
            } else {
                this.mXWalkUIClient.onPageLoadStopped(this.mXWalkView, url, this.mLoadStatus);
            }
            this.mLoadingUrl = null;
        }
        this.onResourceLoadFinished(url);
    }

    @Override
    protected void onStopLoading() {
        this.mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.CANCELLED;
    }

    @Override
    public void onReceivedError(int errorCode, String description, String failingUrl) {
        if (this.mLoadingUrl != null && this.mLoadingUrl.equals(failingUrl)) {
            this.mLoadStatus = XWalkUIClientInternal.LoadStatusInternal.FAILED;
        }
        this.mXWalkResourceClient.onReceivedLoadError(this.mXWalkView, errorCode, description, failingUrl);
    }

    @Override
    public void onRendererUnresponsive() {
        if (this.mXWalkClient != null) {
            this.mXWalkClient.onRendererUnresponsive(this.mXWalkView);
        }
    }

    @Override
    public void onRendererResponsive() {
        if (this.mXWalkClient != null) {
            this.mXWalkClient.onRendererResponsive(this.mXWalkView);
        }
    }

    @Override
    public void onFormResubmission(Message dontResend, Message resend) {
        dontResend.sendToTarget();
    }

    @Override
    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
        if (this.mDownloadListener != null) {
            this.mDownloadListener.onDownloadStart(url, userAgent, contentDisposition, mimeType, contentLength);
        }
    }

    @Override
    public boolean onCreateWindow(boolean isDialog, boolean isUserGesture) {
        if (isDialog) {
            return false;
        }
        XWalkUIClientInternal.InitiateByInternal initiator = XWalkUIClientInternal.InitiateByInternal.BY_JAVASCRIPT;
        if (isUserGesture) {
            initiator = XWalkUIClientInternal.InitiateByInternal.BY_USER_GESTURE;
        }
        ValueCallback<XWalkViewInternal> callback = new ValueCallback<XWalkViewInternal>(){

            public void onReceiveValue(XWalkViewInternal newXWalkView) {
                Message m = XWalkContentsClientBridge.this.mUiThreadHandler.obtainMessage(100, (Object)newXWalkView);
                m.sendToTarget();
            }
        };
        return this.mXWalkUIClient.onCreateWindowRequested(this.mXWalkView, initiator, callback);
    }

    @Override
    public void onRequestFocus() {
        this.mXWalkUIClient.onRequestFocus(this.mXWalkView);
    }

    @Override
    public void onCloseWindow() {
        this.mXWalkUIClient.onJavascriptCloseWindow(this.mXWalkView);
    }

    @Override
    public void onShowCustomView(View view, CustomViewCallbackInternal callback) {
        if (this.mXWalkUIClient != null) {
            this.mXWalkUIClient.onShowCustomView(view, callback);
        }
    }

    @Override
    public void onShowCustomView(View view, int requestedOrientation, CustomViewCallbackInternal callback) {
        if (this.mXWalkUIClient != null) {
            this.mXWalkUIClient.onShowCustomView(view, requestedOrientation, callback);
        }
    }

    @Override
    public void onHideCustomView() {
        if (this.mXWalkUIClient != null) {
            this.mXWalkUIClient.onHideCustomView();
        }
    }

    @Override
    public void onScaleChangedScaled(float oldScale, float newScale) {
        this.mXWalkUIClient.onScaleChanged(this.mXWalkView, oldScale, newScale);
    }

    @Override
    public void didFinishLoad(String url) {
    }

    @Override
    public void onTitleChanged(String title) {
        if (this.mXWalkUIClient != null) {
            this.mXWalkUIClient.onReceivedTitle(this.mXWalkView, title);
        }
    }

    @Override
    public void onToggleFullscreen(boolean enterFullscreen) {
        this.mIsFullscreen = enterFullscreen;
        this.mXWalkUIClient.onFullscreenToggled(this.mXWalkView, enterFullscreen);
    }

    @Override
    public boolean hasEnteredFullscreen() {
        return this.mIsFullscreen;
    }

    @Override
    public boolean shouldCreateWebContents(String contentUrl) {
        return true;
    }

    @Override
    public boolean shouldOverrideRunFileChooser(final int processId, final int renderId, final int modeFlags, String acceptTypes, boolean capture) {
        abstract class UriCallback
        implements ValueCallback<Uri> {
            boolean syncNullReceived = false;
            boolean syncCallFinished = false;

            UriCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String resolveFileName(Uri uri, ContentResolver contentResolver) {
                if (contentResolver == null || uri == null) {
                    return "";
                }
                try (Cursor cursor = null;){
                    cursor = contentResolver.query(uri, null, null, null, null);
                    if (cursor != null && cursor.getCount() >= 1) {
                        cursor.moveToFirst();
                        int index = cursor.getColumnIndex("_display_name");
                        if (index > -1) {
                            String string2 = cursor.getString(index);
                            return string2;
                        }
                    }
                }
                return "";
            }
        }
        UriCallback uploadFile = new UriCallback(){
            boolean completed;
            {
                this.completed = false;
            }

            public void onReceiveValue(Uri value) {
                if (this.completed) {
                    throw new IllegalStateException("Duplicate openFileChooser result");
                }
                if (value == null && !this.syncCallFinished) {
                    this.syncNullReceived = true;
                    return;
                }
                this.completed = true;
                if (value == null) {
                    XWalkContentsClientBridge.this.nativeOnFilesNotSelected(XWalkContentsClientBridge.this.mNativeContentsClientBridge, processId, renderId, modeFlags);
                } else {
                    String result = "";
                    String displayName = null;
                    if ("file".equals(value.getScheme())) {
                        result = value.getSchemeSpecificPart();
                        displayName = value.getLastPathSegment();
                    } else if ("content".equals(value.getScheme())) {
                        result = value.toString();
                        displayName = this.resolveFileName(value, XWalkContentsClientBridge.this.mXWalkView.getContext().getContentResolver());
                    } else {
                        result = value.getPath();
                        displayName = value.getLastPathSegment();
                    }
                    if (displayName == null || displayName.isEmpty()) {
                        displayName = result;
                    }
                    XWalkContentsClientBridge.this.nativeOnFilesSelected(XWalkContentsClientBridge.this.mNativeContentsClientBridge, processId, renderId, modeFlags, result, displayName);
                }
            }
        };
        this.mXWalkUIClient.openFileChooser(this.mXWalkView, uploadFile, acceptTypes, Boolean.toString(capture));
        uploadFile.syncCallFinished = true;
        return !uploadFile.syncNullReceived;
    }

    @Override
    public ContentVideoViewEmbedder getContentVideoViewEmbedder() {
        return new XWalkContentVideoViewClient(this, this.mXWalkView);
    }

    @Override
    public void provideClientCertificateResponse(int id2, byte[][] certChain, PrivateKey privateKey) {
        this.nativeProvideClientCertificateResponse(this.mNativeContentsClientBridge, id2, certChain, privateKey);
    }

    public Bitmap getFavicon() {
        return this.mFavicon;
    }

    @CalledByNative
    private void setNativeContentsClientBridge(long nativeContentsClientBridge) {
        this.mNativeContentsClientBridge = nativeContentsClientBridge;
    }

    @CalledByNative
    private boolean allowCertificateError(int certError, byte[] derBytes, String url, final int id2) {
        boolean shouldDeny = SslUtil.shouldDenyRequest(certError);
        if (shouldDeny) {
            Toast.makeText((Context)this.mXWalkView.getContext(), (int)R.string.ssl_error_deny_request, (int)0).show();
            return false;
        }
        SslCertificate cert = SslUtil.getCertificateFromDerBytes(derBytes);
        if (cert == null) {
            return false;
        }
        SslError sslError = SslUtil.sslErrorFromNetErrorCode(certError, cert, url);
        ValueCallback<Boolean> callback = new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean value) {
                XWalkContentsClientBridge.this.proceedSslError(value, id2);
            }
        };
        this.onReceivedSslError(callback, sslError);
        return true;
    }

    @CalledByNative
    private void selectClientCertificate(int id2, String[] keyTypes, byte[][] encodedPrincipals, String host, int port) {
        if (this.mXWalkResourceClient != null) {
            assert (this.mNativeContentsClientBridge != 0L);
            ClientCertLookupTable.Cert cert = this.mLookupTable.getCertData(host, port);
            if (this.mLookupTable.isDenied(host, port)) {
                this.nativeProvideClientCertificateResponse(this.mNativeContentsClientBridge, id2, null, null);
                return;
            }
            if (cert != null) {
                this.nativeProvideClientCertificateResponse(this.mNativeContentsClientBridge, id2, cert.mCertChain, cert.mPrivateKey);
                return;
            }
            Principal[] principals = null;
            if (encodedPrincipals.length > 0) {
                principals = new X500Principal[encodedPrincipals.length];
                for (int n = 0; n < encodedPrincipals.length; ++n) {
                    try {
                        principals[n] = new X500Principal(encodedPrincipals[n]);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Log.w((String)TAG, (String)("Exception while decoding issuers list: " + e));
                        this.nativeProvideClientCertificateResponse(this.mNativeContentsClientBridge, id2, null, null);
                        return;
                    }
                }
            }
            ClientCertRequestHandlerInternal handler = new ClientCertRequestHandlerInternal(this, id2, keyTypes, principals, host, port);
            this.onReceivedClientCertRequest(handler);
        }
    }

    public void clearClientCertPreferences(Runnable callback) {
        this.mLookupTable.clear();
        if (this.mNativeContentsClientBridge != 0L) {
            this.nativeClearClientCertPreferences(this.mNativeContentsClientBridge, callback);
        } else if (callback != null) {
            callback.run();
        }
    }

    @CalledByNative
    private void clientCertificatesCleared(Runnable callback) {
        if (callback == null) {
            return;
        }
        callback.run();
    }

    private void proceedSslError(boolean proceed, int id2) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeProceedSslError(this.mNativeContentsClientBridge, proceed, id2);
    }

    @CalledByNative
    private void handleJsAlert(String url, String message, int id2) {
        XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
        this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_ALERT, url, message, "", result);
    }

    @CalledByNative
    private void handleJsConfirm(String url, String message, int id2) {
        XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
        this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_CONFIRM, url, message, "", result);
    }

    @CalledByNative
    private void handleJsPrompt(String url, String message, String defaultValue, int id2) {
        XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
        this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_PROMPT, url, message, defaultValue, result);
    }

    @CalledByNative
    private void handleJsBeforeUnload(String url, String message, int id2) {
        XWalkJavascriptResultHandlerInternal result = new XWalkJavascriptResultHandlerInternal(this, id2);
        this.mXWalkUIClient.onJavascriptModalDialog(this.mXWalkView, XWalkUIClientInternal.JavascriptMessageTypeInternal.JAVASCRIPT_BEFOREUNLOAD, url, message, "", result);
    }

    @CalledByNative
    private boolean shouldOverrideUrlLoading(String url, boolean hasUserGesture, boolean isRedirect, boolean isMainFrame) {
        return this.shouldOverrideUrlLoading(url);
    }

    @CalledByNative
    private void showNotification(String title, String message, String replaceId, Bitmap icon, int notificationId) {
        this.mNotificationService.showNotification(title, message, replaceId, icon, notificationId);
    }

    @CalledByNative
    private void cancelNotification(int notificationId) {
        this.mNotificationService.cancelNotification(notificationId);
    }

    void confirmJsResult(int id2, String prompt) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeConfirmJsResult(this.mNativeContentsClientBridge, id2, prompt);
    }

    void cancelJsResult(int id2) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeCancelJsResult(this.mNativeContentsClientBridge, id2);
    }

    public void notificationDisplayed(int id2) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationDisplayed(this.mNativeContentsClientBridge, id2);
    }

    public void notificationClicked(int id2) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationClicked(this.mNativeContentsClientBridge, id2);
    }

    public void notificationClosed(int id2, boolean byUser) {
        if (this.mNativeContentsClientBridge == 0L) {
            return;
        }
        this.nativeNotificationClosed(this.mNativeContentsClientBridge, id2, byUser);
    }

    void setDownloadListener(XWalkDownloadListenerInternal listener) {
        this.mDownloadListener = listener;
    }

    void setFindListener(XWalkFindListenerInternal listener) {
        this.mFindListener = listener;
    }

    @CalledByNative
    public void onWebLayoutPageScaleFactorChanged(float pageScaleFactor) {
        if (this.mPageScaleFactor == pageScaleFactor) {
            return;
        }
        float oldPageScaleFactor = this.mPageScaleFactor;
        this.mPageScaleFactor = pageScaleFactor;
        this.onScaleChanged(oldPageScaleFactor, this.mPageScaleFactor);
    }

    @CalledByNative
    public void onIconAvailable(String url) {
        Message m = this.mUiThreadHandler.obtainMessage(101, (Object)url);
        this.mXWalkUIClient.onIconAvailable(this.mXWalkView, url, m);
    }

    @CalledByNative
    public void onReceivedIcon(String url, Bitmap icon) {
        this.mXWalkUIClient.onReceivedIcon(this.mXWalkView, url, icon);
        this.mFavicon = icon;
    }

    private native void nativeProceedSslError(long var1, boolean var3, int var4);

    private native void nativeConfirmJsResult(long var1, int var3, String var4);

    private native void nativeCancelJsResult(long var1, int var3);

    private native void nativeNotificationDisplayed(long var1, int var3);

    private native void nativeNotificationClicked(long var1, int var3);

    private native void nativeNotificationClosed(long var1, int var3, boolean var4);

    private native void nativeOnFilesSelected(long var1, int var3, int var4, int var5, String var6, String var7);

    private native void nativeOnFilesNotSelected(long var1, int var3, int var4, int var5);

    private native void nativeDownloadIcon(long var1, String var3);

    private native void nativeProvideClientCertificateResponse(long var1, int var3, byte[][] var4, PrivateKey var5);

    private native void nativeClearClientCertPreferences(long var1, Runnable var3);

    private class InterceptNavigationDelegateImpl
    implements InterceptNavigationDelegate {
        private XWalkContentsClient mContentsClient;

        public InterceptNavigationDelegateImpl(XWalkContentsClient client) {
            this.mContentsClient = client;
        }

        @Override
        public boolean shouldIgnoreNavigation(NavigationParams navigationParams) {
            boolean ignoreNavigation;
            String url = navigationParams.url;
            boolean bl = ignoreNavigation = XWalkContentsClientBridge.this.mNavigationHandler != null && XWalkContentsClientBridge.this.mNavigationHandler.handleNavigation(navigationParams);
            if (!ignoreNavigation) {
                String fallbackUrl = XWalkContentsClientBridge.this.mNavigationHandler.getFallbackUrl();
                if (fallbackUrl != null) {
                    XWalkContentsClientBridge.this.mNavigationHandler.resetFallbackUrl();
                    XWalkContentsClientBridge.this.mXWalkView.loadUrl(fallbackUrl);
                } else {
                    this.mContentsClient.getCallbackHelper().postOnPageStarted(url);
                }
            }
            return ignoreNavigation;
        }
    }
}

