/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import java.util.HashMap;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkWebResourceResponseInternal;

@JNINamespace(value="xwalk")
public abstract class XWalkContentsIoThreadClient {
    @CalledByNative
    public abstract int getCacheMode();

    @CalledByNative
    public abstract boolean shouldBlockContentUrls();

    @CalledByNative
    public abstract boolean shouldBlockFileUrls();

    @CalledByNative
    public abstract boolean shouldBlockNetworkLoads();

    @CalledByNative
    public abstract void onDownloadStart(String var1, String var2, String var3, String var4, long var5);

    @CalledByNative
    public abstract void newLoginRequest(String var1, String var2, String var3);

    public abstract XWalkWebResourceResponseInternal shouldInterceptRequest(XWalkContentsClient.WebResourceRequestInner var1);

    public abstract void onReceivedResponseHeaders(XWalkContentsClient.WebResourceRequestInner var1, XWalkWebResourceResponseInternal var2);

    @CalledByNative
    protected XWalkWebResourceResponseInternal shouldInterceptRequest(String url, boolean isMainFrame, boolean hasUserGesture, String method, String[] requestHeaderNames, String[] requestHeaderValues) {
        XWalkContentsClient.WebResourceRequestInner request = new XWalkContentsClient.WebResourceRequestInner();
        request.url = url;
        request.isMainFrame = isMainFrame;
        request.hasUserGesture = hasUserGesture;
        request.method = method;
        request.requestHeaders = new HashMap(requestHeaderNames.length);
        for (int i = 0; i < requestHeaderNames.length; ++i) {
            request.requestHeaders.put(requestHeaderNames[i], requestHeaderValues[i]);
        }
        return this.shouldInterceptRequest(request);
    }

    @CalledByNative
    protected void onReceivedResponseHeaders(String url, boolean isMainFrame, boolean hasUserGesture, String method, String[] requestHeaderNames, String[] requestHeaderValues, String mimeType, String encoding, int statusCode, String reasonPhrase, String[] responseHeaderNames, String[] responseHeaderValues) {
        XWalkContentsClient.WebResourceRequestInner request = new XWalkContentsClient.WebResourceRequestInner();
        request.url = url;
        request.isMainFrame = isMainFrame;
        request.hasUserGesture = hasUserGesture;
        request.method = method;
        request.requestHeaders = new HashMap(requestHeaderNames.length);
        for (int i = 0; i < requestHeaderNames.length; ++i) {
            request.requestHeaders.put(requestHeaderNames[i], requestHeaderValues[i]);
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>(responseHeaderNames.length);
        for (int i = 0; i < responseHeaderNames.length; ++i) {
            if (!responseHeaders.containsKey(responseHeaderNames[i])) {
                responseHeaders.put(responseHeaderNames[i], responseHeaderValues[i]);
                continue;
            }
            if (responseHeaderValues[i].isEmpty()) continue;
            String currentValue = (String)responseHeaders.get(responseHeaderNames[i]);
            if (!currentValue.isEmpty()) {
                currentValue = currentValue + ", ";
            }
            responseHeaders.put(responseHeaderNames[i], currentValue + responseHeaderValues[i]);
        }
        XWalkWebResourceResponseInternal response = new XWalkWebResourceResponseInternal(mimeType, encoding, null, statusCode, reasonPhrase, responseHeaders);
        this.onReceivedResponseHeaders(request, response);
    }
}

