/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import org.chromium.base.annotations.JNINamespace;
import org.xwalk.core.internal.XWalkAPI;

@JNINamespace(value="xwalk")
@XWalkAPI(createExternally=true)
public class XWalkCookieManagerInternal {
    private static final String TAG = "XWalkCookieManager";

    @XWalkAPI
    public void setAcceptCookie(boolean accept) {
        this.nativeSetAcceptCookie(accept);
    }

    @XWalkAPI
    public boolean acceptCookie() {
        return this.nativeAcceptCookie();
    }

    @XWalkAPI
    public void setCookie(String url, String value) {
        try {
            this.nativeSetCookie(new URL(url).toString(), value);
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)"Not setting cookie due to invalid URL", (Throwable)e);
        }
    }

    @XWalkAPI
    public String getCookie(String url) {
        try {
            String cookie = this.nativeGetCookie(new URL(url).toString());
            return cookie == null || cookie.trim().isEmpty() ? null : cookie;
        }
        catch (MalformedURLException e) {
            Log.e((String)TAG, (String)"Unable to get cookies due to invalid URL", (Throwable)e);
            return null;
        }
    }

    @XWalkAPI
    public void removeSessionCookie() {
        this.nativeRemoveSessionCookie();
    }

    @XWalkAPI
    public void removeAllCookie() {
        this.nativeRemoveAllCookie();
    }

    @XWalkAPI
    public boolean hasCookies() {
        return this.nativeHasCookies();
    }

    @XWalkAPI
    public void removeExpiredCookie() {
        this.nativeRemoveExpiredCookie();
    }

    @XWalkAPI
    public void flushCookieStore() {
        this.nativeFlushCookieStore();
    }

    @XWalkAPI
    public boolean allowFileSchemeCookies() {
        return this.nativeAllowFileSchemeCookies();
    }

    @XWalkAPI
    public void setAcceptFileSchemeCookies(boolean accept) {
        this.nativeSetAcceptFileSchemeCookies(accept);
    }

    private native void nativeSetAcceptCookie(boolean var1);

    private native boolean nativeAcceptCookie();

    private native void nativeSetCookie(String var1, String var2);

    private native String nativeGetCookie(String var1);

    private native void nativeRemoveSessionCookie();

    private native void nativeRemoveAllCookie();

    private native void nativeRemoveExpiredCookie();

    private native void nativeFlushCookieStore();

    private native boolean nativeHasCookies();

    private native boolean nativeAllowFileSchemeCookies();

    private native void nativeSetAcceptFileSchemeCookies(boolean var1);
}

