/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.xwalk.core.internal.XWalkAPI;
import org.xwalk.core.internal.XWalkHttpAuthInternal;

@JNINamespace(value="xwalk")
@XWalkAPI(impl=XWalkHttpAuthInternal.class, createInternally=true)
public class XWalkHttpAuthHandlerInternal
implements XWalkHttpAuthInternal {
    private long mNativeXWalkHttpAuthHandler;
    private final boolean mFirstAttempt;

    @Override
    @XWalkAPI
    public void proceed(String username, String password) {
        if (this.mNativeXWalkHttpAuthHandler != 0L) {
            this.nativeProceed(this.mNativeXWalkHttpAuthHandler, username, password);
            this.mNativeXWalkHttpAuthHandler = 0L;
        }
    }

    @Override
    @XWalkAPI
    public void cancel() {
        if (this.mNativeXWalkHttpAuthHandler != 0L) {
            this.nativeCancel(this.mNativeXWalkHttpAuthHandler);
            this.mNativeXWalkHttpAuthHandler = 0L;
        }
    }

    @Override
    @XWalkAPI
    public boolean isFirstAttempt() {
        return this.mFirstAttempt;
    }

    @CalledByNative
    public static XWalkHttpAuthHandlerInternal create(long nativeXWalkAuthHandler, boolean firstAttempt) {
        return new XWalkHttpAuthHandlerInternal(nativeXWalkAuthHandler, firstAttempt);
    }

    public XWalkHttpAuthHandlerInternal(long nativeXWalkHttpAuthHandler, boolean firstAttempt) {
        this.mNativeXWalkHttpAuthHandler = nativeXWalkHttpAuthHandler;
        this.mFirstAttempt = firstAttempt;
    }

    XWalkHttpAuthHandlerInternal() {
        this.mNativeXWalkHttpAuthHandler = 0L;
        this.mFirstAttempt = false;
    }

    @CalledByNative
    void handlerDestroyed() {
        this.mNativeXWalkHttpAuthHandler = 0L;
    }

    private native void nativeProceed(long var1, String var3, String var4);

    private native void nativeCancel(long var1);
}

