/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.net.URI;
import java.util.List;
import org.chromium.components.navigation_interception.NavigationParams;
import org.xwalk.core.internal.UrlUtilities;
import org.xwalk.core.internal.XWalkNavigationHandler;

public class XWalkNavigationHandlerImpl
implements XWalkNavigationHandler {
    private static final String TAG = "XWalkNavigationHandlerImpl";
    private static final String PROTOCOL_WTAI_PREFIX = "wtai://";
    private static final String PROTOCOL_WTAI_MC_PREFIX = "wtai://wp/mc;";
    private static final String ACTION_TEL_PREFIX = "tel:";
    private static final String ACTION_SMS_PREFIX = "sms:";
    private static final String ACTION_MAIL_PREFIX = "mailto:";
    private static final String ACTION_GEO_PREFIX = "geo:";
    private static final String ACTION_MARKET_PREFIX = "market:";
    private static final String ACTION_INTENT_PREFIX = "intent:";
    private Context mContext;
    public static final String EXTRA_BROWSER_FALLBACK_URL = "browser_fallback_url";
    private String mFallbackUrl;

    public XWalkNavigationHandlerImpl(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean handleNavigation(NavigationParams params) {
        String url = params.url;
        if (UrlUtilities.isAcceptedScheme(url)) {
            return false;
        }
        Intent intent = null;
        intent = url.startsWith(PROTOCOL_WTAI_PREFIX) ? this.createIntentForWTAI(url) : this.createIntentForActionUri(url);
        if (intent == null && this.shouldOverrideUrlLoadingInternal(params)) {
            return true;
        }
        if (intent != null && this.startActivity(intent)) {
            return true;
        }
        return this.handleUrlByMimeType(url);
    }

    protected boolean startActivity(Intent intent) {
        try {
            if (!(this.mContext instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Log.w((String)TAG, (String)"Activity not found for Intent:");
            Log.w((String)TAG, (String)intent.toUri(0));
            return false;
        }
        return true;
    }

    private Intent createIntentForWTAI(String url) {
        Intent intent = null;
        if (url.startsWith(PROTOCOL_WTAI_MC_PREFIX)) {
            String number = url.substring(PROTOCOL_WTAI_MC_PREFIX.length());
            String mcUrl = ACTION_TEL_PREFIX + number;
            intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)mcUrl));
        }
        return intent;
    }

    private Intent createIntentForActionUri(String url) {
        Intent intent = null;
        if (url.startsWith(ACTION_TEL_PREFIX)) {
            intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)url));
        } else if (url.startsWith(ACTION_GEO_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
        } else if (url.startsWith(ACTION_MAIL_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
        } else if (url.startsWith(ACTION_SMS_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            String address = null;
            int parmIndex = url.indexOf(63);
            if (parmIndex == -1) {
                address = url.substring(4);
            } else {
                address = url.substring(4, parmIndex);
                Uri uri = Uri.parse((String)url);
                String query = uri.getQuery();
                if (query != null && query.startsWith("body=")) {
                    intent.putExtra("sms_body", query.substring(5));
                }
            }
            intent.setData(Uri.parse((String)(ACTION_SMS_PREFIX + address)));
            intent.putExtra("address", address);
            intent.setType("vnd.android-dir/mms-sms");
        } else if (url.startsWith(ACTION_MARKET_PREFIX)) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
        }
        return intent;
    }

    private boolean handleUrlByMimeType(String url) {
        String extenstion;
        MimeTypeMap map = MimeTypeMap.getSingleton();
        String mimeType = map.getMimeTypeFromExtension(extenstion = MimeTypeMap.getFileExtensionFromUrl((String)url));
        if (this.shouldHandleMimeType(mimeType)) {
            Intent sendIntent = new Intent();
            sendIntent.setAction("android.intent.action.VIEW");
            sendIntent.setDataAndType(Uri.parse((String)url), mimeType);
            if (sendIntent.resolveActivity(this.mContext.getPackageManager()) != null) {
                this.startActivity(sendIntent);
                return true;
            }
        }
        return false;
    }

    private boolean shouldHandleMimeType(String mimeType) {
        if (mimeType != null && mimeType.startsWith("application/")) {
            return mimeType != "application/xhtml+xml" && mimeType != "application/xml";
        }
        return false;
    }

    @Override
    public String getFallbackUrl() {
        return this.mFallbackUrl;
    }

    @Override
    public void resetFallbackUrl() {
        this.mFallbackUrl = null;
    }

    private boolean shouldOverrideUrlLoadingInternal(NavigationParams params) {
        Intent selector;
        boolean canResolveActivity;
        boolean isRedirectFromFormSubmit;
        Intent intent;
        String url = params.url;
        try {
            intent = Intent.parseUri((String)url, (int)1);
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)("Bad URI=" + url + " ex=" + ex));
            return false;
        }
        int pageTransitionCore = params.pageTransitionType & 0xFF;
        boolean isLink = pageTransitionCore == 0;
        boolean isFormSubmit = pageTransitionCore == 7;
        boolean isFromIntent = (params.pageTransitionType & 0x8000000) != 0;
        boolean isForwardBackNavigation = (params.pageTransitionType & 0x1000000) != 0;
        boolean isExternalProtocol = !UrlUtilities.isAcceptedScheme(url);
        boolean isTyped = pageTransitionCore == 1;
        boolean typedRedirectToExternalProtocol = isTyped && params.isRedirect && isExternalProtocol;
        boolean hasBrowserFallbackUrl = false;
        String browserFallbackUrl = UrlUtilities.safeGetStringExtra(intent, EXTRA_BROWSER_FALLBACK_URL);
        if (browserFallbackUrl != null && UrlUtilities.isValidForIntentFallbackNavigation(browserFallbackUrl)) {
            hasBrowserFallbackUrl = true;
        } else {
            browserFallbackUrl = null;
        }
        if (isForwardBackNavigation) {
            return false;
        }
        boolean linkNotFromIntent = isLink && !isFromIntent;
        boolean incomingIntentRedirect = isLink && isFromIntent && params.isRedirect;
        boolean bl = isRedirectFromFormSubmit = isFormSubmit && params.isRedirect;
        if (!(typedRedirectToExternalProtocol || linkNotFromIntent || incomingIntentRedirect || isRedirectFromFormSubmit)) {
            return false;
        }
        if (url.matches(".*youtube\\.com.*[?&]pairingCode=.*")) {
            return false;
        }
        List<ComponentName> resolvingComponentNames = UrlUtilities.getIntentHandlers(this.mContext, intent);
        boolean bl2 = canResolveActivity = resolvingComponentNames.size() > 0;
        if (!canResolveActivity) {
            if (hasBrowserFallbackUrl) {
                this.mFallbackUrl = browserFallbackUrl;
                return false;
            }
            String packagename = intent.getPackage();
            if (packagename != null) {
                try {
                    intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packagename + "&referrer=" + this.mContext.getPackageName())));
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setPackage("com.android.vending");
                    intent.addFlags(0x10000000);
                    this.mContext.startActivity(intent);
                    return true;
                }
                catch (ActivityNotFoundException ex) {
                    return false;
                }
            }
            return false;
        }
        if (hasBrowserFallbackUrl) {
            intent.removeExtra(EXTRA_BROWSER_FALLBACK_URL);
        }
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setComponent(null);
        if (Build.VERSION.SDK_INT >= 15 && (selector = intent.getSelector()) != null) {
            selector.addCategory("android.intent.category.BROWSABLE");
            selector.setComponent(null);
        }
        intent.putExtra("com.android.browser.application_id", this.mContext.getPackageName());
        intent.addFlags(0x10000000);
        if (!isExternalProtocol) {
            if (!UrlUtilities.isSpecializedHandlerAvailable(this.mContext, intent)) {
                return false;
            }
            if (params.referrer != null && (isLink || isFormSubmit)) {
                URI previousUri;
                URI currentUri;
                try {
                    currentUri = new URI(url);
                    previousUri = new URI(params.referrer);
                }
                catch (Exception e) {
                    currentUri = null;
                    previousUri = null;
                }
                if (currentUri != null && previousUri != null && TextUtils.equals((CharSequence)currentUri.getHost(), (CharSequence)previousUri.getHost())) {
                    Intent previousIntent;
                    try {
                        previousIntent = Intent.parseUri((String)params.referrer, (int)1);
                    }
                    catch (Exception e) {
                        previousIntent = null;
                    }
                    if (previousIntent != null) {
                        List<ComponentName> currentHandlers = UrlUtilities.getIntentHandlers(this.mContext, intent);
                        List<ComponentName> previousHandlers = UrlUtilities.getIntentHandlers(this.mContext, previousIntent);
                        if (previousHandlers.containsAll(currentHandlers)) {
                            return false;
                        }
                    }
                }
            }
        }
        return intent != null && this.startActivity(intent);
    }
}

