/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.provider.Settings;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content_public.browser.WebContents;
import org.xwalk.core.internal.XWalkAPI;

@JNINamespace(value="xwalk")
@XWalkAPI(createInternally=true)
public class XWalkSettingsInternal {
    @XWalkAPI
    public static final int LOAD_DEFAULT = -1;
    @XWalkAPI
    public static final int LOAD_CACHE_ELSE_NETWORK = 1;
    @XWalkAPI
    public static final int LOAD_NO_CACHE = 2;
    @XWalkAPI
    public static final int LOAD_CACHE_ONLY = 3;
    private static final String TAG = "XWalkSettings";
    private final Object mXWalkSettingsLock = new Object();
    private final Context mContext;
    private boolean mAllowScriptsToCloseWindows = true;
    private boolean mLoadsImagesAutomatically = true;
    private boolean mImagesEnabled = true;
    private boolean mJavaScriptEnabled = true;
    private boolean mAllowUniversalAccessFromFileURLs = false;
    private boolean mAllowFileAccessFromFileURLs = false;
    private boolean mJavaScriptCanOpenWindowsAutomatically = true;
    private int mCacheMode = -1;
    private boolean mSupportMultipleWindows = false;
    private boolean mAppCacheEnabled = true;
    private boolean mDomStorageEnabled = true;
    private boolean mDatabaseEnabled = true;
    private boolean mUseWideViewport = false;
    private boolean mLoadWithOverviewMode = false;
    private boolean mMediaPlaybackRequiresUserGesture = false;
    private String mDefaultVideoPosterURL;
    private final boolean mPasswordEchoEnabled;
    private boolean mBlockNetworkLoads;
    private boolean mAllowContentUrlAccess = true;
    private boolean mAllowFileUrlAccess = true;
    private boolean mShouldFocusFirstNode = true;
    private boolean mGeolocationEnabled = true;
    private String mUserAgent;
    private String mAcceptLanguages;
    private static final Object sGlobalContentSettingsLock = new Object();
    private static boolean sAppCachePathIsSet = false;
    private long mNativeXWalkSettings = 0L;
    private boolean mIsUpdateWebkitPrefsMessagePending = false;
    private final EventHandler mEventHandler;
    private static final int MINIMUM_FONT_SIZE = 1;
    private static final int MAXIMUM_FONT_SIZE = 72;
    private int mDefaultFontSize = 16;
    private int mDefaultFixedFontSize = 13;
    private boolean mAutoCompleteEnabled = true;
    private float mInitialPageScalePercent = 0.0f;
    private double mDIPScale = 1.0;
    private int mTextSizePercent = 100;
    private ZoomSupportChangeListener mZoomChangeListener;
    private boolean mSupportZoom = true;
    private boolean mBuiltInZoomControls = false;
    private boolean mDisplayZoomControls = true;
    private boolean mSpatialNavigationEnabled = true;
    private boolean mQuirksModeEnabled = false;
    private LayoutAlgorithmInternal mLayoutAlgorithm = LayoutAlgorithmInternal.NARROW_COLUMNS;

    XWalkSettingsInternal() {
        this.mContext = null;
        this.mEventHandler = null;
        this.mPasswordEchoEnabled = false;
    }

    XWalkSettingsInternal(Context context, WebContents webContents, boolean isAccessFromFileURLsGrantedByDefault) {
        ThreadUtils.assertOnUiThread();
        this.mContext = context;
        boolean bl = this.mBlockNetworkLoads = this.mContext.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) != 0;
        if (isAccessFromFileURLsGrantedByDefault) {
            this.mAllowUniversalAccessFromFileURLs = true;
            this.mAllowFileAccessFromFileURLs = true;
        }
        this.mUserAgent = LazyDefaultUserAgent.sInstance;
        this.mPasswordEchoEnabled = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"show_password", (int)1) == 1;
        this.mEventHandler = new EventHandler();
        this.setWebContents(webContents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWebContents(WebContents webContents) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mNativeXWalkSettings != 0L) {
                this.nativeDestroy(this.mNativeXWalkSettings);
                assert (this.mNativeXWalkSettings == 0L);
            }
            if (webContents != null) {
                this.mEventHandler.bindUiThread();
                this.mNativeXWalkSettings = this.nativeInit(webContents);
                this.nativeUpdateEverythingLocked(this.mNativeXWalkSettings);
            }
        }
    }

    @CalledByNative
    private void nativeXWalkSettingsGone(long nativeXWalkSettings) {
        assert (this.mNativeXWalkSettings != 0L && this.mNativeXWalkSettings == nativeXWalkSettings);
        this.mNativeXWalkSettings = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowScriptsToCloseWindows(boolean allow) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowScriptsToCloseWindows != allow) {
                this.mAllowScriptsToCloseWindows = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowScriptsToCloseWindows() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowScriptsToCloseWindows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setCacheMode(int mode) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mCacheMode != mode) {
                this.mCacheMode = mode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public int getCacheMode() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mCacheMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setBlockNetworkLoads(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (!flag && this.mContext.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) != 0) {
                throw new SecurityException("Permission denied - application missing INTERNET permission");
            }
            this.mBlockNetworkLoads = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getBlockNetworkLoads() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mBlockNetworkLoads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setAllowFileAccess(boolean allow) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowFileUrlAccess != allow) {
                this.mAllowFileUrlAccess = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getAllowFileAccess() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowFileUrlAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setAllowContentAccess(boolean allow) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowContentUrlAccess != allow) {
                this.mAllowContentUrlAccess = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getAllowContentAccess() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowContentUrlAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeolocationEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mGeolocationEnabled != flag) {
                this.mGeolocationEnabled = flag;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getGeolocationEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mGeolocationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setJavaScriptEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mJavaScriptEnabled != flag) {
                this.mJavaScriptEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setAllowUniversalAccessFromFileURLs(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowUniversalAccessFromFileURLs != flag) {
                this.mAllowUniversalAccessFromFileURLs = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setAllowFileAccessFromFileURLs(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowFileAccessFromFileURLs != flag) {
                this.mAllowFileAccessFromFileURLs = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setLoadsImagesAutomatically(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mLoadsImagesAutomatically != flag) {
                this.mLoadsImagesAutomatically = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getLoadsImagesAutomatically() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mLoadsImagesAutomatically;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setBlockNetworkImage(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mImagesEnabled == flag) {
                this.mImagesEnabled = !flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getBlockNetworkImage() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return !this.mImagesEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getJavaScriptEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mJavaScriptEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getAllowUniversalAccessFromFileURLs() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowUniversalAccessFromFileURLs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getAllowFileAccessFromFileURLs() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowFileAccessFromFileURLs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setJavaScriptCanOpenWindowsAutomatically(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mJavaScriptCanOpenWindowsAutomatically != flag) {
                this.mJavaScriptCanOpenWindowsAutomatically = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getJavaScriptCanOpenWindowsAutomatically() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mJavaScriptCanOpenWindowsAutomatically;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setSupportMultipleWindows(boolean support) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mSupportMultipleWindows != support) {
                this.mSupportMultipleWindows = support;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean supportMultipleWindows() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mSupportMultipleWindows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setUseWideViewPort(boolean use) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mUseWideViewport != use) {
                this.mUseWideViewport = use;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getUseWideViewPort() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mUseWideViewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppCacheEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAppCacheEnabled != flag) {
                this.mAppCacheEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppCachePath(String path) {
        boolean needToSync = false;
        Object object = sGlobalContentSettingsLock;
        synchronized (object) {
            if (!sAppCachePathIsSet && path != null && !path.isEmpty()) {
                sAppCachePathIsSet = true;
                needToSync = true;
            }
        }
        if (needToSync) {
            object = this.mXWalkSettingsLock;
            synchronized (object) {
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    @CalledByNative
    private boolean getAppCacheEnabled() {
        return this.mAppCacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setDomStorageEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mDomStorageEnabled != flag) {
                this.mDomStorageEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getDomStorageEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDomStorageEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setDatabaseEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mDatabaseEnabled != flag) {
                this.mDatabaseEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getDatabaseEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDatabaseEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setMediaPlaybackRequiresUserGesture(boolean require) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mMediaPlaybackRequiresUserGesture != require) {
                this.mMediaPlaybackRequiresUserGesture = require;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getMediaPlaybackRequiresUserGesture() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mMediaPlaybackRequiresUserGesture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultVideoPosterURL(String url) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mDefaultVideoPosterURL != null && !this.mDefaultVideoPosterURL.equals(url) || this.mDefaultVideoPosterURL == null && url != null) {
                this.mDefaultVideoPosterURL = url;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    public static String getDefaultUserAgent() {
        return LazyDefaultUserAgent.sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setUserAgentString(String userAgent) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            String oldUserAgent = this.mUserAgent;
            this.mUserAgent = userAgent == null || userAgent.length() == 0 ? LazyDefaultUserAgent.sInstance : userAgent;
            if (!oldUserAgent.equals(this.mUserAgent)) {
                this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                    @Override
                    public void run() {
                        if (XWalkSettingsInternal.this.mNativeXWalkSettings != 0L) {
                            XWalkSettingsInternal.this.nativeUpdateUserAgent(XWalkSettingsInternal.this.mNativeXWalkSettings);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public String getUserAgentString() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mUserAgent;
        }
    }

    @CalledByNative
    private String getUserAgentLocked() {
        return this.mUserAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultVideoPosterURL() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDefaultVideoPosterURL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void updateEverything() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            this.nativeUpdateEverythingLocked(this.mNativeXWalkSettings);
        }
    }

    private void updateWebkitPreferencesOnUiThread() {
        if (this.mNativeXWalkSettings != 0L) {
            ThreadUtils.assertOnUiThread();
            this.nativeUpdateWebkitPreferences(this.mNativeXWalkSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setAcceptLanguages(String acceptLanguages) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAcceptLanguages == acceptLanguages) {
                return;
            }
            this.mAcceptLanguages = acceptLanguages;
            this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                @Override
                public void run() {
                    if (XWalkSettingsInternal.this.mNativeXWalkSettings != 0L) {
                        XWalkSettingsInternal.this.nativeUpdateAcceptLanguages(XWalkSettingsInternal.this.mNativeXWalkSettings);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public String getAcceptLanguages() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAcceptLanguages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setSaveFormData(boolean enable) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAutoCompleteEnabled == enable) {
                return;
            }
            this.mAutoCompleteEnabled = enable;
            this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                @Override
                public void run() {
                    if (XWalkSettingsInternal.this.mNativeXWalkSettings != 0L) {
                        XWalkSettingsInternal.this.nativeUpdateFormDataPreferences(XWalkSettingsInternal.this.mNativeXWalkSettings);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getSaveFormData() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.getSaveFormDataLocked();
        }
    }

    @CalledByNative
    private String getAcceptLanguagesLocked() {
        return this.mAcceptLanguages;
    }

    @CalledByNative
    private boolean getSaveFormDataLocked() {
        return this.mAutoCompleteEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDIPScale(double dipScale) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            this.mDIPScale = dipScale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setInitialPageScale(float scaleInPercent) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mInitialPageScalePercent == scaleInPercent) {
                return;
            }
            this.mInitialPageScalePercent = scaleInPercent;
            this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                @Override
                public void run() {
                    if (XWalkSettingsInternal.this.mNativeXWalkSettings != 0L) {
                        XWalkSettingsInternal.this.nativeUpdateInitialPageScale(XWalkSettingsInternal.this.mNativeXWalkSettings);
                    }
                }
            });
        }
    }

    @CalledByNative
    private float getInitialPageScalePercentLocked() {
        assert (Thread.holdsLock(this.mXWalkSettingsLock));
        return this.mInitialPageScalePercent;
    }

    @CalledByNative
    private double getDIPScaleLocked() {
        assert (Thread.holdsLock(this.mXWalkSettingsLock));
        return this.mDIPScale;
    }

    @CalledByNative
    private boolean getPasswordEchoEnabledLocked() {
        assert (Thread.holdsLock(this.mXWalkSettingsLock));
        return this.mPasswordEchoEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setTextZoom(int textZoom) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mTextSizePercent == textZoom) {
                return;
            }
            this.mTextSizePercent = textZoom;
            this.mEventHandler.updateWebkitPreferencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public int getTextZoom() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mTextSizePercent;
        }
    }

    private int clipFontSize(int size) {
        if (size < 1) {
            return 1;
        }
        if (size > 72) {
            return 72;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setDefaultFontSize(int size) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            size = this.clipFontSize(size);
            if (this.mDefaultFontSize == size) {
                return;
            }
            this.mDefaultFontSize = size;
            this.mEventHandler.updateWebkitPreferencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public int getDefaultFontSize() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDefaultFontSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setDefaultFixedFontSize(int size) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            size = this.clipFontSize(size);
            if (this.mDefaultFixedFontSize == size) {
                return;
            }
            this.mDefaultFixedFontSize = size;
            this.mEventHandler.updateWebkitPreferencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public int getDefaultFixedFontSize() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDefaultFixedFontSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setZoomListener(ZoomSupportChangeListener zoomChangeListener) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            this.mZoomChangeListener = zoomChangeListener;
        }
    }

    private void onGestureZoomSupportChanged(final boolean supportsDoubleTapZoom, final boolean supportsMultiTouchZoom) {
        this.mEventHandler.maybePostOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = XWalkSettingsInternal.this.mXWalkSettingsLock;
                synchronized (object) {
                    if (XWalkSettingsInternal.this.mZoomChangeListener == null) {
                        return;
                    }
                    XWalkSettingsInternal.this.mZoomChangeListener.onGestureZoomSupportChanged(supportsDoubleTapZoom, supportsMultiTouchZoom);
                }
            }
        });
    }

    @CalledByNative
    private boolean supportsDoubleTapZoomLocked() {
        assert (Thread.holdsLock(this.mXWalkSettingsLock));
        return this.mSupportZoom && this.mBuiltInZoomControls && this.mUseWideViewport;
    }

    private boolean supportsMultiTouchZoomLocked() {
        assert (Thread.holdsLock(this.mXWalkSettingsLock));
        return this.mSupportZoom && this.mBuiltInZoomControls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setSupportZoom(boolean support) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mSupportZoom == support) {
                return;
            }
            this.mSupportZoom = support;
            this.onGestureZoomSupportChanged(this.supportsDoubleTapZoomLocked(), this.supportsMultiTouchZoomLocked());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean supportZoom() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mSupportZoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setBuiltInZoomControls(boolean enabled) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mBuiltInZoomControls == enabled) {
                return;
            }
            this.mBuiltInZoomControls = enabled;
            this.onGestureZoomSupportChanged(this.supportsDoubleTapZoomLocked(), this.supportsMultiTouchZoomLocked());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getBuiltInZoomControls() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mBuiltInZoomControls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean supportsMultiTouchZoomForTest() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.supportsMultiTouchZoomLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setSupportSpatialNavigation(boolean enable) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mSpatialNavigationEnabled == enable) {
                return;
            }
            this.mSpatialNavigationEnabled = enable;
            this.mEventHandler.updateWebkitPreferencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getSupportSpatialNavigation() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mSpatialNavigationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setSupportQuirksMode(boolean enable) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mQuirksModeEnabled == enable) {
                return;
            }
            this.mQuirksModeEnabled = enable;
            this.mEventHandler.updateWebkitPreferencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getSupportQuirksMode() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mQuirksModeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setLayoutAlgorithm(LayoutAlgorithmInternal la) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mLayoutAlgorithm == la) {
                return;
            }
            this.mLayoutAlgorithm = la;
            this.mEventHandler.updateWebkitPreferencesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public LayoutAlgorithmInternal getLayoutAlgorithm() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mLayoutAlgorithm;
        }
    }

    @CalledByNative
    private boolean getTextAutosizingEnabledLocked() {
        assert (Thread.holdsLock(this.mXWalkSettingsLock));
        return this.mLayoutAlgorithm == LayoutAlgorithmInternal.TEXT_AUTOSIZING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public void setLoadWithOverviewMode(boolean overview) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mLoadWithOverviewMode == overview) {
                return;
            }
            this.mLoadWithOverviewMode = overview;
            this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                @Override
                public void run() {
                    if (XWalkSettingsInternal.this.mNativeXWalkSettings != 0L) {
                        XWalkSettingsInternal.this.mEventHandler.updateWebkitPreferencesLocked();
                        XWalkSettingsInternal.this.nativeResetScrollAndScaleState(XWalkSettingsInternal.this.mNativeXWalkSettings);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XWalkAPI
    public boolean getLoadWithOverviewMode() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mLoadWithOverviewMode;
        }
    }

    private native long nativeInit(WebContents var1);

    private native void nativeDestroy(long var1);

    private static native String nativeGetDefaultUserAgent();

    private native void nativeUpdateEverythingLocked(long var1);

    private native void nativeUpdateUserAgent(long var1);

    private native void nativeUpdateWebkitPreferences(long var1);

    private native void nativeUpdateAcceptLanguages(long var1);

    private native void nativeUpdateFormDataPreferences(long var1);

    private native void nativeUpdateInitialPageScale(long var1);

    private native void nativeResetScrollAndScaleState(long var1);

    static /* synthetic */ String access$000() {
        return XWalkSettingsInternal.nativeGetDefaultUserAgent();
    }

    static interface ZoomSupportChangeListener {
        public void onGestureZoomSupportChanged(boolean var1, boolean var2);
    }

    private class EventHandler {
        private static final int UPDATE_WEBKIT_PREFERENCES = 0;
        private Handler mHandler;

        EventHandler() {
        }

        void bindUiThread() {
            if (this.mHandler != null) {
                return;
            }
            this.mHandler = new Handler(ThreadUtils.getUiThreadLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            Object object = XWalkSettingsInternal.this.mXWalkSettingsLock;
                            synchronized (object) {
                                XWalkSettingsInternal.this.updateWebkitPreferencesOnUiThread();
                                XWalkSettingsInternal.this.mIsUpdateWebkitPrefsMessagePending = false;
                                XWalkSettingsInternal.this.mXWalkSettingsLock.notifyAll();
                                break;
                            }
                        }
                    }
                }
            };
        }

        void maybeRunOnUiThreadBlocking(Runnable r) {
            if (this.mHandler != null) {
                ThreadUtils.runOnUiThreadBlocking(r);
            }
        }

        void maybePostOnUiThread(Runnable r) {
            if (this.mHandler != null) {
                this.mHandler.post(r);
            }
        }

        private void updateWebkitPreferencesLocked() {
            assert (Thread.holdsLock(XWalkSettingsInternal.this.mXWalkSettingsLock));
            if (XWalkSettingsInternal.this.mNativeXWalkSettings == 0L) {
                return;
            }
            if (this.mHandler == null) {
                return;
            }
            if (ThreadUtils.runningOnUiThread()) {
                XWalkSettingsInternal.this.updateWebkitPreferencesOnUiThread();
            } else {
                if (XWalkSettingsInternal.this.mIsUpdateWebkitPrefsMessagePending) {
                    return;
                }
                XWalkSettingsInternal.this.mIsUpdateWebkitPrefsMessagePending = true;
                this.mHandler.sendMessage(Message.obtain(null, (int)0));
                try {
                    while (XWalkSettingsInternal.this.mIsUpdateWebkitPrefsMessagePending) {
                        XWalkSettingsInternal.this.mXWalkSettingsLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static class LazyDefaultUserAgent {
        private static final String sInstance = XWalkSettingsInternal.access$000();

        LazyDefaultUserAgent() {
        }
    }

    @XWalkAPI
    public static enum LayoutAlgorithmInternal {
        NORMAL,
        SINGLE_COLUMN,
        NARROW_COLUMNS,
        TEXT_AUTOSIZING;

    }
}

