/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.widget.EditText;
import android.widget.FrameLayout;
import org.chromium.base.ApiCompatibilityUtils;
import org.xwalk.core.internal.CustomViewCallbackInternal;
import org.xwalk.core.internal.R;
import org.xwalk.core.internal.XWalkAPI;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkJavascriptResultInternal;
import org.xwalk.core.internal.XWalkViewInternal;

@XWalkAPI(createExternally=true)
public class XWalkUIClientInternal {
    private Context mContext;
    private AlertDialog mDialog;
    private EditText mPromptText;
    private int mSystemUiFlag;
    private XWalkViewInternal mXWalkView;
    private boolean mOriginalFullscreen;
    private boolean mOriginalForceNotFullscreen;
    private boolean mIsFullscreen = false;
    private View mCustomXWalkView;
    private final int INVALID_ORIENTATION = -2;
    private int mPreOrientation = -2;
    private CustomViewCallbackInternal mCustomViewCallback;
    private XWalkContentsClient mContentsClient;

    @XWalkAPI
    public XWalkUIClientInternal(XWalkViewInternal view) {
        this.mContext = view.getContext();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mSystemUiFlag = 1792;
        }
        this.mXWalkView = view;
    }

    @XWalkAPI
    public boolean onCreateWindowRequested(XWalkViewInternal view, InitiateByInternal initiator, ValueCallback<XWalkViewInternal> callback) {
        return false;
    }

    public void onDidChangeThemeColor(XWalkViewInternal view, int color2) {
        if (view == null || !(this.mContext instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)this.mContext;
        ApiCompatibilityUtils.setStatusBarColor(activity.getWindow(), color2);
        ApiCompatibilityUtils.setTaskDescription(activity, null, null, color2);
    }

    @XWalkAPI
    public void onIconAvailable(XWalkViewInternal view, String url, Message startDownload) {
    }

    @XWalkAPI
    public void onReceivedIcon(XWalkViewInternal view, String url, Bitmap icon) {
    }

    @XWalkAPI
    public void onRequestFocus(XWalkViewInternal view) {
    }

    @XWalkAPI
    public void onJavascriptCloseWindow(XWalkViewInternal view) {
        if (view == null || !(this.mContext instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)this.mContext;
        activity.finish();
    }

    @XWalkAPI
    public boolean onJavascriptModalDialog(XWalkViewInternal view, JavascriptMessageTypeInternal type2, String url, String message, String defaultValue, XWalkJavascriptResultInternal result) {
        switch (type2) {
            case JAVASCRIPT_ALERT: {
                return this.onJsAlert(view, url, message, result);
            }
            case JAVASCRIPT_CONFIRM: {
                return this.onJsConfirm(view, url, message, result);
            }
            case JAVASCRIPT_PROMPT: {
                return this.onJsPrompt(view, url, message, defaultValue, result);
            }
            case JAVASCRIPT_BEFOREUNLOAD: {
                return this.onJsConfirm(view, url, message, result);
            }
        }
        assert (false);
        return false;
    }

    @XWalkAPI
    public void onFullscreenToggled(XWalkViewInternal view, boolean enterFullscreen) {
        if (!(this.mContext instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)this.mContext;
        if (enterFullscreen) {
            if ((activity.getWindow().getAttributes().flags & 0x800) != 0) {
                this.mOriginalForceNotFullscreen = true;
                activity.getWindow().clearFlags(2048);
            } else {
                this.mOriginalForceNotFullscreen = false;
            }
            if (!this.mIsFullscreen) {
                if (Build.VERSION.SDK_INT >= 19) {
                    View decorView = activity.getWindow().getDecorView();
                    this.mSystemUiFlag = decorView.getSystemUiVisibility();
                    decorView.setSystemUiVisibility(5894);
                } else if ((activity.getWindow().getAttributes().flags & 0x400) != 0) {
                    this.mOriginalFullscreen = true;
                } else {
                    this.mOriginalFullscreen = false;
                    activity.getWindow().addFlags(1024);
                }
                this.mIsFullscreen = true;
            }
        } else {
            if (this.mOriginalForceNotFullscreen) {
                activity.getWindow().addFlags(2048);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                activity.getWindow().getDecorView().setSystemUiVisibility(this.mSystemUiFlag);
            } else if (!this.mOriginalFullscreen) {
                activity.getWindow().clearFlags(1024);
            }
            this.mIsFullscreen = false;
        }
    }

    @XWalkAPI
    public void openFileChooser(XWalkViewInternal view, ValueCallback<Uri> uploadFile, String acceptType, String capture) {
        uploadFile.onReceiveValue(null);
    }

    @XWalkAPI
    public void onScaleChanged(XWalkViewInternal view, float oldScale, float newScale) {
    }

    @XWalkAPI
    public boolean shouldOverrideKeyEvent(XWalkViewInternal view, KeyEvent event) {
        return false;
    }

    @XWalkAPI
    public void onUnhandledKeyEvent(XWalkViewInternal view, KeyEvent event) {
    }

    @XWalkAPI
    public boolean onConsoleMessage(XWalkViewInternal view, String message, int lineNumber, String sourceId, ConsoleMessageType messageType) {
        return false;
    }

    @XWalkAPI
    public void onReceivedTitle(XWalkViewInternal view, String title) {
    }

    @XWalkAPI
    public void onPageLoadStarted(XWalkViewInternal view, String url) {
    }

    @XWalkAPI
    public void onPageLoadStopped(XWalkViewInternal view, String url, LoadStatusInternal status) {
    }

    @XWalkAPI
    public boolean onJsAlert(XWalkViewInternal view, String url, String message, XWalkJavascriptResultInternal result) {
        final XWalkJavascriptResultInternal fResult = result;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle((CharSequence)this.mContext.getString(R.string.js_alert_title)).setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)this.mContext.getString(17039370), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                fResult.confirm();
                dialog.dismiss();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                fResult.cancel();
            }
        });
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
        return false;
    }

    @XWalkAPI
    public boolean onJsConfirm(XWalkViewInternal view, String url, String message, XWalkJavascriptResultInternal result) {
        final XWalkJavascriptResultInternal fResult = result;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle((CharSequence)this.mContext.getString(R.string.js_confirm_title)).setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)this.mContext.getString(17039370), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                fResult.confirm();
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)this.mContext.getString(0x1040000), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                fResult.cancel();
            }
        });
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
        return false;
    }

    @XWalkAPI
    public boolean onJsPrompt(XWalkViewInternal view, String url, String message, String defaultValue, XWalkJavascriptResultInternal result) {
        final XWalkJavascriptResultInternal fResult = result;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle((CharSequence)this.mContext.getString(R.string.js_prompt_title)).setMessage((CharSequence)message).setPositiveButton((CharSequence)this.mContext.getString(17039370), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                fResult.confirmWithResult(XWalkUIClientInternal.this.mPromptText.getText().toString());
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)this.mContext.getString(0x1040000), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                fResult.cancel();
            }
        });
        this.mPromptText = new EditText(this.mContext);
        this.mPromptText.setVisibility(0);
        this.mPromptText.setText((CharSequence)defaultValue);
        this.mPromptText.selectAll();
        dialogBuilder.setView((View)this.mPromptText);
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
        return false;
    }

    void setContentsClient(XWalkContentsClient client) {
        this.mContentsClient = client;
    }

    private Activity addContentView(View view, CustomViewCallbackInternal callback) {
        Activity activity = null;
        try {
            Context context = this.mXWalkView.getContext();
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
        }
        catch (ClassCastException context) {
            // empty catch block
        }
        if (this.mCustomXWalkView != null || activity == null) {
            if (callback != null) {
                callback.onCustomViewHidden();
            }
            return null;
        }
        this.mCustomXWalkView = view;
        this.mCustomViewCallback = callback;
        if (this.mContentsClient != null) {
            this.mContentsClient.onToggleFullscreen(true);
        }
        FrameLayout decor = (FrameLayout)activity.getWindow().getDecorView();
        decor.addView(this.mCustomXWalkView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        return activity;
    }

    @XWalkAPI
    public void onShowCustomView(View view, CustomViewCallbackInternal callback) {
        this.addContentView(view, callback);
    }

    @XWalkAPI
    public void onShowCustomView(View view, int requestedOrientation, CustomViewCallbackInternal callback) {
        Activity activity = this.addContentView(view, callback);
        if (activity == null) {
            return;
        }
        int orientation = activity.getResources().getConfiguration().orientation;
        if (requestedOrientation != orientation && requestedOrientation >= -1 && requestedOrientation <= 14) {
            this.mPreOrientation = orientation;
            activity.setRequestedOrientation(requestedOrientation);
        }
    }

    @XWalkAPI
    public void onHideCustomView() {
        if (this.mCustomXWalkView == null || !(this.mXWalkView.getContext() instanceof Activity)) {
            return;
        }
        if (this.mContentsClient != null) {
            this.mContentsClient.onToggleFullscreen(false);
        }
        Activity activity = (Activity)this.mXWalkView.getContext();
        FrameLayout decor = (FrameLayout)activity.getWindow().getDecorView();
        decor.removeView(this.mCustomXWalkView);
        if (this.mCustomViewCallback != null) {
            this.mCustomViewCallback.onCustomViewHidden();
        }
        if (this.mPreOrientation != -2 && this.mPreOrientation >= -1 && this.mPreOrientation <= 14) {
            activity.setRequestedOrientation(this.mPreOrientation);
            this.mPreOrientation = -2;
        }
        this.mCustomXWalkView = null;
        this.mCustomViewCallback = null;
    }

    @XWalkAPI
    public static enum LoadStatusInternal {
        FINISHED,
        FAILED,
        CANCELLED;

    }

    @XWalkAPI
    public static enum ConsoleMessageType {
        DEBUG,
        ERROR,
        LOG,
        INFO,
        WARNING;

    }

    @XWalkAPI
    public static enum JavascriptMessageTypeInternal {
        JAVASCRIPT_ALERT,
        JAVASCRIPT_CONFIRM,
        JAVASCRIPT_PROMPT,
        JAVASCRIPT_BEFOREUNLOAD;

    }

    @XWalkAPI
    public static enum InitiateByInternal {
        BY_USER_GESTURE,
        BY_JAVASCRIPT;

    }
}

