/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.chromium.base.ApplicationStatusManager;
import org.chromium.base.CommandLine;
import org.chromium.base.PathUtils;
import org.chromium.base.ResourceExtractor;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.browser.BrowserStartupController;
import org.chromium.content.browser.DeviceUtils;
import org.xwalk.core.internal.MixedContext;
import org.xwalk.core.internal.XWalkInternalResources;
import org.xwalk.core.internal.XWalkPreferencesInternal;
import org.xwalk.core.internal.XWalkPresentationHost;

@JNINamespace(value="xwalk")
class XWalkViewDelegate {
    private static boolean sInitialized = false;
    private static boolean sLibraryLoaded = false;
    private static boolean sLoadedByHoudini = false;
    private static String sDeviceAbi;
    private static final String PRIVATE_DATA_DIRECTORY_SUFFIX = "xwalkcore";
    private static final String XWALK_CORE_EXTRACTED_DIR = "extracted_xwalkcore";
    private static final String META_XWALK_ENABLE_DOWNLOAD_MODE = "xwalk_enable_download_mode";
    private static final String META_XWALK_DOWNLOAD_MODE = "xwalk_download_mode";
    private static final String[] MANDATORY_PAKS;
    private static final String[] MANDATORY_LIBRARIES;
    private static final String TAG = "XWalkLib";
    private static final String XWALK_RESOURCES_LIST_RES_NAME = "xwalk_resources_list";
    private static final String XWALK_PAK_NAME = "xwalk.pak";
    private static final String COMMAND_LINE_FILE = "xwalk-command-line";

    XWalkViewDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readCommandLine(Context context) {
        InputStreamReader reader = null;
        try {
            int length;
            InputStream input = context.getAssets().open(COMMAND_LINE_FILE, 3);
            int size = 1024;
            char[] buffer = new char[size];
            StringBuilder builder = new StringBuilder();
            reader = new InputStreamReader(input, "UTF-8");
            while ((length = reader.read(buffer, 0, size)) != -1) {
                builder.append(buffer, 0, length);
            }
            String[] stringArray = CommandLine.tokenizeQuotedAruments(builder.toString().toCharArray());
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to close file reader.", (Throwable)e);
            }
        }
    }

    public static void init(Context libContext, Context appContext) {
        if (!XWalkViewDelegate.loadXWalkLibrary(libContext, null)) {
            throw new RuntimeException("Failed to load native library");
        }
        if (sInitialized) {
            return;
        }
        Object context = libContext == null ? appContext : new MixedContext(libContext, appContext);
        PathUtils.setPrivateDataDirectorySuffix(PRIVATE_DATA_DIRECTORY_SUFFIX, context);
        XWalkInternalResources.resetIds(context);
        if (!CommandLine.isInitialized()) {
            CommandLine.init(XWalkViewDelegate.readCommandLine(context.getApplicationContext()));
        }
        try {
            XWalkViewDelegate.setupResourceInterceptor(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ResourceExtractor.get(context);
        XWalkViewDelegate.startBrowserProcess(context);
        if (appContext instanceof Activity) {
            ApplicationStatusManager.init(((Activity)appContext).getApplication());
        } else if (appContext instanceof Service) {
            ApplicationStatusManager.init(((Service)appContext).getApplication());
        }
        XWalkPresentationHost.createInstanceOnce(context);
        sInitialized = true;
    }

    public static boolean loadXWalkLibrary(Context context) {
        return XWalkViewDelegate.loadXWalkLibrary(context, null);
    }

    public static boolean loadXWalkLibrary(Context context, String libDir) throws UnsatisfiedLinkError {
        if (sLibraryLoaded) {
            return true;
        }
        if (libDir != null && !sLoadedByHoudini) {
            for (String library : MANDATORY_LIBRARIES) {
                System.load(libDir + File.separator + "lib" + library + ".so");
            }
        } else {
            for (String library : MANDATORY_LIBRARIES) {
                System.loadLibrary(library);
            }
        }
        try {
            LibraryLoader libraryLoader = LibraryLoader.get(1);
            libraryLoader.loadNow(context);
        }
        catch (ProcessInitException processInitException) {
            // empty catch block
        }
        if (XWalkViewDelegate.nativeIsLibraryBuiltForIA()) {
            Log.d((String)TAG, (String)"Native library is built for IA");
        } else {
            Log.d((String)TAG, (String)"Native library is built for ARM");
            if (XWalkViewDelegate.isIaDevice()) {
                Log.d((String)TAG, (String)"Crosswalk's native library does not support Houdini");
                sLoadedByHoudini = true;
                return false;
            }
        }
        sLibraryLoaded = true;
        return true;
    }

    private static void startBrowserProcess(final Context context) {
        ThreadUtils.runOnUiThreadBlocking(new Runnable(){

            @Override
            public void run() {
                try {
                    LibraryLoader.get(1).ensureInitialized(context);
                }
                catch (ProcessInitException e) {
                    throw new RuntimeException("Cannot initialize Crosswalk Core", e);
                }
                DeviceUtils.addDeviceSpecificUserAgentSwitch(context);
                CommandLine.getInstance().appendSwitchWithValue("profile-name", XWalkPreferencesInternal.getStringValue("profile-name"));
                if (XWalkPreferencesInternal.getValue("animatable-xwalk-view") && !CommandLine.getInstance().hasSwitch("disable-gpu-rasterization")) {
                    CommandLine.getInstance().appendSwitch("disable-gpu-rasterization");
                }
                try {
                    BrowserStartupController.get(context, 1).startBrowserProcessesSync(true);
                }
                catch (ProcessInitException e) {
                    throw new RuntimeException("Cannot initialize Crosswalk Core", e);
                }
            }
        });
    }

    private static void setupResourceInterceptor(final Context context) throws IOException {
        final boolean isSharedMode = !context.getPackageName().equals(context.getApplicationContext().getPackageName());
        String enable = XWalkViewDelegate.getApplicationMetaData(context, META_XWALK_DOWNLOAD_MODE);
        if (enable == null) {
            enable = XWalkViewDelegate.getApplicationMetaData(context, META_XWALK_ENABLE_DOWNLOAD_MODE);
        }
        final boolean isDownloadMode = enable != null && (enable.equalsIgnoreCase("enable") || enable.equalsIgnoreCase("true"));
        final boolean isTestApk = !isSharedMode && Arrays.asList(context.getAssets().list("")).contains(XWALK_PAK_NAME);
        HashMap<String, ResourceExtractor.ResourceEntry> resourceList = new HashMap<String, ResourceExtractor.ResourceEntry>();
        try {
            String[] crosswalkResources;
            int resourceListId = XWalkViewDelegate.getResourceId(context, XWALK_RESOURCES_LIST_RES_NAME, "array");
            for (String resource : crosswalkResources = context.getResources().getStringArray(resourceListId)) {
                resourceList.put(resource, new ResourceExtractor.ResourceEntry(0, "", resource));
            }
        }
        catch (Resources.NotFoundException e) {
            for (String resource : MANDATORY_PAKS) {
                resourceList.put(resource, new ResourceExtractor.ResourceEntry(0, "", resource));
            }
        }
        ResourceExtractor.setResourcesToExtract(resourceList.values().toArray(new ResourceExtractor.ResourceEntry[resourceList.size()]));
        final HashSet interceptableResources = new HashSet(resourceList.keySet());
        ResourceExtractor.setResourceInterceptor(new ResourceExtractor.ResourceInterceptor(){

            @Override
            public boolean shouldInterceptLoadRequest(String resource) {
                return interceptableResources.contains(resource);
            }

            @Override
            public InputStream openRawResource(String resource) {
                if (isSharedMode || isTestApk) {
                    try {
                        return context.getAssets().open(resource);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(resource + " can't be found in assets.");
                    }
                }
                if (isDownloadMode) {
                    try {
                        String resDir = context.getApplicationContext().getDir(XWalkViewDelegate.XWALK_CORE_EXTRACTED_DIR, 0).getAbsolutePath();
                        return new FileInputStream(new File(resDir, resource));
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(resource + " can't be found.");
                    }
                }
                String resourceName = resource.split("\\.")[0];
                int resourceId = XWalkViewDelegate.getResourceId(context, resourceName, "raw");
                try {
                    return context.getResources().openRawResource(resourceId);
                }
                catch (Resources.NotFoundException e) {
                    throw new RuntimeException("R.raw." + resourceName + " can't be found.");
                }
            }
        });
    }

    private static int getResourceId(Context context, String resourceName, String resourceType) {
        int resourceId = context.getResources().getIdentifier(resourceName, resourceType, context.getClass().getPackage().getName());
        if (resourceId == 0) {
            resourceId = context.getResources().getIdentifier(resourceName, resourceType, context.getPackageName());
        }
        return resourceId;
    }

    private static String getApplicationMetaData(Context context, String name) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            return appInfo.metaData.get(name).toString();
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            return null;
        }
    }

    private static boolean isIaDevice() {
        String abi = XWalkViewDelegate.getDeviceAbi();
        return abi.equals("x86") || abi.equals("x86_64");
    }

    private static String getDeviceAbi() {
        if (sDeviceAbi == null) {
            try {
                sDeviceAbi = Build.SUPPORTED_ABIS[0].toLowerCase();
            }
            catch (NoSuchFieldError e) {
                try {
                    Process process = Runtime.getRuntime().exec("getprop ro.product.cpu.abi");
                    InputStreamReader ir = new InputStreamReader(process.getInputStream());
                    BufferedReader input = new BufferedReader(ir);
                    sDeviceAbi = input.readLine().toLowerCase();
                    input.close();
                    ir.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Can not detect device's ABI");
                }
            }
            Log.d((String)TAG, (String)("Device ABI: " + sDeviceAbi));
        }
        return sDeviceAbi;
    }

    private static native boolean nativeIsLibraryBuiltForIA();

    static {
        MANDATORY_PAKS = new String[]{XWALK_PAK_NAME, "icudtl.dat", "xwalk_100_percent.pak"};
        MANDATORY_LIBRARIES = new String[]{PRIVATE_DATA_DIRECTORY_SUFFIX};
    }
}

