/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.util.Log;
import android.view.KeyEvent;
import android.webkit.ConsoleMessage;
import org.chromium.content.browser.ContentVideoView;
import org.xwalk.core.internal.XWalkContentsClient;
import org.xwalk.core.internal.XWalkWebContentsDelegate;

class XWalkWebContentsDelegateAdapter
extends XWalkWebContentsDelegate {
    private static final String TAG = XWalkWebContentsDelegateAdapter.class.getName();
    private XWalkContentsClient mXWalkContentsClient;

    public XWalkWebContentsDelegateAdapter(XWalkContentsClient client) {
        this.mXWalkContentsClient = client;
    }

    @Override
    public boolean shouldCreateWebContents(String contentUrl) {
        if (this.mXWalkContentsClient != null) {
            return this.mXWalkContentsClient.shouldCreateWebContents(contentUrl);
        }
        return super.shouldCreateWebContents(contentUrl);
    }

    @Override
    public void onLoadProgressChanged(int progress) {
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onProgressChanged(progress);
        }
    }

    @Override
    public boolean addNewContents(boolean isDialog, boolean isUserGesture) {
        return this.mXWalkContentsClient.onCreateWindow(isDialog, isUserGesture);
    }

    @Override
    public void closeContents() {
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onCloseWindow();
        }
    }

    @Override
    public void activateContents() {
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onRequestFocus();
        }
    }

    @Override
    public void rendererUnresponsive() {
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onRendererUnresponsive();
        }
    }

    @Override
    public void rendererResponsive() {
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onRendererResponsive();
        }
    }

    @Override
    public void handleKeyboardEvent(KeyEvent event) {
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onUnhandledKeyEvent(event);
        }
    }

    @Override
    public boolean addMessageToConsole(int level, String message, int lineNumber, String sourceId) {
        if (this.mXWalkContentsClient == null) {
            return false;
        }
        ConsoleMessage.MessageLevel messageLevel = ConsoleMessage.MessageLevel.DEBUG;
        switch (level) {
            case 0: {
                messageLevel = ConsoleMessage.MessageLevel.TIP;
                break;
            }
            case 1: {
                messageLevel = ConsoleMessage.MessageLevel.LOG;
                break;
            }
            case 2: {
                messageLevel = ConsoleMessage.MessageLevel.WARNING;
                break;
            }
            case 3: {
                messageLevel = ConsoleMessage.MessageLevel.ERROR;
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown message level, defaulting to DEBUG");
            }
        }
        return this.mXWalkContentsClient.onConsoleMessage(new ConsoleMessage(message, sourceId, lineNumber, messageLevel));
    }

    @Override
    public void toggleFullscreen(boolean enterFullscreen) {
        ContentVideoView videoView;
        if (!enterFullscreen && (videoView = ContentVideoView.getContentVideoView()) != null) {
            videoView.exitFullscreen(false);
        }
        if (this.mXWalkContentsClient != null) {
            this.mXWalkContentsClient.onToggleFullscreen(enterFullscreen);
        }
    }

    @Override
    public boolean isFullscreen() {
        if (this.mXWalkContentsClient != null) {
            return this.mXWalkContentsClient.hasEnteredFullscreen();
        }
        return false;
    }

    @Override
    public boolean shouldOverrideRunFileChooser(int processId, int renderId, int mode, String acceptTypes, boolean capture) {
        if (this.mXWalkContentsClient != null) {
            return this.mXWalkContentsClient.shouldOverrideRunFileChooser(processId, renderId, mode, acceptTypes, capture);
        }
        return false;
    }
}

