/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.wifidirect;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtensionWithActivityStateListener;

public class WifiDirect
extends XWalkExtensionWithActivityStateListener {
    public static final String JS_API_PATH = "jsapi/wifidirect_api.js";
    private static final String TAG = "WifiDirect";
    private static final String NAME = "xwalk.experimental.wifidirect";
    private static final String TAG_ASYNC_CALL_ID = "asyncCallId";
    private static final String TAG_CMD = "cmd";
    private static final String TAG_CONNECTED = "connected";
    private static final String TAG_DATA = "data";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_ERROR = "error";
    private static final String TAG_ERROR_CODE = "errorCode";
    private static final String TAG_EVENT_NAME = "eventName";
    private static final String TAG_FALSE = "false";
    private static final String TAG_GROUP_FORMED = "groupFormed";
    private static final String TAG_IS_SERVER = "isServer";
    private static final String TAG_MAC = "MAC";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_NAME = "name";
    private static final String TAG_SERVER_IP = "serverIP";
    private static final String TAG_STATUS = "status";
    private static final String TAG_TRUE = "true";
    private static final String TAG_TYPE = "type";
    private static final String CMD_CANCEL_CONNECT = "cancelConnect";
    private static final String CMD_CONNECT = "connect";
    private static final String CMD_DISCONNECT = "disconnect";
    private static final String CMD_DISCOVER_PEERS = "discoverPeers";
    private static final String CMD_GET_CONNECTION_INFO = "getConnectionInfo";
    private static final String CMD_GET_PEERS = "getPeers";
    private static final String CMD_INIT = "init";
    private static final String EVENT_CONNECTION_CHANGED = "connectionchanged";
    private static final String EVENT_DISCOVERY_STOPPED = "discoverystoppedevent";
    private static final String EVENT_PEERS_CHANGED = "peerschanged";
    private static final String EVENT_THIS_DEVICE_CHANGED = "thisdevicechanged";
    private static final String EVENT_WIFI_STATE_CHANGED = "wifistatechanged";
    private static final String STATE_AVAILABLE = "available";
    private static final String STATE_CONNECTED = "connected";
    private static final String STATE_FAILED = "failed";
    private static final String STATE_INVITED = "invited";
    private static final String STATE_UNAVAILABLE = "unavailable";
    private static final String ERROR_P2P_UNSUPPORTED = "WifiP2pManager.P2P_UNSUPPORTED";
    private static final String ERROR_NO_SERVICE_REQUESTS = "WifiP2pManager.NO_SERVICE_REQUESTS";
    private static final String ERROR_BUSY = "WifiP2pManager.BUSY";
    private static final String ERROR_DEFAULT = "WifiP2pManager.ERROR";
    private static final String ERROR_INVALID_CALL_NO_DATA_MSG = "Error: Invalid connect API call - data === null";
    private static final String ERROR_GENERAL_ERROR_MSG_STEM = "Android WiFi Direct error: ";
    private static final String ERROR_REASON_CODE_STEM = "WifiP2pManager reasonCode: ";
    private WifiP2pManager mManager = null;
    private WifiP2pManager.Channel mChannel = null;
    private BroadcastReceiver mReceiver = null;
    private IntentFilter mIntentFilter;
    private boolean mReceiverRegistered = false;
    private Activity mActivity = null;

    public WifiDirect(String jsApiContent, Activity activity) {
        super(NAME, jsApiContent, activity);
        this.mActivity = activity;
    }

    private WifiP2pManager.ActionListener createCallActionListener(final int instanceID, final JSONObject jsonOutput) {
        return new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                try {
                    jsonOutput.put(WifiDirect.TAG_DATA, true);
                }
                catch (JSONException e) {
                    WifiDirect.this.printErrorMessage(e);
                }
                WifiDirect.this.postMessage(instanceID, jsonOutput.toString());
            }

            public void onFailure(int reasonCode) {
                WifiDirect.this.setError(jsonOutput, "", reasonCode);
                WifiDirect.this.postMessage(instanceID, jsonOutput.toString());
            }
        };
    }

    private void disconnect(final int instanceID, final JSONObject jsonOutput) {
        if (this.mManager != null && this.mChannel != null) {
            this.mManager.requestGroupInfo(this.mChannel, new WifiP2pManager.GroupInfoListener(){

                public void onGroupInfoAvailable(WifiP2pGroup group) {
                    if (group != null) {
                        WifiDirect.this.mManager.removeGroup(WifiDirect.this.mChannel, WifiDirect.this.createCallActionListener(instanceID, jsonOutput));
                    }
                }
            });
        }
    }

    private void handleMessage(final int instanceID, String message) {
        try {
            JSONObject jsonInput = new JSONObject(message);
            String cmd = jsonInput.getString(TAG_CMD);
            String asyncCallId = jsonInput.getString(TAG_ASYNC_CALL_ID);
            final JSONObject jsonOutput = new JSONObject();
            jsonOutput.put(TAG_ASYNC_CALL_ID, (Object)asyncCallId);
            if (cmd.equals(CMD_DISCOVER_PEERS)) {
                this.mManager.discoverPeers(this.mChannel, this.createCallActionListener(instanceID, jsonOutput));
            } else if (cmd.equals(CMD_GET_PEERS)) {
                this.mManager.requestPeers(this.mChannel, new WifiP2pManager.PeerListListener(){

                    public void onPeersAvailable(WifiP2pDeviceList peers) {
                        try {
                            jsonOutput.put(WifiDirect.TAG_DATA, (Object)WifiDirect.this.convertListToJSON(peers));
                        }
                        catch (JSONException e) {
                            WifiDirect.this.printErrorMessage(e);
                        }
                        WifiDirect.this.postMessage(instanceID, jsonOutput.toString());
                    }
                });
            } else if (cmd.equals(CMD_INIT)) {
                jsonOutput.put(TAG_DATA, this.init());
                this.postMessage(instanceID, jsonOutput.toString());
            } else if (cmd.equals(CMD_GET_CONNECTION_INFO)) {
                this.mManager.requestConnectionInfo(this.mChannel, new WifiP2pManager.ConnectionInfoListener(){

                    public void onConnectionInfoAvailable(WifiP2pInfo info) {
                        try {
                            JSONObject data = new JSONObject();
                            jsonOutput.put(WifiDirect.TAG_DATA, (Object)data);
                            data.put(WifiDirect.TAG_GROUP_FORMED, info.groupFormed);
                            if (info.groupFormed) {
                                data.put(WifiDirect.TAG_IS_SERVER, info.isGroupOwner);
                                data.put(WifiDirect.TAG_SERVER_IP, (Object)(info.isGroupOwner ? "" : info.groupOwnerAddress.toString().replace("/", "")));
                            }
                            WifiDirect.this.postMessage(instanceID, jsonOutput.toString());
                        }
                        catch (JSONException e) {
                            WifiDirect.this.printErrorMessage(e);
                        }
                    }
                });
            } else if (cmd.equals(CMD_CONNECT)) {
                JSONObject dev = jsonInput.getJSONObject(TAG_DATA);
                if (dev == null) {
                    this.setError(jsonOutput, ERROR_INVALID_CALL_NO_DATA_MSG, 0);
                    this.postMessage(instanceID, jsonOutput.toString());
                } else {
                    WifiP2pConfig config = new WifiP2pConfig();
                    config.deviceAddress = dev.getString(TAG_MAC);
                    config.wps.setup = 0;
                    this.mManager.connect(this.mChannel, config, this.createCallActionListener(instanceID, jsonOutput));
                }
            } else if (cmd.equals(CMD_CANCEL_CONNECT)) {
                this.mManager.cancelConnect(this.mChannel, this.createCallActionListener(instanceID, jsonOutput));
            } else if (cmd.equals(CMD_DISCONNECT)) {
                this.disconnect(instanceID, jsonOutput);
            }
        }
        catch (JSONException e) {
            this.printErrorMessage(e);
        }
    }

    private JSONObject setEventData(JSONObject out, String eventName) throws JSONException {
        out.put(TAG_EVENT_NAME, (Object)eventName);
        JSONObject data = new JSONObject();
        out.put(TAG_DATA, (Object)data);
        return data;
    }

    private boolean init() {
        if (this.mActivity == null) {
            return false;
        }
        this.mManager = (WifiP2pManager)this.mActivity.getSystemService("wifip2p");
        this.mChannel = this.mManager.initialize((Context)this.mActivity, this.mActivity.getMainLooper(), null);
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                JSONObject out = new JSONObject();
                try {
                    if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
                        WifiDirect.this.setEventData(out, WifiDirect.EVENT_WIFI_STATE_CHANGED).put(WifiDirect.TAG_ENABLED, (Object)(intent.getIntExtra("wifi_p2p_state", -1) == 2 ? WifiDirect.TAG_TRUE : WifiDirect.TAG_FALSE));
                    } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
                        WifiDirect.this.setEventData(out, WifiDirect.EVENT_PEERS_CHANGED);
                    } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action)) {
                        NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                        WifiDirect.this.setEventData(out, WifiDirect.EVENT_CONNECTION_CHANGED).put("connected", networkInfo.isConnected());
                    } else if ("android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
                        WifiP2pDevice dev = (WifiP2pDevice)intent.getParcelableExtra("wifiP2pDevice");
                        WifiDirect.this.convertDeviceToJSON(WifiDirect.this.setEventData(out, WifiDirect.EVENT_THIS_DEVICE_CHANGED), dev);
                    } else if ("android.net.wifi.p2p.DISCOVERY_STATE_CHANGE".equals(action)) {
                        if (intent.getIntExtra("discoveryState", -1) != 1) {
                            return;
                        }
                        WifiDirect.this.setEventData(out, WifiDirect.EVENT_DISCOVERY_STOPPED);
                    }
                    WifiDirect.this.broadcastMessage(out.toString());
                }
                catch (JSONException e) {
                    WifiDirect.this.printErrorMessage(e);
                }
            }
        };
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        this.mIntentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.p2p.DISCOVERY_STATE_CHANGE");
        if (!this.mReceiverRegistered) {
            this.mActivity.registerReceiver(this.mReceiver, this.mIntentFilter);
            this.mReceiverRegistered = true;
        }
        return true;
    }

    private String convertStateToString(int state) {
        switch (state) {
            case 3: {
                return STATE_AVAILABLE;
            }
            case 0: {
                return "connected";
            }
            case 2: {
                return STATE_FAILED;
            }
            case 1: {
                return STATE_INVITED;
            }
            case 4: {
                return STATE_UNAVAILABLE;
            }
        }
        return "";
    }

    private void convertDeviceToJSON(JSONObject ob, WifiP2pDevice peer) throws JSONException {
        ob.put(TAG_MAC, (Object)peer.deviceAddress);
        ob.put(TAG_NAME, (Object)peer.deviceName);
        ob.put(TAG_TYPE, (Object)peer.primaryDeviceType);
        ob.put(TAG_STATUS, (Object)this.convertStateToString(peer.status));
    }

    private JSONArray convertListToJSON(WifiP2pDeviceList peers) throws JSONException {
        JSONArray arr = new JSONArray();
        for (WifiP2pDevice peer : peers.getDeviceList()) {
            JSONObject ob = new JSONObject();
            this.convertDeviceToJSON(ob, peer);
            arr.put((Object)ob);
        }
        return arr;
    }

    protected void printErrorMessage(JSONException e) {
        Log.e((String)TAG, (String)e.toString());
    }

    private String convertReasonCodeToString(int reasonCode) {
        switch (reasonCode) {
            case 2: {
                return ERROR_BUSY;
            }
            case 0: {
                return ERROR_DEFAULT;
            }
            case 3: {
                return ERROR_NO_SERVICE_REQUESTS;
            }
            case 1: {
                return ERROR_P2P_UNSUPPORTED;
            }
        }
        return ERROR_REASON_CODE_STEM + reasonCode;
    }

    protected void setError(JSONObject out, String errorMessage, int reasonCode) {
        JSONObject data = new JSONObject();
        JSONObject error = new JSONObject();
        try {
            out.put(TAG_DATA, (Object)data);
            error.put(TAG_MESSAGE, (Object)(errorMessage.isEmpty() ? ERROR_GENERAL_ERROR_MSG_STEM + this.convertReasonCodeToString(reasonCode) : errorMessage));
            error.put(TAG_ERROR_CODE, reasonCode);
            data.put(TAG_ERROR, (Object)error);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    @Override
    public void onMessage(int instanceID, String message) {
        if (!message.isEmpty()) {
            this.handleMessage(instanceID, message);
        }
    }

    @Override
    public void onActivityStateChange(Activity activity, int newState) {
        if (this.mReceiver == null) {
            return;
        }
        switch (newState) {
            case 3: {
                this.mActivity = activity;
                if (this.mReceiverRegistered) break;
                this.mActivity.registerReceiver(this.mReceiver, this.mIntentFilter);
                this.mReceiverRegistered = true;
                break;
            }
            case 4: {
                if (this.mReceiverRegistered) {
                    this.mActivity.unregisterReceiver(this.mReceiver);
                    this.mReceiverRegistered = false;
                }
                this.mActivity = null;
                break;
            }
        }
    }

    @Override
    public String onSyncMessage(int instanceID, String message) {
        return null;
    }
}

