/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.view.MotionEvent;
import oz.client.shape.ui.ICSignPadWnd;
import oz.client.shape.ui.OZSignView$1;
import oz.client.shape.ui.OZSignView$2;
import oz.client.shape.ui.OZSignView$3;
import oz.client.shape.ui.OZSignView$4;
import oz.client.shape.ui.OZSignView$5;
import oz.client.shape.ui.OZSignViewBase;
import oz.client.shape.ui.data.OZSignPadGuideLineData;
import oz.client.shape.ui.view.OZSignpadScrollView;
import oz.main.OZStorage;
import oz.util.AutoSizeTextDrawHelper;
import oz.util.OZPathSkia;

public class OZSignView
extends OZSignViewBase {
    private static final long BITMAP_MAX_SIZE = 0x1400000L;
    private static final int BITMAP_MAX_WIDTH = 15000;
    private static final int BITMAP_MAX_HEIGHT = 15000;
    private OZPathSkia mPath;
    private OZPathSkia mAllTempPath;
    private Bitmap mBitmap;
    private float mBitmapScale;
    private Canvas mCanvas;
    private Paint mPaint;
    private Paint mBitmapPaint;
    private Rect mTextDrawRect;
    private Paint mTextPaint;
    private float mFixedTextScale;
    private boolean mReadyPath;
    private boolean mIsApplyParamPenThick;
    private float mStrokeWidth;
    private float mStrokeWidthParam;
    private float mStrokeWidthDefault;
    private RectF mScaledSize;
    private float mScale;
    private PointF mScaleXY;
    private int mActivePointerId;
    private PointF mTouchTemp;
    private PointF mTouchTempS;
    private boolean mIsTouchMove;
    private boolean mIsTouchErase;
    private PointF mTouchPoint;
    private PointF mTouchPointS;
    private PointF mTouchMove;
    private PointF mTouchMoveS;
    private float msPressure;
    private long mSignStartTime;
    private byte[] mFirstextBytes;
    private boolean mIsSignMove;
    private boolean mIsSignClick;
    private RectF mTempRectF;
    private boolean mClickEmptyButton;
    private boolean mIsTracingOutline;
    private boolean mIsOnlyShowTracingOutline;
    private RectF mNextScrollTouchRect;
    private boolean mRequestScroll;
    private boolean mIsUpdatePathClear;
    private OZSignPadGuideLineData mGuideLineData;
    private RectF mGuideLineRect;
    private Paint mGuideLinePaint;
    public float mMinTextSize = 0.0f;
    private AutoSizeTextDrawHelper mAutoTextDrawHelper;
    private Rect mTextDrawTemp;
    static final float TOUCH_TOLERANCE = 4.0f;

    public OZSignView(Context context, ICSignPadWnd iCSignPadWnd, float f2, float f3, float f4, float f5) {
        super(context, iCSignPadWnd, f2, f3);
        this.initOS();
        this.initValue();
        this.initSize(f4, f5);
        this.initPaint();
        this.initGuideLineOptions();
        this.init();
        this.getPostSignData();
    }

    private void initOS() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    private void initValue() {
        this.mActivePointerId = -1;
        this.mIsTouchMove = false;
        this.mIsTouchErase = false;
        this.mBitmapScale = 1.0f;
        this.getICParent().getRealSignRect().setEmpty();
        this.getICParent().getSignPadRect().setEmpty();
        this.mPath = new OZPathSkia();
        this.mAllTempPath = new OZPathSkia();
        this.mTempRectF = new RectF();
        this.mNextScrollTouchRect = new RectF();
        this.mTextDrawRect = new Rect();
        this.mTouchTemp = new PointF();
        this.mTouchTempS = new PointF();
        this.mTouchPoint = new PointF();
        this.mTouchPointS = new PointF();
        this.mTouchMove = new PointF();
        this.mTouchMoveS = new PointF();
        this.mIsApplyParamPenThick = this.getICParent().isSignApplyPenWidthParam();
        this.mStrokeWidthParam = this.getICParent().getSignPenWidthParam();
        this.mStrokeWidthDefault = this.getICParent().getSignPenWidthDefault();
        this.mStrokeWidth = this.getICParent().getSignPenWidth();
        this.mIsTracingOutline = this.getICParent().isTracingOutLine();
    }

    private void initSize(float f2, float f3) {
        this.mScaledSize = new RectF(0.0f, 0.0f, f2, f3);
        this.mScaleXY = new PointF();
        this.updateScale();
    }

    private void initPaint() {
        this.mBitmapPaint = new Paint(4);
        this.mPaint = new Paint(1);
        this.mPaint.setDither(true);
        this.mPaint.setColor(this.getICParent().getSignPenColor());
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        float f2 = this.mStrokeWidthParam;
        if (f2 == 0.0f) {
            f2 = this.mStrokeWidth;
        }
        if (this.mIsApplyParamPenThick && !this.getICParent().isSignModePadLikeFitToFrame()) {
            float f3 = 7.0f;
            this.mPaint.setStrokeWidth(this.mIsApplyParamPenThick ? f2 * f3 : this.mStrokeWidth * this.mScale);
        } else {
            this.mPaint.setStrokeWidth(this.mIsApplyParamPenThick ? f2 * this.mScale : this.mStrokeWidth * this.mScale);
        }
        this.mTextPaint = new Paint(1);
        if (this.getICParent().getTextTypeface() != null) {
            this.mTextPaint.setTypeface(this.getICParent().getTextTypeface().getAndroidTypeface());
        }
        this.applyChangedTextSize();
        this.mTextPaint.setColor((this.getICParent().isSignModeZoom() ? -1 : 0x33FFFFFF) & this.getICParent().getComponentTextColor());
        this.mTextPaint.setFakeBoldText(this.getICParent().isTextBold());
    }

    private void initGuideLineOptions() {
        this.mGuideLineData = new OZSignPadGuideLineData(this.getICParent().getCustomUIJSONString());
        int n = this.getICParent().getGuideLineShapeType();
        if (n != 1) {
            this.mGuideLineData.setShapeType(n);
        }
        if (this.mGuideLineData.getShapeType() > 1 && this.mGuideLineData.isValid()) {
            this.mGuideLinePaint = new Paint(1);
            this.mGuideLinePaint.setColor(this.mGuideLineData.getColor());
            this.mGuideLinePaint.setStyle(Paint.Style.STROKE);
            this.mGuideLinePaint.setStrokeWidth(this.mGuideLineData.getThickness() * OZStorage.DpPerPx(this.getContext(), true));
            if (this.mGuideLineData.getLineType() == 1) {
                this.mGuideLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.getGuideLineDashWidth(), this.getGuideLineBlankWidth()}, 0.0f));
            }
            this.mGuideLineRect = new RectF();
        } else {
            this.mGuideLineData = null;
        }
    }

    private float getGuideLineDashWidth() {
        return Math.max(12.0f * OZStorage.DpPerPx(this.getContext(), true), this.mGuideLinePaint.getStrokeWidth());
    }

    private float getGuideLineBlankWidth() {
        return this.getGuideLineDashWidth() * 0.5f;
    }

    private void updateGuideLineRect(int n, int n2) {
        if (this.mGuideLineData != null) {
            int n3 = (int)((float)n * 0.05f);
            int n4 = n2 / 4;
            int n5 = n4 * 3;
            switch (this.mGuideLineData.getShapeType()) {
                default: 
            }
            if (this.mGuideLineData.getLineType() == 1) {
                float f2 = this.getGuideLineDashWidth();
                float f3 = this.getGuideLineBlankWidth();
                float f4 = (float)(n - 2 * n3) - f2;
                float f5 = (float)(n5 - n4) - f2;
                float f6 = f4 % (f2 + f3);
                float f7 = (f5 + this.mGuideLinePaint.getStrokeWidth()) % (f2 + f3);
                float f8 = f2 + f3;
                if ((float)n3 < f8 * 2.0f) {
                    f8 = -f8;
                }
                if (f6 > (f2 + f3) / 2.0f) {
                    f6 -= f8;
                }
                if (f7 > (f2 + f3) / 2.0f) {
                    f7 -= f8;
                }
                this.mGuideLineRect.set((float)n3 + f6 / 2.0f, (float)n4 + f7 / 2.0f, (float)(n - n3) - f6 / 2.0f, (float)n5 - f7 / 2.0f);
            } else {
                this.mGuideLineRect.set((float)n3, (float)n4, (float)(n - n3), (float)n5);
            }
        }
    }

    public void setTextDrawRect(Rect rect) {
        if (rect != null) {
            this.mTextDrawRect.set(rect);
        } else {
            this.mTextDrawRect.setEmpty();
        }
    }

    public void setFixedTextScale(float f2) {
        this.mFixedTextScale = f2;
        this.applyChangedTextSize();
    }

    public void setOnlyShowTracingOutline(boolean bl) {
        this.mIsOnlyShowTracingOutline = bl;
    }

    public RectF getScaledSize() {
        return this.mScaledSize;
    }

    public float getSignScale() {
        return this.mScale;
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        OZSignpadScrollView oZSignpadScrollView = this.getICParent().getScrollableScrollView();
        if (oZSignpadScrollView != null) {
            oZSignpadScrollView.cancelScroll();
            oZSignpadScrollView.onScrollChanged(oZSignpadScrollView.getHorizontalCommand());
        }
    }

    public void clear() {
        this.clear(0);
    }

    public void clear(boolean bl) {
        this.clear(bl ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int n) {
        boolean bl = false;
        this.mClickEmptyButton = true;
        this.mReadyPath = false;
        this.mAllTempPath.reset();
        this.getICParent().getSignPath().reset();
        this.getICParent().setSignBytesLengthDefault();
        this.getICParent().changed();
        this.getICParent().getRealSignRect().setEmpty();
        this.getICParent().clearSignPathData();
        this.getICParent().restPenWidth();
        this.getICParent().erasePathUpdateClear();
        this.getICParent().updateTempPathClear();
        this.appendEnd();
        this.getICParent().setSignPressureMode(n);
        if (this.getICParent().isSignDrawBitmapMode()) {
            this.getICParent().bitmapClear();
            this.getICParent().clearNativeBitmap();
            if (!this.getICParent().isEmptyComponent()) {
                this.getCompSize().set(0.0f, 0.0f, this.getICParent().getCompOriginalWidth(), this.getICParent().getCompOriginalHeight());
                this.getICParent().setComponentSize(this.getCompSize().width(), this.getCompSize().height());
                if (!this.getICParent().isSignModePadLikeFitToFrame()) {
                    this.getOriginalSize().set(this.getCompSize());
                }
                this.updateScale();
            }
            bl = true;
            this.post(new OZSignView$1(this));
            if (this.mCanvas != null) {
                this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
            this.getICParent().setSignDrawMode(2);
        }
        if (this.mStrokeWidthParam > 0.0f) {
            this.mIsApplyParamPenThick = true;
            float f2 = this.mScale;
            if (!this.getICParent().isSignModePadLikeFitToFrame()) {
                f2 = 7.0f;
            }
            this.mPaint.setStrokeWidth(this.mStrokeWidthParam * f2);
        } else {
            this.mIsApplyParamPenThick = false;
            this.mStrokeWidth = this.mStrokeWidthDefault;
            this.mPaint.setStrokeWidth(this.mStrokeWidth * this.mScale);
        }
        OZPathSkia oZPathSkia = this.getICParent().getSignPath();
        synchronized (oZPathSkia) {
            if (this.getICParent().isInputRender() && !this.getICParent().getSignPath().isEmpty()) {
                this.getICParent().clearNativeBitmap();
                this.init();
                bl = true;
                this.post(new OZSignView$2(this));
            }
        }
        this.init();
        this.invalidate();
        if (!bl) {
            this.repaint();
        }
    }

    private void init() {
        this.initBitmap();
        if (this.getICParent().isSignDrawBitmapMode()) {
            this.initModeBitmap();
        } else {
            this.initModePath();
        }
    }

    private static float getBitmapScale(int n, int n2) {
        float f2 = 1.0f;
        long l = n * n2 * 4;
        if (l > 0x1400000L) {
            f2 = (float)((double)l / 2.097152E7);
        }
        if (f2 > 0.0f) {
            int n3 = (int)((float)n / f2);
            int n4 = (int)((float)n2 / f2);
            while (n3 > 15000 || n4 > 15000) {
                n3 = (int)((float)n / (f2 *= 1.05f));
                n4 = (int)((float)n2 / f2);
            }
        }
        return f2;
    }

    private void initBitmap() {
        if (this.mBitmap == null) {
            if (this.getScaledSize().isEmpty()) {
                this.getICParent().flushInputControls();
                return;
            }
            int n = (int)this.getScaledSize().width();
            int n2 = (int)this.getScaledSize().height();
            this.mBitmapScale = OZSignView.getBitmapScale(n, n2);
            this.mBitmap = Bitmap.createBitmap((int)Math.max(1, (int)((float)n / this.mBitmapScale)), (int)Math.max(1, (int)((float)n2 / Math.max(this.mBitmapScale, 0.0f))), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCanvas = new Canvas(this.mBitmap);
            if (this.mBitmapScale > 0.0f && this.mBitmapScale != 1.0f) {
                this.mCanvas.scale(1.0f / this.mBitmapScale, 1.0f / this.mBitmapScale);
            }
        } else {
            this.mBitmap.eraseColor(0);
        }
    }

    private void initModeBitmap() {
        this.mPath.reset();
        this.mAllTempPath.reset();
        this.getICParent().getSignPath().reset();
        this.getICParent().clearSignPathData();
        if (this.getICParent().getSignBitmap() != null && !this.getICParent().isBitmapClear()) {
            float f2;
            boolean bl;
            RectF rectF = new RectF(this.getScaledSize());
            Rect rect = new Rect(0, 0, this.getICParent().getSignBitmap().getWidth(), this.getICParent().getSignBitmap().getHeight());
            float f3 = rectF.width() / (float)this.getICParent().getSignBitmap().getWidth();
            boolean bl2 = bl = !(f3 > (f2 = rectF.height() / (float)this.getICParent().getSignBitmap().getHeight()));
            if (bl) {
                float f4 = (rectF.bottom - f3 * (float)rect.bottom) / 2.0f;
                rectF.top += f4;
                rectF.bottom -= f4;
            } else {
                float f5 = (rectF.right - f2 * (float)rect.right) / 2.0f;
                rectF.left += f5;
                rectF.right -= f5;
            }
            this.mCanvas.drawBitmap(this.getICParent().getSignBitmap(), rect, rectF, this.mBitmapPaint);
        }
    }

    private void getPostSignData() {
        if (this.mIsApplyParamPenThick && !this.getICParent().isSignModePadLikeFitToFrame()) {
            this.getICParent().updateKeepRatioPath(this.mScale);
            this.initPathScale();
            this.initPaintStyle();
            this.mAllTempPath.set(this.mPath);
            this.mCanvas.drawPath((Path)this.mPath, this.mPaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModePath() {
        if (!this.getICParent().hasSignPathData()) {
            this.mPath.reset();
            this.mAllTempPath.reset();
            OZPathSkia oZPathSkia = this.getICParent().getSignPath();
            synchronized (oZPathSkia) {
                this.getICParent().getSignPath().reset();
            }
        } else if (!this.getICParent().isSignModePadLikeFitToFrame() || this.mReadyPath) {
            this.mPath.reset();
            this.mAllTempPath.reset();
            this.initPathScale();
            this.initPaintStyle();
            if (!this.getICParent().isSignPressureMode() && this.getICParent().isSignModePadLikeFitToFrame()) {
                this.mAllTempPath.set(this.mPath);
            }
            this.mCanvas.drawPath((Path)this.mPath, this.mPaint);
        }
    }

    private void initPaintStyle() {
        this.getICParent().initPaintStyle(this.getICParent().getSignPressureMode(), this.mPaint);
    }

    private void initPathScale() {
        Matrix matrix = new Matrix();
        if (!this.getICParent().isSignModePadLikeFitToFrame()) {
            matrix.setScale(this.mScale, this.mScale);
        } else {
            matrix.setScale(1.0f, 1.0f);
        }
        float f2 = 0.0f;
        f2 = this.mIsApplyParamPenThick ? (this.mStrokeWidthParam > 0.0f ? this.mStrokeWidthParam : this.mStrokeWidth) : this.getICParent().getSignPenWidth();
        if (this.getICParent().isSignModePadLikeFitToFrame()) {
            f2 *= this.mScale;
        }
        if (!this.getICParent().erasePathUpdate(this.mPath, f2)) {
            this.mPath.set(this.getICParent().getSignPath());
            this.mPath.transform(matrix);
        } else {
            this.getICParent().setComponentPathString(this.getICParent().getErasePathUpdate(), true);
        }
    }

    public void onDrawBackgroundColor(Canvas canvas) {
        int n = -1;
        boolean bl = true;
        if (this.getICParent().isEmptyComponent()) {
            n = this.getICParent().getComponentBackGroundColor();
            bl = false;
        } else {
            boolean bl2;
            boolean bl3 = !this.getICParent().isSignModeZoom();
            boolean bl4 = this.getICParent().isSignPadKeepBackgroundColor();
            boolean bl5 = bl2 = this.getICParent().getComponentBackGroundAlpha() == 255;
            if (bl4 && (bl3 || bl2)) {
                canvas.drawColor(n);
                n = this.getICParent().getComponentBackGroundColor() | this.getICParent().getComponentBackGroundAlpha() << 24;
            } else if (!bl3 && !bl2) {
                n = 0;
            }
        }
        canvas.drawColor(n);
        if (bl) {
            this.invalidate();
        }
    }

    public void onDrawText(Canvas canvas, Rect rect) {
        if (this.mTextDrawTemp == null) {
            this.mTextDrawTemp = new Rect();
        }
        if (this.mTextDrawRect.isEmpty()) {
            this.mTextDrawTemp.set(0, 0, canvas.getWidth(), canvas.getHeight());
        } else {
            this.mTextDrawTemp.set(rect);
            if (this.mTextDrawTemp.width() < canvas.getWidth()) {
                this.mTextDrawTemp.set(canvas.getWidth() - this.mTextDrawTemp.width(), this.mTextDrawRect.top, this.mTextDrawRect.right, this.mTextDrawRect.bottom);
            }
        }
        if (!this.mIsTracingOutline) {
            if (!this.getICParent().hasSignPathData() && !this.getICParent().isSignDrawBitmapMode()) {
                if (this.mIsOnlyShowTracingOutline || this.getICParent().isEmptyComponent()) {
                    if (this.mAutoTextDrawHelper == null) {
                        this.mAutoTextDrawHelper = new AutoSizeTextDrawHelper();
                    }
                    this.mAutoTextDrawHelper.drawTextFullAutoSize(canvas, this.mTextPaint, this.getICParent().getTextTokens(), this.mTextDrawTemp.left, this.mTextDrawTemp.top, this.mTextDrawTemp.right, this.mTextDrawTemp.bottom, this.mMinTextSize);
                } else {
                    this.getICParent().drawTextSelf(canvas, this.mTextPaint, this.getICParent().getTextTokens(), this.mTextDrawTemp.left, this.mTextDrawTemp.top, this.mTextDrawTemp.right, this.mTextDrawTemp.bottom, this.mTextPaint.getTextSize(), this.getICParent().getComponentGravity());
                }
            }
        } else {
            if (this.mAutoTextDrawHelper == null) {
                this.mAutoTextDrawHelper = new AutoSizeTextDrawHelper();
            }
            this.mAutoTextDrawHelper.drawTextFullAutoSize(canvas, this.mTextPaint, this.getICParent().getTextTokens(), this.mTextDrawTemp.left, this.mTextDrawTemp.top, this.mTextDrawTemp.right, this.mTextDrawTemp.bottom, this.mMinTextSize);
        }
    }

    public float getTextFullAutoSize(Rect rect) {
        if (this.mAutoTextDrawHelper == null) {
            this.mAutoTextDrawHelper = new AutoSizeTextDrawHelper();
        }
        float f2 = this.mAutoTextDrawHelper.getTextFullAutoSize(this.getICParent().getTextTokens(), rect.left, rect.top, rect.right, rect.bottom);
        return f2;
    }

    private boolean setCanvasSetScaleAndRestore(Canvas canvas, boolean bl) {
        if (bl) {
            canvas.restore();
        } else if (this.mBitmapScale != 1.0f) {
            canvas.save();
            canvas.scale(this.mBitmapScale, this.mBitmapScale);
            return true;
        }
        return false;
    }

    public void onDrawGuideLine(Canvas canvas) {
        if (this.mGuideLineData != null && !this.mGuideLineRect.isEmpty()) {
            switch (this.mGuideLineData.getShapeType()) {
                case 3: {
                    if (this.mGuideLineData.getLineType() == 1) {
                        canvas.drawLine(this.mGuideLineRect.left, this.mGuideLineRect.bottom, this.mGuideLineRect.right, this.mGuideLineRect.bottom, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.left, this.mGuideLineRect.top, this.mGuideLineRect.right, this.mGuideLineRect.top, this.mGuideLinePaint);
                        float f2 = this.getGuideLineDashWidth();
                        float f3 = this.getGuideLineBlankWidth();
                        if (!(this.mGuideLineRect.height() > f2 + f3)) break;
                        float f4 = this.mGuideLinePaint.getStrokeWidth() / 2.0f;
                        float f5 = f2 - this.mGuideLinePaint.getStrokeWidth() % (f2 + f3);
                        canvas.drawLine(this.mGuideLineRect.left + f4, this.mGuideLineRect.top + f4 + f5 + f3, this.mGuideLineRect.left + f4, this.mGuideLineRect.bottom - f4 - f5 - f3, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.right - f4, this.mGuideLineRect.top + f4 + f5 + f3, this.mGuideLineRect.right - f4, this.mGuideLineRect.bottom - f4 - f5 - f3, this.mGuideLinePaint);
                        if (f5 == 0.0f) break;
                        canvas.drawLine(this.mGuideLineRect.left + f4, this.mGuideLineRect.top + f4, this.mGuideLineRect.left + f4, this.mGuideLineRect.top + f4 + f5, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.left + f4, this.mGuideLineRect.bottom - f4 - f5, this.mGuideLineRect.left + f4, this.mGuideLineRect.bottom - f4, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.right - f4, this.mGuideLineRect.top + f4, this.mGuideLineRect.right - f4, this.mGuideLineRect.top + f4 + f5, this.mGuideLinePaint);
                        canvas.drawLine(this.mGuideLineRect.right - f4, this.mGuideLineRect.bottom - f4 - f5, this.mGuideLineRect.right - f4, this.mGuideLineRect.bottom - f4, this.mGuideLinePaint);
                        break;
                    }
                    canvas.drawRect(this.mGuideLineRect, this.mGuideLinePaint);
                    break;
                }
                case 2: {
                    canvas.drawLine(this.mGuideLineRect.left, this.mGuideLineRect.bottom, this.mGuideLineRect.right, this.mGuideLineRect.bottom, this.mGuideLinePaint);
                    break;
                }
            }
        }
    }

    public void onDrawPath(Canvas canvas) {
        boolean bl = this.setCanvasSetScaleAndRestore(canvas, false);
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mBitmapPaint);
        if (bl) {
            this.setCanvasSetScaleAndRestore(canvas, true);
        }
        this.initPaintStyle();
        canvas.drawPath((Path)this.mPath, this.mPaint);
    }

    public void onDrawBorder(Canvas canvas) {
        if (this.getICParent().isSignModeZoom()) {
            if (this.getICParent().isInputRender()) {
                this.getICParent().nativeRealSignDraw(canvas, 0.0f, 0.0f, this.mScale);
            } else {
                this.getICParent().nativeRealSignDraw(canvas, 0.0f, 0.0f, this.getICParent().m_scale);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        this.onDrawBackgroundColor(canvas);
        this.onDrawText(canvas, this.mTextDrawRect);
        this.onDrawGuideLine(canvas);
        this.onDrawPath(canvas);
        this.onDrawBorder(canvas);
    }

    private boolean touch_clear(boolean bl) {
        if (this.getICParent().isSignDrawBitmapMode() || this.getICParent().isSignPressureClearMode()) {
            this.clear(bl);
            return true;
        }
        return false;
    }

    private void touch_start(PointF pointF, PointF pointF2, float f2, boolean bl) {
        if (this.getICParent().isSignPressureClearMode()) {
            this.getICParent().setSignBytesLengthDefault();
        }
        this.mIsSignClick = true;
        this.mIsSignMove = true;
        this.msPressure = f2;
        long l = System.currentTimeMillis();
        this.mSignStartTime = l / 1000L * 1000L;
        this.mFirstextBytes = this.getExtra_2Bytes(l, this.msPressure, this.mSignStartTime);
        this.mTouchPoint.set(pointF);
        this.mTouchMove.set(pointF);
        this.mTouchPointS.set(pointF2);
        this.mTouchMoveS.set(pointF2);
        if (bl && !this.getICParent().hasSignPathData()) {
            this.getICParent().setSignPressureMode(1);
        }
        this.moveComponent();
    }

    private boolean touch_move(PointF pointF, PointF pointF2, float f2, boolean bl) {
        boolean bl2;
        float f3 = Math.abs(pointF.x - this.mTouchPoint.x);
        float f4 = Math.abs(pointF.y - this.mTouchPoint.y);
        boolean bl3 = bl2 = f3 >= 4.0f || f4 >= 4.0f;
        if (bl2) {
            boolean bl4 = this.getICParent().isSignPressureMode();
            if (this.mIsSignMove) {
                if (this.touch_clear(bl)) {
                    bl4 = this.getICParent().isSignPressureMode();
                }
                this.appendPointWithExtra("M", this.mTouchMoveS, this.mFirstextBytes);
                if (!bl4) {
                    this.mPath.moveTo(this.mTouchMove.x, this.mTouchMove.y);
                    if (!this.getICParent().isSignModePadLikeFitToFrame()) {
                        this.getICParent().getSignPath().moveTo(this.mTouchMoveS.x, this.mTouchMoveS.y);
                    }
                } else {
                    this.getICParent().startUpdateTempPath(this.mTouchMoveS.x / this.getOriginalSize().width(), this.mTouchMoveS.y / this.getOriginalSize().height(), this.mFirstextBytes);
                    float f5 = this.mStrokeWidthParam;
                    if (f5 == 0.0f) {
                        f5 = this.mStrokeWidth;
                    }
                    if (this.mIsApplyParamPenThick && !this.getICParent().isSignModePadLikeFitToFrame()) {
                        float f6 = 7.0f;
                        this.getICParent().startTempPath(this.mTouchMove.x, this.mTouchMove.y, this.mFirstextBytes, this.mIsApplyParamPenThick ? f5 * f6 : this.mStrokeWidth * this.mScale);
                    } else {
                        this.getICParent().startTempPath(this.mTouchMove.x, this.mTouchMove.y, this.mFirstextBytes, this.mIsApplyParamPenThick ? f5 * this.mScale : this.mStrokeWidth * this.mScale);
                    }
                }
                this.mFirstextBytes = null;
                this.mIsSignMove = false;
            }
            this.mIsSignClick = false;
            long l = this.appendPointWithExtra_1Byte("L", pointF2, this.msPressure, this.mSignStartTime);
            byte[] byArray = this.getExtra_1Bytes(l, this.msPressure, this.mSignStartTime);
            if (!bl4) {
                this.mPath.quadTo(this.mTouchPoint.x, this.mTouchPoint.y, (pointF.x + this.mTouchPoint.x) / 2.0f, (pointF.y + this.mTouchPoint.y) / 2.0f);
                if (!this.getICParent().isSignModePadLikeFitToFrame()) {
                    this.getICParent().getSignPath().quadTo(this.mTouchPointS.x, this.mTouchPointS.y, (pointF2.x + this.mTouchPointS.x) / 2.0f, (pointF2.y + this.mTouchPointS.y) / 2.0f);
                }
            } else {
                this.mPath.reset();
                this.getICParent().moveUpdateTempPath(pointF2.x / this.getOriginalSize().width(), pointF2.y / this.getOriginalSize().height(), byArray);
                this.getICParent().moveTempPath(pointF.x, pointF.y, byArray, this.mPath);
            }
            this.msPressure = f2;
            this.mTouchPoint.set(pointF);
            this.mTouchPointS.set(pointF2);
            if (this.getICParent().getCommitInterval() > 0 && l - this.getICParent().getLastCommitTime() > (long)this.getICParent().getCommitInterval()) {
                this.getICParent().setLastCommitTime(l);
                if (this.getICParent().hasSignPathData()) {
                    this.getICParent().setImageBitmap(null, true);
                }
            }
            this.getICParent().erasePathUpdateClear();
            this.invalidate();
        }
        return bl2;
    }

    private void touch_up(boolean bl) {
        this.getICParent().changed();
        boolean bl2 = this.getICParent().isSignPressureMode();
        if (!this.mIsSignMove) {
            if (!bl2 && !this.getICParent().isSignModePadLikeFitToFrame()) {
                this.getICParent().getSignPath().lineTo(this.mTouchPointS.x + 0.01f, this.mTouchPointS.y + 0.01f);
            }
            long l = this.appendPointWithExtra_1Byte("L", this.mTouchPointS, this.msPressure, this.mSignStartTime);
            boolean bl3 = false;
            if (bl2) {
                this.getICParent().endUpdateTempPath(this.mTouchPointS.x / this.getOriginalSize().width(), this.mTouchPointS.y / this.getOriginalSize().height(), this.getExtra_1Bytes(l, this.msPressure, this.mSignStartTime));
                this.getICParent().endTempPath(this.mTouchPoint.x, this.mTouchPoint.y, this.getExtra_1Bytes(l, this.msPressure, this.mSignStartTime), this.mPath);
                if (this.getICParent().isEmptyComponent()) {
                    this.mPath.reset();
                    this.updatePath(this.mPath, true);
                    bl3 = true;
                    this.mCanvas.drawPath((Path)this.mPath, this.mPaint);
                    this.mPath.reset();
                } else if (!this.getICParent().hasUpdatePath()) {
                    this.updatePath(null, true);
                    bl3 = true;
                    this.mPath.reset();
                }
            }
            if (this.mIsSignClick || bl3) {
                this.initPathScale();
            } else if (!bl2) {
                this.mPath.lineTo(this.mTouchPoint.x, this.mTouchPoint.y);
            }
            this.initPaintStyle();
            if (!this.mPath.isEmpty()) {
                this.mCanvas.drawPath((Path)this.mPath, this.mPaint);
            }
            if (this.getICParent().getCommitInterval() > 0 && this.getICParent().hasSignPathData()) {
                this.getICParent().setImageBitmap(null, true);
            }
        } else {
            if (this.touch_clear(bl)) {
                bl2 = this.getICParent().isSignPressureMode();
            }
            if (!bl2) {
                this.mPath.moveTo(this.mTouchMove.x, this.mTouchMove.y);
                if (!this.getICParent().isSignModePadLikeFitToFrame()) {
                    this.getICParent().getSignPath().moveTo(this.mTouchMoveS.x, this.mTouchMoveS.y);
                }
            } else {
                float f2 = this.mStrokeWidthParam;
                if (f2 == 0.0f) {
                    f2 = this.mStrokeWidth;
                }
                float f3 = this.mScale;
                if (this.mIsApplyParamPenThick && !this.getICParent().isSignModePadLikeScrollable()) {
                    f3 = 7.0f;
                }
                this.getICParent().startUpdateTempPath(this.mTouchMoveS.x / this.getOriginalSize().width(), this.mTouchMoveS.y / this.getOriginalSize().height(), this.mFirstextBytes);
                this.getICParent().startTempPath(this.mTouchMove.x, this.mTouchMove.y, this.mFirstextBytes, this.mIsApplyParamPenThick ? f2 * f3 : this.mStrokeWidth * this.mScale);
            }
            this.appendPointWithExtra("M", this.mTouchMoveS, this.mFirstextBytes);
            this.mFirstextBytes = null;
            long l = this.appendPointWithExtra_1Byte("L", this.mTouchPointS, this.msPressure, this.mSignStartTime);
            if (!bl2) {
                this.mPath.lineTo(this.mTouchPoint.x + 0.01f, this.mTouchPoint.y + 0.01f);
                if (!this.getICParent().isSignModePadLikeFitToFrame()) {
                    this.getICParent().getSignPath().lineTo(this.mTouchPointS.x + 0.01f, this.mTouchPointS.y + 0.01f);
                }
            } else {
                this.getICParent().endUpdateTempPath(this.mTouchPointS.x / this.getOriginalSize().width(), this.mTouchPointS.y / this.getOriginalSize().height(), this.getExtra_1Bytes(l, this.msPressure, this.mSignStartTime));
                this.getICParent().endTempPath(this.mTouchPoint.x, this.mTouchPoint.y, this.getExtra_1Bytes(l, this.msPressure, this.mSignStartTime), null);
            }
            if (this.getICParent().getCommitInterval() > 0 && this.getICParent().hasSignPathData()) {
                this.getICParent().setImageBitmap(null, true);
            }
            if (bl2) {
                if (this.getICParent().isEmptyComponent()) {
                    this.mPath.reset();
                    this.updatePath(this.mPath, true);
                    this.mCanvas.drawPath((Path)this.mPath, this.mPaint);
                    this.mPath.reset();
                } else if (!this.getICParent().hasUpdatePath()) {
                    this.updatePath(null, true);
                    this.mPath.reset();
                    this.initPathScale();
                }
            }
            this.initPaintStyle();
            if (!this.mPath.isEmpty()) {
                this.mCanvas.drawPath((Path)this.mPath, this.mPaint);
            }
            this.invalidate();
            this.mIsSignMove = false;
            this.mFirstextBytes = null;
        }
        if (!bl2 && this.getICParent().isSignModePadLikeFitToFrame()) {
            this.mReadyPath = true;
            this.mAllTempPath.addPath(this.mPath);
        }
        this.mPath.reset();
        this.appendEnd();
    }

    private boolean applyActivePointer(MotionEvent motionEvent, PointF pointF) {
        int n;
        if (this.mActivePointerId != -1 && (n = motionEvent.findPointerIndex(this.mActivePointerId)) >= 0) {
            pointF.set(motionEvent.getX(n) + (float)this.getScrollX(), motionEvent.getY(n) + (float)this.getScrollY());
            return true;
        }
        return false;
    }

    private void calcScaledPointer(PointF pointF, PointF pointF2) {
        if (this.getICParent().isSignModePadLikeKeepRatio() || this.getICParent().isSignModePadLikeScrollable()) {
            pointF2.set(pointF.x / this.mScaleXY.x, pointF.y / this.mScaleXY.y);
        } else if (this.getICParent().isSignModeZoom()) {
            this.mTempRectF.set(this.getICParent().getCompRect());
            if (this.mTempRectF.width() * this.getOriginalSize().height() < this.mTempRectF.height() * this.getOriginalSize().width()) {
                this.mTempRectF.inset(0.0f, (this.mTempRectF.height() - this.getOriginalSize().height() * this.mTempRectF.width() / this.getOriginalSize().width()) / 2.0f);
            } else {
                this.mTempRectF.inset((this.mTempRectF.width() - this.getOriginalSize().width() * this.mTempRectF.height() / this.getOriginalSize().height()) / 2.0f, 0.0f);
            }
            pointF2.set(pointF.x / (this.mTempRectF.width() / this.getOriginalSize().width()), pointF.y / (this.mTempRectF.height() / this.getOriginalSize().height()));
        } else {
            pointF2.set(pointF);
        }
    }

    private void requestCancelScroll() {
        if (this.mRequestScroll && this.getICParent().isSignModePadLikeScrollable()) {
            this.requestCancelScroll(this.getICParent().getScrollableScrollView());
        }
    }

    private void requestCancelScroll(OZSignpadScrollView oZSignpadScrollView) {
        if (oZSignpadScrollView != null) {
            oZSignpadScrollView.cancelScroll();
        }
        this.mRequestScroll = false;
    }

    private void requestScroll(PointF pointF) {
        OZSignpadScrollView oZSignpadScrollView;
        if (this.getICParent().isSignModePadLikeScrollable() && (oZSignpadScrollView = this.getICParent().getScrollableScrollView()) != null) {
            this.mNextScrollTouchRect.set((float)oZSignpadScrollView.getWidth() * 0.85f, -2000.0f, (float)(oZSignpadScrollView.getWidth() + 2000), (float)(this.getHeight() + 2000));
            this.mNextScrollTouchRect.offset((float)oZSignpadScrollView.getHorizontalCommand().getCurrentScroll(), (float)oZSignpadScrollView.getVerticalCommand().getCurrentScroll());
            if (this.getWidth() >= oZSignpadScrollView.getWidth() && this.mNextScrollTouchRect.contains(pointF.x, pointF.y)) {
                this.requestCancelScroll(oZSignpadScrollView);
                this.mRequestScroll = true;
                oZSignpadScrollView.nextScroll(0.85f, 1000, false);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mTouchTemp.set(motionEvent.getX() + (float)this.getScrollX(), motionEvent.getY() + (float)this.getScrollY());
        boolean bl = motionEvent.getToolType(0) == 2;
        float f2 = bl ? motionEvent.getPressure() : 0.5f;
        boolean bl2 = this.applyActivePointer(motionEvent, this.mTouchTemp);
        this.calcScaledPointer(this.mTouchTemp, this.mTouchTempS);
        if (this.mActivePointerId == -1) {
            switch (motionEvent.getAction() & 0xFF) {
                case 0: {
                    this.requestCancelScroll();
                    if (this.getICParent().isSignModeKeyPadLike()) {
                        this.getICParent().setNotInvalidate(true);
                    }
                    this.mActivePointerId = motionEvent.getPointerId(0);
                    if (this.getICParent().isEraseMode()) {
                        this.mIsTouchErase = true;
                        this.mTouchPoint.set(this.mTouchTemp.x / this.getScaledSize().width(), this.mTouchTemp.y / this.getScaledSize().height());
                        if (this.getICParent().isSignViewKeepRatio()) {
                            this.getICParent().selectSignPad(this);
                        }
                    } else {
                        if (this.touch_clear(bl)) {
                            this.mTouchTemp.set(motionEvent.getX() + (float)this.getScrollX(), motionEvent.getY() + (float)this.getScrollY());
                            this.calcScaledPointer(this.mTouchTemp, this.mTouchTempS);
                        }
                        this.touch_start(this.mTouchTemp, this.mTouchTempS, f2, bl);
                        this.setNativeRealRect(this.mTouchTemp, true);
                    }
                    this.mIsTouchMove = false;
                    this.getICParent().setShowThis(true);
                    this.invalidate();
                }
            }
        }
        if (this.mActivePointerId != -1 || bl2) {
            switch (motionEvent.getAction() & 0xFF) {
                case 2: {
                    if (this.mIsTouchErase) {
                        String string;
                        this.mTouchMove.set(this.mTouchPoint);
                        this.mTouchPoint.set(this.mTouchTemp.x / this.getScaledSize().width(), this.mTouchTemp.y / this.getScaledSize().height());
                        if (!this.getICParent().isSignDrawPathMode() || !this.getICParent().hasSignPathData() || (string = this.erasePath(this.mTouchMove, this.mTouchPoint)) == null) break;
                        this.getICParent().setComponentPathString(string, true);
                        if (!this.getICParent().hasSignPathData()) {
                            this.clear();
                        } else {
                            this.getICParent().changed();
                            this.getICParent().getRealSignRect().setEmpty();
                            this.updatePathFirst();
                            this.init();
                        }
                        if (this.getICParent().isSignModeZoom()) {
                            this.invalidate();
                            this.repaint();
                        }
                        this.mIsTouchMove = true;
                        break;
                    }
                    if (this.touch_move(this.mTouchTemp, this.mTouchTempS, f2, bl)) {
                        this.setNativeRealRect(this.mTouchTemp, false);
                    }
                    this.mIsTouchMove = true;
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    if (this.mIsTouchErase) {
                        this.mIsTouchErase = false;
                        if (this.mIsTouchMove) {
                            this.moveComponent();
                            if (this.getICParent().isSignModeZoom()) {
                                this.repaint();
                            }
                        }
                    } else {
                        boolean bl3 = this.mIsTouchMove;
                        this.mTouchPoint.set(this.mTouchTemp);
                        this.mTouchPointS.set(this.mTouchTempS);
                        this.touch_up(bl);
                        if (!bl3) {
                            this.setNativeRealRect(this.mTouchTemp, false);
                        }
                        this.requestScroll(this.mTouchTemp);
                    }
                    if (this.getICParent().isSignModeKeyPadLike()) {
                        this.getICParent().setNotInvalidate(false);
                    }
                    this.invalidate();
                    if (this.getICParent().isSignModePadLike()) {
                        this.repaint();
                    }
                    this.mActivePointerId = -1;
                    this.mIsTouchMove = false;
                }
            }
        }
        return true;
    }

    private void moveComponent() {
        if (this.getICParent().isSignModePadLike() && !this.getICParent().isSignViewScrollable()) {
            if (this.getICParent().isSignModeKeyPadLike()) {
                this.post(new OZSignView$3(this));
            }
            if (this.getICParent().isSignViewKeepRatio()) {
                this.getICParent().selectSignPad(this);
            }
        }
    }

    private void setNativeRealRect(PointF pointF, boolean bl) {
        RectF rectF = this.getICParent().getRealSignRect();
        if (rectF.isEmpty()) {
            rectF.left = pointF.x;
            rectF.top = pointF.y;
            rectF.right = pointF.x + 0.01f;
            rectF.bottom = pointF.y + 0.01f;
        } else {
            rectF.union(pointF.x, pointF.y);
        }
    }

    public void applyChangedTextSize() {
        this.mTextPaint.setTextSize(this.getICParent().getSignTextSize() / this.getICParent().getPageViewZoomScale() * (this.mFixedTextScale > 0.0f ? this.mFixedTextScale : this.mScale));
    }

    private void updateScale() {
        boolean bl = this.getICParent().isSignModePadLikeFitToFrame();
        RectF rectF = bl ? this.getCompSize() : this.getOriginalSize();
        float f2 = rectF.width();
        float f3 = rectF.height();
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        if (f3 <= 0.0f) {
            f3 = 1.0f;
        }
        this.mScaleXY.set(this.getScaledSize().width() / f2, this.getScaledSize().height() / f3);
        this.mScale = Math.min(this.mScaleXY.x, this.mScaleXY.y);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (this.getICParent().isSignModePadLikeFitToFrame()) {
            this.setOriginalSize(0.0f, 0.0f, n, n2);
            this.mScaledSize.set(0.0f, 0.0f, (float)n, (float)n2);
            this.updateScale();
            this.applyChangedTextSize();
            this.getICParent().getSignPadRect().set(this.getScaledSize());
            float f2 = this.mStrokeWidthParam;
            if (f2 == 0.0f) {
                f2 = this.mStrokeWidth;
            }
            if (this.mIsApplyParamPenThick && !this.getICParent().isSignModePadLikeFitToFrame()) {
                float f3 = 7.0f;
                this.mPaint.setStrokeWidth(this.mIsApplyParamPenThick ? f2 * f3 : this.mStrokeWidth * this.mScale);
            } else {
                this.mPaint.setStrokeWidth(this.mIsApplyParamPenThick ? f2 * this.mScale : this.mStrokeWidth * this.mScale);
            }
            if (this.mBitmap != null && ((float)this.mBitmap.getWidth() != this.getOriginalSize().width() || (float)this.mBitmap.getHeight() != this.getOriginalSize().height())) {
                this.mBitmap.recycle();
                this.mCanvas = null;
                this.mBitmap = null;
                int n5 = (int)this.getOriginalSize().width();
                int n6 = (int)this.getOriginalSize().height();
                this.mBitmapScale = OZSignView.getBitmapScale(n5, n6);
                this.mBitmap = Bitmap.createBitmap((int)Math.max(1, (int)((float)n5 / this.mBitmapScale)), (int)Math.max(1, (int)((float)n6 / this.mBitmapScale)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBitmap.eraseColor(0);
                this.mCanvas = new Canvas(this.mBitmap);
                if (this.mBitmapScale > 0.0f && this.mBitmapScale != 1.0f) {
                    this.mCanvas.scale(1.0f / this.mBitmapScale, 1.0f / this.mBitmapScale);
                }
            }
            this.postDelayed(new OZSignView$4(this), 50L);
        }
        if (!this.getICParent().isSignModePadLikeScrollable()) {
            this.requestInvalidateGuideLine(n, n2);
        }
    }

    private void updatePathFirst() {
        this.updatePath(this.getICParent().isEmptyComponent() ? this.mAllTempPath : null, false, false);
    }

    private void updatePath(OZPathSkia oZPathSkia, boolean bl) {
        this.updatePath(oZPathSkia, true, bl);
    }

    private void updatePath(OZPathSkia oZPathSkia, boolean bl, boolean bl2) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.getICParent().isEmptyComponent()) {
            f2 = this.getScaledSize().width();
            f3 = this.getScaledSize().height();
        }
        float f4 = 0.0f;
        float f5 = this.mStrokeWidthParam;
        if (f5 == 0.0f) {
            f5 = this.mStrokeWidth;
        }
        f4 = this.mIsApplyParamPenThick ? f5 : this.getICParent().getSignPenWidth();
        if (this.getICParent().isSignModePadLikeFitToFrame()) {
            f4 *= this.mScale;
        }
        if (this.getICParent().isSignModePadLikeFitToFrame()) {
            this.getICParent().updatePath(oZPathSkia, this.getICParent().getPageViewZoomScale(), bl, this.getICParent().getPageViewZoomScale() / this.mScale, f2, f3, f4, this.mIsApplyParamPenThick, bl2, new OZSignView$5(this));
        } else if (this.mIsApplyParamPenThick) {
            this.getICParent().updatePath(oZPathSkia, this.mScale, bl, f4, f2, f3, f4, this.mIsApplyParamPenThick, bl2, null);
        } else {
            this.getICParent().updatePath(oZPathSkia, f2, f3, f4, this.mIsApplyParamPenThick, bl2);
        }
    }

    private String erasePath(PointF pointF, PointF pointF2) {
        String string = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        boolean bl = this.getICParent().isSignModePadLikeFitToFrame();
        if (this.getICParent().isEmptyComponent() || bl) {
            f2 = this.getScaledSize().width();
            f3 = this.getScaledSize().height();
        } else {
            f2 = this.getICParent().getSignOriginalWidth();
            f3 = this.getICParent().getSignOriginalHeight();
        }
        if (f3 > 0.0f) {
            f4 = f2 / f3;
        }
        float f5 = 0.0f;
        float f6 = this.mStrokeWidthParam;
        if (f6 == 0.0f) {
            f6 = this.mStrokeWidth;
        }
        f5 = this.mIsApplyParamPenThick ? (!this.getICParent().isSignModePadLikeFitToFrame() ? f6 * 7.0f : f6) : this.getICParent().getSignPenWidth();
        if (this.getICParent().isSignModePadLikeFitToFrame()) {
            f5 *= this.mScale;
        }
        string = this.getICParent().erasePath(f4, pointF, pointF2, bl, f5);
        return string;
    }

    private void repaint() {
        if (!this.getICParent().isSignModeDialog()) {
            this.getICParent().repaint();
        }
    }

    public boolean isReadySignPath() {
        return this.mReadyPath;
    }

    public OZPathSkia getSignPath() {
        return this.mAllTempPath;
    }

    public boolean isClickEmptyButton() {
        return this.mClickEmptyButton;
    }

    public void requestInvalidateGuideLine(int n, int n2) {
        this.updateGuideLineRect(n, n2);
    }

    static /* synthetic */ void access$000(OZSignView oZSignView) {
        oZSignView.repaint();
    }

    static /* synthetic */ void access$100(OZSignView oZSignView) {
        oZSignView.updatePathFirst();
    }

    static /* synthetic */ void access$200(OZSignView oZSignView) {
        oZSignView.init();
    }

    static /* synthetic */ boolean access$302(OZSignView oZSignView, boolean bl) {
        oZSignView.mReadyPath = bl;
        return oZSignView.mReadyPath;
    }

    static /* synthetic */ boolean access$400(OZSignView oZSignView) {
        return oZSignView.mIsUpdatePathClear;
    }

    static /* synthetic */ boolean access$402(OZSignView oZSignView, boolean bl) {
        oZSignView.mIsUpdatePathClear = bl;
        return oZSignView.mIsUpdatePathClear;
    }
}

