/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import oz.util.barcode.client.android.camera.AutoFocusManager$AutoFocusTask;
import oz.util.barcode.client.android.common.executor.AsyncTaskExecInterface;
import oz.util.barcode.client.android.common.executor.AsyncTaskExecManager;

final class AutoFocusManager
implements Camera.AutoFocusCallback {
    private static final String TAG = AutoFocusManager.class.getSimpleName();
    private static final long AUTO_FOCUS_INTERVAL_MS = 2000L;
    private static final Collection FOCUS_MODES_CALLING_AF = new ArrayList(2);
    private boolean active;
    private final boolean useAutoFocus;
    private final Camera camera;
    private AutoFocusManager$AutoFocusTask outstandingTask;
    private final AsyncTaskExecInterface taskExec;

    static {
        FOCUS_MODES_CALLING_AF.add("auto");
        FOCUS_MODES_CALLING_AF.add("macro");
    }

    AutoFocusManager(Context context, Camera camera) {
        this.camera = camera;
        this.taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
        Camera.Parameters parameters = camera.getParameters();
        String string = this.findSettableValue(parameters.getSupportedFocusModes(), "auto");
        if (string != null) {
            parameters.setFocusMode(string);
        }
        camera.setParameters(parameters);
        String string2 = camera.getParameters().getFocusMode();
        this.useAutoFocus = FOCUS_MODES_CALLING_AF.contains(string2);
        Log.i((String)TAG, (String)("Current focus mode '" + string2 + "'; use auto focus? " + this.useAutoFocus));
        this.start();
    }

    private String findSettableValue(Collection collection, String ... stringArray) {
        Log.i((String)TAG, (String)("Supported values: " + collection));
        String string = null;
        if (collection != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (collection.contains(string2)) {
                    string = string2;
                    break;
                }
                ++n2;
            }
        }
        Log.i((String)TAG, (String)("Settable value: " + string));
        return string;
    }

    public synchronized void onAutoFocus(boolean bl, Camera camera) {
        if (this.active) {
            this.outstandingTask = new AutoFocusManager$AutoFocusTask(this, null);
            this.taskExec.execute(this.outstandingTask, new Object[0]);
        }
    }

    synchronized void start() {
        if (this.useAutoFocus) {
            this.active = true;
            try {
                if (this.camera != null) {
                    this.camera.autoFocus((Camera.AutoFocusCallback)this);
                }
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)TAG, (String)"Unexpected exception while focusing", (Throwable)runtimeException);
            }
        }
    }

    synchronized void stop() {
        if (this.useAutoFocus) {
            try {
                this.camera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)TAG, (String)"Unexpected exception while cancelling focusing", (Throwable)runtimeException);
            }
        }
        if (this.outstandingTask != null) {
            this.outstandingTask.cancel(true);
            this.outstandingTask = null;
        }
        this.active = false;
    }

    static /* synthetic */ boolean access$0(AutoFocusManager autoFocusManager) {
        return autoFocusManager.active;
    }
}

