/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import java.util.ArrayList;
import java.util.Formatter;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.pdf417.PDF417Common;
import oz.util.barcode.pdf417.decoder.BarcodeMetadata;
import oz.util.barcode.pdf417.decoder.BarcodeValue;
import oz.util.barcode.pdf417.decoder.BoundingBox;
import oz.util.barcode.pdf417.decoder.Codeword;
import oz.util.barcode.pdf417.decoder.DecodedBitStreamParser;
import oz.util.barcode.pdf417.decoder.DetectionResult;
import oz.util.barcode.pdf417.decoder.DetectionResultColumn;
import oz.util.barcode.pdf417.decoder.DetectionResultRowIndicatorColumn;
import oz.util.barcode.pdf417.decoder.PDF417CodewordDecoder;
import oz.util.barcode.pdf417.decoder.ec.ErrorCorrection;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    public static DecoderResult decode(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n, int n2) {
        BoundingBox boundingBox = new BoundingBox(bitMatrix, resultPoint, resultPoint2, resultPoint3, resultPoint4);
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = null;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = null;
        DetectionResult detectionResult = null;
        int n3 = 0;
        while (n3 < 2) {
            if (resultPoint != null) {
                detectionResultRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox, resultPoint, true, n, n2);
            }
            if (resultPoint3 != null) {
                detectionResultRowIndicatorColumn2 = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox, resultPoint3, false, n, n2);
            }
            if ((detectionResult = PDF417ScanningDecoder.merge(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2)) == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            if (n3 != 0 || detectionResult.getBoundingBox() == null || detectionResult.getBoundingBox().getMinY() >= boundingBox.getMinY() && detectionResult.getBoundingBox().getMaxY() <= boundingBox.getMaxY()) {
                detectionResult.setBoundingBox(boundingBox);
                break;
            }
            boundingBox = detectionResult.getBoundingBox();
            ++n3;
        }
        n3 = detectionResult.getBarcodeColumnCount() + 1;
        detectionResult.setDetectionResultColumn(0, detectionResultRowIndicatorColumn);
        detectionResult.setDetectionResultColumn(n3, detectionResultRowIndicatorColumn2);
        boolean bl = detectionResultRowIndicatorColumn != null;
        int n4 = 1;
        while (n4 <= n3) {
            block11: {
                int n5;
                int n6;
                int n7 = n6 = bl ? n4 : n3 - n4;
                if (detectionResult.getDetectionResultColumn(n6) != null) break block11;
                DetectionResultColumn detectionResultColumn = n6 == 0 || n6 == n3 ? new DetectionResultRowIndicatorColumn(boundingBox, n6 == 0) : new DetectionResultColumn(boundingBox);
                detectionResult.setDetectionResultColumn(n6, detectionResultColumn);
                int n8 = n5 = -1;
                int n9 = boundingBox.getMinY();
                while (n9 <= boundingBox.getMaxY()) {
                    block13: {
                        Codeword codeword;
                        block12: {
                            n5 = PDF417ScanningDecoder.getStartColumn(detectionResult, n6, n9, bl);
                            if (n5 >= 0 && n5 <= boundingBox.getMaxX()) break block12;
                            if (n8 == -1) break block13;
                            n5 = n8;
                        }
                        if ((codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, boundingBox.getMinX(), boundingBox.getMaxX(), bl, n5, n9, n, n2)) != null) {
                            detectionResultColumn.setCodeword(n9, codeword);
                            n8 = n5;
                            n = Math.min(n, codeword.getWidth());
                            n2 = Math.max(n2, codeword.getWidth());
                        }
                    }
                    ++n9;
                }
            }
            ++n4;
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) {
        if (detectionResultRowIndicatorColumn == null && detectionResultRowIndicatorColumn2 == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2);
        if (barcodeMetadata == null) {
            return null;
        }
        BoundingBox boundingBox = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn2));
        return new DetectionResult(barcodeMetadata, boundingBox);
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) {
        if (detectionResultRowIndicatorColumn == null) {
            return null;
        }
        int[] nArray = detectionResultRowIndicatorColumn.getRowHeights();
        if (nArray == null) {
            return null;
        }
        int n = PDF417ScanningDecoder.getMax(nArray);
        int n2 = 0;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            n2 += n - n5;
            if (n5 > 0) break;
            ++n4;
        }
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        n4 = 0;
        while (n2 > 0 && codewordArray[n4] == null) {
            --n2;
            ++n4;
        }
        n4 = 0;
        n3 = nArray.length - 1;
        while (n3 >= 0) {
            n4 += n - nArray[n3];
            if (nArray[n3] > 0) break;
            --n3;
        }
        n3 = codewordArray.length - 1;
        while (n4 > 0 && codewordArray[n3] == null) {
            --n4;
            --n3;
        }
        return detectionResultRowIndicatorColumn.getBoundingBox().addMissingRows(n2, n4, detectionResultRowIndicatorColumn.isLeft());
    }

    private static int getMax(int[] nArray) {
        int n = -1;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            n = Math.max(n, n4);
            ++n3;
        }
        return n;
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) {
        BarcodeMetadata barcodeMetadata;
        BarcodeMetadata barcodeMetadata2;
        if (detectionResultRowIndicatorColumn == null || (barcodeMetadata2 = detectionResultRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return detectionResultRowIndicatorColumn2 == null ? null : detectionResultRowIndicatorColumn2.getBarcodeMetadata();
        }
        if (detectionResultRowIndicatorColumn2 == null || (barcodeMetadata = detectionResultRowIndicatorColumn2.getBarcodeMetadata()) == null) {
            return barcodeMetadata2;
        }
        if (barcodeMetadata2.getColumnCount() != barcodeMetadata.getColumnCount() && barcodeMetadata2.getErrorCorrectionLevel() != barcodeMetadata.getErrorCorrectionLevel() && barcodeMetadata2.getRowCount() != barcodeMetadata.getRowCount()) {
            return null;
        }
        return barcodeMetadata2;
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix bitMatrix, BoundingBox boundingBox, ResultPoint resultPoint, boolean bl, int n, int n2) {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, bl);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = n3 == 0 ? 1 : -1;
            int n5 = (int)resultPoint.getX();
            int n6 = (int)resultPoint.getY();
            while (n6 <= boundingBox.getMaxY() && n6 >= boundingBox.getMinY()) {
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, 0, bitMatrix.getWidth(), bl, n5, n6, n, n2);
                if (codeword != null) {
                    detectionResultRowIndicatorColumn.setCodeword(n6, codeword);
                    n5 = bl ? codeword.getStartX() : codeword.getEndX();
                }
                n6 += n4;
            }
            ++n3;
        }
        return detectionResultRowIndicatorColumn;
    }

    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeValueArray) {
        int[] nArray = barcodeValueArray[0][1].getValue();
        int n = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (nArray.length == 0) {
            if (n < 1 || n > 928) {
                throw NotFoundException.getNotFoundInstance();
            }
            barcodeValueArray[0][1].setValue(n);
        } else if (nArray[0] != n) {
            barcodeValueArray[0][1].setValue(n);
        }
    }

    private static DecoderResult createDecoderResult(DetectionResult detectionResult) {
        int n;
        BarcodeValue[][] barcodeValueArray = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeValueArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = new int[detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount()];
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < detectionResult.getBarcodeRowCount()) {
            n = 0;
            while (n < detectionResult.getBarcodeColumnCount()) {
                int[] nArray2 = barcodeValueArray[n2][n + 1].getValue();
                int n3 = n2 * detectionResult.getBarcodeColumnCount() + n;
                if (nArray2.length == 0) {
                    arrayList.add(n3);
                } else if (nArray2.length == 1) {
                    nArray[n3] = nArray2[0];
                } else {
                    arrayList3.add(n3);
                    arrayList2.add(nArray2);
                }
                ++n;
            }
            ++n2;
        }
        int[][] nArrayArray = new int[arrayList2.size()][];
        n = 0;
        while (n < nArrayArray.length) {
            nArrayArray[n] = (int[])arrayList2.get(n);
            ++n;
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult.getBarcodeECLevel(), nArray, PDF417Common.toIntArray(arrayList), PDF417Common.toIntArray(arrayList3), nArrayArray);
    }

    /*
     * Unable to fully structure code
     */
    private static DecoderResult createDecoderResultFromAmbiguousValues(int var0, int[] var1_1, int[] var2_2, int[] var3_3, int[][] var4_4) {
        var5_5 = new int[var3_3.length];
        var6_6 = 100;
        block2: while (var6_6-- > 0) {
            var7_7 = 0;
            while (var7_7 < var5_5.length) {
                var1_1[var3_3[var7_7]] = var4_4[var7_7][var5_5[var7_7]];
                ++var7_7;
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(var1_1, var0, var2_2);
            }
            catch (ChecksumException var7_8) {
                if (var5_5.length == 0) {
                    throw ChecksumException.getChecksumInstance();
                }
                var7_7 = 0;
                ** while (var7_7 < var5_5.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var5_5[var7_7] < var4_4[var7_7].length - 1) {
                    v0 = var7_7;
                    var5_5[v0] = var5_5[v0] + 1;
                    continue block2;
                }
                var5_5[var7_7] = 0;
                if (var7_7 == var5_5.length - 1) {
                    throw ChecksumException.getChecksumInstance();
                }
                ++var7_7;
                continue;
lbl25:
                // 1 sources

            }
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) {
        BarcodeValue[][] barcodeValueArray = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        int n = 0;
        while (n < barcodeValueArray.length) {
            int n2 = 0;
            while (n2 < barcodeValueArray[n].length) {
                barcodeValueArray[n][n2] = new BarcodeValue();
                ++n2;
            }
            ++n;
        }
        n = 0;
        DetectionResultColumn[] detectionResultColumnArray = detectionResult.getDetectionResultColumns();
        int n3 = detectionResultColumnArray.length;
        int n4 = 0;
        while (n4 < n3) {
            DetectionResultColumn detectionResultColumn = detectionResultColumnArray[n4];
            if (detectionResultColumn != null) {
                Codeword[] codewordArray = detectionResultColumn.getCodewords();
                int n5 = codewordArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7;
                    Codeword codeword = codewordArray[n6];
                    if (codeword != null && (n7 = codeword.getRowNumber()) >= 0) {
                        if (n7 >= barcodeValueArray.length) {
                            throw FormatException.getFormatInstance();
                        }
                        barcodeValueArray[n7][n].setValue(codeword.getValue());
                    }
                    ++n6;
                }
            }
            ++n;
            ++n4;
        }
        return barcodeValueArray;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int n) {
        return n >= 0 && n <= detectionResult.getBarcodeColumnCount() + 1;
    }

    private static int getStartColumn(DetectionResult detectionResult, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : -1;
        Codeword codeword = null;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n - n3)) {
            codeword = detectionResult.getDetectionResultColumn(n - n3).getCodeword(n2);
        }
        if (codeword != null) {
            return bl ? codeword.getEndX() : codeword.getStartX();
        }
        codeword = detectionResult.getDetectionResultColumn(n).getCodewordNearby(n2);
        if (codeword != null) {
            return bl ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n - n3)) {
            codeword = detectionResult.getDetectionResultColumn(n - n3).getCodewordNearby(n2);
        }
        if (codeword != null) {
            return bl ? codeword.getEndX() : codeword.getStartX();
        }
        int n4 = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n - n3)) {
            Codeword[] codewordArray = detectionResult.getDetectionResultColumn(n -= n3).getCodewords();
            int n5 = codewordArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Codeword codeword2 = codewordArray[n6];
                if (codeword2 != null) {
                    return (bl ? codeword2.getEndX() : codeword2.getStartX()) + n3 * n4 * (codeword2.getEndX() - codeword2.getStartX());
                }
                ++n6;
            }
            ++n4;
        }
        return bl ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    }

    private static Codeword detectCodeword(BitMatrix bitMatrix, int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int[] nArray = PDF417ScanningDecoder.getModuleBitCount(bitMatrix, n, n2, bl, n3 = PDF417ScanningDecoder.adjustCodewordStartColumn(bitMatrix, n, n2, bl, n3, n4), n4);
        if (nArray == null) {
            return null;
        }
        int n10 = PDF417Common.getBitCountSum(nArray);
        if (bl) {
            n9 = n3 + n10;
        } else {
            n8 = 0;
            while (n8 < nArray.length / 2) {
                n7 = nArray[n8];
                nArray[n8] = nArray[nArray.length - 1 - n8];
                nArray[nArray.length - 1 - n8] = n7;
                ++n8;
            }
            n9 = n3;
            n3 = n9 - n10;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(n10, n5, n6)) {
            return null;
        }
        n8 = PDF417CodewordDecoder.getDecodedValue(nArray);
        n7 = PDF417Common.getCodeword(n8);
        if (n7 == -1) {
            return null;
        }
        return new Codeword(n3, n9, PDF417ScanningDecoder.getCodewordBucketNumber(n8), n7);
    }

    private static int[] getModuleBitCount(BitMatrix bitMatrix, int n, int n2, boolean bl, int n3, int n4) {
        int n5 = n3;
        int[] nArray = new int[8];
        int n6 = 0;
        int n7 = bl ? 1 : -1;
        boolean bl2 = bl;
        while ((bl && n5 < n2 || !bl && n5 >= n) && n6 < nArray.length) {
            if (bitMatrix.get(n5, n4) == bl2) {
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
                n5 += n7;
                continue;
            }
            ++n6;
            boolean bl3 = bl2 = !bl2;
        }
        if (n6 == nArray.length || (bl && n5 == n2 || !bl && n5 == n) && n6 == nArray.length - 1) {
            return nArray;
        }
        return null;
    }

    private static int getNumberOfECCodeWords(int n) {
        return 2 << n;
    }

    /*
     * Unable to fully structure code
     */
    private static int adjustCodewordStartColumn(BitMatrix var0, int var1_1, int var2_2, boolean var3_3, int var4_4, int var5_5) {
        var6_6 = var4_4;
        var7_7 = var3_3 != false ? -1 : 1;
        var8_8 = 0;
        ** GOTO lbl13
        {
            if (Math.abs(var4_4 - var6_6) > 2) {
                return var4_4;
            }
            var6_6 += var7_7;
            do {
                if ((var3_3 && var6_6 >= var1_1 || !var3_3 && var6_6 < var2_2) && var3_3 == var0.get(var6_6, var5_5)) continue block0;
                var7_7 = -var7_7;
                var3_3 = var3_3 == false;
                ++var8_8;
lbl13:
                // 2 sources

            } while (var8_8 < 2);
        }
        return var6_6;
    }

    private static boolean checkCodewordSkew(int n, int n2, int n3) {
        return n2 - 2 <= n && n <= n3 + 2;
    }

    private static DecoderResult decodeCodewords(int[] nArray, int n, int[] nArray2) {
        if (nArray.length == 0) {
            throw FormatException.getFormatInstance();
        }
        int n2 = 1 << n + 1;
        int n3 = PDF417ScanningDecoder.correctErrors(nArray, nArray2, n2);
        PDF417ScanningDecoder.verifyCodewordCount(nArray, n2);
        DecoderResult decoderResult = DecodedBitStreamParser.decode(nArray, String.valueOf(n));
        decoderResult.setErrorsCorrected(n3);
        decoderResult.setErasures(nArray2.length);
        return decoderResult;
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n) {
        if (nArray2 != null && nArray2.length > n / 2 + 3 || n < 0 || n > 512) {
            throw ChecksumException.getChecksumInstance();
        }
        return errorCorrection.decode(nArray, n, nArray2);
    }

    private static void verifyCodewordCount(int[] nArray, int n) {
        if (nArray.length < 4) {
            throw FormatException.getFormatInstance();
        }
        int n2 = nArray[0];
        if (n2 > nArray.length) {
            throw FormatException.getFormatInstance();
        }
        if (n2 == 0) {
            if (n < nArray.length) {
                nArray[0] = nArray.length - n;
            } else {
                throw FormatException.getFormatInstance();
            }
        }
    }

    private static int[] getBitCountForCodeword(int n) {
        int[] nArray = new int[8];
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (true) {
            if ((n & 1) != n2) {
                n2 = n & 1;
                if (--n3 < 0) break;
            }
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
            n >>= 1;
        }
        return nArray;
    }

    private static int getCodewordBucketNumber(int n) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(n));
    }

    private static int getCodewordBucketNumber(int[] nArray) {
        return (nArray[0] - nArray[2] + nArray[4] - nArray[6] + 9) % 9;
    }

    public static String toString(BarcodeValue[][] barcodeValueArray) {
        Formatter formatter = new Formatter();
        int n = 0;
        while (n < barcodeValueArray.length) {
            formatter.format("Row %2d: ", n);
            int n2 = 0;
            while (n2 < barcodeValueArray[n].length) {
                BarcodeValue barcodeValue = barcodeValueArray[n][n2];
                if (barcodeValue.getValue().length == 0) {
                    formatter.format("        ", null);
                } else {
                    formatter.format("%4d(%2d)", barcodeValue.getValue()[0], barcodeValue.getConfidence(barcodeValue.getValue()[0]));
                }
                ++n2;
            }
            formatter.format("%n", new Object[0]);
            ++n;
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }
}

