/*
 * Decompiled with CFR 0.152.
 */
package oz.util.gif;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import oz.util.gif.GifDecoder$BitmapProvider;
import oz.util.gif.GifFrame;
import oz.util.gif.GifHeader;
import oz.util.gif.GifHeaderParser;
import oz.util.gif.SimpleBitmapProvider;

class GifDecoder {
    private static final String TAG = GifDecoder.class.getSimpleName();
    static final int STATUS_OK = 0;
    static final int STATUS_FORMAT_ERROR = 1;
    static final int STATUS_OPEN_ERROR = 2;
    static final int STATUS_PARTIAL_DECODE = 3;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    static final int LOOP_FOREVER = -1;
    private static final int BYTES_PER_INTEGER = 4;
    private int[] act;
    private final int[] pct = new int[256];
    private ByteBuffer rawData;
    private byte[] block;
    private static final int WORK_BUFFER_SIZE = 16384;
    private byte[] workBuffer;
    private int workBufferSize = 0;
    private int workBufferPosition = 0;
    private GifHeaderParser parser;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] mainPixels;
    private int[] mainScratch;
    private int framePointer;
    private int loopIndex;
    private GifHeader header;
    private GifDecoder$BitmapProvider bitmapProvider;
    private Bitmap previousImage;
    private boolean savePrevious;
    private int status;
    private int sampleSize;
    private int downsampledHeight;
    private int downsampledWidth;
    private boolean isFirstFrameTransparent;

    GifDecoder(GifDecoder$BitmapProvider gifDecoder$BitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer) {
        this(gifDecoder$BitmapProvider, gifHeader, byteBuffer, 1);
    }

    GifDecoder(GifDecoder$BitmapProvider gifDecoder$BitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer, int n) {
        this(gifDecoder$BitmapProvider);
        this.setData(gifHeader, byteBuffer, n);
    }

    GifDecoder(GifDecoder$BitmapProvider gifDecoder$BitmapProvider) {
        this.bitmapProvider = gifDecoder$BitmapProvider;
        this.header = new GifHeader();
    }

    GifDecoder() {
        this(new SimpleBitmapProvider());
    }

    int getWidth() {
        return this.header.width;
    }

    int getHeight() {
        return this.header.height;
    }

    ByteBuffer getData() {
        return this.rawData;
    }

    int getStatus() {
        return this.status;
    }

    boolean advance() {
        if (this.header.frameCount <= 0) {
            return false;
        }
        if (this.framePointer == this.getFrameCount() - 1) {
            ++this.loopIndex;
        }
        if (this.header.loopCount != -1 && this.loopIndex > this.header.loopCount) {
            return false;
        }
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
        return true;
    }

    int getDelay(int n) {
        int n2 = -1;
        if (n >= 0 && n < this.header.frameCount) {
            n2 = ((GifFrame)this.header.frames.get((int)n)).delay;
        }
        return n2;
    }

    int getNextDelay() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return 0;
        }
        return this.getDelay(this.framePointer);
    }

    int getFrameCount() {
        return this.header != null ? this.header.frameCount : 0;
    }

    int getCurrentFrameIndex() {
        return this.framePointer;
    }

    boolean setFrameIndex(int n) {
        if (n < -1 || n >= this.getFrameCount()) {
            return false;
        }
        this.framePointer = n;
        return true;
    }

    void resetFrameIndex() {
        this.framePointer = -1;
    }

    void resetLoopIndex() {
        this.loopIndex = 0;
    }

    int getLoopCount() {
        return this.header.loopCount;
    }

    int getLoopIndex() {
        return this.loopIndex;
    }

    int getByteSize() {
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer));
            }
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, status=" + this.status));
            }
            return null;
        }
        this.status = 0;
        GifFrame gifFrame = (GifFrame)this.header.frames.get(this.framePointer);
        GifFrame gifFrame2 = null;
        int n = this.framePointer - 1;
        if (n >= 0) {
            gifFrame2 = (GifFrame)this.header.frames.get(n);
        }
        int[] nArray = this.act = gifFrame.lct != null ? gifFrame.lct : this.header.gct;
        if (this.act == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("No Valid Color Table for frame #" + this.framePointer));
            }
            this.status = 1;
            return null;
        }
        if (gifFrame.transparency) {
            System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
            this.act = this.pct;
            this.act[gifFrame.transIndex] = 0;
        }
        return this.setPixels(gifFrame, gifFrame2);
    }

    int read(InputStream inputStream, int n) {
        if (inputStream != null) {
            try {
                int n2;
                int n3 = n > 0 ? n + 4096 : 16384;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
                byte[] byArray = new byte[16384];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
                this.read(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
            }
        } else {
            this.status = 2;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)iOException);
        }
        return this.status;
    }

    void clear() {
        this.header = null;
        if (this.mainPixels != null) {
            this.bitmapProvider.release(this.mainPixels);
        }
        if (this.mainScratch != null) {
            this.bitmapProvider.release(this.mainScratch);
        }
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = false;
        if (this.block != null) {
            this.bitmapProvider.release(this.block);
        }
        if (this.workBuffer != null) {
            this.bitmapProvider.release(this.workBuffer);
        }
    }

    synchronized void setData(GifHeader gifHeader, byte[] byArray) {
        this.setData(gifHeader, ByteBuffer.wrap(byArray));
    }

    synchronized void setData(GifHeader gifHeader, ByteBuffer byteBuffer) {
        this.setData(gifHeader, byteBuffer, 1);
    }

    synchronized void setData(GifHeader gifHeader, ByteBuffer byteBuffer, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Sample size must be >=0, not: " + n);
        }
        n = Integer.highestOneBit(n);
        this.status = 0;
        this.header = gifHeader;
        this.isFirstFrameTransparent = false;
        this.framePointer = -1;
        this.resetLoopIndex();
        this.rawData = byteBuffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        for (GifFrame gifFrame : gifHeader.frames) {
            if (gifFrame.dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.sampleSize = n;
        this.downsampledWidth = gifHeader.width / n;
        this.downsampledHeight = gifHeader.height / n;
        this.mainPixels = this.bitmapProvider.obtainByteArray(gifHeader.width * gifHeader.height);
        this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    synchronized int read(byte[] byArray) {
        this.header = this.getHeaderParser().setData(byArray).parseHeader();
        if (byArray != null) {
            this.setData(this.header, byArray);
        }
        return this.status;
    }

    private Bitmap setPixels(GifFrame gifFrame, GifFrame gifFrame2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = this.mainScratch;
        if (gifFrame2 == null) {
            Arrays.fill(nArray, 0);
        }
        if (gifFrame2 != null && gifFrame2.dispose > 0) {
            if (gifFrame2.dispose == 2) {
                n5 = 0;
                if (!gifFrame.transparency) {
                    n5 = this.header.bgColor;
                    if (gifFrame.lct != null && this.header.bgIndex == gifFrame.transIndex) {
                        n5 = 0;
                    }
                } else if (this.framePointer == 0) {
                    this.isFirstFrameTransparent = true;
                }
                this.fillRect(nArray, gifFrame2, n5);
            } else if (gifFrame2.dispose == 3) {
                if (this.previousImage == null) {
                    this.fillRect(nArray, gifFrame2, 0);
                } else {
                    n5 = gifFrame2.ih / this.sampleSize;
                    n4 = gifFrame2.iy / this.sampleSize;
                    n3 = gifFrame2.iw / this.sampleSize;
                    n2 = gifFrame2.ix / this.sampleSize;
                    n = n4 * this.downsampledWidth + n2;
                    this.previousImage.getPixels(nArray, n, this.downsampledWidth, n2, n4, n3, n5);
                }
            }
        }
        this.decodeBitmapData(gifFrame);
        n5 = gifFrame.ih / this.sampleSize;
        n4 = gifFrame.iy / this.sampleSize;
        n3 = gifFrame.iw / this.sampleSize;
        n2 = gifFrame.ix / this.sampleSize;
        n = 1;
        int n6 = 8;
        int n7 = 0;
        boolean bl = this.framePointer == 0;
        for (int j = 0; j < n5; ++j) {
            int n8 = j;
            if (gifFrame.interlace) {
                if (n7 >= n5) {
                    switch (++n) {
                        case 2: {
                            n7 = 4;
                            break;
                        }
                        case 3: {
                            n7 = 2;
                            n6 = 4;
                            break;
                        }
                        case 4: {
                            n7 = 1;
                            n6 = 2;
                            break;
                        }
                    }
                }
                n8 = n7;
                n7 += n6;
            }
            if ((n8 += n4) >= this.downsampledHeight) continue;
            int n9 = n8 * this.downsampledWidth;
            int n10 = n9 + n2;
            int n11 = n10 + n3;
            if (n9 + this.downsampledWidth < n11) {
                n11 = n9 + this.downsampledWidth;
            }
            int n12 = j * this.sampleSize * gifFrame.iw;
            int n13 = n12 + (n11 - n10) * this.sampleSize;
            while (n10 < n11) {
                int n14;
                if (this.sampleSize == 1) {
                    int n15 = this.mainPixels[n12] & 0xFF;
                    n14 = this.act[n15];
                } else {
                    n14 = this.averageColorsNear(n12, n13, gifFrame.iw);
                }
                if (n14 != 0) {
                    nArray[n10] = n14;
                } else if (!this.isFirstFrameTransparent && bl) {
                    this.isFirstFrameTransparent = true;
                }
                n12 += this.sampleSize;
                ++n10;
            }
        }
        if (this.savePrevious && (gifFrame.dispose == 0 || gifFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            this.previousImage.setPixels(nArray, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        }
        Bitmap bitmap = this.getNextBitmap();
        bitmap.setPixels(nArray, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        return bitmap;
    }

    private void fillRect(int[] nArray, GifFrame gifFrame, int n) {
        int n2 = gifFrame.ih / this.sampleSize;
        int n3 = gifFrame.iy / this.sampleSize;
        int n4 = gifFrame.iw / this.sampleSize;
        int n5 = gifFrame.ix / this.sampleSize;
        int n6 = n3 * this.downsampledWidth + n5;
        int n7 = n6 + n2 * this.downsampledWidth;
        for (int j = n6; j < n7; j += this.downsampledWidth) {
            int n8 = j + n4;
            for (int k = j; k < n8; ++k) {
                nArray[k] = n;
            }
        }
    }

    private int averageColorsNear(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n6 = n; n6 < n + this.sampleSize && n6 < this.mainPixels.length && n6 < n2; ++n6) {
            n5 = this.mainPixels[n6] & 0xFF;
            n4 = this.act[n5];
            if (n4 == 0) continue;
            n7 += n4 >> 24 & 0xFF;
            n8 += n4 >> 16 & 0xFF;
            n9 += n4 >> 8 & 0xFF;
            n10 += n4 & 0xFF;
            ++n11;
        }
        for (n6 = n + n3; n6 < n + n3 + this.sampleSize && n6 < this.mainPixels.length && n6 < n2; ++n6) {
            n5 = this.mainPixels[n6] & 0xFF;
            n4 = this.act[n5];
            if (n4 == 0) continue;
            n7 += n4 >> 24 & 0xFF;
            n8 += n4 >> 16 & 0xFF;
            n9 += n4 >> 8 & 0xFF;
            n10 += n4 & 0xFF;
            ++n11;
        }
        if (n11 == 0) {
            return 0;
        }
        return n7 / n11 << 24 | n8 / n11 << 16 | n9 / n11 << 8 | n10 / n11;
    }

    private void decodeBitmapData(GifFrame gifFrame) {
        int n;
        int n2;
        this.workBufferSize = 0;
        this.workBufferPosition = 0;
        if (gifFrame != null) {
            this.rawData.position(gifFrame.bufferFrameStart);
        }
        int n3 = n2 = gifFrame == null ? this.header.width * this.header.height : gifFrame.iw * gifFrame.ih;
        if (this.mainPixels == null || this.mainPixels.length < n2) {
            this.mainPixels = this.bitmapProvider.obtainByteArray(n2);
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n4 = this.readByte();
        int n5 = 1 << n4;
        int n6 = n5 + 1;
        int n7 = n5 + 2;
        int n8 = -1;
        int n9 = n4 + 1;
        int n10 = (1 << n9) - 1;
        for (n = 0; n < n5; ++n) {
            this.prefix[n] = 0;
            this.suffix[n] = (byte)n;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        block1: while (n18 < n2) {
            if (n15 == 0) {
                n15 = this.readBlock();
                if (n15 <= 0) {
                    this.status = 3;
                    break;
                }
                n11 = 0;
            }
            n17 += (this.block[n11] & 0xFF) << n16;
            n16 += 8;
            ++n11;
            --n15;
            while (n16 >= n9) {
                n = n17 & n10;
                n17 >>= n9;
                n16 -= n9;
                if (n == n5) {
                    n9 = n4 + 1;
                    n10 = (1 << n9) - 1;
                    n7 = n5 + 2;
                    n8 = -1;
                    continue;
                }
                if (n > n7) {
                    this.status = 3;
                    continue block1;
                }
                if (n == n6) continue block1;
                if (n8 == -1) {
                    this.pixelStack[n13++] = this.suffix[n];
                    n8 = n;
                    n14 = n;
                    continue;
                }
                int n19 = n;
                if (n >= n7) {
                    this.pixelStack[n13++] = (byte)n14;
                    n = n8;
                }
                while (n >= n5) {
                    this.pixelStack[n13++] = this.suffix[n];
                    n = this.prefix[n];
                }
                n14 = this.suffix[n] & 0xFF;
                this.pixelStack[n13++] = (byte)n14;
                if (n7 < 4096) {
                    this.prefix[n7] = (short)n8;
                    this.suffix[n7] = (byte)n14;
                    if ((++n7 & n10) == 0 && n7 < 4096) {
                        ++n9;
                        n10 += n7;
                    }
                }
                n8 = n19;
                while (n13 > 0) {
                    this.mainPixels[n12++] = this.pixelStack[--n13];
                    ++n18;
                }
            }
        }
        for (n18 = n12; n18 < n2; ++n18) {
            this.mainPixels[n18] = 0;
        }
    }

    private void readChunkIfNeeded() {
        if (this.workBufferSize > this.workBufferPosition) {
            return;
        }
        if (this.workBuffer == null) {
            this.workBuffer = this.bitmapProvider.obtainByteArray(16384);
        }
        this.workBufferPosition = 0;
        this.workBufferSize = Math.min(this.rawData.remaining(), 16384);
        this.rawData.get(this.workBuffer, 0, this.workBufferSize);
    }

    private int readByte() {
        try {
            this.readChunkIfNeeded();
            return this.workBuffer[this.workBufferPosition++] & 0xFF;
        }
        catch (Exception exception) {
            this.status = 1;
            return 0;
        }
    }

    private int readBlock() {
        int n = this.readByte();
        if (n > 0) {
            try {
                int n2;
                if (this.block == null) {
                    this.block = this.bitmapProvider.obtainByteArray(255);
                }
                if ((n2 = this.workBufferSize - this.workBufferPosition) >= n) {
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, n);
                    this.workBufferPosition += n;
                } else if (this.rawData.remaining() + n2 >= n) {
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, n2);
                    this.workBufferPosition = this.workBufferSize;
                    this.readChunkIfNeeded();
                    int n3 = n - n2;
                    System.arraycopy(this.workBuffer, 0, this.block, n2, n3);
                    this.workBufferPosition += n3;
                } else {
                    this.status = 1;
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Error Reading Block", (Throwable)exception);
                this.status = 1;
            }
        }
        return n;
    }

    private Bitmap getNextBitmap() {
        Bitmap.Config config = this.isFirstFrameTransparent ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, config);
        GifDecoder.setAlpha(bitmap);
        return bitmap;
    }

    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(true);
        }
    }
}

