/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import oz.main.MainFrameView;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.edit.AEditableBaseView;
import oz.viewer.ui.edit.AEditableBottomBar$1;
import oz.viewer.ui.edit.AEditableBottomBar$2;
import oz.viewer.ui.edit.AEditableBottomBar$3;
import oz.viewer.ui.edit.AEditableBottomBar$CommentAble;
import oz.viewer.ui.edit.AEditableConst$Size;
import oz.viewer.ui.edit.AEditableLinearLayout;
import oz.viewer.ui.edit.AEditableUtil;
import oz.viewer.ui.edit.APopupToolbarButton;

public class AEditableBottomBar
extends AEditableLinearLayout {
    private static final int[] TOOLBAR_BUTTONS = new int[]{0, 1, 2, 3, 4};
    private boolean mIsHandMode;
    private APopupToolbarButton[] mToolbarButtons;
    private boolean m_isEditableImagePicker;
    private AEditableBottomBar$CommentAble m_commentToolbar;
    private MainFrameView m_mfView;
    private boolean mIsFirstDraw;
    private RectF mBorderRect;
    private Paint mPaint;

    public AEditableBottomBar(Context context, AEditableBaseView aEditableBaseView, boolean bl, AEditableBottomBar$CommentAble aEditableBottomBar$CommentAble, MainFrameView mainFrameView) {
        super(context, aEditableBaseView);
        this.m_isEditableImagePicker = bl;
        this.m_commentToolbar = aEditableBottomBar$CommentAble;
        this.m_mfView = mainFrameView;
        this.init();
    }

    public AEditableBottomBar$CommentAble getCommentAble() {
        return this.m_commentToolbar;
    }

    public MainFrameView getMainFrameView() {
        return this.m_mfView;
    }

    public boolean isHandMode() {
        if (this.isFromImagePicker()) {
            return this.mIsHandMode;
        }
        return this.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentMemoMode();
    }

    public void setHandMode() {
        this.setMode(true);
        if (this.isFromComment()) {
            this.getMainFrameView().getOverlayLayout().getScreenToolController().setCommentMemoMode();
        }
    }

    private void setMode(boolean bl) {
        this.mIsHandMode = bl;
    }

    public boolean isCommentMode() {
        if (this.isFromImagePicker()) {
            return !this.mIsHandMode;
        }
        return !this.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentMemoMode() && this.getMainFrameView().getOverlayLayout().getScreenToolController().isCommentMode();
    }

    public void setCommentMode() {
        this.setCommentMode(true);
    }

    public void setCommentMode(boolean bl) {
        this.setMode(false);
        if (this.isFromComment()) {
            boolean bl2 = false;
            switch (this.getBaseView().getCommentMode()) {
                case 3: 
                case 4: {
                    bl2 = true;
                }
            }
            if (bl2) {
                this.getMainFrameView().getOverlayLayout().getScreenToolController().setCommentFillMode();
            } else {
                this.getMainFrameView().getOverlayLayout().getScreenToolController().setCommentMode();
            }
            if (bl) {
                this.getCommentAble().SetCommentShow(true);
            }
        }
    }

    public boolean isFromImagePicker() {
        return this.m_isEditableImagePicker;
    }

    public boolean isFromComment() {
        return !this.m_isEditableImagePicker;
    }

    private void init() {
        this.setPadding(AEditableConst$Size.EDITABLE_GAP_30, 0, AEditableConst$Size.EDITABLE_GAP_30, AEditableConst$Size.EDITABLE_GAP_15);
        this.setGravity(17);
        this.setBackgroundColor(0);
        this.init_ToolbarButtons();
        this.init_Draw();
        if (this.isFromImagePicker()) {
            this.post(new AEditableBottomBar$1(this));
        }
    }

    private void init_ToolbarButtons() {
        this.mToolbarButtons = new APopupToolbarButton[TOOLBAR_BUTTONS.length];
        for (int j = 0; j < TOOLBAR_BUTTONS.length; ++j) {
            this.mToolbarButtons[j] = new APopupToolbarButton(this.getContext(), TOOLBAR_BUTTONS[j], this.getBaseView());
            if (j == 0) {
                AEditableUtil.setViewPadding((View)this.mToolbarButtons[j], 0, this.mToolbarButtons[j].getPaddingTop(), this.mToolbarButtons[j].getPaddingRight(), this.mToolbarButtons[j].getPaddingBottom());
            }
            this.addView((View)this.mToolbarButtons[j]);
        }
    }

    private void init_Draw() {
        this.mIsFirstDraw = true;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16777216);
        this.mPaint.setAlpha(191);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mBorderRect = new RectF();
    }

    public APopupToolbarButton getToolbarButton(int n) {
        for (int j = 0; j < TOOLBAR_BUTTONS.length; ++j) {
            if (TOOLBAR_BUTTONS[j] != n) continue;
            return this.mToolbarButtons[j];
        }
        return null;
    }

    public void setVisibleBtn() {
        if (this.isFromComment()) {
            this.getToolbarButton(2).setVisibility(this.getCommentAble().IsVisibleEraserAll() ? 0 : 8);
            this.getToolbarButton(3).setVisibility(this.getCommentAble().IsVisibleMemo() ? 0 : 8);
            this.getToolbarButton(4).setVisibility(this.getCommentAble().IsVisibleImage() ? 0 : 8);
            if (this.getBaseView().getPopupParent() != null) {
                if (!this.getCommentAble().IsVisibleColor()) {
                    this.getBaseView().setButtonProperties((ViewGroup)this.getBaseView().getPopupParent(), false, false);
                }
                this.getBaseView().getPenSeekBar().setFixedEnabled(!this.getCommentAble().IsVisibleThick());
            }
        }
    }

    public void setModeBackground() {
        for (int j = 0; j < this.mToolbarButtons.length; ++j) {
            this.mToolbarButtons[j].updateState();
        }
    }

    public void callAlertDlg() {
        if (this.isFromImagePicker()) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
            builder.setMessage((CharSequence)OZAndroidResource.getResource("image.edit.remove.all.edits"));
            builder.setPositiveButton((CharSequence)OZAndroidResource.getResource(60019), (DialogInterface.OnClickListener)new AEditableBottomBar$2(this));
            builder.setNegativeButton((CharSequence)OZAndroidResource.getResource(60020), (DialogInterface.OnClickListener)new AEditableBottomBar$3(this));
            builder.show();
        } else {
            this.getCommentAble().CommentConfirmClearForScript(this.getCommentAble().IsEraserConfirm());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.mIsFirstDraw && n != 0 && n2 != 0) {
            this.setVisibleBtn();
            this.mIsFirstDraw = false;
        }
        this.mBorderRect.set(0.0f, 0.0f, (float)n, (float)(n2 - AEditableConst$Size.EDITABLE_GAP_15));
        canvas.drawRoundRect(this.mBorderRect, (float)((n2 - AEditableConst$Size.EDITABLE_GAP_15) / 2), (float)((n2 - AEditableConst$Size.EDITABLE_GAP_15) / 2), this.mPaint);
    }
}

