/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Bitmap;
import android.util.Log;
import android.util.SparseArray;
import oz.viewer.ui.main.ACommentView;
import oz.viewer.ui.main.overlay.ANativeController$ExeComment;
import oz.viewer.ui.main.overlay.ANativeController$ExeCommon;
import oz.viewer.ui.main.overlay.ANativeController$ExeLink;
import oz.viewer.ui.main.overlay.ANativeController$ExeMemo;
import oz.viewer.ui.main.overlay.ANativeController$ExeParam;
import oz.viewer.ui.main.overlay.ANativeController$ExeRefresh;
import oz.viewer.ui.main.overlay.ANativeController$ExeScreenTool;
import oz.viewer.ui.main.overlay.ANativeController$ExeScroll;
import oz.viewer.ui.main.overlay.ANativeController$ExeSearch;
import oz.viewer.ui.main.overlay.ANativeController$ExeStatus;
import oz.viewer.ui.main.overlay.ANativeController$ExeTable;
import oz.viewer.ui.main.overlay.ANativeController$ExeToolbar;
import oz.viewer.ui.main.overlay.ANativeController$Executeable;
import oz.viewer.ui.main.overlay.ATableView$ThumbnailView;
import oz.viewer.ui.main.overlay.OZOverlayController;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.OverlayObject;

public class ANativeController
extends OZOverlayController {
    private static final String TAG = "OZViewer";
    private static final int VERSION = 10;
    private static final int LOCK_THUMBNAIL_LOCKNUMBER = 0;
    private static final int LOCK_THUMBNAIL_START = 1;
    private static final int LOCK_THUMBNAIL_END = 8;
    private static final int LOCK_COUNT = 9;
    private SparseArray mExes;
    private boolean mIsDispose;
    private Object[] mLocks;
    private int mNextThumbnailLock;

    public ANativeController(OverlayLayout overlayLayout) {
        super(overlayLayout, 10001);
        Log.i((String)TAG, (String)String.format("NativeControllerVersion_JAVA %d", 10));
        this.mExes = new SparseArray();
        this.mIsDispose = false;
        this.mLocks = new Object[9];
        for (int j = 0; j < 9; ++j) {
            this.mLocks[j] = new Object();
        }
        this.mNextThumbnailLock = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.mIsDispose = true;
        for (int j = 0; j < 9; ++j) {
            Object object = this.mLocks[j];
            synchronized (object) {
                this.mLocks[j] = null;
                continue;
            }
        }
    }

    public boolean isDispose() {
        return this.mIsDispose;
    }

    private Object exe(OverlayObject overlayObject, int n, int n2, Object[] objectArray) {
        if (!this.isDispose()) {
            ANativeController$Executeable aNativeController$Executeable = (ANativeController$Executeable)this.mExes.get(n);
            if (aNativeController$Executeable == null) {
                switch (n) {
                    case -1: {
                        aNativeController$Executeable = new ANativeController$ExeCommon(this, null);
                        break;
                    }
                    case 1: 
                    case 11: {
                        aNativeController$Executeable = new ANativeController$ExeToolbar(this, null);
                        break;
                    }
                    case 2: {
                        aNativeController$Executeable = new ANativeController$ExeComment(this, null);
                        break;
                    }
                    case 4: {
                        aNativeController$Executeable = new ANativeController$ExeParam(this, null);
                        break;
                    }
                    case 5: {
                        aNativeController$Executeable = new ANativeController$ExeSearch(this, null);
                        break;
                    }
                    case 6: {
                        aNativeController$Executeable = new ANativeController$ExeRefresh(this, null);
                        break;
                    }
                    case 7: {
                        aNativeController$Executeable = new ANativeController$ExeStatus(this, null);
                        break;
                    }
                    case 8: {
                        aNativeController$Executeable = new ANativeController$ExeScroll(this, null);
                        break;
                    }
                    case 9: {
                        aNativeController$Executeable = new ANativeController$ExeLink(this, null);
                        break;
                    }
                    case 10: {
                        aNativeController$Executeable = new ANativeController$ExeTable(this, null);
                        break;
                    }
                    case 10002: {
                        aNativeController$Executeable = new ANativeController$ExeScreenTool(this, null);
                        break;
                    }
                    case 10003: {
                        aNativeController$Executeable = new ANativeController$ExeMemo(this, null);
                        break;
                    }
                    default: {
                        this.executeError(n, n2, objectArray);
                        return null;
                    }
                }
                this.mExes.put(n, (Object)aNativeController$Executeable);
            }
            return aNativeController$Executeable.run(overlayObject, n2, objectArray);
        }
        return null;
    }

    private Object[] getEmptyObjectArray(int n) {
        Object[] objectArray = null;
        try {
            objectArray = new Object[n];
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return objectArray;
    }

    private void setInteger(Object[] objectArray, int n, int n2) {
        objectArray[n] = n2;
    }

    private void setBoolean(Object[] objectArray, int n, boolean bl) {
        objectArray[n] = bl;
    }

    private void setFloat(Object[] objectArray, int n, float f2) {
        objectArray[n] = Float.valueOf(f2);
    }

    private void setString(Object[] objectArray, int n, String string) {
        objectArray[n] = new String(string);
    }

    private void setObject(Object[] objectArray, int n, Object object) {
        objectArray[n] = object;
    }

    private void executeError(OverlayObject overlayObject, int n, Object[] objectArray) {
        this.executeError(overlayObject.getType(), n, objectArray);
    }

    private void executeErrorNeedCreate(int n, int n2) {
        Log.e((String)TAG, (String)String.format("Need create target : target=%d, method=%d", n, n2));
    }

    private void executeError(int n, int n2, Object[] objectArray) {
        Log.e((String)TAG, (String)String.format("Unknown method execute error : target=%d, method=%d", n, n2));
    }

    private void executeException(int n, int n2, Object[] objectArray) {
        Log.e((String)TAG, (String)String.format("method exception : target=%d, method=%d, args=%s", n, n2, objectArray != null ? objectArray.toString() : "null"));
    }

    private void execute(int n, int n2, Object[] objectArray) {
        this.executeObj(n, n2, objectArray);
    }

    private Object executeObj(int n, int n2, Object[] objectArray) {
        Object object = null;
        try {
            object = this.executeInternal(n, n2, objectArray);
        }
        catch (Throwable throwable) {
            this.executeException(n, n2, objectArray);
            throwable.printStackTrace();
        }
        return object;
    }

    private int executeInt(int n, int n2, Object[] objectArray) {
        Object object = this.executeObj(n, n2, objectArray);
        int n3 = 0;
        if (object != null) {
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof Boolean) {
                n3 = (Boolean)object != false ? 1 : 0;
            }
        }
        return n3;
    }

    private float executeFloat(int n, int n2, Object[] objectArray) {
        Object object = this.executeObj(n, n2, objectArray);
        float f2 = 0.0f;
        if (object != null) {
            if (object instanceof Float) {
                f2 = ((Float)object).floatValue();
            } else if (object instanceof Integer) {
                f2 = ((Integer)object).intValue();
            } else if (object instanceof Double) {
                f2 = (float)((Double)object).doubleValue();
            }
        }
        return f2;
    }

    private Object executeInternal(int n, int n2, Object[] objectArray) {
        Object object = null;
        if (n == -1 && n2 == -1) {
            int n3 = (Integer)objectArray[0];
            Log.i((String)TAG, (String)String.format("NativeControllerVersion_C %d", n3));
            if (n3 != 10) {
                Log.w((String)TAG, (String)"please check your .jar and .so");
            }
        } else {
            object = n2 > 100000 ? this.exe(this.getOZParent().findOverlayView(n), -1, n2, objectArray) : this.exe(this.getOZParent().findOverlayObject(n), n, n2, objectArray);
        }
        return object;
    }

    private native void nativeOnToolbarClickEvent(int var1, int var2);

    void OnToolbarClickEvent(int n, int n2) {
        if (!this.isDispose()) {
            this.nativeOnToolbarClickEvent(n, n2);
        }
    }

    private native void nativeOnBottomToolbarClickEvent(int var1, int var2);

    void OnBottomToolbarClickEvent(int n, int n2) {
        if (!this.isDispose()) {
            this.nativeOnBottomToolbarClickEvent(n, n2);
        }
    }

    private native void nativeOnScreenToolChanged(int var1);

    void OnScreenToolChanged(int n) {
        if (!this.isDispose()) {
            this.nativeOnScreenToolChanged(n);
        }
    }

    private native void nativeSetCommentMode(boolean var1);

    void setCommentMode(boolean bl) {
        if (!this.isDispose()) {
            this.nativeSetCommentMode(bl);
        }
    }

    private native void nativeSetCommentSubModeMemo();

    void setCommentSubModeMemo() {
        if (!this.isDispose()) {
            this.nativeSetCommentSubModeMemo();
        }
    }

    private native void nativeSetCommentSubModeNormal();

    void setCommentSubModeNormal() {
        if (!this.isDispose()) {
            this.nativeSetCommentSubModeNormal();
        }
    }

    private native void nativeSetCommentSubModeFill();

    void setCommentSubModeFill() {
        if (!this.isDispose()) {
            this.nativeSetCommentSubModeFill();
        }
    }

    private native void nativeOnTableViewItemSelected(int var1, boolean var2);

    void onTreeItemSelected(int n) {
        if (!this.isDispose()) {
            this.nativeOnTableViewItemSelected(n - 1, false);
        }
    }

    void onThumbnailItemSelected(int n) {
        if (!this.isDispose()) {
            this.nativeOnTableViewItemSelected(n + 1, true);
        }
    }

    private native boolean nativeGetThumbnailView(int var1);

    ATableView$ThumbnailView getThumbnailView(int n) {
        if (!this.isDispose() && this.nativeGetThumbnailView(n)) {
            return this.getOZParent().getTable().getThumbnailView(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getThumbnailLockNumber() {
        int n = 1;
        Object object = this.mLocks[0];
        synchronized (object) {
            n = this.mNextThumbnailLock++;
            if (this.mNextThumbnailLock > 8) {
                this.mNextThumbnailLock = 1;
            }
        }
        return n;
    }

    private native boolean nativeDrawThumbnail(Bitmap var1, int var2, float var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean drawThumbnail(Bitmap bitmap, int n, float f2) {
        if (!this.isDispose()) {
            boolean bl = false;
            Object object = this.mLocks[this.getThumbnailLockNumber()];
            synchronized (object) {
                bl = this.nativeDrawThumbnail(bitmap, n, f2);
            }
            return bl;
        }
        return false;
    }

    private native void nativeThumbnailOnCloseBtnClick(int var1);

    void thumbnailOnCloseBtnClick(int n) {
        if (!this.isDispose()) {
            this.nativeThumbnailOnCloseBtnClick(n);
        }
    }

    private native ACommentView nativeGetCommentView();

    ACommentView getCommentView() {
        if (!this.isDispose()) {
            return this.nativeGetCommentView();
        }
        return null;
    }

    private native void nativeCommentClear();

    void commentClear() {
        if (!this.isDispose()) {
            this.nativeCommentClear();
        }
    }

    private native boolean nativeIsCommentClearNeedConfirm();

    boolean isCommentClearNeedConfirm() {
        if (!this.isDispose()) {
            return this.nativeIsCommentClearNeedConfirm();
        }
        return false;
    }

    void commentSetUserInteractionEnabled(boolean bl) {
        ACommentView aCommentView = this.getCommentView();
        if (aCommentView != null) {
            aCommentView.setUserInteractionEnabled(bl);
        }
    }

    private native void nativeThickValue(int var1, int var2);

    void commentThickValue(int n, int n2) {
        if (!this.isDispose()) {
            this.nativeThickValue(n, n2);
        }
    }

    private native void nativeColorValue(int var1, int var2);

    void commentColorValue(int n, int n2) {
        if (!this.isDispose()) {
            this.nativeColorValue(n, n2);
        }
    }

    private native void nativeSelectedPen(int var1);

    void commentSelectedPen(int n) {
        if (!this.isDispose()) {
            this.nativeSelectedPen(n);
        }
    }

    private native void nativeMemoOnCreateDialog();

    void memoOnCreateDialog() {
        if (!this.isDispose()) {
            this.nativeMemoOnCreateDialog();
        }
    }

    private native void nativeMemoSetLabelText(String var1);

    void memoSetLabelText(String string) {
        if (!this.isDispose()) {
            this.nativeMemoSetLabelText(string);
        }
    }

    private native void nativeMemoOnDialogOkCancel(boolean var1);

    void memoOnDialogOkCancel(boolean bl) {
        if (!this.isDispose()) {
            this.nativeMemoOnDialogOkCancel(bl);
        }
    }

    private native void nativeMemoOnOkParagraph(int var1, int var2);

    void memoOnOkParagraph(int n, int n2) {
        if (!this.isDispose()) {
            this.nativeMemoOnOkParagraph(n, n2);
        }
    }

    private native void nativeMemoOnOkFont(int var1, int var2, int var3, String var4);

    void memoOnOkFont(int n, int n2, int n3, String string) {
        if (!this.isDispose()) {
            this.nativeMemoOnOkFont(n, n2, n3, string);
        }
    }

    private native void nativeMemoOnOkFill(boolean var1, String var2, int var3);

    void memoOnOkFill(boolean bl, String string, int n) {
        if (!this.isDispose()) {
            this.nativeMemoOnOkFill(bl, string, n);
        }
    }

    private native void nativeMemoOnOkEtc(boolean var1, boolean var2, boolean var3, int var4, boolean var5);

    void memoOnOkEtc(boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (!this.isDispose()) {
            this.nativeMemoOnOkEtc(bl, bl2, bl3, n, bl4);
        }
    }

    private native boolean nativeMemoIsMemoType();

    boolean memoIsMemoType() {
        if (!this.isDispose()) {
            return this.nativeMemoIsMemoType();
        }
        return false;
    }

    private native void nativeSearchText(String var1, int var2);

    void searchText(String string, int n) {
        if (!this.isDispose()) {
            this.nativeSearchText(string, n);
        }
    }

    private native void nativeRefreshOnOK();

    void onRefreshStart() {
        if (!this.isDispose()) {
            this.nativeRefreshOnOK();
        }
    }

    private native void nativeRefreshOnStop();

    void onRefreshStop() {
        if (!this.isDispose()) {
            this.nativeRefreshOnStop();
        }
    }

    private native void nativeRefreshOnBtnRefresh();

    void onRefresh() {
        if (!this.isDispose()) {
            this.nativeRefreshOnBtnRefresh();
        }
    }

    private native void nativeRefreshOnRefreshClose();

    void onRefreshClose() {
        if (!this.isDispose()) {
            this.nativeRefreshOnRefreshClose();
        }
    }

    private native void nativeParameterOnFind(String var1, String var2);

    void parameterOnFind(String string, String string2) {
        if (!this.isDispose()) {
            this.nativeParameterOnFind(string, string2);
        }
    }

    private native void nativeParameterOnRebind();

    void parameterOnRebind() {
        if (!this.isDispose()) {
            this.nativeParameterOnRebind();
        }
    }

    private native void nativeParameterToolbarClose();

    void parameterToolbarClose() {
        if (!this.isDispose()) {
            this.nativeParameterToolbarClose();
        }
    }

    private native boolean nativeIsDocSizeZero();

    boolean isDocSizeZero() {
        if (!this.isDispose()) {
            return this.nativeIsDocSizeZero();
        }
        return true;
    }

    private native void nativeRemoveEditObj();

    void removeEditObj() {
        if (!this.isDispose()) {
            this.nativeRemoveEditObj();
        }
    }

    private native void nativeDeleteEditObj();

    void deleteEditObj() {
        if (!this.isDispose()) {
            this.nativeDeleteEditObj();
        }
    }

    private native void nativeFlushInputControls();

    void flushInputControls() {
        if (!this.isDispose()) {
            this.nativeFlushInputControls();
        }
    }

    static /* synthetic */ void access$1300(ANativeController aNativeController, OverlayObject overlayObject, int n, Object[] objectArray) {
        aNativeController.executeError(overlayObject, n, objectArray);
    }

    static /* synthetic */ void access$1400(ANativeController aNativeController, int n, int n2) {
        aNativeController.executeErrorNeedCreate(n, n2);
    }
}

