/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Looper;
import android.view.View;
import android.widget.ImageButton;
import oz.main.OZStorage;

public class AOverlayUtil {
    public static Drawable getAssetIcon(Context context, String string) {
        Drawable drawable2 = null;
        try {
            drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open(OZStorage.getImagePath(string)));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return drawable2;
    }

    public static Drawable getAssetIcon(Context context, String string, float f2) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)AOverlayUtil.getAssetIcon(context, string);
        if (bitmapDrawable != null) {
            int n = -1;
            int n2 = -1;
            if (f2 > 0.0f) {
                float f3 = (float)bitmapDrawable.getIntrinsicWidth() / f2;
                if (f3 > 1.0f) {
                    n = (int)(f3 * 100.0f);
                    n2 = 100;
                } else if (f3 < 1.0f) {
                    n = 100;
                    n2 = (int)(f3 * 100.0f);
                }
            }
            if (n > -1) {
                bitmapDrawable.getBitmap().setDensity(n);
            }
            if (n2 > -1) {
                bitmapDrawable.setTargetDensity(n2);
            }
        }
        return bitmapDrawable;
    }

    public static Drawable setDrawableAlpha(Drawable drawable2, int n) {
        if (drawable2 != null) {
            drawable2.setAlpha(n);
        }
        return drawable2;
    }

    public static ImageButton setImageButtonSize(ImageButton imageButton, float f2) {
        if (imageButton.getDrawable() != null && imageButton.getLayoutParams() != null) {
            imageButton.getLayoutParams().width = (int)((float)imageButton.getDrawable().getIntrinsicWidth() * f2);
            imageButton.getLayoutParams().height = (int)((float)imageButton.getDrawable().getIntrinsicWidth() * f2);
        }
        return imageButton;
    }

    public static ImageButton createImageButton(Context context, int n, String string, int n2, View.OnClickListener onClickListener) {
        ImageButton imageButton = new ImageButton(context);
        if (n != 0) {
            imageButton.setId(n);
        }
        imageButton.setBackgroundDrawable(null);
        Drawable drawable2 = AOverlayUtil.getAssetIcon(context, string);
        if (n2 != 255) {
            AOverlayUtil.setDrawableAlpha(drawable2, n2);
        }
        imageButton.setImageDrawable(drawable2);
        imageButton.setPadding(0, 0, 0, 0);
        imageButton.setAdjustViewBounds(true);
        imageButton.setOnClickListener(onClickListener);
        return imageButton;
    }

    public static float getDP() {
        return OZStorage.padding_1;
    }

    public static int getDP5() {
        return OZStorage.padding_5;
    }

    public static int getDP10() {
        return OZStorage.padding_10;
    }

    public static int getDP20() {
        return OZStorage.padding_20;
    }

    public static int DpToPx(int n) {
        return OZStorage.getPaddingInt(n);
    }

    public static float DpToPxF(int n) {
        return OZStorage.getPadding(n);
    }

    public static ShapeDrawable getRoundRectDrawable(float f2) {
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        return shapeDrawable;
    }

    public static boolean isUIThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static StateListDrawable getListViewStateListDrawableFromAsset(Context context, String string, String string2, int n) {
        return AOverlayUtil.getListViewStateListDrawable(AOverlayUtil.getAssetIcon(context, string, n), AOverlayUtil.getAssetIcon(context, string2, n));
    }

    public static StateListDrawable getListViewStateListDrawable(Drawable drawable2, Drawable drawable3) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910}, drawable2);
        stateListDrawable.addState(new int[]{-16842910}, drawable3);
        return stateListDrawable;
    }
}

