/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import oz.viewer.ui.main.overlay.AButtonInfo;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;

public class ToolbarManagerBase
extends AutoHideAbleOZOverlayView {
    private ArrayList mInfos = new ArrayList();
    private SparseBooleanArray mVisibilitys = new SparseBooleanArray();
    private HorizontalScrollView mView;
    private ViewGroup mIconLayoutView;

    public ToolbarManagerBase(OverlayLayout overlayLayout, int n, int n2) {
        super(overlayLayout, n);
        for (int j = 0; j < n2; ++j) {
            this.mInfos.add(new Hashtable());
            this.mVisibilitys.put(j, true);
        }
        this.preInitView();
        this.initView();
    }

    protected void preInitView() {
    }

    private void initView() {
        this.mView = new HorizontalScrollView(this.getContext());
        this.mView.setHorizontalScrollBarEnabled(false);
        this.mView.setOverScrollMode(2);
        this.mView.setBackgroundColor(0);
        this.mView.setPadding(AOverlayUtil.getDP5(), 0, 0, 0);
        this.mIconLayoutView = new LinearLayout(this.getContext());
        this.mView.addView((View)this.mIconLayoutView);
        this.mView.setVisibility(4);
    }

    protected View getView() {
        return this.mView;
    }

    protected void updateView() {
        for (int j = this.mInfos.size() - 1; j > -1; --j) {
            AButtonInfo[] aButtonInfoArray = this.getButtons(j);
            boolean bl = this.getIconTypeVisibility(j);
            for (int k = 0; k < aButtonInfoArray.length; ++k) {
                ImageButton imageButton = aButtonInfoArray[k].getButton();
                if (imageButton == null) {
                    imageButton = aButtonInfoArray[k].createButton(this.getContext());
                } else if (imageButton.getParent() != null) {
                    this.mIconLayoutView.removeView((View)imageButton);
                }
                if (!bl) continue;
                this.mIconLayoutView.addView((View)imageButton, 0);
            }
        }
    }

    public void setButtonTypeVisibility(int n, boolean bl) {
        if (this.getIconTypeVisibility(n) != bl) {
            this.mVisibilitys.put(n, bl);
            this.requestNeedUpdateView();
        }
    }

    public boolean getIconTypeVisibility(int n) {
        return this.mVisibilitys.get(n);
    }

    public ArrayList getButtonInfos() {
        return this.mInfos;
    }

    public int getButtonCount(int n) {
        return ((Map)this.mInfos.get(n)).size();
    }

    public AButtonInfo getButtonFromKey(int n, int n2) {
        return (AButtonInfo)((Map)this.mInfos.get(n)).get(n2);
    }

    public AButtonInfo[] getButtons(int n) {
        return ((Map)this.mInfos.get(n)).values().toArray(new AButtonInfo[this.getButtonCount(n)]);
    }

    public void addButton(int n, AButtonInfo aButtonInfo) {
        AButtonInfo aButtonInfo2 = this.getButtonFromKey(n, aButtonInfo.getIndex());
        if (!aButtonInfo.equals(aButtonInfo2)) {
            ((Map)this.mInfos.get(n)).put(aButtonInfo.getIndex(), aButtonInfo);
            this.requestNeedUpdateView();
            if (aButtonInfo2 != null) {
                aButtonInfo2.removeButton();
            }
        }
    }

    public void clearButton(int n) {
        Iterator iterator = ((Map)this.mInfos.get(n)).keySet().iterator();
        while (iterator.hasNext()) {
            ((AButtonInfo)((Map)this.mInfos.get(n)).get(iterator.next())).removeButton();
        }
        ((Map)this.mInfos.get(n)).clear();
    }
}

