package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONArray;
import org.json.adf.JSONException;
import org.json.adf.JSONObject;

/**
 * ACMSからの例外情報を格納します。
 * @author Taejin Hong
 * @version 1.0.0 
 */
public class AcmsMessageJSON extends AcmsCommonJSON {
	public static final String ErrorMessage = "errorMessage";
	public static final String Message = "message";
	public static final String LoginErrorMessage = "loginErrorMessage";
	public String[] errorMessage; // ACMSが返したエラーメッセージの配列
	public String loginErrorMessage; // ユーザに表示するエラーメッセージ
	public String message; // ユーザに表示するメッセージ
	
	public AcmsMessageJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}

	@Override
	protected void parse(JSONObject json) throws JSONValidationException, JSONException {
		super.parse(json);
		if (json.has(ErrorMessage)) {
			Object obj = json.get(ErrorMessage);
			
			if (obj instanceof JSONArray) {
				JSONArray jarr = (JSONArray) obj;
				List<String> list = new ArrayList<String>();
				
				for (int i = 0; i < jarr.length(); i++) {
					list.add(jarr.getString(i));
				}
				errorMessage = new String[list.size()];
				errorMessage = list.toArray(errorMessage);
			} else if (obj != null) {
				errorMessage = new String[] {(String)obj};
			}
		}
		
		loginErrorMessage = getString(json, LoginErrorMessage, null);
		message = getString(json, Message, null);
	}
}
