package jp.agentec.abook.abv.bl.acms.client.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.CategoryDto;
import jp.agentec.abook.abv.bl.acms.client.AcmsClient;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#category} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0 
 */
public class CategoriesJSON extends AcmsCommonJSON {
	public static final String CategoryList = "categoryList";
	public static final String CategoryId = "categoryId";
	public static final String CategoryName = "categoryName";
	public static final String ParentCategoryId = "parentCategoryId";
	public static final String DispOrder = "dispOrder";
	public static final String CategoryLevel = "categoryLevel";
	public static final String CategoryDellList = "categoryDelList";
	public static final String UpdateDate = "updateDate";

	public ArrayList<CategoryDto> categoryList;
	public String updateDate;
	public List<Integer> dellCategoryList;

	public CategoriesJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}

	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		if (json.has(CategoryList)) {
			JSONArray jarr = json.getJSONArray(CategoryList);
			
			int count = jarr.length();
			categoryList = new ArrayList<CategoryDto>();
			
			for (int i = 0; i < count; i++) {
				JSONObject category = jarr.getJSONObject(i);
				int categoryId = getInt(category, CategoryId);
				String categoryName = getString(category, CategoryName);
				short dispOrder = (short) getInt(category, DispOrder);
				int parentCategoryId = getInt(category, ParentCategoryId);
				CategoryDto dto = new CategoryDto(categoryId, categoryName, dispOrder, parentCategoryId);
				if (category.has(CategoryLevel)) {
					dto.categoryLevel = category.getInt(CategoryLevel);
				}
				categoryList.add(dto);
			}
			//ジャンルレベルでソート、階層の低いジャンルからデータベースに追加
			Collections.sort(categoryList, new CategoryLevelComparator());
		} else {
			throw new JSONValidationException(json.toString(), CategoryList + " property not found.");
		}
		//1.7.2から追加
		if (json.has(CategoryDellList)) {
			//1.7.2バーhジョンからジャンル改善仕様が追加
			dellCategoryList = new ArrayList<Integer>();
			JSONArray dellCategories = json.getJSONArray(CategoryDellList);
			int length = dellCategories.length();
			for (int i = 0; i < length; i++) {
				dellCategoryList.add(dellCategories.getInt(i));
			}
		} else {
			//ignore
		}
		if (json.has(UpdateDate)) {
			updateDate = json.getString(UpdateDate);
		} else {
			//ignore
		}
	}

	private class CategoryLevelComparator implements Comparator<CategoryDto> {
		@Override
		public int compare(CategoryDto dto1, CategoryDto dto2) {
			int category1 = dto1.categoryLevel;
			int category2 = dto2.categoryLevel;
			int result;
			if (category1 > category2) {
				result = 1;
			} else if(category1 == category2) {
				result = 0;
			} else {
				result = -1;
			}
			return result;
		}
	}
}
