package jp.agentec.abook.abv.bl.common.db;


public interface SQLiteDatabase {
	void beginTransaction();
	void endTransaction();
	void setTransactionSuccessful();
	boolean inTransaction();
	void close();
	
	Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy);
	Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit);
	Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limitone);
	
	Cursor rawQuery(String sql, String[] selectionArgs);
//	public Cursor rawQuery(String sql, String[] selectionArgs, int initialRead, int maxRead);
	
	int delete(String table, String whereClause, String[] whereArgs);
	void execSQL(String sql);
	void execSQL(String sql, Object[] bindArgs);
	boolean isOpen();
	boolean needUpgrade(int newVersion);
	SQLiteStatement compileStatement(String string);
	String getPath();
	int getVersion();
	
}
