package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.ContentOldPdfDto;

public class ContentOldPdfDao extends AbstractDao {

	/*package*/ ContentOldPdfDao() {
	}
	
	@Override
    public ContentOldPdfDto convert(Cursor cursor) {
		ContentOldPdfDto dto = new ContentOldPdfDto();

		int colnum = cursor.getColumnIndex("content_id");
		if (colnum != -1) {
			dto.contentId = cursor.getLong(colnum);
		}
		colnum = cursor.getColumnIndex("orientation");
		if (colnum != -1) {
			dto.orientation = cursor.getInt(colnum);
		}
		colnum = cursor.getColumnIndex("all_page_num");
		if (colnum != -1) {
			dto.allPageNum = cursor.getInt(colnum);
		}

		return dto;
	}

	public ContentOldPdfDto getContentOldPdf(long contentId) {
		return rawQueryGetDto("select * from t_content_old_pdf where content_id=?", new String[]{""+ contentId}, ContentOldPdfDto.class);
	}

	
	public void insertContentOldPdf(long contentId, int allPageNum, int orientation) {
		execSql("insert or replace into t_content_old_pdf (content_id, all_page_num, orientation) values (?, ?, ?)", new Object[]{contentId, allPageNum, orientation});
	}

}
