package jp.agentec.abook.abv.bl.logic;

import org.json.adf.JSONObject;

import java.io.File;
import java.io.IOException;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.ApertureMasterDataJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.GetApertureMasterDataParameters;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.adf.util.FileUtil;

public class ApertureMasterDataLogic extends AbstractLogic {
    private static final java.lang.String TAG = "RefineMasterDataLogic";
    private static final String ApertureData = "apertureData";

    /**
     * グループ情報をサーバから受信し、ローカルに保存します。既存のデータは上書きされます。
     * また、サーバにないグループがローカルにある場合、そのグループは削除されます。
     * 絞り検索マスタデータ情報をサーバから受信し、ローカルにJSONで保存する。
     * 日付を比べてサーバーからローカルのデータより最新のデータを受信した場合、受信した情報を保存する。
     * ローカルの日付はない場合、受信した情報を保存する。
     */
    public void initializeApertureMasterData() {
        try {
            //端末機の日付
            String lastFetchDateString = cache.getTempApertureMasterDataFetchDate();

            //サーバーから絞り検索マスタデータを取得
            GetApertureMasterDataParameters param = new GetApertureMasterDataParameters(cache.getMemberInfo().sid, lastFetchDateString);
            ApertureMasterDataJSON masterDataJson = AcmsClient.getInstance(cache.getUrlPath(), networkAdapter).getApertureMasterData(param);

            //サーバーデータの日付
            String lastEditDateString = masterDataJson.lastEditDate;

            //サーバから取得した情報がある場合、端末に保存
            if(lastEditDateString != null) {
                //サーバーから取得した日付をキャッシュメモリに保存
                cache.setTempApertureMasterDataFetchDate(lastEditDateString);
                if (masterDataJson.apertureData != null && masterDataJson.apertureData.keys().hasNext()) {
                    createApertureMasterDataJson(masterDataJson.apertureData);
//                updateApertureMasterDataJson(masterDataJson.apertureData);
                }
            }
        } catch (Exception e) {
            Logger.e(TAG, "apertureMasterDataSend error : ", e);
        }
    }

    /**
     * apertureMaster.jsonファイル作成
     * @param masterDataJson
     * @throws IOException
     */
    private void createApertureMasterDataJson(JSONObject masterDataJson) throws IOException {
        // マスタデータの保存されるパス
        String masterDataJsonPath = ABVEnvironment.getInstance().getApertureMasterFilePath() + File.separator + ABVEnvironment.getInstance().ApertureMasterDataFileName;
        FileUtil.createFile(masterDataJsonPath, masterDataJson.toString());
    }
}
