package jp.agentec.abook.abv.bl.logic;

import java.io.IOException;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.AcmsMessageJSON;
import jp.agentec.abook.abv.bl.acms.client.json.FixPushMessageJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.SendPushMessageParameters;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.PushMessageDao;
import jp.agentec.abook.abv.bl.dto.FixPushMessageDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;

/**
 * Created by kim jinsung on 2018/09/17.
 */

public class PushMessageLogic extends AbstractLogic {
    private static final String TAG = "OperationRelatedContentActivity";
    private PushMessageDao mPushMessageDao = AbstractDao.getDao(PushMessageDao.class);
    /**
     * プッシュメッセージの定型文取得
     * @return 定型文リスト
     * @throws IOException
     * @throws AcmsException
     */
    public List<FixPushMessageDto> getFixPushMessage() throws IOException, AcmsException, NetworkDisconnectedException {
        FixPushMessageJSON json = AcmsClient.getInstance(cache.getUrlPath(), networkAdapter).getFixPushMessage(cache.getMemberInfo().sid);
        return json.fixPushMessageDtoList;
    }

    /**
     * プッシュメッセージ送信依頼
     * @return 定型文リスト
     * @throws IOException
     * @throws AcmsException
     */
    public boolean sendPushMessageRequest(int sendType, String message, long operationId) throws IOException, AcmsException, NetworkDisconnectedException {
        SendPushMessageParameters param = new SendPushMessageParameters(cache.getMemberInfo().sid, operationId, sendType, message);
        AcmsMessageJSON json = AcmsClient.getInstance(cache.getUrlPath(), networkAdapter).sendPushMessageRequest(param);
        Logger.d(TAG, " status=" + json.httpStatus);
        if (json.httpStatus == ABookKeys.HTTP_STATUS_SUCCESS) {
            Logger.v(TAG, "sendPushMessageRequest httpStatus=" + json.httpStatus);
            return true;
        }
        return false;
    }

    public List<PushMessageDto> getAllPushMessageList() {
        return mPushMessageDao.selectAll();
    }

    public PushMessageDto getPushMessage(long pushMessageId) {
        return mPushMessageDao.select(pushMessageId);
    }

    public void updateReadingFlg(long pushMessageId) {
        mPushMessageDao.updateReadingFlg(pushMessageId);
    }
}
