package jp.agentec.abook.abv.bl.common.log;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;

import org.junit.Test;

public class LoggerTest {

	@Test
	public void testLogger2() throws FileNotFoundException {
		ABVEnvironment.getInstance().setLogLevel(LogLevel.verbose);
		Logger logger2 = (Logger) Logger.getLogger();
		logger2.setLogPathFormat("/var/log/logger_%s.txt");
		Logger.setLogger2(logger2);
		
		Logger.v("tag", "mssssg");
		System.out.println("fin");
	}

	@Test
	public void testLogger() {
		ABVEnvironment.getInstance().setLogLevel(LogLevel.verbose);
		
		Logger.v("mssssg");
		Logger.v("tag", "mssssg");
		Logger.v("tag", "mssssg %s %d %d", "a", 1, 3);
		Logger.v("tag", "mssssg", new Exception("hoge"));
		Logger.v("mssssg", new Exception("hoge"));

		try {
			Thread.sleep(10000); // この間に端末の日付を変更する
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		Logger.d("mssssg");
		Logger.d("tag", "mssssg");
		Logger.d("tag", "mssssg %s %d %d", "a", 1, 3);
		Logger.d("tag", "mssssg", new Exception("hoge"));
		Logger.d("mssssg", new Exception("hoge"));

		Logger.i("mssssg");
		Logger.i("tag", "mssssg");
		Logger.i("tag", "mssssg %s %d %d", "a", 1, 3);
		Logger.i("tag", "mssssg", new Exception("hoge"));
		Logger.i("mssssg", new Exception("hoge"));

		Logger.w("mssssg");
		Logger.w("tag", "mssssg");
		Logger.w("tag", "mssssg %s %d %d", "a", 1, 3);
		Logger.w("tag", "mssssg", new Exception("hoge"));
		Logger.w("mssssg", new Exception("hoge"));

		Logger.e("mssssg");
		Logger.e("tag", "mssssg");
		Logger.e("tag", "mssssg %s %d %d", "a", 1, 3);
		Logger.e("tag", "mssssg", new Exception("hoge"));
		Logger.e("mssssg", new Exception("hoge"));
	}

}
