package jp.agentec.abook.abv.cl.push;

import android.content.Context;

import com.google.firebase.iid.FirebaseInstanceId;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.ThreadUtil;
import jp.agentec.abook.abv.launcher.android.R;


public class FcmManager {

    /**
     * FcmTokenを返す。ただし、PushMessageの利用なしの場合は、noneIdを返す。
     * @param context Context
     * @return String
     */
    public static String getFcmToken(Context context) {
        String fcmToken;
        if (context.getResources().getInteger(R.integer.push_message) == 1) {
            fcmToken = getFcmTokenWithRetryCount(10);
        } else {
            fcmToken = "noneId";
        }
        return fcmToken;
    }

    private static String getFcmTokenWithRetryCount(int retryCount) {
        String token = FirebaseInstanceId.getInstance().getToken();
        if (token != null) {
            return token;
        }
        // Tokenの取得に失敗したため、{retryCount}回までリトライする
        int count = 0;
        while (count < retryCount && token == null) {
            ThreadUtil.sleep(1000);// 1sec
            count++;
            Logger.d("FcmManager", "[getFcmTokenWithRetry]:retry_count=" + count);
            token = FirebaseInstanceId.getInstance().getToken();

        }
        return token;
    }
}