package jp.agentec.abook.abv.cl.util;

import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.PrefName;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;

public class PreferenceUtil {
	
	// Default Preference
	
	public static String get(Context context, String key, String def) {
		return getPref(context).getString(key, def);
	}

	public static int getInt(Context context, String key, String def) {
		return Integer.parseInt(get(context, key, def));
	}
	
	public static int get(Context context, String key, int def) {
		return getPref(context).getInt(key, def);
	}
	
	public static boolean get(Context context, String key, boolean def) {
		return getPref(context).getBoolean(key, def);
	}
	
	public static boolean contains(Context context, String key) {
		return getPref(context).contains(key);
	}
	
	public static void put(Context context, String key, boolean val) {
		getEditor(context).putBoolean(key, val).commit();
	}

	public static void put(Context context, String key, int val) {
		getEditor(context).putInt(key, val).commit();
	}
	
	public static void put(Context context, String key, String val) {
		getEditor(context).putString(key, val).commit();
	}
	
	public static void clear(Context context) {
		getEditor(context).clear().commit();
	}

	public static Editor getEditor(Context context) {
		return getPref(context).edit();
	}
	
	public static SharedPreferences getPref(Context context) {
		return PreferenceManager.getDefaultSharedPreferences(context);
	}
	

	// User Preference
	
	public static SharedPreferences getUserPreference(Context context) {
		return context.getSharedPreferences(PrefName.USER_PREFERENCE, Context.MODE_PRIVATE);
	}

	public static Editor getUserEditor(Context context) {
		return getUserPreference(context).edit();
	}

	public static boolean getUserPref(Context context, String key, boolean def) {
		return getUserPreference(context).getBoolean(key, def);
	}

	public static int getUserPref(Context context, String key, int def) {
		return getUserPreference(context).getInt(key, def);
	}

	public static long getUserPref(Context context, String key, long def) {
		return getUserPreference(context).getLong(key, def);
	}

	public static String getUserPref(Context context, String key, String def) {
		return getUserPreference(context).getString(key, def);
	}

	public static float getUserPref(Context context, String key, float def) {
		return getUserPreference(context).getFloat(key, def);
	}

	public static void putUserPref(Context context, String key, boolean val) {
		Editor editor = getUserEditor(context);
		editor.putBoolean(key, val);
		editor.commit();
	}

	public static void putUserPref(Context context, String key, int val) {
		Editor editor = getUserEditor(context);
		editor.putInt(key, val);
		editor.commit();
	}

	public static void putUserPref(Context context, String key, long val) {
		Editor editor = getUserEditor(context);
		editor.putLong(key, val);
		editor.commit();
	}

	public static void putUserPref(Context context, String key, String val) {
		Editor editor = getUserEditor(context);
		editor.putString(key, val);
		editor.commit();
	}

	public static void putUserPref(Context context, String key, float val) {
		Editor editor = getUserEditor(context);
		editor.putFloat(key, val);
		editor.commit();
	}

	public static void clearUserPref(Context context) {
		getUserEditor(context).clear().commit();
	}

	public static boolean userPrefContains(Context context, String key) {
		return getUserPreference(context).contains(key);
	}

	public static void removeUserPref(Context context, String key) {
		getUserEditor(context).remove(key).commit();
	}

}
