package jp.agentec.abook.abv.ui.common.util;

import android.content.Context;
import android.os.Handler;
import android.view.Gravity;
import android.widget.Toast;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;

/**
 * 連続でトーストを表示するときなどはこのクラスからトースト受け取ってshow()すると固まりません
 * @author tauchi
 * @version 1.0.0
 */
public class ABVToastUtil {
	private static Toast sToast = null;
	
	// キーボードに重なる場合があるため、Toastメッセージは中央表示にする
	public static void showMakeText(Context context, CharSequence text, int duration) {
		showMakeText(context, text, duration, Gravity.CENTER);
	}

	public static void showMakeText(Context context, int resId, int duration) {
		showMakeText(context, context.getResources().getString(resId), duration);
	}
	
	// 基本的にはこの下のメソッドは使わないこと！
	public static void showMakeText(Context context, int resId, int duration, int gravity) {
		showMakeText(context, context.getResources().getString(resId), duration, gravity);
	}

	public static void showMakeText(final Context context, final CharSequence text, final int duration, final int gravity) {
        if (!ABVEnvironment.getInstance().enableToastMessage) {
            return;
        }

        new Handler(context.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                if (sToast != null) {
                    sToast.setText(text);
                    sToast.setDuration(duration);
                } else {
                    sToast = Toast.makeText(context.getApplicationContext(), text, duration);
                }
                sToast.setGravity(gravity, 0, 0);
                sToast.show();
            }
        });
	}
}
