package jp.agentec.abook.abv.ui.common.util;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;

import android.content.Context;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import android.widget.TextView;
public class AlertDialogUtil {

	public static ABookAlertDialog createABookAlertDialog(Context context) {
		ABookAlertDialog alertDialog = new ABookAlertDialog(context);
		alertDialog.setIcon(R.drawable.icon);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, int titleId) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(titleId);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, String title) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(title);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, int titleId, int messageId) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(titleId);
		alertDialog.setMessage(messageId);
		return alertDialog;
	}
	
	public static ABookAlertDialog createAlertDialog(Context context, String title, String message) {
		ABookAlertDialog alertDialog = createABookAlertDialog(context);
		alertDialog.setTitle(title);
		alertDialog.setMessage(message);
		return alertDialog;
	}
	
	public static ABookAlertDialog deleteContentAlertDialog(Context context, int deleteMessage) {
		ABookAlertDialog alertDialog = createAlertDialog(context, R.string.delete);
		alertDialog.setMessage(deleteMessage);
		return alertDialog;
	}
	
	public static ABookAlertDialog deleteContentAlertDialog(Context context) {
		return deleteContentAlertDialog(context, R.string.message_delete_content);
	}
	
	public static ABookAlertDialog scrollableAlertDialog(Context context, int titleId, String message) {
		ABookAlertDialog alertDialog = createAlertDialog(context, titleId);
		TextView txtMsg = new TextView(context);
		txtMsg.setText(message);
		txtMsg.setTextColor(context.getResources().getColor(R.color.text_select));
		txtMsg.setTextSize(20);
		txtMsg.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);

		int FP = ViewGroup.LayoutParams.MATCH_PARENT;
		FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(FP, FP);
		params.leftMargin = 10;
		ScrollView scrollView = new ScrollView(context);
		scrollView.addView(txtMsg, params);
		scrollView.setLayoutParams(new FrameLayout.LayoutParams(FP, FP));
		alertDialog.setView(scrollView);
		return alertDialog;
	}
}
