package jp.agentec.abook.abv.ui.home.activity;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;

import java.io.IOException;
import java.io.InputStream;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.download.ContentFileExtractor;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.FileUtil;

public class ABookSettingActivity extends PreferenceActivity {

	private static final String TAG = "ABookSettingActivity";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		if (isNormalSize()) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		}

		setContentView(R.layout.ac_setting_main);

		findViewById(R.id.app_icon).setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				backToHome();
			}
		});
		//操作説明書コピー(バージョン変更もあるので毎回コピー)
		try {
			ContentFileExtractor.getInstance().removeContentCash(0L);
			String filePath = ContentFileExtractor.getInstance().getGuidePDFFilePath(0);
			InputStream inputStream = getAssets().open(ContentFileExtractor.getInstance().GUIDE_PDF_FILE_NAME);
			FileUtil.copyGuidePDFFile(inputStream, filePath);
		} catch (IOException e) {
			Logger.e(TAG, "copyGuidePDFFile Exception = " + e);
		}
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			Logger.d(TAG, "onKeyUp.Back");
			backToHome();
		}
		return super.onKeyUp(keyCode, event);
	}

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    private void backToHome() {
		ABVUIActivity activity = ActivityHandlingHelper.getInstance().getPreviousOfSettingActivity();
		Intent intent = new Intent(this, (activity != null ? activity.getClass() : OperationListActivity.class));

		intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
		startActivity(intent);
		finish();
	}

	private boolean isNormalSize() {
		return (getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK) == Configuration.SCREENLAYOUT_SIZE_NORMAL;
	}

}
