package jp.agentec.abook.abv.ui.home.activity;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.handmark.pulltorefresh.library.PullToRefreshBase;

import net.lingala.zip4j.exception.ZipException;

import org.json.adf.JSONObject;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.OperationDataJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.GetOperationDataParameters;
import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.abook.abv.bl.acms.type.OperationType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.Constant.ReportType;
import jp.agentec.abook.abv.bl.common.Constant.TaskReportLevel;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.exception.ABVExceptionCode;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.OperationContentDao;
import jp.agentec.abook.abv.bl.data.dao.OperationDao;
import jp.agentec.abook.abv.bl.data.dao.TaskDao;
import jp.agentec.abook.abv.bl.data.dao.TaskReportDao;
import jp.agentec.abook.abv.bl.download.ContentFileExtractor;
import jp.agentec.abook.abv.bl.download.ContentZipDownloadNotification;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.OperationContentDto;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterDto;
import jp.agentec.abook.abv.bl.dto.TaskDto;
import jp.agentec.abook.abv.bl.dto.TaskReportDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationGroupMasterLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.OperationLocationType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.ViewMode;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.common.view.ABVBatchSyncView;
import jp.agentec.abook.abv.ui.common.view.ABVListDialog;
import jp.agentec.abook.abv.ui.common.view.ABVPopupListWindow;
import jp.agentec.abook.abv.ui.home.adapter.HierarchyOperationGroupListAdapter;
import jp.agentec.abook.abv.ui.home.helper.ABookCheckWebViewHelper;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.home.helper.HomeOperationListHelper;
import jp.agentec.abook.abv.ui.home.helper.OperationGroupMasterListHelper;
import jp.agentec.abook.abv.ui.home.helper.OperationListHelper;
import jp.agentec.abook.abv.ui.viewer.activity.HTMLXWalkWebViewActivity;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;


/**
 * Created by leej on 2018/08/17
 */

public class OperationListActivity extends ABVUIActivity {
    private static final String TAG = "OperationListActivity";

    private ImageButton mViewModeButton;                          // パンネル・リスト表示ボタン
    private ImageButton mSearchButton;                             // 検索ボタン
    private ImageButton mCommonContentButton;                    // 共通資料ボタン
    private ImageButton mOperationBatchSyncButton;              // カテゴリの一括同期ボタン
    private ImageButton mCategoryLocationButton;                 // カテゴリ選択ボタン

    private TextView mOperationTitle;                             // 一覧のタイトル


    // 検索画面の条件（文字列）
    public String mSearchWord;                                      // 検索画面の値（作業名）
    public String mStartDateStr;                                    // 検索画面の値（作業開始日）
    public String mEndDateStr;                                      // 検索画面の値（作業終了日）

    private EditText mSearchTextView;                              // 検索画面の作業名
    private TextView mStartDate;                                    // 検索画面の作業開始日
    private TextView mEndDate;                                      // 検索画面の作業終了日

    private Dialog mSearchDialog;
    private Date mOperationLastEditDate;

    private Dialog mPanoEntryDialog;

    private OperationDao mOperationDao = AbstractDao.getDao(OperationDao.class);
    private OperationContentDao mOperationContentDao = AbstractDao.getDao(OperationContentDao.class);

    private TaskReportDao mTaskReportDao = AbstractDao.getDao(TaskReportDao.class);
    private OperationLogic mOperationLogic = AbstractLogic.getLogic(OperationLogic.class);
    private OperationGroupMasterLogic mOperationGroupMasterLogic = AbstractLogic.getLogic(OperationGroupMasterLogic.class);
    private TaskDao mTaskDao = AbstractDao.getDao(TaskDao.class);

    private ImageView mPanoCotnentImageView;
    private TextView  mPanoContentNameTextView;
    private Uri mSelectPanoContentUri;

    private final static int ABOOK_CHECK_OPERATION_PANO_CONTENT_IMAGE = 201;
    private File mLocalFile;
    private boolean activityResultFlg;

    private OperationListHelper mListHelper = null;

    private ABVListDialog mShowDialog;

    private Map<Integer, Integer> operationCountMap;
    // 全て・作業種別のセグメントボタン
    private RadioGroup mLocationTypeRadioGroup;

    // 作業種別のサービスオプション値を保持用フラグ
    private boolean mOperationGroupMasterServiceOperationFlg;

    // ビューの作成
    private class ReloadHandler implements Runnable {
        @Override
        public void run() {
            View child = mListHelper.getOperationView();
            ViewGroup parent = (ViewGroup) child.getParent();
            if (parent != null) {
                parent.removeView(child);
            }
            FrameLayout vg = (FrameLayout) findViewById(R.id.operation_list_layout);
            vg.removeAllViews();
            vg.addView(child);
            // ツールバーのビューモードイメージ変更
            if (getABVUIDataCache().getViewMode() == AppDefType.ViewMode.PANEL) {
                mViewModeButton.setImageResource(R.drawable.ic_display_list);
            } else {
                mViewModeButton.setImageResource(R.drawable.ic_display_pannel);
            }
            closeProgressPopup();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.ac_operation_list);
        mListHelper = getListHelper();
        // ビュー変更ボタン
        mViewModeButton = (ImageButton) findViewById(R.id.btn_view_mode);
        // 検索ボタン
        mSearchButton = (ImageButton) findViewById(R.id.btn_search);
        // ツールバーのタイトル表示
        mOperationTitle = (TextView) findViewById(R.id.operation_title);
        mOperationBatchSyncButton = (ImageButton) findViewById(R.id.btn_batch_sync);

        communicationButton = (ImageButton) findViewById(R.id.btn_communication_menu);
        mCommonContentButton = (ImageButton) findViewById(R.id.btn_common_content);
        mCategoryLocationButton = (ImageButton) findViewById(R.id.btn_category_location);

        // 定期点検で同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合、needSyncFlgをtrueに更新
        updateNeedSyncRoutineOperation();

        // 非活性化する（ホーム画面ではホームボタンが必要ないため）
        ImageButton operationHomeButton = (ImageButton) findViewById(R.id.btn_operation_home);
        operationHomeButton.setEnabled(false);

        // ビュー変更ボタンのタッチイベント
        mViewModeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (getABVUIDataCache().getViewMode() == ViewMode.PANEL) {
                    getABVUIDataCache().setViewMode(ViewMode.LIST);
                } else {
                    getABVUIDataCache().setViewMode(ViewMode.PANEL);
                }
                setOperationListView();
            }
        });

        // サービスオプション(作業種別使用)をセット
        mOperationGroupMasterServiceOperationFlg = ABVDataCache.getInstance().serviceOption.isOperationGroupMaster();

        // 検索アイコンのクリックイベント
        mSearchButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showSearchDialog();
            }
        });

        // コミュニケーションボタン
        communicationButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showCommunicationMenuDialog();
            }
        });

        // 共通関連資料ボタン
        mCommonContentButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showCommonContent();
            }
        });

        // 一括同期ボタン
        mOperationBatchSyncButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // ネットワーク通信チェック
                if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
                    showSimpleAlertDialog(getString(R.string.app_name), getString(R.string.request_network_connection));
                    return;
                }

                // 新着更新チェック
                if (contentRefresher.isRefreshing()) {
                    showSimpleAlertDialog(getString(R.string.app_name), getString(R.string.msg_batch_sync_new_content_updating));
                    return;
                }

                // 会議室接続中
                if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
                    ABVToastUtil.showMakeText(OperationListActivity.this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
                    return;
                }
                showBatchSyncDialog();
            }
        });


        if (!StringUtil.isNullOrEmpty(getIntent().getStringExtra(AppDefType.PushMessageKey.operationId))) {
            final long operationId = Long.parseLong(getIntent().getStringExtra(AppDefType.PushMessageKey.operationId));
            String message = getIntent().getStringExtra(AppDefType.PushMessageKey.message);
            if (operationId > 0) {
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(this, getRString(R.string.app_name), message);
                // リソースパターンの適用
                alertDialog.setPositiveButton(PatternStringUtil.patternToInt(getApplicationContext(), R.string.work_report, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                        new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (contentRefresher.isRefreshing()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(OperationListActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                    R.string.msg_routineTask_report_disable_refreshing,
                                                                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else if(ActivityHandlingHelper.getInstance().isMeetingConnected()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(OperationListActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                    R.string.msg_routineTask_report_disable_meeting_room,
                                                                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else if (isShowingBatchSync()) {
                            // 一括同期中は移動しない
                            ErrorMessage.showErrorMessageToast(OperationListActivity.this, getString(R.string.msg_batch_sync_move_operation_view));
                        } else {
                            OperationDto operationDto = mOperationLogic.getOperation(operationId);

                            if (operationDto == null) {
                                // リソースパターンの適用
                                ErrorMessage.showErrorMessageToast(OperationListActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                        R.string.msg_routineTask_report_disable_no_operation,
                                                                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                            } else  if (operationDto.needSyncFlg) {
                                // リソースパターンの適用
                                ErrorMessage.showErrorMessageToast(OperationListActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                        R.string.msg_routineTask_report_disable_not_updated,
                                                                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                            } else {
                                startTaskDirectionOrReportView(operationDto);
                            }
                        }

                        dialog.dismiss();
                    }
                });

                alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.dismiss();
                    }
                });

                alertDialog.show();
            }
        }
        // リスト更新
        setOperationListView();
    }

    // 共通資料画面表示
    private void showCommonContent() {
        Intent intent = new Intent();
        intent.setClass(OperationListActivity.this, OperationRelatedContentActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent, NaviConsts.Right);
    }

    // ツールバーの設定
    private void configurationToolbarIcon() {

        // バッチを付けるか判定して、イメージを設定
        setCommunicationImageButton();

        // 作業種別表示・非表示
        if (mOperationGroupMasterServiceOperationFlg) {
            mCategoryLocationButton.setVisibility(View.VISIBLE);

            // アイコンの変更
            if (getABVUIDataCache().getOperationGroupMasterMode() == OperationLocationType.CATEGORY) {
                setCategoryImage(true);
                mOperationTitle.setText(R.string.title_category);
                // 検索ワード削除
                clearSearch();
                // 検索ボタンを無効にする
                mSearchButton.setEnabled(false);
                // 一括同期ボタン表示
                mOperationBatchSyncButton.setVisibility(View.VISIBLE);
            } else {
                // 全て
                // 検索ボタンを活性化
                mSearchButton.setEnabled(true);
                setCategoryImage(false);
                // 一括同期ボタン非表示
                mOperationBatchSyncButton.setVisibility(View.GONE);
                mOperationTitle.setText(R.string.title_all_operation);
            }
        } else {
            mOperationTitle.setText(R.string.title_all_operation);
            // アイコン非表示
            setCategoryImage(false);
            mCategoryLocationButton.setVisibility(View.GONE);
            // 一括同期ボタンを非表示
            mOperationBatchSyncButton.setVisibility(View.GONE);
            // 検索ボタンを活性化
            mSearchButton.setEnabled(true);
        }

        // 検索済みの場合、タイトルを「検索結果」にする
        if (isSearched()) {
            mOperationTitle.setText(R.string.search_result);
        }
    }

    // 検索ワードのクリア
    private void clearSearch() {
        mSearchWord = null;
        mStartDateStr = null;
        mEndDateStr = null;
        clearData();
    }

    // 検索済みかどうかチェック
    private boolean isSearched() {
        return !(StringUtil.isNullOrEmpty(mSearchWord) && StringUtil.isNullOrEmpty(mStartDateStr) && StringUtil.isNullOrEmpty(mEndDateStr));
    }

    // カテゴリのアイコンイメージ設定
    private void setCategoryImage(boolean isCategory) {
        mCategoryLocationButton.setImageResource(isCategory ? R.drawable.ic_category_on : R.drawable.ic_category_off);
    }

    /**
     * ビューを作り直す。
     */
    public void setOperationListView() {
        mListHelper = getListHelper();
        handler.post(new ReloadHandler());
        configurationToolbarIcon();
    }

    // ビューを作り直さずにリストだけ更新する
    public void refreshOperationList() {
        mListHelper.refreshList();
        configurationToolbarIcon();
    }

    @Override
    public void onRefreshedContent(final boolean result, long contentId, Exception e) {
        super.onRefreshedContent(result, contentId, e);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!contentRefresher.isRefreshing()) {
                    // 新着処理が終わったら以下の処理が実行
                    stopUpdateAnimation();
                    // 新着更新時間の更新
                    getABVUIDataCache().saveLastUpdateTime();
                    // リソースパターンを取得し、ローカルに保存する。
                    setResourcePattern();
                    // マスタデータ最新更新する時fetchDateをローカルに保存する。
                    setMasterDataFetchDate();
                    // 絞り検索マスタデータ最新更新する時fetchDateをローカルに保存する。
                    setApertureMasterDataFetchDate();
                    
                    if (mOperationGroupMasterServiceOperationFlg == ABVDataCache.getInstance().serviceOption.isOperationGroupMaster()) {
                        // サービスオプションが変わってない場合は、ビューは作らずにデータのみ更新
                        refreshOperationList();
                    } else {
                        // 初期化
                        getABVUIDataCache().clearOperationGroupMaster();
                        mOperationGroupMasterServiceOperationFlg = ABVDataCache.getInstance().serviceOption.isOperationGroupMaster();
                        // 作業種別の選択画面を閉じる
                        closeOperationGroupMasterDialog();

                        // ビューを作り直す
                        setOperationListView();
                    }
                }
            }
        });
    }

    // 回転時、画面リロード
   @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        // 画面リロード
        setOperationListView();
    }

    @Override
    public void onResume() {
        Logger.i(TAG, "onResume:start");
        super.onResume();
        if (isShowingBatchSync()) {
            // 一括同期中の場合何もしない
            return;
        }
        refreshOperationList();
        // 報告画面から作業一覧へ戻った時の同期処理
        final long operationId = getUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, -1L);
        if (operationId != -1) {
            final OperationDto operationDto = mOperationLogic.getOperation(operationId);
            // リソースパターンの適用
            showProgressView(PatternStringUtil.patternToString(getApplicationContext(),
                                R.string.synchronizing,
                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
            CommonExecutor.execute(new Runnable() {
                @Override
                public void run() {
                    Logger.d(TAG, "onResume Sync operationId : " + operationId);
                    if (operationDto != null && operationDto.needSyncFlg) {
                        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
                            closeProgressPopup();
                            ABVToastUtil.showMakeText(OperationListActivity.this, R.string.msg_network_offline, Toast.LENGTH_SHORT);
                            return;
                        }
                        // 同期処理後、直列処理で新着更新を行う。
                        singleSyncOperation(operationId, operationDto.reportType);
                    } else {
                        closeProgressPopup();
                    }
                    dataRefresh(true);
                }
            });
        }

        if (!activityResultFlg && operationId == -1) {
            dataRefresh(true);
        }
        putUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, -1L);
        activityResultFlg = false;

        configurationToolbarIcon();
    }

    // 検索ダイアログ表示
    private void showSearchDialog() {
        contentRefresher.stopRefresh();
        if (mSearchDialog == null) {
            mSearchDialog = new Dialog(this);
            mSearchDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            mSearchDialog.setCanceledOnTouchOutside(false);
            mSearchDialog.setContentView(R.layout.operation_search_dialog);
        }

        mStartDate = (TextView) mSearchDialog.findViewById(R.id.start_date);

        mEndDate = (TextView) mSearchDialog.findViewById(R.id.end_date);

        // 検索ダイアログ画面の作業名要素
        mSearchTextView = (EditText) mSearchDialog.findViewById(R.id.operation_name);
        mSearchTextView.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN && keyCode == KeyEvent.KEYCODE_ENTER) {
                    //キーボードのエンターキーを無効にする
                    return true;
                }
                return false;
            }
        });

        mStartDate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showDatePicker(mStartDate);
            }
        });

        mEndDate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showDatePicker(mEndDate);
            }
        });

        // クリアボタン
        mSearchDialog.findViewById(R.id.btn_clear).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // 初期化
                clearData();
            }
        });

        // 検索ボタン
        mSearchDialog.findViewById(R.id.btn_search).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                mSearchWord = StringUtil.toString(mSearchTextView.getText());
                mStartDateStr = StringUtil.toString(mStartDate.getText());
                mEndDateStr = StringUtil.toString(mEndDate.getText());

                refreshOperationList();
                mSearchDialog.dismiss();

                // 検索条件に条件がある場合のみ、件数のトーストメッセージは表示する
                if (isSearched()) {
                    // リソースパターンの適用
                    ABVToastUtil.showMakeText(OperationListActivity.this, String.format(PatternStringUtil.patternToString(getApplicationContext(),
                            R.string.operation_search_count,
                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), mListHelper.getOperationCount() + ""), Toast.LENGTH_SHORT);
                }
            }
        });

        // 閉じるボタン
        mSearchDialog.findViewById(R.id.closeBtn).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                mSearchDialog.dismiss();
            }
        });
        if (mSearchDialog != null) {
            mSearchDialog.show();
        }
    }

    private void showDatePicker(final TextView text) {
        String textViewStr = text.getText().toString();
        Calendar calendar = Calendar.getInstance();
        if (!textViewStr.isEmpty()) {
            calendar.setTime(DateTimeUtil.toDate(textViewStr, DateTimeFormat.yyyyMMdd_slash));
        }
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        int day = calendar.get(Calendar.DAY_OF_MONTH);

        //TODO layout変更 => DatePickerDialog.Theme_Holo_Light
        final DatePickerDialog dpd = new DatePickerDialog(this, android.R.style.Theme_Holo_Light_Dialog, new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                String date = String.format("%4d/%02d/%02d", year, monthOfYear + 1, dayOfMonth);
                if (dateValidation(text, date)) {
                    text.setText(date);
                }
            }

        }, year, month, day);
        dpd.setButton(DialogInterface.BUTTON_POSITIVE, getString(R.string.complete), dpd);
        dpd.setButton(DialogInterface.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), dpd);
        dpd.setButton(DialogInterface.BUTTON_NEUTRAL, getString(R.string.clear), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int whichButton) {
                text.setText(StringUtil.Empty);
            }
        });
        dpd.setCanceledOnTouchOutside(false);
        dpd.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dpd.show();
    }

    private void clearData() {
        // 開始日の初期化
        if (mStartDate != null) {
            mStartDate.setText(StringUtil.Empty);
        }

        // 終了日の初期化
        if (mEndDate != null) {
            mEndDate.setText(StringUtil.Empty);
        }

        // 作業名の初期化
        if (mSearchTextView != null) {
            mSearchTextView.setText(StringUtil.Empty);
        }
    }

    // 開始日と終了日のバリデーション
    private boolean dateValidation(TextView textView, String targetDateStr) {
        boolean result = true;
        Date startDate = null;
        Date endDate = null;
        if (textView.equals(mStartDate)) {
            // 選択したTextViewを開始日と見做す
            if (!StringUtil.isNullOrEmpty(mEndDate.getText().toString())) {
                startDate = DateTimeUtil.toDate(targetDateStr, "UTC", DateTimeFormat.yyyyMMdd_hyphen);
                endDate = DateTimeUtil.toDate(mEndDate.getText().toString(), "UTC", DateTimeFormat.yyyyMMdd_hyphen);
            }
        } else {
            // 選択したTextViewが終了日と見做す
            if (!StringUtil.isNullOrEmpty(mStartDate.getText().toString())) {
                startDate = DateTimeUtil.toDate(mStartDate.getText().toString(), "UTC", DateTimeFormat.yyyyMMdd_hyphen);
                endDate = DateTimeUtil.toDate(targetDateStr, "UTC", DateTimeFormat.yyyyMMdd_hyphen);
            }
        }
        if (startDate != null && endDate != null) {
            if (startDate.after(endDate)) {
                // リソースパターンの適用
                ABVToastUtil.showMakeText(OperationListActivity.this, PatternStringUtil.patternToString(getApplicationContext(),
                                                                                R.string.msg_date_validation,
                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
                result = false;
            }
        }
        return result;
    }

    public void startTaskDirectionOrReportView(OperationDto operationDto) {
        ContentDto contentDto = contentDao.getContent(operationDto.contentId);
        try {
            if (contentDto != null && contentDto.downloadedFlg) {
                String contentPath;
                if (operationDto.operationType == OperationType.LIST) {
                    contentPath = ABVEnvironment.getInstance().getTaskListDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                } else if (operationDto.operationType == OperationType.PDF) {
                    contentPath = ABVEnvironment.getInstance().getTaskPdfDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                } else {
                    contentPath = ABVEnvironment.getInstance().getPanoImageDirName(ContentFileExtractor.getInstance().getContentCacheDirWithExtract(operationDto.contentId));
                }

                // 作業の報告画面を表示時、必要なJSONファイル作成
                mOperationLogic.createJsonForOpenABookCheckPano(operationDto.operationId, operationDto.contentId, contentPath);
                mOperationLogic.createJsonForOperationContent(operationDto.operationId, contentPath, operationDto.reportType == ReportType.RoutineTask);

                // 作業閲覧日付の更新
                mOperationDao.updateReadingDate(operationDto.operationId);

                // サーバ作業後、対応必要
                StringBuffer path = new StringBuffer();
                path.append(contentPath);
                // #32926 作業報告画面改善 start
                path.append("/index.html?app=android");
                path.append("&report_type=" + operationDto.reportType);  // 作業報告タイプ : 0:報告 1:定期点検 2:報告(回答)
                path.append("&mobile_flg=" + (isNormalSize() ? "1" : "0"));  // ScreenType

                Logger.d(TAG, "path : " + path);
                // #32926 作業報告画面改善 end
                Intent intent = new Intent();
                intent.putExtra(ABookKeys.CONTENT_ID, operationDto.contentId);
                intent.putExtra(ABookKeys.OPERATION_ID, operationDto.operationId);
                intent.putExtra(Constant.ABookCheck.XWALK_OPEN_TYPE, Constant.XWalkOpenType.TASK_REPORT);
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);

                if(operationDto.operationType == OperationType.PDF) {
                    intent.putExtra("LINKURL", "file://" + path);
                    ActivityHandlingHelper.getInstance().checkContentActivity(operationDto.contentId, 0, intent);
				} else {
					intent.setClass(this, HTMLXWalkWebViewActivity.class);
					ActivityHandlingHelper.getInstance().startHTMLXWalkWebActivity(this, intent, "file://" + path, operationDto.contentId, -1, -1, -1, -1, -1);
				}
            } else {
                Logger.w(TAG, "content is not download");
            }
        } catch (Exception e) {
            Logger.e(TAG, e);
            handleErrorMessageToast(ErrorCode.E107);
        }
    }

    @Override
    public void onDownloadingContentZip(final ContentZipDownloadNotification notification) {
        Logger.d(TAG, "[onDownloadingContentZip]");
        String errorCodeStr = "";
        if (isShowingBatchSync()) {
            if (notification.getError() != null) {
                Exception e = notification.getError();
                Logger.e(TAG, e);
                if (e instanceof AcmsException && ((AcmsException)e).getCode() != null) {
                    errorCodeStr = Integer.toString(((AcmsException)e).getHttpStatus());
                }
            }
        } else {
            // 一括同期以外は親Activityに通知する
            super.onDownloadingContentZip(notification);
        }
        OperationContentDto operationContentDto = mOperationContentDao.getOperationContentForContentId(notification.getContentId());
        if (operationContentDto != null) {
            if (notification.downloadStatus == DownloadStatusType.Succeeded) {
                if (isShowingBatchSync()) {
                    // 一括同期からの同期処理
                    Logger.d(TAG, "[onDownloadingContentZip] batchOperationSync start");
                    batchSyncView.batchOperationSync();
                } else {
                    OperationDto operationDto = mOperationLogic.getOperation(operationContentDto.operationId);
                    singleSyncOperation(operationContentDto.operationId, operationDto.reportType, true);
                }
            } else if (notification.downloadStatus == DownloadStatusType.Failed || notification.downloadStatus == DownloadStatusType.Canceled || notification.downloadStatus == DownloadStatusType.Paused) {
                Logger.d(TAG, "syncOperation update is failed downloadStatus : " + notification.downloadStatus);
                if (isShowingBatchSync()) {
                    // 一括同期からのダウンロード失敗時、エラーメッセージ表示
                    OperationDto operationDto = mOperationLogic.getOperation(operationContentDto.operationId);
                    batchSyncView.showBatchSyncErrorAlert(operationDto, getString(R.string.msg_batch_sync_content_download_fail) + (StringUtil.isNullOrEmpty(errorCodeStr) ? "" : "(" + errorCodeStr + ")"));
                }
                closeProgressPopup();
            }
        }
    }

    // 作業の自動同期処理(onresumeで呼ばれる同期処理)
    public void singleSyncOperation(final long operationId, int operationReportType) {
        singleSyncOperation(operationId, operationReportType, false);
    }

    /**
     * 作業同期処理(単一)
     * @param operationId
     * @param operationReportType
     */
    public void singleSyncOperation(final long operationId, int operationReportType, boolean buttonEventFlg) {
        String errorMessage = syncOperation(operationId, operationReportType, buttonEventFlg);
        if (errorMessage != null) {
            closeProgressPopup();
            // エラーメッセージ表示
            showSimpleAlertDialog(getString(R.string.app_name), errorMessage);
        }
    }

    /**
     * 作業同期処理
     * @param operationId
     * @param reportType
     * @param buttonEventFlag
     * @return result errorMessage
     */
    public String syncOperation(final long operationId, int reportType, boolean buttonEventFlag) {
        final StringBuilder errorMsg = new StringBuilder();
        Logger.i(TAG, "---sync start");

        try {
            //コンテンツダウンロード関連プログレスバー値設定
            progressDialogHorizontal.setProgress(20);
            final Callback progressCallback = new Callback() {
                @Override
                public Object callback(Object ret) {
                    final int progress = (int)ret;
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            progressDialogHorizontal.setProgress(progressDialogHorizontal.getProgress() + progress);
                        }
                    });
                    return null;
                }
            };

            // 報告送信
            mOperationLogic.sendTaskReportSendData(operationId, progressCallback);

            progressDialogHorizontal.setProgress(60);
            // 報告受信
            mOperationLastEditDate = receptionTaskData(operationId, progressCallback, errorMsg);
            // mOperationLastEditDateがnullの場合、エラーと見做す
            if (mOperationLastEditDate != null && reportType == ReportType.RoutineTask) {
                if (buttonEventFlag) {
                    String dialogMsg = null;
                    // 定期点検の利用可能日付を取得
                    String avilableDateStr = mOperationLogic.getRoutineTaskOperationAvailableDateStr(operationId);
                    if (!StringUtil.isNullOrEmpty(avilableDateStr)) {
                        // 利用可能メッセージ
                        // リソースパターンの適用
                        dialogMsg = String.format(PatternStringUtil.patternToString(getApplicationContext(),
                                                    R.string.msg_routineTask_report_available_from,
                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), avilableDateStr);
                    } else if (!mTaskReportDao.existsToDoRoutineTaskReportData(operationId)) {
                        // 作業データが存在しないメッセージ
                        dialogMsg = PatternStringUtil.patternToString(getApplicationContext(),
                                        R.string.msg_no_report_data,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                    }
                    if (!StringUtil.isNullOrEmpty(dialogMsg)) {
                        errorMsg.append(dialogMsg);
                    }
                }
                putUserPref(String.format(AppDefType.UserPrefKey.SYNCED_OPERATION_ID, operationId), DateTimeUtil.toString(DateTimeUtil.getCurrentSqlDate(), DateTimeFormat.yyyyMMdd_none));
            }
        } catch (AcmsException e) {
            //noinspection EnumSwitchStatementWhichMissesCases
            switch (e.getCode()) {
                case P_E_ACMS_P003:
                    // リソースパターンを適用
                    errorMsg.append(getString(PatternStringUtil.patternToInt(getApplicationContext(), R.string.P003, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))));
                    break;
                case P_E_ACMS_P004:
                    errorMsg.append(getString(PatternStringUtil.patternToInt(getApplicationContext(), R.string.P004, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))));
                    break;
                case P_E_ACMS_P005:
                    errorMsg.append(getString(PatternStringUtil.patternToInt(getApplicationContext(), R.string.P005, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))));
                    break;
                case P_E_ACMS_P006:
                    errorMsg.append(getString(PatternStringUtil.patternToInt(getApplicationContext(), R.string.P006, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))));
                    break;
                default:
                    Logger.e(TAG, "syncOperation", e);
                    errorMsg.append(ErrorMessage.getErrorMessage(this, ErrorMessage.getErrorCode(e)));
                    break;
            }
        } catch (Exception e) {
            Logger.e(TAG, e);
            errorMsg.append(ErrorMessage.getErrorMessage(this, ABVExceptionCode.C_E_SYSTEM_0001));
        } finally {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    if (mOperationLastEditDate != null) {
                        mOperationLogic.finishedSyncOperation(operationId, mOperationLastEditDate);
                        progressDialogHorizontal.setProgress(100);
                    }
                    mOperationLastEditDate = null;
                    refreshOperationList();
                    closeProgressPopup();
                }
            });
            Logger.i(TAG, "---sync end");
        }
        return errorMsg.length() > 0 ? errorMsg.toString() : null;
    }

    // 設定画面へ遷移
    public void onClickSetting(View v) {
        showSetting();
    }

    /**
     * 360編集画面表示
     *
     * @param operationDto
     */
    public void startPanoEdit(OperationDto operationDto) {
        // 会議室接続中
        if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
            ABVToastUtil.showMakeText(this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
            return;
        }
        if (operationDto.contentId != null && operationDto.contentId != 0) {
            showProgressPopup();
            try {
                String baseUrl = ABVEnvironment.getInstance().acmsAddress + ABVDataCache.getInstance().getUrlPath() + "/shop/login/authByCheck/%s/%s";
                String url = String.format(baseUrl, ABVDataCache.getInstance().getMemberInfo().sid, operationDto.contentId);
                Intent intent = new Intent();
                intent.putExtra(ABookKeys.CONTENT_ID, operationDto.contentId);
                intent.putExtra(ABookKeys.OPERATION_ID, operationDto.operationId);
                intent.putExtra(Constant.ABookCheck.XWALK_OPEN_TYPE, Constant.XWalkOpenType.PANO_EDIT);
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.setClass(OperationListActivity.this, HTMLXWalkWebViewActivity.class);
                ActivityHandlingHelper.getInstance().startHTMLXWalkWebActivity(OperationListActivity.this, intent, url, operationDto.contentId, -1, -1, -1, -1, -1);
            } catch (Exception e) {
                Logger.e(TAG, e);
                ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
            } finally {
                closeProgressPopup();
            }
        }
    }

    /**
     * 作業データ受信
     * @param operationId
     * @param progressCallback
     * @return
     * @throws NetworkDisconnectedException
     * @throws ABVException
     * @throws IOException
     * @throws InterruptedException
     * @throws NoSuchAlgorithmException
     * @throws ZipException
     */
    public Date receptionTaskData(long operationId, Callback progressCallback, StringBuilder errorMsg) throws NetworkDisconnectedException, ABVException, IOException, InterruptedException, NoSuchAlgorithmException, ZipException {
        GetOperationDataParameters param = new GetOperationDataParameters(ABVDataCache.getInstance().getMemberInfo().sid, operationId);
        OperationDto operationDto = mOperationLogic.getOperation(operationId);
        OperationContentDto operationContentDto = mOperationContentDao.getOperationMainContent(operationId);
        List<TaskDto> localTaskList = mTaskDao.selectAllTaskByOperationId(operationId);

        Date lastEditDate;

        OperationDataJSON json = AcmsClient.getInstance(ABVDataCache.getInstance().getUrlPath(), ABVEnvironment.getInstance().networkAdapter).getOpereationData(param);

        //プログレスを40%進行させるための計算
        int progress = 0;
        if (json.taskDtoList.size() != 0) {
            progress = 40 / json.taskDtoList.size();
        }

        boolean isRoutineTask = operationDto.reportType == ReportType.RoutineTask;


        for (TaskDto serverTaskDto : json.taskDtoList) {

            List<TaskReportDto> localTaskReportList = mTaskReportDao.getTaskReportListByTaskKey(serverTaskDto.taskKey);
            for (TaskReportDto localTaskReportDto : localTaskReportList) {
                if (!isExistsTaskReportInList(serverTaskDto.taskReportDtoList, localTaskReportDto, isRoutineTask)) {
                    if (isRoutineTask) {
                        mOperationLogic.deleteRoutineTaskReport(operationId, operationContentDto.contentId, localTaskReportDto);
                    } else {
                        // taskDtoが存在するとtaskReportLevel 0 (作業報告)が存在しないことはないので、報告（回答）のみチェックして削除
                        if (localTaskReportDto.taskReportLevel != TaskReportLevel.ReportType) {
                            // 作業報告のディレクトリ削除
                            mOperationLogic.deleteTaskFileData(operationId, operationContentDto.contentId, serverTaskDto.taskKey, localTaskReportDto.taskReportLevel);
                            mTaskReportDao.delete(localTaskReportDto);
                        }
                    }
                }
            }

            if (isExistsTaskInList(localTaskList, serverTaskDto)) {
                // 作業の報告更新
                mTaskDao.update(serverTaskDto);
                localTaskList.remove(serverTaskDto);
            } else {
                // 作業の報告登録
                mTaskDao.insert(serverTaskDto);
            }

            // サーバーからの情報で更新
            for (TaskReportDto serverTaskReportDto : serverTaskDto.taskReportDtoList) {
                String attachedFileName = serverTaskReportDto.attachedFileName;
                TaskReportDto localTaskReportDto;
                if (operationDto.reportType == ReportType.RoutineTask) {
                    localTaskReportDto = mTaskReportDao.getRoutineTaskReportUtc(serverTaskReportDto.taskKey, serverTaskReportDto.taskReportId, DateTimeUtil.toString(serverTaskReportDto.reportStartDate, DateTimeFormat.yyyyMMddHHmmss_hyphen));
                } else {
                    localTaskReportDto = mTaskReportDao.selectByTaskKey(serverTaskReportDto.taskKey, serverTaskReportDto.taskReportLevel);
                }
                if (localTaskReportDto != null && localTaskReportDto.localSavedFlg) {
                    // 一時保存フラグがtrueで定期点検且つ点検後修正不可の場合、添付ファイル（作業報告のディレクトリ）を削除して、localSavedFlgをfalseに変更
                    if (operationDto.reportType == ReportType.RoutineTask && operationDto.enableReportUpdate == Constant.EnableReportUpdate.NO) {
                        // 作業報告のディレクトリ削除
                        FileUtil.delete(ABVEnvironment.getInstance().getTempTaskDirPath(operationContentDto.contentId, localTaskReportDto.taskKey));
                        FileUtil.delete(ABVEnvironment.getInstance().getRoutineTaskReportDirFilePath(operationId, localTaskReportDto.taskKey, localTaskReportDto.taskReportId, DateTimeUtil.toString_yyyyMMddHHmmss_none(localTaskReportDto.reportStartDate)));
                        localTaskReportDto.localSavedFlg = false;
                    } else {
                        // 一時保存フラグがtureだと何もしない
                        continue;
                    }
                }

                if (operationDto.reportType == ReportType.RoutineTask) {
                        serverTaskReportDto.taskKey = serverTaskDto.taskKey;

                        // 添付ファイルが存在する場合、取得して解凍する。
                        try {
                            refreshRoutineTaskFile(operationId, operationContentDto.contentId, serverTaskDto.taskId, serverTaskDto.taskKey, serverTaskReportDto.taskReportId, serverTaskReportDto.taskReportInfoId, serverTaskReportDto.reportStartDate, attachedFileName);
                        } catch (Exception e) {
                            Logger.e(TAG, e);
                            // リソースパターンの適用
                            errorMsg.append(getString(PatternStringUtil.patternToInt(getApplicationContext(), R.string.msg_error_task_report_receiving_failed, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))));
                            return null;
                        }
                        if (localTaskReportDto != null) {
                            // 報告データが存在すると作業報告を更新する
                            mOperationLogic.updateRoutineTaskReport(serverTaskDto.operationId, operationContentDto.contentId, serverTaskReportDto, false,  false, localTaskReportDto.localSavedFlg);
                        } else {
                            mOperationLogic.insertRoutineTaskReport(serverTaskDto.operationId, operationContentDto.contentId, serverTaskReportDto, false, false);
                        }
                    } else {
                        JSONObject taskReportJson = null;
                        // 添付ファイルが存在する場合、取得して解凍する。
                        try {
                            refreshTaskFile(operationId, serverTaskReportDto.taskReportLevel, operationContentDto.contentId, serverTaskDto.taskId, serverTaskDto.taskKey, serverTaskReportDto.attachedFileName);
                        } catch (Exception e) {
                            Logger.e(TAG, e);
                            // リソースパターンの適用
                            errorMsg.append(getString(PatternStringUtil.patternToInt(getApplicationContext(), R.string.msg_error_task_report_receiving_failed, getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0))));
                            return null;
                        }
                        if (!serverTaskReportDto.jsonData.isEmpty()) {
                            taskReportJson = new JSONObject(serverTaskReportDto.jsonData);
                            if (serverTaskReportDto.taskReportLevel == TaskReportLevel.ReportType) {
                                taskReportJson.put(ABookKeys.TASK_STATUS, serverTaskDto.taskStatus);
                            }
                        }
                        if (localTaskReportDto == null) {
                            // 登録
                            mOperationLogic.insertTaskReport(serverTaskDto.taskKey, operationId, operationContentDto.contentId,
                                    serverTaskReportDto.taskReportLevel, serverTaskReportDto.enableReport,
                                    taskReportJson, attachedFileName, false, false, false);
                        } else {
                            // 更新
                            // jsonDataが空で入る場合、taskReportJsonをnullで登録
                            mOperationLogic.updateTaskReport(serverTaskDto.taskKey, operationId, operationContentDto.contentId,
                                    serverTaskReportDto.taskReportLevel, serverTaskReportDto.enableReport,
                                    taskReportJson, attachedFileName, false, false, localTaskReportDto.localSavedFlg);
                        }
                    }
                }
            if (progressCallback != null) {
                progressCallback.callback(new Integer(progress));
            }
        }
        // サーバーから取得した作業情報がローカルに存在しないので削除する
        for (TaskDto taskDto : localTaskList) {
            mOperationLogic.deleteTaskFileData(operationId, operationContentDto.contentId, taskDto.taskKey, TaskReportLevel.ReportType);
            mTaskDao.delete(taskDto);
        }
        lastEditDate = json.lastEditDate;
        if (progressCallback != null) {
            progressCallback.callback(new Integer(40));
        }

        return lastEditDate;
    }

    /**
     * 添付ファイルが存在する場合、取得して解凍する。
     * @param operationId
     * @param taskReportLevel
     * @param contentId
     * @param taskId
     * @param taskKey
     * @param attachedFileName
     * @throws ABVException
     * @throws InterruptedException
     * @throws ZipException
     * @throws NoSuchAlgorithmException
     * @throws IOException
     */
    public void refreshTaskFile(final long operationId, final int taskReportLevel, long contentId, final long taskId, final String taskKey, final String attachedFileName) throws Exception {
        //　既存の添付ディレクトリ削除
        FileUtil.delete(ABVEnvironment.getInstance().getTempTaskDirPath(contentId, taskKey));

        String reportLocalAttachedFileName = mTaskReportDao.getTaskReportAttachedFileName(taskKey, taskReportLevel);
        if (attachedFileName != null && !attachedFileName.equals(reportLocalAttachedFileName)) {
            Logger.i(TAG, "[Get Task Report Files] operationId=%s, taskKey=%s, taskId=%s, attachedFileName=%s", operationId, taskKey, taskId, attachedFileName);
            // #32926 start
            FileUtil.delete(ABVEnvironment.getInstance().getOperationTaskReportLevelDirPath(operationId, taskKey, taskReportLevel));
            // #32926 end
            String outputFilePath = mOperationLogic.getTaskFile(operationId, taskKey, taskId, attachedFileName, taskReportLevel);
            ContentFileExtractor.getInstance().extractZipFile(contentId, outputFilePath, ABVEnvironment.getInstance().getOperationTaskReportLevelDirPath(operationId, taskKey, taskReportLevel),null, true);
        }
    }

    /**
     * 定期点検用ファイル更新
     * @param operationId
     * @param contentId
     * @param taskId
     * @param taskKey
     * @param taskReportId
     * @param reportStartDate
     * @param reportAttachedFileName
     * @throws ABVException
     * @throws InterruptedException
     * @throws ZipException
     * @throws NoSuchAlgorithmException
     * @throws IOException
     */
    public void refreshRoutineTaskFile(final long operationId, final long contentId, final long taskId, final String taskKey, final int taskReportId, final int taskReportInfoId, final Date reportStartDate, final String reportAttachedFileName) throws Exception {
        String reportStartDateHypn = DateTimeUtil.toString(reportStartDate, DateTimeFormat.yyyyMMddHHmmss_hyphen);
        final String reportStartDateNone = DateTimeUtil.toString_yyyyMMddHHmmss_none(reportStartDate);
        //　既存の添付ディレクトリ削除
        FileUtil.delete(ABVEnvironment.getInstance().getTempTaskDirPath(contentId, taskKey));

        String reportLocalAttachedFileName = mTaskReportDao.getRoutineTaskReportAttachedFileName(taskKey, taskReportId, reportStartDateHypn);
        boolean getReportFileFlg = !StringUtil.isNullOrEmpty(reportAttachedFileName) && !reportAttachedFileName.equals(reportLocalAttachedFileName);

        if (getReportFileFlg) {
            Logger.i(TAG, "[Get Task Report Files] operationId=%s, taskKey=%s, taskId=%s, attachedFileName=%s", operationId, taskKey, taskId, reportAttachedFileName);
            // #32926 start
            int taskReportLevel = 0;
            FileUtil.delete(ABVEnvironment.getInstance().getRoutineTaskReportDirFilePath(operationId, taskKey, taskReportId, reportStartDateNone));
            // #32926 end
            String outputFilePath = mOperationLogic.getRoutineTaskReportFile(operationId, taskKey, taskId, taskReportId, taskReportInfoId, reportStartDateNone, reportAttachedFileName);
            // #32926 start
            ContentFileExtractor.getInstance().extractZipFile(contentId, outputFilePath,
                    ABVEnvironment.getInstance().getRoutineTaskReportDirFilePath(operationId, taskKey, taskReportId, reportStartDateNone), null, true);
            // #32926 end
        }
    }

    /**
     * 360コンテンツ登録ダイアログ
     */
    public void showPanoEntryDialog(final OperationDto operationDto) {
        Logger.d(TAG, "*****************showPanoEntryDialog");
        if (contentRefresher != null && contentRefresher.isRefreshing()) {
            // 新着更新処理が行っていれば、止める
            contentRefresher.stopRefresh();
        }
        if (mPanoEntryDialog == null) {
            mPanoEntryDialog = new Dialog(OperationListActivity.this);
            mPanoEntryDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            mPanoEntryDialog.setCanceledOnTouchOutside(false);
            mPanoEntryDialog.setContentView(R.layout.operation_pano_entry_dialog);
        }
        mPanoCotnentImageView = (ImageView) mPanoEntryDialog.findViewById(R.id.pano_image_view);
        mPanoContentNameTextView = (TextView) mPanoEntryDialog.findViewById(R.id.operation_name);

        mPanoContentNameTextView.setText(operationDto.operationName);
        mPanoCotnentImageView.setImageBitmap(null);
        FileUtil.delete(ABVEnvironment.getInstance().getCacheTempAttachedImageDirPath());

        // 閉じるボタン
        mPanoEntryDialog.findViewById(R.id.closeBtn).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                mPanoCotnentImageView.setImageBitmap(null);
                mSelectPanoContentUri = null;
                mPanoEntryDialog.dismiss();
                FileUtil.delete(ABVEnvironment.getInstance().getCacheTempAttachedImageDirPath());
            }
        });


        // 画像選択ボタン
        mPanoEntryDialog.findViewById(R.id.select_image).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startCameraIntent(ABOOK_CHECK_OPERATION_PANO_CONTENT_IMAGE, "Camera", ABookKeys.IMAGE, false);
            }
        });


        // 登録ボタン
        mPanoEntryDialog.findViewById(R.id.btn_entry).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
                    ABVToastUtil.showMakeText(OperationListActivity.this, R.string.msg_network_offline, Toast.LENGTH_SHORT);
                    return;
                }
                if (mSelectPanoContentUri == null) {
                    ABVToastUtil.showMakeText(OperationListActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                        R.string.msg_pano_image_no_selected,
                                                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
                    return;
                }
                // リソースパターンの適用
                showProgressView(PatternStringUtil.patternToString(getApplicationContext(),
                                    R.string.msg_common_processing,
                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                CommonExecutor.execute(new Runnable() {
                    @Override
                    public void run() {
                        boolean isError = true;
                        String[] projection = {MediaStore.MediaColumns.DATA};
                        Cursor cursor = getContentResolver().query(mSelectPanoContentUri, projection, null, null, null);

                        String scenePath = null;
                        if (mSelectPanoContentUri.toString().contains("file")) { //アプリ内に臨時保存した画像ファイル
                            scenePath = mSelectPanoContentUri.getPath();
                        } else {
                            if (cursor != null) {
                                if (cursor.moveToFirst()) {
                                    scenePath = cursor.getString(0);
                                }
                                cursor.close();
                            }

                        }
                        if (scenePath != null) {
                            File file = new File(scenePath);
                            isError = true;
                            try {
                                mOperationLogic.sendPanoContent(operationDto.operationId, operationDto.operationName, file);
                                isError = false;
                            } catch (ABVException e) {
                                //noinspection EnumSwitchStatementWhichMissesCases
                                switch (e.getCode()) {
                                    case P_E_ACMS_P001:
                                        showSimpleAlertDialog(R.string.app_name,
                                                PatternStringUtil.patternToInt(getApplicationContext(),
                                                        R.string.P001,
                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                        break;
                                    case P_E_ACMS_P002:
                                        showSimpleAlertDialog(R.string.app_name,
                                                PatternStringUtil.patternToInt(getApplicationContext(),
                                                        R.string.P002,
                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                        break;
                                    case S_E_ACMS_0500:
                                        handleErrorMessageToast(ABVExceptionCode.S_E_ACMS_0500);
                                        break;
                                    default:
                                        Logger.e(TAG, "PanoContent send error", e);
                                        handleErrorMessageToast(ErrorCode.E107);
                                        break;
                                }
                            } catch (Exception e) {
                                Logger.e(TAG, e);
                                ErrorMessage.showErrorMessageToast(OperationListActivity.this, ErrorCode.E107);
                            }
                        }
                        if (isError) {
                            closeProgressPopup();
                        } else {
                            handler.post(new Runnable() {
                                @Override
                                public void run() {
                                    progressDialogHorizontal.setProgress(20);
                                    mOperationLogic.setContentCreatingFlg(operationDto.operationId);
                                    refreshOperationList();
                                }
                            });

                            //10秒後に新着更新させる
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    int progress = progressDialogHorizontal.getProgress();
                                    progressDialogHorizontal.setProgress(progress + 8);
                                    if (progress >= 100) {
                                        closeProgressPopup();
                                        mPanoEntryDialog.dismiss();
                                        mPanoCotnentImageView.setImageBitmap(null);
                                        dataRefresh(true);
                                    } else {
                                        handler.postDelayed(this, 1000);
                                    }
                                }
                            }, 1000);
                        }
                    }
                });
            }
        });

        if (mPanoEntryDialog != null) {
            mPanoEntryDialog.show();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        activityResultFlg = true;
        Uri result = (intent == null || resultCode != RESULT_OK) ? null : intent.getData();
        if (requestCode == ABOOK_CHECK_OPERATION_PANO_CONTENT_IMAGE) {
            if (result != null) {
                mSelectPanoContentUri = result;
                try {
                    String[] projection = {MediaStore.MediaColumns.DATA};
                    Cursor cursor = getContentResolver().query(mSelectPanoContentUri, projection, null, null, null);
                    String photoFilePath = ABookCheckWebViewHelper.getInstance().contentSchemeUriToFilePath(cursor);
                    int rotationAngle = ABookCheckWebViewHelper.getInstance().rotateBitmapOrientation(photoFilePath);
                    if (rotationAngle != 0) {
                        mLocalFile = ABookCheckWebViewHelper.getInstance().rotateBitmapToImageFile(rotationAngle, photoFilePath, ABVEnvironment.getInstance().getCacheTempAttachedImageDirPath());
                        mSelectPanoContentUri = Uri.fromFile(mLocalFile);
                    }
                    if (mSelectPanoContentUri != null) {
                        InputStream stream = getContentResolver().openInputStream(mSelectPanoContentUri);
                        Bitmap bitmap = BitmapFactory.decodeStream(stream);
                        mPanoCotnentImageView.setImageBitmap(bitmap);
                    }

                } catch (FileNotFoundException e) {
                    Logger.e(TAG, "panoImageContent is not found", e);
                } catch (IOException e) {
                    Logger.e(TAG, "IOException = ", e);
                }
            }
        }
    }

    /**
     * listDtoの中に第2引数のdtoが存在するかチェックメソッド
     * @param listDto　リストDto
     * @param dto　ターゲットDto
     * @return
     */
    private boolean isExistsTaskInList(List<TaskDto> listDto, TaskDto dto) {
        for (TaskDto lDto : listDto) {
            if (lDto.taskKey.equals(dto.taskKey)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 報告存在チェック
     * @param listDto
     * @param rDto
     * @return
     */
    private boolean isExistsTaskReportInList(List<TaskReportDto> listDto, TaskReportDto rDto, boolean isRoutineTask) {
        for (TaskReportDto lDto : listDto) {
            if (isRoutineTask) {
                // 定期点検の場合、taskKey,taskReportId,reportStartDateで判定
                if (lDto.taskKey.equals(rDto.taskKey) &&
                        lDto.taskReportId == rDto.taskReportId  &&
                        lDto.reportStartDate.equals(rDto.reportStartDate)) {
                    return true;
                }
            } else {
                // taskKeyと作業報告階層で判定
                if (lDto.taskKey.equals(rDto.taskKey) &&
                        lDto.taskReportLevel == rDto.taskReportLevel) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 作業報告画面に移動
     * @param operationDto
     */
    public void openReportView(OperationDto operationDto) {
        if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
            ABVToastUtil.showMakeText(this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
            return;
        }
        // 新着更新を止める
        contentRefresher.stopRefresh();
        startTaskDirectionOrReportView(operationDto);
    }

    /**
     * 同期処理
     * @param operationDto
     */
    public void startSyncOperation(final OperationDto operationDto) {
        //ネットワークチェック
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            ABVToastUtil.showMakeText(OperationListActivity.this, R.string.request_network_connection, Toast.LENGTH_SHORT);
            return;
        }
        //新着更新中
        if (contentRefresher.isRefreshing()) {
            return;
        }

        // 会議室接続中
        if (ActivityHandlingHelper.getInstance().isMeetingConnected()) {
            ABVToastUtil.showMakeText(this, R.string.msg_operation_enable_meeting_room_connected, Toast.LENGTH_SHORT);
            return;
        }

        // リソースパターンの適用
        showProgressView(PatternStringUtil.patternToString(getApplicationContext(),
                            R.string.synchronizing,
                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                Logger.i(TAG, "[syncOperation] operationId=%s, contentId=%s", operationDto.operationId, operationDto.contentId);
                // コンテンツダウンロード
                ContentDto contentDto = contentDao.getContent(operationDto.contentId);
                if (contentDto == null) {
                    Logger.e(TAG, "contentDto is null !");
                    return;
                }
                if (!contentDto.downloadedFlg || contentDto.updatedFlg) {
                    if (!operationContentDownload(contentDto)) {
                        Logger.e("operation sync baseFile download fail");
                        closeProgressPopup();
                    }
                } else {
                    singleSyncOperation(operationDto.operationId, operationDto.reportType, true);
                }
            }
        });
    }

    /**
     * リストビュー用のプルダウンで新着更新処理
     * @param refreshView
     */
    public void pullToListViewRefresh(PullToRefreshBase<ListView> refreshView) {
        refreshBaseView = refreshView;

        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showDisConnectNetworkDialog();
            return;
        }
        long lastUpdateTime = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.LAST_UPDATE_TIME, 0L);
        if (lastUpdateTime > 0) {
            String lastUpdateTimeLabel = null;
            String strUpdateTime = DateTimeUtil.toString(new Date(lastUpdateTime), DateTimeFormat.yyyyMMddHHmmss_slash);
            // リソースパターンの適用
            String formatStr = PatternStringUtil.patternToString(getApplicationContext(),
                                R.string.recent_update_date,
                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
            lastUpdateTimeLabel = String.format(formatStr, strUpdateTime);

            // Update the LastUpdatedLabel
            if (lastUpdateTimeLabel != null) {
                refreshView.getLoadingLayoutProxy().setLastUpdatedLabel(lastUpdateTimeLabel);
            }
        }
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                if (!contentRefresher.isRefreshing()) {
                    dataRefresh(false);
                }
            }
        });
    }

    /**
     * パンネルビュー用のプルダウンで新着更新処理
     * @param refreshView
     */
    public void pullToGridViewRefresh(PullToRefreshBase<GridView> refreshView) {
        // 完了通知のため、ビューをメンバー変数で管理する
        refreshBaseView = refreshView;
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showDisConnectNetworkDialog();
            return;
        }
        long lastUpdateTime = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.LAST_UPDATE_TIME, 0L);
        if (lastUpdateTime > 0) {
            String lastUpdateTimeLabel = null;
            String strUpdateTime = DateTimeUtil.toString(new Date(lastUpdateTime), DateTimeFormat.yyyyMMddHHmmss_slash);
            // リソースパターンの適用
            String formatStr = PatternStringUtil.patternToString(getApplicationContext(),
                                R.string.recent_update_date,
                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
            lastUpdateTimeLabel = String.format(formatStr, strUpdateTime);

            // Update the LastUpdatedLabel
            if (lastUpdateTimeLabel != null) {
                refreshView.getLoadingLayoutProxy().setLastUpdatedLabel(lastUpdateTimeLabel);
            }
        }
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        if (!contentRefresher.isRefreshing()) {
                            dataRefresh(false);
                        }
                    }
                });
            }
        });
    }

    /**
     * インターネットが繋がってない場合のダイアログ表示
     */
    private void showDisConnectNetworkDialog() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                // ヘッダーの新着更新処理を完了にさせる
                stopUpdateAnimation();
                final ABookAlertDialog messageDialog = AlertDialogUtil.createAlertDialog(OperationListActivity.this, R.string.app_name);
                messageDialog.setMessage(getString(R.string.msg_network_offline));
                messageDialog.setPositiveButton(R.string.confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        messageDialog.dismiss();
                    }
                });
                messageDialog.show();
            }
        });
    }

    // ログイン成功した後、新着更新時の「ContentVersion」APIからリソースパターンを取得し、ローカルに保存する。
    private void setResourcePattern() {
        Logger.d(TAG, "ABVEnvironment.getInstance().resourcePatternType : " + ABVEnvironment.getInstance().resourcePatternType);
        putUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, ABVEnvironment.getInstance().resourcePatternType);
    }

    /**
     * 作業種別の選択のダイアログ画面表示
     * @param isInit 初期表示
     */
    public void showOperationGroupMasterDialog(boolean isInit) {
        if (isInit || operationCountMap == null) {
            // 最後の階層レベルを取得
            Integer lastLevel = mOperationGroupMasterLogic.getLastGroupLevel();
            operationCountMap = new HashMap<Integer, Integer>();
            // 作業種別毎に作業数をMapにセット
            mOperationGroupMasterLogic.getAllOperationCount(lastLevel, operationCountMap);
        }
        // 既にダイアログが存在するか、開いた状態である場合は何もしない
        if (mShowDialog != null && mShowDialog.isShowing()) {
            return;
        }
        final ABVListDialog dialog = new ABVListDialog(this);
        // 外側タップしてもダイアログ画面が閉じられないように設定
        dialog.setCanceledOnTouchOutside(false);
        mShowDialog = dialog;
        OperationGroupMasterListHelper helper = (OperationGroupMasterListHelper) mListHelper;
        ArrayList<String> groupNames = new ArrayList<>();

        // 直下の作業種別リスト情報を取得
        final List<OperationGroupMasterDto> operationGroupMasterDtoList = helper.getChildList();

        dialog.setTitle(helper.getPeekName(), R.drawable.ic_title_group_operation);

        // 閉じるボタン
        dialog.setRightItemOnClickListener(R.drawable.ic_operation_close, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        boolean[] haveChildFlags = new boolean[operationGroupMasterDtoList.size()];
        int[] operationCounts = new int[operationGroupMasterDtoList.size()];
        int i = 0;
        for (OperationGroupMasterDto dto : operationGroupMasterDtoList) {
            int operationGroupMasterId = dto.operationGroupMasterId;
            groupNames.add(dto.operationGroupMasterName);
            // 下位階層があるか否かチェック
            haveChildFlags[i] = helper.getChildList(operationGroupMasterId).size() > 0;
            // 子グループも含めて作業種別に紐づく作業数
            operationCounts[i] = operationCountMap.get(operationGroupMasterId);
            i++;
        }

        final HierarchyOperationGroupListAdapter adapter = new HierarchyOperationGroupListAdapter(this, groupNames, haveChildFlags, operationCounts);

        // 上位階層がある場合、上位階層に戻るボタンを追加
        if (helper.getStackSize() > 1) {
            dialog.setListViewAdapter(adapter);
            String backToName = helper.getPrePeekName();
            // スマートフォン端末で20文字を超えた場合、20文字まで切り落として後ろに...をつけて表示
            if (isNormalSize() && backToName.length() > 20) {
                backToName = backToName.substring(0, 20) + "...";
            }
            dialog.setHeaderItemOnClickListener(backToName, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    OperationGroupMasterListHelper helper = (OperationGroupMasterListHelper) mListHelper;
                    helper.popList(1, true);
                    // ポップアップ再表示
                    dialog.dismiss();
                    showOperationGroupMasterDialog(false);
                }
            });
        } else {
            dialog.setListViewAdapter(adapter);
        }

        // 直下階層の要素をクリックイベント
        dialog.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                OperationGroupMasterDto operationGroupMasterDto = operationGroupMasterDtoList.get(position);
                OperationGroupMasterListHelper helper = (OperationGroupMasterListHelper) mListHelper;
                helper.pushList(operationGroupMasterDto);
                // ポップアップ再表示
                dialog.dismiss();
                showOperationGroupMasterDialog(false);
            }
        });

        // リストが空の時表示するテキストを設定
        dialog.setListEmptyText(getString(R.string.no_child));
        if (isNormalSize()) {
            dialog.showHalfSize();
        } else {
            dialog.show();
        }
    }

    /**
     * operationListHelperに通常か作業種別のhelperをセット
     * @return
     */
    private OperationListHelper getListHelper() {
        OperationListHelper operationListHelper;
        if (mOperationGroupMasterServiceOperationFlg && getABVUIDataCache().getOperationGroupMasterMode() == OperationLocationType.CATEGORY) {
            operationListHelper = new OperationGroupMasterListHelper(this);
        } else {
            operationListHelper = new HomeOperationListHelper(this);
        }
        return operationListHelper;
    }

    /**
     * 作業種別ID取得
     * @return
     */
    public int getOperationGroupMasterId() {
        return getABVUIDataCache().getOperationGroupMasterId();
    }

    /**
     * 開いた作業種別ID保存
     * @param operationGroupMasterId
     */
    public void setOperationGroupMasterId(int operationGroupMasterId) {
        getABVUIDataCache().setOperationGroupMasterId(operationGroupMasterId);
    }

    /**
     * 作業種別選択画面を閉じる処理
     */
    public void closeOperationGroupMasterDialog() {
        if (mShowDialog != null && mShowDialog.isShowing()) {
            mShowDialog.dismiss();
        }
    }

    /**
     * 絞り検索の日付を設定
     */
    private void setApertureMasterDataFetchDate() {
        putUserPref(AppDefType.UserPrefKey.APERTURE_MASTER_DATA_FETCH_DATE, ABVDataCache.getInstance().getTempApertureMasterDataFetchDate());
    }

    /**
     * カテゴリの一括同期ダイアログ表示
     */
    private void showBatchSyncDialog() {
        ABookAlertDialog dialog = AlertDialogUtil.createABookAlertDialog(this);
        dialog.setTitle(getString(R.string.batch_sync));
        dialog.setMessage(getString(R.string.msg_confirm_batch_sync));
        dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                // 一括同期開始
                categoryBatchSync();
            }
        });
        dialog.setNegativeButton(R.string.cancel,  new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        if (mAlertDialog != null && this.mAlertDialog.isShowing()) {
            mAlertDialog.dismiss();
        }
        this.mAlertDialog = dialog;
        mAlertDialog.show();
    }

    /**
     * カテゴリの一括同期ボタン
     */
    public void categoryBatchSync() {
        Logger.i(TAG, "---batch sync start");
        // ネットワーク通信チェック
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            showSimpleAlertDialog(getString(R.string.app_name), getString(R.string.request_network_connection));
            return;
        }

        // 作業種別に関連する作業リストを取得
        List<OperationDto> operationList = mOperationDao.getNeedSyncOperationByGroupMasterId(getABVUIDataCache().getOperationGroupMasterId());

        // 作業リストをスタックにセット
        Stack<OperationDto> operationDtoStack = new Stack<OperationDto>();
        operationDtoStack.addAll(operationList);

        // 一括同期を設定
        batchSyncView = new ABVBatchSyncView(this);

        // batchSyncViewにスタックをセットして表示
        batchSyncView.setStack(operationDtoStack);
        batchSyncView.show();

        // 一括同期処理
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                batchSyncView.batchOperationSyncForCheckDonwload();
            }
        });
    }

    /**
     * 同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合
     * needSyncFlgをtrueに更新する
     */
    private void updateNeedSyncRoutineOperation() {
        // サービスオプションチェック
        if (ABVDataCache.getInstance().serviceOption.isRoutineTaskReport()) {
            // 同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合needSyncFlgをtrueに更新する
            List<OperationDto> deactivatedRoutineOperationList = mOperationDao.getDeactivatedRoutineOperation();
            for (OperationDto routineOperationDto : deactivatedRoutineOperationList) {
                String syncedDate = getUserPref(String.format(AppDefType.UserPrefKey.SYNCED_OPERATION_ID, routineOperationDto.operationId), "");
                if (StringUtil.isNullOrEmpty(routineOperationDto.reportPeriod) && !syncedDate.equals(DateTimeUtil.toString(DateTimeUtil.getCurrentSqlDate(), DateTimeFormat.yyyyMMdd_none))) {
                    // 同期ボタンタップの日付と現在の日付が異なる且つ、作業するデータが存在しない場合
                    mOperationLogic.updateSyncOperation(routineOperationDto.operationId, true);
                }
            }
        }
    }

    /**
     * 作業用コンテンツダウンロード時、ダウンロードかダウンロード再開か判定して行う。
     * @param contentDto
     * @return
     */
    public boolean operationContentDownload(final ContentDto contentDto) {
        if (contentDto.isDownloadPaused()) {
            // ダウンロード途中で通信が切れた場合、一時停止のステータスに変更になるため、再開させる
            try {
                contentDownloader.resume(contentDto.contentId);
            } catch (Exception e) {
                Logger.e(TAG, "downloadContent failed. contentId=" + contentDto.contentId, e);
                return false;
            }
        } else {
            // ダウンロード
            return contentDownload(contentDto.contentId, false, false);
        }
        return true;
    }

    /**
     * 一括同期の活性化・非活性化チェック
     */
    public void checkBatchNeedSyncButton(Integer operationGroupMasterId) {
        if (mOperationDao.hasNeedSyncOperationByGroupMasterId(operationGroupMasterId)) {
            // 選択したカテゴリ一覧でneedSyncFlgがtrueの作業が存在すれば、活性化する
            mOperationBatchSyncButton.setEnabled(true);
        } else {
            // 一括同期ボタンを非活性化する
            mOperationBatchSyncButton.setEnabled(false);
        }
    }

    @Override
    public void onDestroy() {
        Logger.d(TAG, "onDestroy");
        contentDownloader.removeContentDownloadListener(this);
        if (batchSyncView != null) {
            batchSyncView.setActivityDestroy();
        }
        super.onDestroy();
    }

    /**
     * 並び替え設定メニュー（タブレット）
     * @param anchor
     */
    public void onClickSortMenuByTablet(View anchor) {
        Logger.d(TAG, "onClickShowSortConditionList");
        final ABVPopupListWindow popup = new ABVPopupListWindow(this, R.layout.popup_simple_list);
        popup.setTitle(getRString(R.string.sort_title));

        ListView listView = popup.getListView();
        // ソート用のリストビューセット
        ArrayAdapter<String> adapter = setSortListView(listView);
        listView.setAdapter(adapter);
        listView.setItemChecked(getABVUIDataCache().getSortCondition(), true);

        // 横幅をフィットさせる
        popup.setWidth((int)(ABVPopupListWindow.getWidestView(this, adapter) * 1.15));

        popup.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Logger.d(TAG, "onClickSortMenuByTablet id:" + id);
                getABVUIDataCache().setSortCondition((int)id);
                // ビューア更新
                refreshOperationList();
            }
        });

        if (anchor == null) {
            // 呼び出したViewが存在しない場合、真ん中に表示する
            popup.showAtLocation(getWindow().getDecorView().findViewById(android.R.id.content), Gravity.CENTER, 0,0);
        } else {
            popup.showAsDropDown(anchor);
        }
    }


    /**
     * 並び替え設定メニュー（スマートフォン）
     * @param view
     */
    public void onClickSortMenuByNormalSize(View view) {
        final ABVListDialog dialog = new ABVListDialog(this, getString(R.string.sort_title));

        // ダイアログ表示時、ダイアログ以外の画面をタップしても閉じられないように設定
        dialog.setCanceledOnTouchOutside(false);
        // ソート用のリストビューセット
        ListView listView = dialog.getListView();
        dialog.setListViewAdapter(setSortListView(listView));
        listView.setItemChecked(getABVUIDataCache().getSortCondition(), true);

        mShowDialog = dialog;

        // 閉じるボタン
        dialog.setRightItemOnClickListener(R.drawable.ic_operation_close, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        dialog.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                getABVUIDataCache().setSortCondition((int)id);
                refreshOperationList();
            }
        });

        if (isNormalSize()) {
            dialog.showHalfSize();
        } else {
            dialog.show();
        }
    }

    // 並び替えの表示するソートリスト

    /**
     * 並び替えの表示するソートリスト
     * @param listView
     * @return ArrayAdapter ソート名をセットしたアダプタ
     */
    private ArrayAdapter<String> setSortListView(ListView listView) {
        listView.setChoiceMode(AbsListView.CHOICE_MODE_SINGLE);
        return new ArrayAdapter<>(this, R.layout.item_checked_list, Arrays.asList(getRStringArray(R.array.sort_names)));
    }

    /**
     * 並べ替え画面表示
     *
     * @param anchor
     */
    public void onClickGroupLocationByTablet(final View anchor) {
        Logger.d(TAG, "onClickGroupLocationByTablet start");
        final ABVPopupListWindow popup = new ABVPopupListWindow(this, R.layout.popup_simple_list);
        popup.setTitle(getRString(R.string.category_list));
        popup.setWidth(getRDimensionSize(R.dimen.popup_size_large));

        // 表示するコンテンツタイプのリストを作成
        ListView listView = popup.getListView();
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, R.layout.item_dialog_list, Arrays.asList(getRStringArray(R.array.category_types)));

        popup.setListViewAdapter(adapter);

        popup.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                popup.dismiss();
                setOperationLocation(id);
            }
        });
        if (anchor == null) {
            // 呼び出したViewが存在しない場合、真ん中に表示する
            popup.showAtLocation(getWindow().getDecorView().findViewById(android.R.id.content), Gravity.CENTER, 0,0);
        } else {
            popup.showAsDropDown(anchor);
        }
    }

    // 全て・カテゴリ選択画面(スマートフォン)
    public void onClickGroupLocationByNormalSize(View view) {
        final ABVListDialog dialog = new ABVListDialog(this);
        // 外側タップしてもダイアログ画面が閉じられないように設定
        final ArrayAdapter<String> adapter = new ArrayAdapter<>(this, R.layout.item_dialog_list, Arrays.asList(getRStringArray(R.array.category_types)));
        dialog.setTitle(getRString(R.string.category_list));
        dialog.setListViewAdapter(adapter);
        dialog.setCanceledOnTouchOutside(false);

        // 閉じるボタン
        dialog.setRightItemOnClickListener(R.drawable.ic_operation_close, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        dialog.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // ポップアップ再表示
                dialog.dismiss();
                setOperationLocation(id);
            }
        });

        if (isNormalSize()) {
            dialog.showHalfSize();
        } else {
            dialog.show();
        }
    }

    private void setMasterDataFetchDate() {
        Logger.d(TAG, "ABVDataCache.getInstance().tempMasterDataFetchDate : " + ABVDataCache.getInstance().tempMasterDataFetchDate);
        putUserPref(AppDefType.UserPrefKey.MASTER_DATA_FETCH_DATE, ABVDataCache.getInstance().tempMasterDataFetchDate);
    }
    
    /**
     * カテゴリ選択した内容で設定・表示する
     * @param type 0 : 全て 1: カテゴリ
     */
    private void setOperationLocation(long type) {
        Logger.d(TAG, "setOperationLocation type :" + type);
        int localType = getABVUIDataCache().getOperationGroupMasterMode();

        // loadFlgがtrueの場合のみ、タイプを保存して画面を再作成する
        if (localType != type) {
            // typeの値をxmlに書き込み
            getABVUIDataCache().setOperationGroupMasterMode((int) type);
            // プログレスバー
            showProgressPopup();
            setOperationListView();
        }

        if (getABVUIDataCache().getOperationGroupMasterMode() == OperationLocationType.CATEGORY) {
            //作業種別モードの場合は、作業種別選択ダイアログ画面を表示
            showOperationGroupMasterDialog(true);
        }
    }

    /**
     * ソート順取得（デフォルト：１(作業期間が新しい順)）
     * @return
     */
    public int getSortCondition() {
        return getABVUIDataCache().getSortCondition();
    }
}
