package jp.agentec.abook.abv.ui.home.helper;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.abook.abv.ui.viewer.activity.HTMLWebViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.HTMLXWalkWebViewActivity;

import static android.content.pm.PackageManager.PERMISSION_GRANTED;
import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;

/**
 * 権限チェック及び設定画面遷移
 * Created by kim jinsung on 2018/09/21.
 */
public class ABookPermissionHelper {
    private Context mContext;
    private int mPermitionType;
    private AlertDialog mAlertDialog;
    private Callback mCallback;

    public ABookPermissionHelper(Context context, int permissionType, Callback callback) {
        mContext = context;
        mPermitionType = permissionType;
        mCallback = callback;
    }

    public ABookPermissionHelper(Context context) {
        mContext = context;
    }

    public ArrayList<String> checkMultiPermissions() {

        ArrayList<String> reqPermissions = new ArrayList<>();
        //Android6.0未満の場合はチェックしない
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            return reqPermissions;
        }
        // 位置情報
        if (ContextCompat.checkSelfPermission(mContext,
                android.Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            reqPermissions.add(android.Manifest.permission.ACCESS_FINE_LOCATION);
        }
        if (ContextCompat.checkSelfPermission(mContext,
                android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            reqPermissions.add(android.Manifest.permission.ACCESS_COARSE_LOCATION);
        }
        // ストレージ
        if (ContextCompat.checkSelfPermission(mContext,
                android.Manifest.permission.READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            reqPermissions.add(android.Manifest.permission.READ_EXTERNAL_STORAGE);
        }
        if (ContextCompat.checkSelfPermission(mContext,
                android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            reqPermissions.add(android.Manifest.permission.WRITE_EXTERNAL_STORAGE);
        }
        // カメラ
        if (ContextCompat.checkSelfPermission(mContext,
                android.Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
            reqPermissions.add(android.Manifest.permission.CAMERA);
        }
        // マイク（オーディオ）
        if (ContextCompat.checkSelfPermission(mContext,
                android.Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
            reqPermissions.add(android.Manifest.permission.RECORD_AUDIO);
        }
        return reqPermissions;
    }

    public boolean checkMultiPermissions(boolean showDialogFlg) {
        //Android6.0未満の場合はチェックしない
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }

        int permitionTextResourceId = -1;
        switch (mPermitionType) {
            case Constant.ABookPermissionType.ReadExternalStorage:
                // ストレージ
                if (ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.READ_EXTERNAL_STORAGE) != PERMISSION_GRANTED ||
                        ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PERMISSION_GRANTED) {
                    if (mContext instanceof HTMLWebViewActivity || mContext instanceof HTMLXWalkWebViewActivity || mContext instanceof OperationListActivity) {
                        // リソースパターンの適用
                        permitionTextResourceId = PatternStringUtil.patternToInt(mContext,
                                                        R.string.msg_permission_dialog_storage_album,
                                                        getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                    } else {
                        // リソースパターンの適用
                        permitionTextResourceId = PatternStringUtil.patternToInt(mContext,
                                                        R.string.msg_permission_dialog_storage_update,
                                                        getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                    }

                }
                break;
            case Constant.ABookPermissionType.AccessFineLocation:
                // 位置情報
                if (ContextCompat.checkSelfPermission(mContext,
                        android.Manifest.permission.ACCESS_FINE_LOCATION) != PERMISSION_GRANTED) {
                    // リソースパターンの適用
                    permitionTextResourceId = PatternStringUtil.patternToInt(mContext,
                            R.string.msg_permission_dialog_location,
                            getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                }
                if (ContextCompat.checkSelfPermission(mContext,
                        android.Manifest.permission.ACCESS_COARSE_LOCATION) != PERMISSION_GRANTED) {
                    // リソースパターンの適用
                    permitionTextResourceId = PatternStringUtil.patternToInt(mContext,
                            R.string.msg_permission_dialog_location,
                            getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                }
                break;

            case Constant.ABookPermissionType.Camera:
                // カメラ
                if (ContextCompat.checkSelfPermission(mContext,
                        android.Manifest.permission.CAMERA) != PERMISSION_GRANTED) {
                    // リソースパターンの適用
                    permitionTextResourceId = PatternStringUtil.patternToInt(mContext,
                            R.string.msg_permission_dialog_camera,
                            getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                }
                break;
            case Constant.ABookPermissionType.Audio:
                // マイク(オーディオ）
                if (ContextCompat.checkSelfPermission(mContext,
                        android.Manifest.permission.RECORD_AUDIO) != PERMISSION_GRANTED) {
                    // リソースパターンの適用
                    permitionTextResourceId = PatternStringUtil.patternToInt(mContext,
                            R.string.msg_permission_dialog_mic,
                            getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
                }
                break;
        }

        if (permitionTextResourceId > 0) {
            if (showDialogFlg) {
                ABookAlertDialog dialog = AlertDialogUtil.createABookAlertDialog(mContext);
                // リソースパターンの適用
                dialog.setTitle(PatternStringUtil.patternToString(mContext,
                                    R.string.title_permission_dialog,
                                    getUserPref(mContext, AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                dialog.setMessage(permitionTextResourceId);
                dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
                        Uri uri = Uri.fromParts("package", mContext.getPackageName(), null);
                        intent.setData(uri);
                        mContext.startActivity(intent);
                        if (mCallback != null) {
                            mCallback.callback(true);
                        }
                    }
                });
                dialog.setNegativeButton(R.string.cancel,  new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (mCallback != null) {
                            mCallback.callback(false);
                        }
                    }
                });
                if (mAlertDialog != null && this.mAlertDialog.isShowing()) {
                    mAlertDialog.dismiss();
                }
                this.mAlertDialog = dialog;
                mAlertDialog.show();
            }
            return false;
        }
        return true;
    }

}
