package jp.agentec.abook.abv.ui.viewer.activity;

import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.Toast;

import org.xwalk.core.XWalkNavigationHistory;
import org.xwalk.core.XWalkPreferences;
import org.xwalk.core.XWalkResourceClient;
import org.xwalk.core.XWalkSettings;
import org.xwalk.core.XWalkUIClient;
import org.xwalk.core.XWalkView;
import org.xwalk.core.XWalkWebResourceRequest;
import org.xwalk.core.XWalkWebResourceResponse;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ContentDao;
import jp.agentec.abook.abv.bl.download.ContentDownloader;
import jp.agentec.abook.abv.bl.download.ContentZipDownloadNotification;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContentReadingLogLogic;
import jp.agentec.abook.abv.bl.logic.ContractLogic;
import jp.agentec.abook.abv.cl.util.ContentLogUtil;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.common.view.ABVPopupListWindow;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;

/**
 * Created by leej on 2018/04/17.
 */

public class HTMLXWalkWebViewActivity extends ParentWebViewActivity {
    private static final String TAG = "HTMLXWalkWebViewActivity";

    /** Called when the activity is first created. */

    private ImageButton reloadButton;
    private ImageButton downloadButton;
    private int objectLogId;
    private XWalkView webView;

    private HTMLXWalkWebViewActivity.JsInf jsInf = new HTMLXWalkWebViewActivity.JsInf();

    private Integer lastPageNo = 0;
    private Date lastPageStartDate;
    private FrameLayout xWalkLayout;
    private ValueCallback<Uri> mUploadMessage;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "onCreate");
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE); // タイトルバー非表示
        setContentView(R.layout.ac_html_xwalk);
        commonOnCreate();
        // ***** 引数の取得
        Intent intent = getIntent();
        if (objectId != -1 || ABVEnvironment.getInstance().disableLogSend) {
            // アクションとして起動された場合, Streaming表示の場合ログは記録しない
            readingLogFlg = false;
        }

        objectLogId = intent.getIntExtra("objectLogId", -1);
        boolean isDownloadable = intent.getBooleanExtra("isDownloadable", false);
        boolean isUpdate = intent.getBooleanExtra("isUpdate", false);

        final String url = intent.getStringExtra("LINKURL"); // LinkURL
        mOperationId = intent.getLongExtra(ABookKeys.OPERATION_ID, -1); // OperationId


        // ***** WebViewセット

        webView = new XWalkView(this);
        xWalkLayout = (FrameLayout) findViewById(R.id.xWalkLayout);
        xWalkLayout.setVisibility(View.VISIBLE);
        xWalkLayout.addView(webView, new ViewGroup.LayoutParams(WC, WC));
        webView.setVerticalFadingEdgeEnabled(false);
        webView.clearCache(true);
        // //ブラウザの描画領域を対象としたイベントをフック
        XWalkSettings settings = webView.getSettings();
        settings.setSupportMultipleWindows(true); // 新しいウィンドウを開くイベントを取得する
        settings.setLoadsImagesAutomatically(true); // イメージを自動的にロードする
        settings.setBuiltInZoomControls(true); // ズーム機能を有効にする
        settings.setSupportZoom(true); // ズーム機能を有効にする
        settings.setJavaScriptEnabled(true); // JavaScriptを有効にする
        settings.setLoadWithOverviewMode(true); // 画面の横幅にページの横幅を合わせる
        settings.setUseWideViewPort(true); // 画面の横幅にページの横幅を合わせる
        settings.setDomStorageEnabled(true); // WebStorage有効化
        settings.setCacheMode(XWalkSettings.LOAD_NO_CACHE);
        if (Logger.isDebugEnabled()) {
            XWalkPreferences.setValue(XWalkPreferences.REMOTE_DEBUGGING, true); //デバッグモード（chromeからinspect可)
        }

        final RelativeLayout fl = (RelativeLayout) findViewById(R.id.frameTopbar);

        // ***** 戻るボタン
        closeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finishActivity();
            }
        });
        closeButton.setVisibility(View.VISIBLE);
        boolean isFromHomeMenu = intent.getIntExtra("pageNumber", -1) == -1 && mXWalkOpenType == -1;

        if (isFromHomeMenu) {
            closeButton.setBackgroundResource(R.drawable.btn_home);
            historyListBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    showHistoryList(v);
                }
            });

            subMenuBtn.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    mShowedPopupWindow = new ABVPopupListWindow(HTMLXWalkWebViewActivity.this);
                    if (isNormalSize()) {
                        mShowedPopupWindow.setWidth(getRDimensionSize(R.dimen.popup_size_normal));
                    } else {
                        mShowedPopupWindow.setWidth(getRDimensionSize(R.dimen.popup_size_large));
                    }

                    ArrayList<String> menuNameList = new ArrayList<>();
                    final boolean isExist = contentLogic.isExsitContentFavorite(getContentId());
                    if (isExist) {
                        menuNameList.add(getRString(R.string.remove_favorite_content));
                    } else {
                        menuNameList.add(getRString(R.string.add_favorite_content));
                    }

                    mShowedPopupWindow.setRepresentNames(menuNameList);
                    mShowedPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                        @Override
                        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                            switch (position) {
                                case 0 :
                                    // お気に入り
                                    contentLogic.setFavoriteContent(getContentId(), !isExist);
                                    break;
                                default :
                                    break;
                            }
                            mShowedPopupWindow.dismiss();
                        }
                    });

                    mShowedPopupWindow.showAsDropDown(v);
                }
            });

        } else {
            historyListBtn.setVisibility(View.GONE);
            subMenuBtn.setVisibility(View.GONE);
        }

        // ***** リンク元コンテンツへ戻るボタン
        btnLinkOriginalBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                goToBack();
            }
        });

        subMenuBtn.setVisibility(View.GONE);

        final Button btnWebBack = (Button) findViewById(R.id.btnWebBack);
        final Button btnWebForward = (Button) findViewById(R.id.btnWebForward);
        btnWebClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (fl.getVisibility() == View.VISIBLE) {
                    fl.setVisibility(View.GONE);
                    //noinspection deprecation(API16から非推奨になった。無視)
                    btnWebClose.setBackgroundDrawable(getResources().getDrawable(R.drawable.btn_webview_open));
                } else {
                    fl.setVisibility(View.VISIBLE);
                    //noinspection deprecation(API16から非推奨になった。無視)
                    btnWebClose.setBackgroundDrawable(getResources().getDrawable(R.drawable.btn_webview_close));
                }
            }
        });
        webView.setUIClient(new XWalkUIClient(webView) {
            public void onProgressChanged(WebView view, int newProgress) {
                commonProgressChanged(newProgress);
            }

            @Override
            public void openFileChooser(XWalkView view, ValueCallback<Uri> uploadFile,
                                        String acceptType, String capture) {
                super.openFileChooser(view, uploadFile, acceptType, capture);
                Logger.d(TAG, "*********************commonOpenFileChooser");
                boolean result = false;
                if (acceptType.toLowerCase().indexOf(ABookKeys.IMAGE) != -1) {
                    result = startCameraIntent(ABOOK_CHECK_TASK_IMAGE, "Camera", ABookKeys.IMAGE, true);
                } else if (acceptType.toLowerCase().indexOf(ABookKeys.VIDEO) != -1) {
                    result = startCameraIntent(ABOOK_CHECK_TASK_VIDEO, "Video", ABookKeys.VIDEO, true);
                }
                mUploadMessage = uploadFile;
                if (result) {
                    if (mUploadMessage != null) {
                        mUploadMessage.onReceiveValue(null);
                    }
                } else {
                    //すぐ処理すると、もう一度File追加タップしても反応しない問題の対応のため、１秒後に処理するように修正
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (mUploadMessage != null) {
                                mUploadMessage.onReceiveValue(null);
                            }
                            mUploadMessage = null;
                        }
                    }, 500);
                    super.openFileChooser(view, uploadFile, acceptType, capture);
                }
                Logger.i(TAG, "oepnFile acceptType : %s, capture : %s", acceptType, capture);
            }
        });

        webView.setResourceClient(new XWalkResourceClient(webView) {

            @Override
            public void onReceivedLoadError (XWalkView view, int errorCode, String description, String failingUrl) {
                Logger.e(TAG, "onReceivedError errorCode=%s, description=%s, failingUrl=%s", errorCode, description, failingUrl);
            }

            @Override
            public void onLoadFinished(final XWalkView view, String url) {
                super.onLoadFinished(view, url);
                if (view.getNavigationHistory() != null) {
                    btnWebBack.setEnabled(view.getNavigationHistory().canGoBack());
                    btnWebBack.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            if (view.getNavigationHistory().canGoBack()) {
                                view.getNavigationHistory().navigate(XWalkNavigationHistory.Direction.BACKWARD, 1) ;
                            }
                        }
                    });

                    btnWebForward.setEnabled(view.getNavigationHistory().canGoForward());
                    btnWebForward.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            if (view.getNavigationHistory().canGoForward()) {
                                view.getNavigationHistory().navigate(XWalkNavigationHistory.Direction.FORWARD, 1) ;
                            }
                        }
                    });
                }
                isPageFinished = true;
            }

            @Override
            public boolean shouldOverrideUrlLoading(XWalkView view, String url) {
                Logger.d(TAG, "shouldOverrideUrlLoading: %s", url);

                if (url.startsWith(ABookKeys.ABOOK)) {
                    final Uri uri = Uri.parse(url);
                    // AndroidOSが5以下のPANO_SERVER処理のため、置き換える必要がある。
                    url = "/" + url;
                    if (url.startsWith(ABookKeys.MOVEPAGE) || url.startsWith(ABookKeys.CONTENTLINK) || url.startsWith(ABookKeys.DETAILLOG)) {
                        Map<String, String> param = new HashMap<String, String>();
                        for (String key : uri.getQueryParameterNames()) {
                            param.put(key, uri.getQueryParameter(key));
                        }
                        param.put(ABookKeys.URI, url);

                        //　プロジェクト関連資料なのかをチェック
                        if (url.startsWith(ABookKeys.CONTENTLINK)) {
                            Long dstContentId = Long.valueOf(param.get("contentId"));
                            if (ActivityHandlingHelper.getInstance().isExistCommonContent(contentId)) {
                                if (!ActivityHandlingHelper.getInstance().isExistCommonContent(dstContentId)) {
                                    // リソースパターンの適用
                                    ABVToastUtil.showMakeText(getApplicationContext(), PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                        R.string.msg_not_common_content,
                                                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
                                    return true;
                                }
                            } else if (ActivityHandlingHelper.getInstance().isExistRelatedContent(contentId, mOperationId)) {
                                if (!ActivityHandlingHelper.getInstance().isExistRelatedContent(dstContentId, mOperationId)) {
                                    // リソースパターンの適用
                                    ABVToastUtil.showMakeText(getApplicationContext(), PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                        R.string.msg_not_related_content,
                                                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
                                    return true;
                                }
                            }
                        }

                        String ret = doParameter(param, getApplicationContext(), contentId, lastPageNo, readingLogId, lastPageStartDate, new Callback() {
                            @Override
                            public Object callback(Object ret) {
                                Map<String, Object> map = (Map<String, Object>) ret;
                                if (map.containsKey(ABookKeys.PARAM_LAST_PAGE_NUMBER)) {
                                    lastPageNo = (int) map.get(ABookKeys.PARAM_LAST_PAGE_NUMBER);
                                }
                                if (map.containsKey(ABookKeys.PARAM_LAST_PAGE_START_DATE)) {
                                    lastPageStartDate = (Date) map.get(ABookKeys.PARAM_LAST_PAGE_START_DATE);
                                }
                                if (map.containsKey(ABookKeys.PARAM_READING_LOG_ID)) {
                                    readingLogId = (Integer) map.get(ABookKeys.PARAM_READING_LOG_ID);
                                }
                                return null;
                            }
                        });
                        if (ret != null && !ret.startsWith(ABookKeys.OK)) {
                            // リソースパターンの適用
                            showSimpleAlertDialog(PatternStringUtil.patternToString(getApplicationContext(),
                                                    R.string.error,
                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), ret);
                        }
                    } else if (url.contains(ABookKeys.ABOOK_CHECK_API)) {
                        commonShouldOverrideUrlLoading(uri, null);
                    }
                    return true;
                } else if (url.startsWith(ABookKeys.PING)) {
                    return true;
                }
                return false;
            }
        });
        if (mXWalkOpenType == Constant.XWalkOpenType.TASK_REPORT) {
            webView.addJavascriptInterface(jsInf, "android");
        }
        // webView.postUrl(url,EncodingUtils.getBytes("", "utf-8"));
        Logger.d(TAG, "loadUrl: " + url);
        webView.loadUrl(url);

        reloadButton = (ImageButton) findViewById(R.id.btn_reload);
        reloadButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.d(TAG, "ReloadUrl");
                if (latitude != null && longitude != null) {
                    webView.loadUrl(url + "&reload=true&latitude=" + latitude + "&longitude=" + longitude);
                }
                else {
                    webView.loadUrl(url + "&reload=true");
                }
            }
        });

        downloadButton = (ImageButton) findViewById(R.id.btn_download);
        downloadButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.d(TAG, "Click download");
                try {
                    downloadButton.setEnabled(false);
                    ContentDownloader.getInstance().download(contentId);
                    ABVToastUtil.showMakeText(getApplicationContext(), R.string.download_start, Toast.LENGTH_SHORT);
                } catch (Exception e) {
                    Logger.e(TAG, "Download failed." ,e);
                    downloadButton.setEnabled(true);
                    handleErrorMessageToast(e);
                }
            }
        });
        if (isDownloadable) {
            downloadButton.setVisibility(View.VISIBLE);
            if (isUpdate) {
                downloadButton.setBackgroundResource(R.drawable.btn_update);
            }
            else {
                downloadButton.setBackgroundResource(R.drawable.btn_download);
            }
        }

        mBtnRemoteStart.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                meetingManager.setPaused(false);
                configureRemote();
            }
        });


        exitMeetingBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG, "exit onClick");
                showMeetingExitDialog();
            }
        });


        promoteBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG, "promote onClick");
                sendPromoteRequest();
            }
        });

        pauseBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Logger.v(TAG, "remoteOnOff onClick");
                meetingManager.setPaused(true);
                configureRemote();
            }
        });

        if(isLinkedContent) {
            if (ContentJSON.KEY_MOVIE_TYPE.equals(mContentDto.contentType) || ContentJSON.KEY_MUSIC_TYPE.equals(mContentDto.contentType)
                    || ContentJSON.KEY_PANO_IMAGE_TYPE.equals(mContentDto.contentType) || ContentJSON.KEY_PANO_MOVIE_TYPE.equals(mContentDto.contentType)
                    || ContentJSON.KEY_OBJECTVR_TYPE.equals(mContentDto.contentType) || ContentJSON.KEY_OTHER_TYPE.equals(mContentDto.contentType)) {

                closeButton.setBackgroundResource(R.drawable.btn_first_back);
                btnLinkOriginalBack.setVisibility(View.VISIBLE);
                btnWebBack.setVisibility(View.GONE);
                btnWebForward.setVisibility(View.GONE);
                reloadButton.setVisibility(View.GONE);
                downloadButton.setVisibility(View.GONE);
                mBtnRemoteStart.setVisibility(View.GONE);
                exitMeetingBtn.setVisibility(View.GONE);
                promoteBtn.setVisibility(View.GONE);
                pauseBtn.setVisibility(View.GONE);
                historyListBtn.setVisibility(View.GONE);
                subMenuBtn.setVisibility(View.GONE);
            } else if (ContentJSON.KEY_LINK_TYPE.equals(mContentDto.contentType) || ContentJSON.KEY_HTML_TYPE.equals(mContentDto.contentType)) {
                closeButton.setBackgroundResource(R.drawable.btn_first_back);
                btnLinkOriginalBack.setVisibility(View.VISIBLE);
                reloadButton.setVisibility(View.GONE);
                downloadButton.setVisibility(View.GONE);
                mBtnRemoteStart.setVisibility(View.GONE);
                exitMeetingBtn.setVisibility(View.GONE);
                promoteBtn.setVisibility(View.GONE);
                pauseBtn.setVisibility(View.GONE);
                historyListBtn.setVisibility(View.GONE);
                subMenuBtn.setVisibility(View.GONE);
            }
        } else {
            configureRemote();
        }
    }

    private void removeNewFlag() {
        // Newフラグ更新
        ContentDto contentDto = AbstractDao.getDao(ContentDao.class).getContent(contentId);
        if (contentDto.newFlg) {
            contentDto.newFlg = false;
            contentDao.updateContent(contentDto, false);
        }
    }

    private class JsInf {
        @org.xwalk.core.JavascriptInterface
        public void existSetLocation(String ret) {
            Logger.d(TAG, "existSetLocation=%s", ret);
            if (ret != null && ret.equals("true")) { // setLocationメソッドが存在する場合、ページ読み込み完了とみなす
                isPageFinished = true;
            }
            else { // 存在しない場合、ページ読み込み未完了とみなし１秒後に再度呼出しを繰り返す
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        callExistsSetLocation();
                    }
                }, 1000);
            }
        }

        @org.xwalk.core.JavascriptInterface
        public void existSendLog(String ret) {
            Logger.d(TAG, "existSendLog=%s", ret);
            if (ret != null && ret.equals("true")) {
                runOnUiThread(new Runnable() { // sendLogメソッドが存在する場合、呼び出す
                    @Override
                    public void run() {
                        try {
                            webView.loadUrl("javascript:sendLog()");
                        } catch (Exception e) {
                            Logger.e(TAG, "javascript:sendLog error. " + e.toString());
                        }
                    }
                });
            }
            else {
                finishActivity();
            }
        }

        @org.xwalk.core.JavascriptInterface
        public void getAttachedDataUrl(String taskKey, String data) {
            commonAttachedDataUrl(taskKey, data);
        }

        @org.xwalk.core.JavascriptInterface
        public void openEditPage() {
            commonOpenEditPage();
        }
    }

    @Override
    protected void onDestroy() {
        Logger.d(TAG, "onDestroy");
        finishWebView();
        super.onDestroy();
    }

    public void finishWebView() {
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                for (int i = 0; i < 100; i++) {
                    if (isPageFinished) {
                        break;
                    }
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                    }
                }
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        if (webView != null) {
                            ViewGroup parent = (ViewGroup) webView.getParent();
                            if (parent != null) {
                                parent.removeView(webView);
                            }
                            webView.removeAllViews();
                            webView.onDestroy();
                            webView = null;
                        }
                    }
                });
            };
        });
    }

    @Override
    public void onDetachedFromWindow() {
        Logger.d(TAG, "onDetachedFromWindow");
        super.onDetachedFromWindow();
        finishWebView();
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        Logger.i(TAG, "onResume");
        super.onResume();
        if (objectLogId != -1) {
            ContentLogUtil.getInstance().resumeObjectLog(getContentId(), objectLogId);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        webView.stopLoading();
        if (objectLogId == -1) {
            if (lastPageStartDate != null) { // 360の場合
                ContentLogUtil.getInstance().endContentPageReadLog(contentId, lastPageNo, readingLogId);
                AbstractLogic.getLogic(ContentReadingLogLogic.class).endContentReadLog(contentId);
            }
        } else {
            ContentLogUtil.getInstance().endObjectLog(getContentId(), objectLogId);
        }
    }

    @Override
    public void configureRemote() {
        if (objectId == -1 && meetingManager.isSubscribed()) {
            closeButton.setVisibility(View.INVISIBLE);
            historyListBtn.setVisibility(View.INVISIBLE);
            if (meetingManager.isPaused()) {
                mBtnRemoteStart.setVisibility(View.VISIBLE);
                pauseBtn.setVisibility(View.GONE);
                exitMeetingBtn.setVisibility(View.GONE);
                promoteBtn.setVisibility(View.GONE);
            } else {
                subMenuBtn.setVisibility(View.GONE);
                mBtnRemoteStart.setVisibility(View.GONE);
                pauseBtn.setVisibility(View.VISIBLE);
                exitMeetingBtn.setVisibility(View.VISIBLE);
                promoteBtn.setVisibility(View.VISIBLE);
            }
        } else {
            closeButton.setVisibility(View.VISIBLE);
            historyListBtn.setVisibility(View.GONE);
            subMenuBtn.setVisibility(View.GONE);

            mBtnRemoteStart.setVisibility(View.GONE);
            if (meetingManager.isSendable()) { // 会議室退室ボタン表示
                exitMeetingBtn.setVisibility(View.VISIBLE);
            }
            pauseBtn.setVisibility(View.GONE);
            promoteBtn.setVisibility(View.GONE);
        }

        if (meetingManager.isConnected() && meetingManager.isOwner()) {
            webView.setOnTouchListener(new View.OnTouchListener() {
                boolean showCount = false;

                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    Logger.d(TAG, "onTouch showCount=" + showCount);
                    showCount = !showCount;
                    setMeetingParticipantCount(showCount, findViewById(android.R.id.content));
                    v.performClick();
                    return false;
                }
            });
        }
        commonConfigureRemote();
    }

    @Override
    public void onDownloadingContentZip(ContentZipDownloadNotification notification) { // Streaming表示でダウンロードが完了した場合
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ABVToastUtil.showMakeText(getApplicationContext(), R.string.download_success, Toast.LENGTH_SHORT);
                downloadButton.setVisibility(View.GONE);
            }
        });
    }

    private void callExistsSetLocation() { // setLocation functionがjavascriptに定義されているかどうかを調べる（結果はexistSetLocationメソッドにコールバック）
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (webView != null) {
                    webView.loadUrl("javascript:android.existSetLocation(typeof setLocation == 'function')");
                }
            }
        });
    }

    private void callExistsSendLog() { // setLocation functionがjavascriptに定義されているかどうかを調べる（結果はexistSendLogメソッドにコールバック）
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (webView != null) {
                    webView.loadUrl("javascript:android.existSendLog(typeof sendLog == 'function')");
                }
            }
        });

        handler.postDelayed(new Runnable() { // 10秒後に終了していない場合に終了
            @Override
            public void run() {
                //noinspection VariableNotUsedInsideIf
                if (webView != null) {
                    Logger.w(TAG, "Finish forcibly");
                    finishActivity();
                }
            }
        }, 10000);
    }
    @Override
    protected void webViewLoadUrl(String url){
        if (webView != null) {
            webView.loadUrl(url);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {

        Uri result = (intent == null || resultCode != RESULT_OK) ? null : intent.getData();
        if (requestCode == ABOOK_CHECK_TASK_IMAGE) {
            if (mUploadMessage == null) {
                return;
            }
            // 画像
            try {
                if (result == null) {
                    result = imageUri;
                }
                Uri responseUri = attachmentImageProcessing(result);
                mUploadMessage.onReceiveValue(responseUri);
            } catch (Exception e) {
                Logger.e(TAG, e);
                mUploadMessage.onReceiveValue(null);
                ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
            }
        } else if (requestCode == ABOOK_CHECK_TASK_VIDEO) {
            if (mUploadMessage == null) {
                return;
            }
            // 動画
            mUploadMessage.onReceiveValue(result);
        } else if (requestCode == ABOOK_CHECK_SELECT_SCENE) {
            if (intent != null && result != null) {
                confirmEntrySceneDialog(result);
            }
        }
        mUploadMessage = null;
    }
}
