package jp.agentec.abook.abv.ui.viewer.foxitPdf;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PointF;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Library;
import com.foxit.sdk.common.Progressive;
import com.foxit.sdk.common.Renderer;
import com.foxit.sdk.common.fxcrt.Matrix2D;
import com.foxit.sdk.common.fxcrt.RectF;
import com.foxit.sdk.common.fxcrt.RectFArray;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.TextSearch;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;

import static com.foxit.sdk.pdf.PDFDoc.e_PwdNoPassword;


/**
 * Created by leej on 2018/06/11.
 */

public class FoxitPdfCore {

    private static final String TAG = "FoxitPdfCore";

    private Context mContext;
    private String mFilePath;
    private boolean mPasswordError = false;
    private PDFDoc mPDFDoc;

    private static int initErrCode = Constants.e_ErrSuccess;

    private static String sn = "nuSqGjKW5sNcvbr0waEwA4AkknAm89dnc0IotgiDBrFMIEj8lZL2Vw==";
    private static String key = "ezJvj93HtBp39Js1IV0+hIVMn8rGV3voKx6cpoHGePP9qnxzhL01h+6eci/YaEKQbTsM6V7ink8XwjLytd9+TcQT6YHm0K1fNquW/0FiyvS+pOeZRXyk6eWf9kgTLtiKOZ/4ZCUVYpjBmRrZfI2DRdD8GwHu3PHwVRWnWKTuJYrPWEc4u+plAbOrHhzRMMBwn/Ur6Ka9ycwFgCjgpElRGAWPvjt3DSisls0UNJn3fLtb+j0aDhYdwtttJJpUbxkr7Y59gPtVgooNEgZABD0Gf+U/zxRK591hueouzxnt6I+SCznXrv2hQVjjPhau8u1Z1/kQaITGgxFy+7SuGDK/OhZOxOOTIwwHFVlKkxLGLhfMJj/7ofp4Msx9G0yv5BHl+w45y+2qTFVAdY37cwl90EbBSH1BddVByMVMK35b0/89Y9CnJV+NxFF1T27dWs+GZuGEtJ2uGJVnvdkSAZ2FQ+RVh14Z7ADgekKU8T/hlhReEB1scf+PV5RfPQ5sHYJqGF9I3OXroAuErfsgQSYD+nTfB6dZVIv+cArrzY4PVq5xSIqHMHWRHbgE61K82YOJ5llB9NBn8z5F+kEEzaUMySQ4YgL/uDQYezPpTiSe59zB/SbmGlG2ditkRYIojEZTOfLbx3hORj+yo9SeZ7G9Q0UVxA5V2+YZ6i7xVm/hs1zd7KRBeKmjd0CRCe6bAUDrO4L//UwZtUQ820+Dot7EOug+smbXEHS0gRKp0kFB6BDiM2Ps37SIhbWtfxOXTLO1a1teQiW2pAZvvpVFiogrZNOggievW/jv+kqkho4Vu5CI4kS8m2ZRCNgMi9vGHyZrN2DbYjjFCBvvt0zgeWjC5diWZ+SQVLLGZNMkd9KBIbOyHyekfSXUn8mde1zEqT+H0ZPoHI+ztCFVZGp5zvpcu71pxZ5SgjbRDmrOTCeZ6jL7RpDx9b62kg+k8RaFOe8XiHuUDozxmgwY/f3+55uhGshAjyNV7C9xLRgO3Hmi9IbwTKKPOD67APSpSyIbtnSgZunngZWYJlN1xfAlwrUiz9DGv2MGzW7fFk8eA/c1RBbeMUe8DrUIRZLcuUhzG//ihR68CV/HvQ/foBYZFcAzzrfr363uWtkN146SjEqMzHDtC/ASjlvx3xQGmUZNzd8y859yLz3Xdv5YHTMfJGS/DtamhuPiCT+jj16rwToaTBse4VagO3Eq";

    static {
        System.loadLibrary("rdk");
    }

    public FoxitPdfCore(Context context, String filePath) throws PDFException {
        mContext = context;
        mFilePath = filePath;
        mPDFDoc = new PDFDoc(mFilePath);
        //Foxit PDF SDK library init
        initErrCode = Library.initialize(sn, key);
        if (initErrCode != Constants.e_ErrSuccess) {
            if (initErrCode == Constants.e_ErrInvalidLicense) {
                Logger.e(TAG, "The license is invalid!");
            } else {
                Logger.e(TAG, "Failed to initialize the library!");
            }
            throw new PDFException(initErrCode);
        }
    }

    /**
     * PDFDocを読み込む処理
     * パスワードが必要な場合は、trueで返す
     * @param password
     * @return
     * @throws PDFException
     */
    public boolean loadPDFDoc(byte[] password) throws PDFException {
        int passwordType = e_PwdNoPassword;
        try {
            mPDFDoc.load(password);
            passwordType  = mPDFDoc.getPasswordType();
            if(passwordType != e_PwdNoPassword) {
                return true;
            }
        } catch (PDFException e) {
            Logger.e(TAG, "pdfDoc load Failed.", e);
            throw e;
        }
        return false;
    }

    /**
     * PDFページの読み込む処理
     * @param doc
     * @param index
     * @param parseFlag
     * @return
     */
    public PDFPage loadPage(PDFDoc doc, int index, int parseFlag) {
        PDFPage page = null;
        if (doc == null) {
            Logger.e(TAG, "The document is null!");
            return null;
        }

        try {
            page = doc.getPage(index);
            if (page == null) {
                Logger.e(TAG, "Get Page error");
                return null;
            }

            if (!page.isParsed()) {
                Progressive progressive = page.startParse(parseFlag, null, false);

                int state = Progressive.e_ToBeContinued;
                while (state == Progressive.e_ToBeContinued) {
                    state = progressive.resume();
                }

                progressive.delete();
                if (state == Progressive.e_Error) {
                    Logger.e(TAG, "Parse Page error!");
                    return null;
                }
            }

        } catch (PDFException e) {
            Logger.e(TAG, "Load Page error.");
        }
        return page;
    }

    public void releaseDoc() {
        mPDFDoc.delete();
    }

    /**
     * PDFのページ数取得
     * @return
     * @throws PDFException
     */
    public int countPages() throws PDFException {
        return mPDFDoc.getPageCount();
    }

    /**
     * PDFサイズ取得
     * @param pageIndex
     * @return
     * @throws PDFException
     */
    public PointF getPageSize(int pageIndex) throws PDFException {
        Logger.i("getPageSize : " + pageIndex);
        PDFPage pdfPage = mPDFDoc.getPage(pageIndex);
        return new PointF(pdfPage.getWidth(), pdfPage.getHeight());
    }

    /**
     * PDF特定ページのイメージ描画
     * @param bm
     * @param page
     * @param pageW
     * @param pageH
     * @param patchX
     * @param patchY
     * @param patchW
     * @param patchH
     * @return
     */
    public Bitmap drawPage(int page, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH) {
        Logger.i(TAG, "drawPage start.");
        synchronized (mContext) {
            Bitmap bm = Bitmap.createBitmap(patchW, patchH, Bitmap.Config.ARGB_8888);
            PDFPage pdfPage = loadPage(mPDFDoc, page, PDFPage.e_ParsePageNormal);
            Renderer renderer = null;
            Progressive progressive = null;
            try {
                if (pdfPage.hasTransparency()) {
                    bm.eraseColor(Color.TRANSPARENT);
                } else {
                    bm.eraseColor(Color.WHITE);
                }

                Matrix2D matrix = pdfPage.getDisplayMatrix(-(patchX), -(patchY), pageW, pageH, Constants.e_Rotation0);

                renderer = new Renderer(bm, true);

                progressive = renderer.startRender(pdfPage, matrix, null);
                int state = Progressive.e_ToBeContinued;
                while (state == Progressive.e_ToBeContinued) {
                    state = progressive.resume();
                }
                progressive.delete();
                if (state == Progressive.e_Error) {
                    Logger.e(TAG, "Failed to render the page No.%d failed!", page);
                    return null;
                }
                renderer.delete();
                pdfPage.delete();
            } catch (PDFException e) {
               Logger.e(TAG, "Failed to render the page No.%d! %s", page, e.getMessage());
            }

            Logger.i(TAG, "drawPage end.");
            return bm;
        }
    }

    /**
     * ページの文字検索機能
     * @param page
     * @param searchText
     * @return
     */
    public List<RectF> searchPage(int page, String searchText) {
        List<RectF> rectFList = new ArrayList<>();
        TextSearch textSearch = null;
        try {
            textSearch = new TextSearch(mPDFDoc, null);
            PDFPage pdfPage = mPDFDoc.getPage(page);
            if (textSearch == null) {
                Logger.e(TAG, "create text search error");
                return null;
            }

            if (!textSearch.setPattern(searchText)) {
                Logger.e(TAG, "set keywords error");
                textSearch.delete();
                return null;
            }
            textSearch.setStartPage(page);
            textSearch.setEndPage(page);
            while(textSearch.findNext()) {
                if(textSearch.getMatchPageIndex() != page) {
                    break;
                }
                RectFArray rectFArray = textSearch.getMatchRects();
                rectFList.add(rectFArray.getAt(0));
            }
        } catch (PDFException e) {
            Logger.e(TAG, "PDF searchText failed.", e);
        } finally {
            if (textSearch != null) {
                textSearch.delete();
            }
            return rectFList.size() > 0 ? rectFList : null;
        }
    }

}
