/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser.moshi;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oz.lottie.parser.moshi.LinkedHashTreeMap$1;
import oz.lottie.parser.moshi.LinkedHashTreeMap$AvlBuilder;
import oz.lottie.parser.moshi.LinkedHashTreeMap$AvlIterator;
import oz.lottie.parser.moshi.LinkedHashTreeMap$EntrySet;
import oz.lottie.parser.moshi.LinkedHashTreeMap$KeySet;
import oz.lottie.parser.moshi.LinkedHashTreeMap$Node;

final class LinkedHashTreeMap
extends AbstractMap
implements Serializable {
    private static final Comparator NATURAL_ORDER = new LinkedHashTreeMap$1();
    Comparator comparator;
    LinkedHashTreeMap$Node[] table;
    final LinkedHashTreeMap$Node header;
    int size = 0;
    int modCount = 0;
    int threshold;
    private LinkedHashTreeMap$EntrySet entrySet;
    private LinkedHashTreeMap$KeySet keySet;

    LinkedHashTreeMap() {
        this(null);
    }

    LinkedHashTreeMap(Comparator comparator) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
        this.header = new LinkedHashTreeMap$Node();
        this.table = new LinkedHashTreeMap$Node[16];
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(Object object) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node = this.findByObject(object);
        return linkedHashTreeMap$Node != null ? linkedHashTreeMap$Node.value : null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("key == null");
        }
        LinkedHashTreeMap$Node linkedHashTreeMap$Node = this.find(object, true);
        Object object3 = linkedHashTreeMap$Node.value;
        linkedHashTreeMap$Node.value = object2;
        return object3;
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        ++this.modCount;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node = this.header;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node2 = linkedHashTreeMap$Node.next;
        while (linkedHashTreeMap$Node2 != linkedHashTreeMap$Node) {
            LinkedHashTreeMap$Node linkedHashTreeMap$Node3 = linkedHashTreeMap$Node2.next;
            linkedHashTreeMap$Node2.prev = null;
            linkedHashTreeMap$Node2.next = null;
            linkedHashTreeMap$Node2 = linkedHashTreeMap$Node3;
        }
        linkedHashTreeMap$Node.next = linkedHashTreeMap$Node.prev = linkedHashTreeMap$Node;
    }

    @Override
    public Object remove(Object object) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node = this.removeInternalByKey(object);
        return linkedHashTreeMap$Node != null ? linkedHashTreeMap$Node.value : null;
    }

    LinkedHashTreeMap$Node find(Object object, boolean bl) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node;
        Object object2;
        Comparator comparator = this.comparator;
        LinkedHashTreeMap$Node[] linkedHashTreeMap$NodeArray = this.table;
        int n = LinkedHashTreeMap.secondaryHash(object.hashCode());
        int n2 = n & linkedHashTreeMap$NodeArray.length - 1;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node2 = linkedHashTreeMap$NodeArray[n2];
        int n3 = 0;
        if (linkedHashTreeMap$Node2 != null) {
            object2 = comparator == NATURAL_ORDER ? (Comparable)object : null;
            while (true) {
                int n4 = n3 = object2 != null ? object2.compareTo(linkedHashTreeMap$Node2.key) : comparator.compare(object, linkedHashTreeMap$Node2.key);
                if (n3 == 0) {
                    return linkedHashTreeMap$Node2;
                }
                LinkedHashTreeMap$Node linkedHashTreeMap$Node3 = linkedHashTreeMap$Node = n3 < 0 ? linkedHashTreeMap$Node2.left : linkedHashTreeMap$Node2.right;
                if (linkedHashTreeMap$Node == null) break;
                linkedHashTreeMap$Node2 = linkedHashTreeMap$Node;
            }
        }
        if (!bl) {
            return null;
        }
        object2 = this.header;
        if (linkedHashTreeMap$Node2 == null) {
            if (comparator == NATURAL_ORDER && !(object instanceof Comparable)) {
                throw new ClassCastException(String.valueOf(object.getClass().getName()) + " is not Comparable");
            }
            linkedHashTreeMap$NodeArray[n2] = linkedHashTreeMap$Node = new LinkedHashTreeMap$Node(linkedHashTreeMap$Node2, object, n, (LinkedHashTreeMap$Node)object2, ((LinkedHashTreeMap$Node)object2).prev);
        } else {
            linkedHashTreeMap$Node = new LinkedHashTreeMap$Node(linkedHashTreeMap$Node2, object, n, (LinkedHashTreeMap$Node)object2, ((LinkedHashTreeMap$Node)object2).prev);
            if (n3 < 0) {
                linkedHashTreeMap$Node2.left = linkedHashTreeMap$Node;
            } else {
                linkedHashTreeMap$Node2.right = linkedHashTreeMap$Node;
            }
            this.rebalance(linkedHashTreeMap$Node2, true);
        }
        if (this.size++ > this.threshold) {
            this.doubleCapacity();
        }
        ++this.modCount;
        return linkedHashTreeMap$Node;
    }

    LinkedHashTreeMap$Node findByObject(Object object) {
        try {
            return object != null ? this.find(object, false) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    LinkedHashTreeMap$Node findByEntry(Map.Entry entry) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node = this.findByObject(entry.getKey());
        boolean bl = linkedHashTreeMap$Node != null && this.equal(linkedHashTreeMap$Node.value, entry.getValue());
        return bl ? linkedHashTreeMap$Node : null;
    }

    private boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private static int secondaryHash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    void removeInternal(LinkedHashTreeMap$Node linkedHashTreeMap$Node, boolean bl) {
        if (bl) {
            linkedHashTreeMap$Node.prev.next = linkedHashTreeMap$Node.next;
            linkedHashTreeMap$Node.next.prev = linkedHashTreeMap$Node.prev;
            linkedHashTreeMap$Node.prev = null;
            linkedHashTreeMap$Node.next = null;
        }
        LinkedHashTreeMap$Node linkedHashTreeMap$Node2 = linkedHashTreeMap$Node.left;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node3 = linkedHashTreeMap$Node.right;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node4 = linkedHashTreeMap$Node.parent;
        if (linkedHashTreeMap$Node2 != null && linkedHashTreeMap$Node3 != null) {
            LinkedHashTreeMap$Node linkedHashTreeMap$Node5 = linkedHashTreeMap$Node2.height > linkedHashTreeMap$Node3.height ? linkedHashTreeMap$Node2.last() : linkedHashTreeMap$Node3.first();
            this.removeInternal(linkedHashTreeMap$Node5, false);
            int n = 0;
            linkedHashTreeMap$Node2 = linkedHashTreeMap$Node.left;
            if (linkedHashTreeMap$Node2 != null) {
                n = linkedHashTreeMap$Node2.height;
                linkedHashTreeMap$Node5.left = linkedHashTreeMap$Node2;
                linkedHashTreeMap$Node2.parent = linkedHashTreeMap$Node5;
                linkedHashTreeMap$Node.left = null;
            }
            int n2 = 0;
            linkedHashTreeMap$Node3 = linkedHashTreeMap$Node.right;
            if (linkedHashTreeMap$Node3 != null) {
                n2 = linkedHashTreeMap$Node3.height;
                linkedHashTreeMap$Node5.right = linkedHashTreeMap$Node3;
                linkedHashTreeMap$Node3.parent = linkedHashTreeMap$Node5;
                linkedHashTreeMap$Node.right = null;
            }
            linkedHashTreeMap$Node5.height = Math.max(n, n2) + 1;
            this.replaceInParent(linkedHashTreeMap$Node, linkedHashTreeMap$Node5);
            return;
        }
        if (linkedHashTreeMap$Node2 != null) {
            this.replaceInParent(linkedHashTreeMap$Node, linkedHashTreeMap$Node2);
            linkedHashTreeMap$Node.left = null;
        } else if (linkedHashTreeMap$Node3 != null) {
            this.replaceInParent(linkedHashTreeMap$Node, linkedHashTreeMap$Node3);
            linkedHashTreeMap$Node.right = null;
        } else {
            this.replaceInParent(linkedHashTreeMap$Node, null);
        }
        this.rebalance(linkedHashTreeMap$Node4, false);
        --this.size;
        ++this.modCount;
    }

    LinkedHashTreeMap$Node removeInternalByKey(Object object) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node = this.findByObject(object);
        if (linkedHashTreeMap$Node != null) {
            this.removeInternal(linkedHashTreeMap$Node, true);
        }
        return linkedHashTreeMap$Node;
    }

    private void replaceInParent(LinkedHashTreeMap$Node linkedHashTreeMap$Node, LinkedHashTreeMap$Node linkedHashTreeMap$Node2) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node3 = linkedHashTreeMap$Node.parent;
        linkedHashTreeMap$Node.parent = null;
        if (linkedHashTreeMap$Node2 != null) {
            linkedHashTreeMap$Node2.parent = linkedHashTreeMap$Node3;
        }
        if (linkedHashTreeMap$Node3 != null) {
            if (linkedHashTreeMap$Node3.left == linkedHashTreeMap$Node) {
                linkedHashTreeMap$Node3.left = linkedHashTreeMap$Node2;
            } else {
                assert (linkedHashTreeMap$Node3.right == linkedHashTreeMap$Node);
                linkedHashTreeMap$Node3.right = linkedHashTreeMap$Node2;
            }
        } else {
            int n = linkedHashTreeMap$Node.hash & this.table.length - 1;
            this.table[n] = linkedHashTreeMap$Node2;
        }
    }

    private void rebalance(LinkedHashTreeMap$Node linkedHashTreeMap$Node, boolean bl) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node2 = linkedHashTreeMap$Node;
        while (linkedHashTreeMap$Node2 != null) {
            int n;
            LinkedHashTreeMap$Node linkedHashTreeMap$Node3;
            int n2;
            int n3;
            LinkedHashTreeMap$Node linkedHashTreeMap$Node4;
            LinkedHashTreeMap$Node linkedHashTreeMap$Node5;
            int n4;
            LinkedHashTreeMap$Node linkedHashTreeMap$Node6 = linkedHashTreeMap$Node2.left;
            int n5 = linkedHashTreeMap$Node6 != null ? linkedHashTreeMap$Node6.height : 0;
            int n6 = n5 - (n4 = (linkedHashTreeMap$Node5 = linkedHashTreeMap$Node2.right) != null ? linkedHashTreeMap$Node5.height : 0);
            if (n6 == -2) {
                linkedHashTreeMap$Node4 = linkedHashTreeMap$Node5.left;
                n3 = linkedHashTreeMap$Node4 != null ? linkedHashTreeMap$Node4.height : 0;
                n = n3 - (n2 = (linkedHashTreeMap$Node3 = linkedHashTreeMap$Node5.right) != null ? linkedHashTreeMap$Node3.height : 0);
                if (n == -1 || n == 0 && !bl) {
                    this.rotateLeft(linkedHashTreeMap$Node2);
                } else {
                    assert (n == 1);
                    this.rotateRight(linkedHashTreeMap$Node5);
                    this.rotateLeft(linkedHashTreeMap$Node2);
                }
                if (bl) {
                    break;
                }
            } else if (n6 == 2) {
                linkedHashTreeMap$Node4 = linkedHashTreeMap$Node6.left;
                n3 = linkedHashTreeMap$Node4 != null ? linkedHashTreeMap$Node4.height : 0;
                n = n3 - (n2 = (linkedHashTreeMap$Node3 = linkedHashTreeMap$Node6.right) != null ? linkedHashTreeMap$Node3.height : 0);
                if (n == 1 || n == 0 && !bl) {
                    this.rotateRight(linkedHashTreeMap$Node2);
                } else {
                    assert (n == -1);
                    this.rotateLeft(linkedHashTreeMap$Node6);
                    this.rotateRight(linkedHashTreeMap$Node2);
                }
                if (bl) {
                    break;
                }
            } else if (n6 == 0) {
                linkedHashTreeMap$Node2.height = n5 + 1;
                if (bl) {
                    break;
                }
            } else {
                assert (n6 == -1 || n6 == 1);
                linkedHashTreeMap$Node2.height = Math.max(n5, n4) + 1;
                if (!bl) break;
            }
            linkedHashTreeMap$Node2 = linkedHashTreeMap$Node2.parent;
        }
    }

    private void rotateLeft(LinkedHashTreeMap$Node linkedHashTreeMap$Node) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node2 = linkedHashTreeMap$Node.left;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node3 = linkedHashTreeMap$Node.right;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node4 = linkedHashTreeMap$Node3.left;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node5 = linkedHashTreeMap$Node3.right;
        linkedHashTreeMap$Node.right = linkedHashTreeMap$Node4;
        if (linkedHashTreeMap$Node4 != null) {
            linkedHashTreeMap$Node4.parent = linkedHashTreeMap$Node;
        }
        this.replaceInParent(linkedHashTreeMap$Node, linkedHashTreeMap$Node3);
        linkedHashTreeMap$Node3.left = linkedHashTreeMap$Node;
        linkedHashTreeMap$Node.parent = linkedHashTreeMap$Node3;
        linkedHashTreeMap$Node.height = Math.max(linkedHashTreeMap$Node2 != null ? linkedHashTreeMap$Node2.height : 0, linkedHashTreeMap$Node4 != null ? linkedHashTreeMap$Node4.height : 0) + 1;
        linkedHashTreeMap$Node3.height = Math.max(linkedHashTreeMap$Node.height, linkedHashTreeMap$Node5 != null ? linkedHashTreeMap$Node5.height : 0) + 1;
    }

    private void rotateRight(LinkedHashTreeMap$Node linkedHashTreeMap$Node) {
        LinkedHashTreeMap$Node linkedHashTreeMap$Node2;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node3 = linkedHashTreeMap$Node.left;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node4 = linkedHashTreeMap$Node.right;
        LinkedHashTreeMap$Node linkedHashTreeMap$Node5 = linkedHashTreeMap$Node3.left;
        linkedHashTreeMap$Node.left = linkedHashTreeMap$Node2 = linkedHashTreeMap$Node3.right;
        if (linkedHashTreeMap$Node2 != null) {
            linkedHashTreeMap$Node2.parent = linkedHashTreeMap$Node;
        }
        this.replaceInParent(linkedHashTreeMap$Node, linkedHashTreeMap$Node3);
        linkedHashTreeMap$Node3.right = linkedHashTreeMap$Node;
        linkedHashTreeMap$Node.parent = linkedHashTreeMap$Node3;
        linkedHashTreeMap$Node.height = Math.max(linkedHashTreeMap$Node4 != null ? linkedHashTreeMap$Node4.height : 0, linkedHashTreeMap$Node2 != null ? linkedHashTreeMap$Node2.height : 0) + 1;
        linkedHashTreeMap$Node3.height = Math.max(linkedHashTreeMap$Node.height, linkedHashTreeMap$Node5 != null ? linkedHashTreeMap$Node5.height : 0) + 1;
    }

    @Override
    public Set entrySet() {
        LinkedHashTreeMap$EntrySet linkedHashTreeMap$EntrySet = this.entrySet;
        return linkedHashTreeMap$EntrySet != null ? linkedHashTreeMap$EntrySet : (this.entrySet = new LinkedHashTreeMap$EntrySet(this));
    }

    @Override
    public Set keySet() {
        LinkedHashTreeMap$KeySet linkedHashTreeMap$KeySet = this.keySet;
        return linkedHashTreeMap$KeySet != null ? linkedHashTreeMap$KeySet : (this.keySet = new LinkedHashTreeMap$KeySet(this));
    }

    private void doubleCapacity() {
        this.table = LinkedHashTreeMap.doubleCapacity(this.table);
        this.threshold = this.table.length / 2 + this.table.length / 4;
    }

    static LinkedHashTreeMap$Node[] doubleCapacity(LinkedHashTreeMap$Node[] linkedHashTreeMap$NodeArray) {
        int n = linkedHashTreeMap$NodeArray.length;
        LinkedHashTreeMap$Node[] linkedHashTreeMap$NodeArray2 = new LinkedHashTreeMap$Node[n * 2];
        LinkedHashTreeMap$AvlIterator linkedHashTreeMap$AvlIterator = new LinkedHashTreeMap$AvlIterator();
        LinkedHashTreeMap$AvlBuilder linkedHashTreeMap$AvlBuilder = new LinkedHashTreeMap$AvlBuilder();
        LinkedHashTreeMap$AvlBuilder linkedHashTreeMap$AvlBuilder2 = new LinkedHashTreeMap$AvlBuilder();
        int n2 = 0;
        while (n2 < n) {
            LinkedHashTreeMap$Node linkedHashTreeMap$Node = linkedHashTreeMap$NodeArray[n2];
            if (linkedHashTreeMap$Node != null) {
                LinkedHashTreeMap$Node linkedHashTreeMap$Node2;
                linkedHashTreeMap$AvlIterator.reset(linkedHashTreeMap$Node);
                int n3 = 0;
                int n4 = 0;
                while ((linkedHashTreeMap$Node2 = linkedHashTreeMap$AvlIterator.next()) != null) {
                    if ((linkedHashTreeMap$Node2.hash & n) == 0) {
                        ++n3;
                        continue;
                    }
                    ++n4;
                }
                linkedHashTreeMap$AvlBuilder.reset(n3);
                linkedHashTreeMap$AvlBuilder2.reset(n4);
                linkedHashTreeMap$AvlIterator.reset(linkedHashTreeMap$Node);
                while ((linkedHashTreeMap$Node2 = linkedHashTreeMap$AvlIterator.next()) != null) {
                    if ((linkedHashTreeMap$Node2.hash & n) == 0) {
                        linkedHashTreeMap$AvlBuilder.add(linkedHashTreeMap$Node2);
                        continue;
                    }
                    linkedHashTreeMap$AvlBuilder2.add(linkedHashTreeMap$Node2);
                }
                linkedHashTreeMap$NodeArray2[n2] = n3 > 0 ? linkedHashTreeMap$AvlBuilder.root() : null;
                linkedHashTreeMap$NodeArray2[n2 + n] = n4 > 0 ? linkedHashTreeMap$AvlBuilder2.root() : null;
            }
            ++n2;
        }
        return linkedHashTreeMap$NodeArray2;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }
}

